# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RdsAccountArgs', 'RdsAccount']

@pulumi.input_type
class RdsAccountArgs:
    def __init__(__self__, *,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 reset_permission_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RdsAccount resource.
        :param pulumi.Input[_builtins.str] account_description: The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
               
               > **NOTE:** The name cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] account_name: The name of the database account.
               * The name must be unique.
               * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
               * The name must start with a letter and end with a letter or digit.
               * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
               * The length of the value must meet the following requirements:
               * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
               * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
               * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
               * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
               * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
               * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
               * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] account_password: The password of the account.
               * The value must be 8 to 32 characters in length.
               * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
               * Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] account_type: The account type. Valid values:
               * Normal: standard account (default).
               * Super: privileged account.
               * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
               
               > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] db_instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] description: The attribute has been deprecated from 1.120.0 and using `account_description` instead.
        :param pulumi.Input[_builtins.str] instance_id: The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] name: The attribute has been deprecated from 1.120.0 and using `account_name` instead.
        :param pulumi.Input[_builtins.str] password: The attribute has been deprecated from 1.120.0 and using `account_password` instead.
        :param pulumi.Input[_builtins.bool] reset_permission_flag: Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
        :param pulumi.Input[_builtins.str] type: The attribute has been deprecated from 1.120.0 and using `account_type` instead.
               
               > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
        """
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if description is not None:
            warnings.warn("""Field 'description' has been deprecated from provider version 1.120.0. New field 'account_description' instead.""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: Field 'description' has been deprecated from provider version 1.120.0. New field 'account_description' instead.""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            warnings.warn("""Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_id is deprecated: Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id' instead.""")
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            warnings.warn("""Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password' instead.""", DeprecationWarning)
            pulumi.log.warn("""password is deprecated: Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password' instead.""")
        if password is not None:
            pulumi.set(__self__, "password", password)
        if reset_permission_flag is not None:
            pulumi.set(__self__, "reset_permission_flag", reset_permission_flag)
        if type is not None:
            warnings.warn("""Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.""")
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.

        > **NOTE:** The name cannot start with http:// or https://.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database account.
        * The name must be unique.
        * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
        * The name must start with a letter and end with a letter or digit.
        * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
        * The length of the value must meet the following requirements:
        * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
        * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
        * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
        * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
        * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
        * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
        * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the account.
        * The value must be 8 to 32 characters in length.
        * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        * Special characters include ! @ # $ % ^ & * ( ) _ + - =
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account type. Valid values:
        * Normal: standard account (default).
        * Super: privileged account.
        * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.

        > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'description' has been deprecated from provider version 1.120.0. New field 'account_description' instead.""")
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_description` instead.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    @_utilities.deprecated("""Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id' instead.""")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password' instead.""")
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_password` instead.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resetPermissionFlag")
    def reset_permission_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
        """
        return pulumi.get(self, "reset_permission_flag")

    @reset_permission_flag.setter
    def reset_permission_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reset_permission_flag", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.""")
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_type` instead.

        > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _RdsAccountState:
    def __init__(__self__, *,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 reset_permission_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RdsAccount resources.
        :param pulumi.Input[_builtins.str] account_description: The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
               
               > **NOTE:** The name cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] account_name: The name of the database account.
               * The name must be unique.
               * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
               * The name must start with a letter and end with a letter or digit.
               * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
               * The length of the value must meet the following requirements:
               * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
               * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
               * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
               * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
               * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
               * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
               * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] account_password: The password of the account.
               * The value must be 8 to 32 characters in length.
               * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
               * Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] account_type: The account type. Valid values:
               * Normal: standard account (default).
               * Super: privileged account.
               * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
               
               > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] db_instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] description: The attribute has been deprecated from 1.120.0 and using `account_description` instead.
        :param pulumi.Input[_builtins.str] instance_id: The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] name: The attribute has been deprecated from 1.120.0 and using `account_name` instead.
        :param pulumi.Input[_builtins.str] password: The attribute has been deprecated from 1.120.0 and using `account_password` instead.
        :param pulumi.Input[_builtins.bool] reset_permission_flag: Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Available`, `Unavailable`.
        :param pulumi.Input[_builtins.str] type: The attribute has been deprecated from 1.120.0 and using `account_type` instead.
               
               > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
        """
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if description is not None:
            warnings.warn("""Field 'description' has been deprecated from provider version 1.120.0. New field 'account_description' instead.""", DeprecationWarning)
            pulumi.log.warn("""description is deprecated: Field 'description' has been deprecated from provider version 1.120.0. New field 'account_description' instead.""")
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            warnings.warn("""Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_id is deprecated: Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id' instead.""")
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            warnings.warn("""Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password' instead.""", DeprecationWarning)
            pulumi.log.warn("""password is deprecated: Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password' instead.""")
        if password is not None:
            pulumi.set(__self__, "password", password)
        if reset_permission_flag is not None:
            pulumi.set(__self__, "reset_permission_flag", reset_permission_flag)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            warnings.warn("""Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.""")
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.

        > **NOTE:** The name cannot start with http:// or https://.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database account.
        * The name must be unique.
        * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
        * The name must start with a letter and end with a letter or digit.
        * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
        * The length of the value must meet the following requirements:
        * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
        * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
        * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
        * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
        * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
        * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
        * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the account.
        * The value must be 8 to 32 characters in length.
        * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        * Special characters include ! @ # $ % ^ & * ( ) _ + - =
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account type. Valid values:
        * Normal: standard account (default).
        * Super: privileged account.
        * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.

        > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'description' has been deprecated from provider version 1.120.0. New field 'account_description' instead.""")
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_description` instead.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    @_utilities.deprecated("""Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id' instead.""")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password' instead.""")
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_password` instead.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resetPermissionFlag")
    def reset_permission_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
        """
        return pulumi.get(self, "reset_permission_flag")

    @reset_permission_flag.setter
    def reset_permission_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reset_permission_flag", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Available`, `Unavailable`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.""")
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_type` instead.

        > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:rds/rdsAccount:RdsAccount")
class RdsAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 reset_permission_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RDS Account resource.

        For information about RDS Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-createaccount).

        > **NOTE:** Available since v1.120.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default.ids[0],
            engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.ids[0],
            vswitch_name=name)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="5.6",
            instance_type=default_get_instance_classes.instance_classes[1].instance_class,
            instance_storage=10,
            vswitch_id=default_switch.id,
            instance_name=name)
        default_rds_account = alicloud.rds.RdsAccount("default",
            db_instance_id=default_instance.id,
            account_name=name,
            account_password="Example1234")
        ```

        ## Import

        RDS Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/rdsAccount:RdsAccount example <db_instance_id>:<account_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
               
               > **NOTE:** The name cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] account_name: The name of the database account.
               * The name must be unique.
               * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
               * The name must start with a letter and end with a letter or digit.
               * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
               * The length of the value must meet the following requirements:
               * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
               * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
               * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
               * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
               * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
               * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
               * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] account_password: The password of the account.
               * The value must be 8 to 32 characters in length.
               * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
               * Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] account_type: The account type. Valid values:
               * Normal: standard account (default).
               * Super: privileged account.
               * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
               
               > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] db_instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] description: The attribute has been deprecated from 1.120.0 and using `account_description` instead.
        :param pulumi.Input[_builtins.str] instance_id: The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] name: The attribute has been deprecated from 1.120.0 and using `account_name` instead.
        :param pulumi.Input[_builtins.str] password: The attribute has been deprecated from 1.120.0 and using `account_password` instead.
        :param pulumi.Input[_builtins.bool] reset_permission_flag: Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
        :param pulumi.Input[_builtins.str] type: The attribute has been deprecated from 1.120.0 and using `account_type` instead.
               
               > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RdsAccountArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RDS Account resource.

        For information about RDS Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-createaccount).

        > **NOTE:** Available since v1.120.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default.ids[0],
            engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.ids[0],
            vswitch_name=name)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="5.6",
            instance_type=default_get_instance_classes.instance_classes[1].instance_class,
            instance_storage=10,
            vswitch_id=default_switch.id,
            instance_name=name)
        default_rds_account = alicloud.rds.RdsAccount("default",
            db_instance_id=default_instance.id,
            account_name=name,
            account_password="Example1234")
        ```

        ## Import

        RDS Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/rdsAccount:RdsAccount example <db_instance_id>:<account_name>
        ```

        :param str resource_name: The name of the resource.
        :param RdsAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RdsAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 reset_permission_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RdsAccountArgs.__new__(RdsAccountArgs)

            __props__.__dict__["account_description"] = account_description
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["account_password"] = None if account_password is None else pulumi.Output.secret(account_password)
            __props__.__dict__["account_type"] = account_type
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["reset_permission_flag"] = reset_permission_flag
            __props__.__dict__["type"] = type
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountPassword", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RdsAccount, __self__).__init__(
            'alicloud:rds/rdsAccount:RdsAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_description: Optional[pulumi.Input[_builtins.str]] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            account_password: Optional[pulumi.Input[_builtins.str]] = None,
            account_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            reset_permission_flag: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'RdsAccount':
        """
        Get an existing RdsAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.
               
               > **NOTE:** The name cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] account_name: The name of the database account.
               * The name must be unique.
               * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
               * The name must start with a letter and end with a letter or digit.
               * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
               * The length of the value must meet the following requirements:
               * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
               * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
               * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
               * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
               * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
               * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
               * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] account_password: The password of the account.
               * The value must be 8 to 32 characters in length.
               * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
               * Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] account_type: The account type. Valid values:
               * Normal: standard account (default).
               * Super: privileged account.
               * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.
               
               > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        :param pulumi.Input[_builtins.str] db_instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] description: The attribute has been deprecated from 1.120.0 and using `account_description` instead.
        :param pulumi.Input[_builtins.str] instance_id: The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] name: The attribute has been deprecated from 1.120.0 and using `account_name` instead.
        :param pulumi.Input[_builtins.str] password: The attribute has been deprecated from 1.120.0 and using `account_password` instead.
        :param pulumi.Input[_builtins.bool] reset_permission_flag: Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Available`, `Unavailable`.
        :param pulumi.Input[_builtins.str] type: The attribute has been deprecated from 1.120.0 and using `account_type` instead.
               
               > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RdsAccountState.__new__(_RdsAccountState)

        __props__.__dict__["account_description"] = account_description
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["account_type"] = account_type
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["reset_permission_flag"] = reset_permission_flag
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return RdsAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the account. The value must be 2 to 256 characters in length. The value can contain letters, digits, underscores (_), and hyphens (-), and must start with a letter.

        > **NOTE:** The name cannot start with http:// or https://.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database account.
        * The name must be unique.
        * The name can contain lowercase letters, digits, and underscores (_). For MySQL databases, the name can contain uppercase letters.
        * The name must start with a letter and end with a letter or digit.
        * For MySQL databases, the name of the privileged account cannot be the same as that of the standard account. For example, if the name of the privileged account is Test1, the name of the standard account cannot be test1.
        * The length of the value must meet the following requirements:
        * If the instance runs MySQL 5.7 or MySQL 8.0, the value must be 2 to 32 characters in length.
        * If the instance runs MySQL 5.6, the value must be 2 to 16 characters in length.
        * If the instance runs SQL Server, the value must be 2 to 64 characters in length.
        * If the instance runs PostgreSQL with cloud disks, the value must be 2 to 63 characters in length.
        * If the instance runs PostgreSQL with local disks, the value must be 2 to 16 characters in length.
        * If the instance runs MariaDB, the value must be 2 to 16 characters in length.
        * For more information about invalid characters, See [Forbidden keywords](https://help.aliyun.com/zh/rds/developer-reference/forbidden-keywords?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the account.
        * The value must be 8 to 32 characters in length.
        * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        * Special characters include ! @ # $ % ^ & * ( ) _ + - =
        """
        return pulumi.get(self, "account_password")

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The account type. Valid values:
        * Normal: standard account (default).
        * Super: privileged account.
        * Sysadmin: system admin account. The account type is available only for ApsaraDB RDS for SQL Server instances.

        > **NOTE:** Before you create a system admin account, check whether the RDS instance meets all prerequisites. For more information, See [Create a system admin account](https://help.aliyun.com/zh/rds/apsaradb-rds-for-sql-server/create-a-system-admin-account-for-an-apsaradb-rds-for-sql-server-instance?spm=api-workbench.API%20Document.0.0.529e2defHKoZ3o).
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'description' has been deprecated from provider version 1.120.0. New field 'account_description' instead.""")
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_description` instead.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    @_utilities.deprecated("""Field 'instance_id' has been deprecated from provider version 1.120.0. New field 'db_instance_id' instead.""")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The attribute has been deprecated from 1.120.0 and using `db_instance_id` instead.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.120.0. New field 'account_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'password' has been deprecated from provider version 1.120.0. New field 'account_password' instead.""")
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_password` instead.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="resetPermissionFlag")
    def reset_permission_flag(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Resets permissions flag of the privileged account. Default to `false`. Set it to `true` can resets permissions of the privileged account.
        """
        return pulumi.get(self, "reset_permission_flag")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `Available`, `Unavailable`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'type' has been deprecated from provider version 1.120.0. New field 'account_type' instead.""")
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The attribute has been deprecated from 1.120.0 and using `account_type` instead.

        > **NOTE**: Only MySQL engine is supported resets permissions of the privileged account.
        """
        return pulumi.get(self, "type")

