# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 abandon_able_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 abandonable_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resell_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] display_name: Member name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandon_able_check_ids: . Field 'abandon_able_check_id' has been deprecated from provider version 1.249.0. New field 'abandonable_check_id' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandonable_check_ids: The ID of the check item that can choose to abandon and continue to perform member deletion.
               The ID is obtained from the return parameter AbandonableChecks of GetAccountDeletionCheckResult.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix. Empty the system randomly generated.
               Format: English letters, numbers, and special characters_.-can be entered. It must start and end with an English letter or number, and continuous special characters_.-cannot be entered '_.-'.
               The format of the full account name is @< ResourceDirectoryId>.aliyunid.com, for example: 'alice @ rd-3G ****.aliyunid.com'
               The account name must be unique in the resource directory.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent folder
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force delete the account.
        :param pulumi.Input[_builtins.str] payer_account_id: The settlement account ID. If it is left blank, the newly created member will be used for self-settlement.
        :param pulumi.Input[_builtins.str] resell_account_type: The identity type of the member. Valid values:
               - resell: The member is an account for a reseller. This is the default value. A relationship is automatically established between the member and the reseller. The management account of the resource directory must be used as the billing account of the member.
               - non_resell: The member is not an account for a reseller. The member is an account that is not associated with a reseller. You can directly use the account to purchase Alibaba Cloud resources. The member is used as its own billing account.
               
               > **NOTE:**  This parameter is available only for resellers at the international site (alibabacloud.com).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] type: Member type. The value of ResourceAccount indicates the resource account
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        pulumi.set(__self__, "display_name", display_name)
        if abandon_able_check_ids is not None:
            warnings.warn("""Field 'abandon_able_check_id' has been deprecated since provider version 1.248.0. New field 'abandonable_check_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""abandon_able_check_ids is deprecated: Field 'abandon_able_check_id' has been deprecated since provider version 1.248.0. New field 'abandonable_check_id' instead.""")
        if abandon_able_check_ids is not None:
            pulumi.set(__self__, "abandon_able_check_ids", abandon_able_check_ids)
        if abandonable_check_ids is not None:
            pulumi.set(__self__, "abandonable_check_ids", abandonable_check_ids)
        if account_name_prefix is not None:
            pulumi.set(__self__, "account_name_prefix", account_name_prefix)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if payer_account_id is not None:
            pulumi.set(__self__, "payer_account_id", payer_account_id)
        if resell_account_type is not None:
            pulumi.set(__self__, "resell_account_type", resell_account_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Member name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="abandonAbleCheckIds")
    @_utilities.deprecated("""Field 'abandon_able_check_id' has been deprecated since provider version 1.248.0. New field 'abandonable_check_id' instead.""")
    def abandon_able_check_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        . Field 'abandon_able_check_id' has been deprecated from provider version 1.249.0. New field 'abandonable_check_id' instead.
        """
        return pulumi.get(self, "abandon_able_check_ids")

    @abandon_able_check_ids.setter
    def abandon_able_check_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "abandon_able_check_ids", value)

    @_builtins.property
    @pulumi.getter(name="abandonableCheckIds")
    def abandonable_check_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of the check item that can choose to abandon and continue to perform member deletion.
        The ID is obtained from the return parameter AbandonableChecks of GetAccountDeletionCheckResult.
        """
        return pulumi.get(self, "abandonable_check_ids")

    @abandonable_check_ids.setter
    def abandonable_check_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "abandonable_check_ids", value)

    @_builtins.property
    @pulumi.getter(name="accountNamePrefix")
    def account_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account name prefix. Empty the system randomly generated.
        Format: English letters, numbers, and special characters_.-can be entered. It must start and end with an English letter or number, and continuous special characters_.-cannot be entered '_.-'.
        The format of the full account name is @< ResourceDirectoryId>.aliyunid.com, for example: 'alice @ rd-3G ****.aliyunid.com'
        The account name must be unique in the resource directory.
        """
        return pulumi.get(self, "account_name_prefix")

    @account_name_prefix.setter
    def account_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the parent folder
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force delete the account.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The settlement account ID. If it is left blank, the newly created member will be used for self-settlement.
        """
        return pulumi.get(self, "payer_account_id")

    @payer_account_id.setter
    def payer_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payer_account_id", value)

    @_builtins.property
    @pulumi.getter(name="resellAccountType")
    def resell_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity type of the member. Valid values:
        - resell: The member is an account for a reseller. This is the default value. A relationship is automatically established between the member and the reseller. The management account of the resource directory must be used as the billing account of the member.
        - non_resell: The member is not an account for a reseller. The member is an account that is not associated with a reseller. You can directly use the account to purchase Alibaba Cloud resources. The member is used as its own billing account.

        > **NOTE:**  This parameter is available only for resellers at the international site (alibabacloud.com).
        """
        return pulumi.get(self, "resell_account_type")

    @resell_account_type.setter
    def resell_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resell_account_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Member type. The value of ResourceAccount indicates the resource account

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 abandon_able_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 abandonable_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 join_method: Optional[pulumi.Input[_builtins.str]] = None,
                 join_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_time: Optional[pulumi.Input[_builtins.str]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resell_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandon_able_check_ids: . Field 'abandon_able_check_id' has been deprecated from provider version 1.249.0. New field 'abandonable_check_id' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandonable_check_ids: The ID of the check item that can choose to abandon and continue to perform member deletion.
               The ID is obtained from the return parameter AbandonableChecks of GetAccountDeletionCheckResult.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix. Empty the system randomly generated.
               Format: English letters, numbers, and special characters_.-can be entered. It must start and end with an English letter or number, and continuous special characters_.-cannot be entered '_.-'.
               The format of the full account name is @< ResourceDirectoryId>.aliyunid.com, for example: 'alice @ rd-3G ****.aliyunid.com'
               The account name must be unique in the resource directory.
        :param pulumi.Input[_builtins.str] display_name: Member name
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent folder
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force delete the account.
        :param pulumi.Input[_builtins.str] join_method: Ways for members to join the resource directory.  invited, created
        :param pulumi.Input[_builtins.str] join_time: The time when the member joined the resource directory
        :param pulumi.Input[_builtins.str] modify_time: The modification time of the invitation
        :param pulumi.Input[_builtins.str] payer_account_id: The settlement account ID. If it is left blank, the newly created member will be used for self-settlement.
        :param pulumi.Input[_builtins.str] resell_account_type: The identity type of the member. Valid values:
               - resell: The member is an account for a reseller. This is the default value. A relationship is automatically established between the member and the reseller. The management account of the resource directory must be used as the billing account of the member.
               - non_resell: The member is not an account for a reseller. The member is an account that is not associated with a reseller. You can directly use the account to purchase Alibaba Cloud resources. The member is used as its own billing account.
               
               > **NOTE:**  This parameter is available only for resellers at the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.str] resource_directory_id: Resource directory ID
        :param pulumi.Input[_builtins.str] status: Member joining status.  CreateSuccess,CreateVerifying,CreateFailed,CreateExpired,CreateCancelled,PromoteVerifying,PromoteFailed,PromoteExpired,PromoteCancelled,PromoteSuccess,InviteSuccess,Removed
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] type: Member type. The value of ResourceAccount indicates the resource account
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if abandon_able_check_ids is not None:
            warnings.warn("""Field 'abandon_able_check_id' has been deprecated since provider version 1.248.0. New field 'abandonable_check_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""abandon_able_check_ids is deprecated: Field 'abandon_able_check_id' has been deprecated since provider version 1.248.0. New field 'abandonable_check_id' instead.""")
        if abandon_able_check_ids is not None:
            pulumi.set(__self__, "abandon_able_check_ids", abandon_able_check_ids)
        if abandonable_check_ids is not None:
            pulumi.set(__self__, "abandonable_check_ids", abandonable_check_ids)
        if account_name_prefix is not None:
            pulumi.set(__self__, "account_name_prefix", account_name_prefix)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if join_method is not None:
            pulumi.set(__self__, "join_method", join_method)
        if join_time is not None:
            pulumi.set(__self__, "join_time", join_time)
        if modify_time is not None:
            pulumi.set(__self__, "modify_time", modify_time)
        if payer_account_id is not None:
            pulumi.set(__self__, "payer_account_id", payer_account_id)
        if resell_account_type is not None:
            pulumi.set(__self__, "resell_account_type", resell_account_type)
        if resource_directory_id is not None:
            pulumi.set(__self__, "resource_directory_id", resource_directory_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="abandonAbleCheckIds")
    @_utilities.deprecated("""Field 'abandon_able_check_id' has been deprecated since provider version 1.248.0. New field 'abandonable_check_id' instead.""")
    def abandon_able_check_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        . Field 'abandon_able_check_id' has been deprecated from provider version 1.249.0. New field 'abandonable_check_id' instead.
        """
        return pulumi.get(self, "abandon_able_check_ids")

    @abandon_able_check_ids.setter
    def abandon_able_check_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "abandon_able_check_ids", value)

    @_builtins.property
    @pulumi.getter(name="abandonableCheckIds")
    def abandonable_check_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of the check item that can choose to abandon and continue to perform member deletion.
        The ID is obtained from the return parameter AbandonableChecks of GetAccountDeletionCheckResult.
        """
        return pulumi.get(self, "abandonable_check_ids")

    @abandonable_check_ids.setter
    def abandonable_check_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "abandonable_check_ids", value)

    @_builtins.property
    @pulumi.getter(name="accountNamePrefix")
    def account_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account name prefix. Empty the system randomly generated.
        Format: English letters, numbers, and special characters_.-can be entered. It must start and end with an English letter or number, and continuous special characters_.-cannot be entered '_.-'.
        The format of the full account name is @< ResourceDirectoryId>.aliyunid.com, for example: 'alice @ rd-3G ****.aliyunid.com'
        The account name must be unique in the resource directory.
        """
        return pulumi.get(self, "account_name_prefix")

    @account_name_prefix.setter
    def account_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Member name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the parent folder
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force delete the account.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="joinMethod")
    def join_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ways for members to join the resource directory.  invited, created
        """
        return pulumi.get(self, "join_method")

    @join_method.setter
    def join_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "join_method", value)

    @_builtins.property
    @pulumi.getter(name="joinTime")
    def join_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the member joined the resource directory
        """
        return pulumi.get(self, "join_time")

    @join_time.setter
    def join_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "join_time", value)

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The modification time of the invitation
        """
        return pulumi.get(self, "modify_time")

    @modify_time.setter
    def modify_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_time", value)

    @_builtins.property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The settlement account ID. If it is left blank, the newly created member will be used for self-settlement.
        """
        return pulumi.get(self, "payer_account_id")

    @payer_account_id.setter
    def payer_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payer_account_id", value)

    @_builtins.property
    @pulumi.getter(name="resellAccountType")
    def resell_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity type of the member. Valid values:
        - resell: The member is an account for a reseller. This is the default value. A relationship is automatically established between the member and the reseller. The management account of the resource directory must be used as the billing account of the member.
        - non_resell: The member is not an account for a reseller. The member is an account that is not associated with a reseller. You can directly use the account to purchase Alibaba Cloud resources. The member is used as its own billing account.

        > **NOTE:**  This parameter is available only for resellers at the international site (alibabacloud.com).
        """
        return pulumi.get(self, "resell_account_type")

    @resell_account_type.setter
    def resell_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resell_account_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource directory ID
        """
        return pulumi.get(self, "resource_directory_id")

    @resource_directory_id.setter
    def resource_directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_directory_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Member joining status.  CreateSuccess,CreateVerifying,CreateFailed,CreateExpired,CreateCancelled,PromoteVerifying,PromoteFailed,PromoteExpired,PromoteCancelled,PromoteSuccess,InviteSuccess,Removed
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Member type. The value of ResourceAccount indicates the resource account

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:resourcemanager/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abandon_able_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 abandonable_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resell_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Account resource.

        For information about Resource Manager Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/doc-detail/111231.htm).

        > **NOTE:** Available since v1.83.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        display_name = config.get("displayName")
        if display_name is None:
            display_name = "EAccount"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.resourcemanager.get_folders()
        example_account = alicloud.resourcemanager.Account("example",
            display_name=f"{display_name}-{default['result']}",
            folder_id=example.ids[0])
        ```

        ## Import

        Resource Manager Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/account:Account example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandon_able_check_ids: . Field 'abandon_able_check_id' has been deprecated from provider version 1.249.0. New field 'abandonable_check_id' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandonable_check_ids: The ID of the check item that can choose to abandon and continue to perform member deletion.
               The ID is obtained from the return parameter AbandonableChecks of GetAccountDeletionCheckResult.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix. Empty the system randomly generated.
               Format: English letters, numbers, and special characters_.-can be entered. It must start and end with an English letter or number, and continuous special characters_.-cannot be entered '_.-'.
               The format of the full account name is @< ResourceDirectoryId>.aliyunid.com, for example: 'alice @ rd-3G ****.aliyunid.com'
               The account name must be unique in the resource directory.
        :param pulumi.Input[_builtins.str] display_name: Member name
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent folder
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force delete the account.
        :param pulumi.Input[_builtins.str] payer_account_id: The settlement account ID. If it is left blank, the newly created member will be used for self-settlement.
        :param pulumi.Input[_builtins.str] resell_account_type: The identity type of the member. Valid values:
               - resell: The member is an account for a reseller. This is the default value. A relationship is automatically established between the member and the reseller. The management account of the resource directory must be used as the billing account of the member.
               - non_resell: The member is not an account for a reseller. The member is an account that is not associated with a reseller. You can directly use the account to purchase Alibaba Cloud resources. The member is used as its own billing account.
               
               > **NOTE:**  This parameter is available only for resellers at the international site (alibabacloud.com).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] type: Member type. The value of ResourceAccount indicates the resource account
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Account resource.

        For information about Resource Manager Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/doc-detail/111231.htm).

        > **NOTE:** Available since v1.83.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        display_name = config.get("displayName")
        if display_name is None:
            display_name = "EAccount"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.resourcemanager.get_folders()
        example_account = alicloud.resourcemanager.Account("example",
            display_name=f"{display_name}-{default['result']}",
            folder_id=example.ids[0])
        ```

        ## Import

        Resource Manager Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/account:Account example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abandon_able_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 abandonable_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resell_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["abandon_able_check_ids"] = abandon_able_check_ids
            __props__.__dict__["abandonable_check_ids"] = abandonable_check_ids
            __props__.__dict__["account_name_prefix"] = account_name_prefix
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["payer_account_id"] = payer_account_id
            __props__.__dict__["resell_account_type"] = resell_account_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["join_method"] = None
            __props__.__dict__["join_time"] = None
            __props__.__dict__["modify_time"] = None
            __props__.__dict__["resource_directory_id"] = None
            __props__.__dict__["status"] = None
        super(Account, __self__).__init__(
            'alicloud:resourcemanager/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            abandon_able_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            abandonable_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            join_method: Optional[pulumi.Input[_builtins.str]] = None,
            join_time: Optional[pulumi.Input[_builtins.str]] = None,
            modify_time: Optional[pulumi.Input[_builtins.str]] = None,
            payer_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            resell_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandon_able_check_ids: . Field 'abandon_able_check_id' has been deprecated from provider version 1.249.0. New field 'abandonable_check_id' instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] abandonable_check_ids: The ID of the check item that can choose to abandon and continue to perform member deletion.
               The ID is obtained from the return parameter AbandonableChecks of GetAccountDeletionCheckResult.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix. Empty the system randomly generated.
               Format: English letters, numbers, and special characters_.-can be entered. It must start and end with an English letter or number, and continuous special characters_.-cannot be entered '_.-'.
               The format of the full account name is @< ResourceDirectoryId>.aliyunid.com, for example: 'alice @ rd-3G ****.aliyunid.com'
               The account name must be unique in the resource directory.
        :param pulumi.Input[_builtins.str] display_name: Member name
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent folder
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force delete the account.
        :param pulumi.Input[_builtins.str] join_method: Ways for members to join the resource directory.  invited, created
        :param pulumi.Input[_builtins.str] join_time: The time when the member joined the resource directory
        :param pulumi.Input[_builtins.str] modify_time: The modification time of the invitation
        :param pulumi.Input[_builtins.str] payer_account_id: The settlement account ID. If it is left blank, the newly created member will be used for self-settlement.
        :param pulumi.Input[_builtins.str] resell_account_type: The identity type of the member. Valid values:
               - resell: The member is an account for a reseller. This is the default value. A relationship is automatically established between the member and the reseller. The management account of the resource directory must be used as the billing account of the member.
               - non_resell: The member is not an account for a reseller. The member is an account that is not associated with a reseller. You can directly use the account to purchase Alibaba Cloud resources. The member is used as its own billing account.
               
               > **NOTE:**  This parameter is available only for resellers at the international site (alibabacloud.com).
        :param pulumi.Input[_builtins.str] resource_directory_id: Resource directory ID
        :param pulumi.Input[_builtins.str] status: Member joining status.  CreateSuccess,CreateVerifying,CreateFailed,CreateExpired,CreateCancelled,PromoteVerifying,PromoteFailed,PromoteExpired,PromoteCancelled,PromoteSuccess,InviteSuccess,Removed
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] type: Member type. The value of ResourceAccount indicates the resource account
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["abandon_able_check_ids"] = abandon_able_check_ids
        __props__.__dict__["abandonable_check_ids"] = abandonable_check_ids
        __props__.__dict__["account_name_prefix"] = account_name_prefix
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["join_method"] = join_method
        __props__.__dict__["join_time"] = join_time
        __props__.__dict__["modify_time"] = modify_time
        __props__.__dict__["payer_account_id"] = payer_account_id
        __props__.__dict__["resell_account_type"] = resell_account_type
        __props__.__dict__["resource_directory_id"] = resource_directory_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="abandonAbleCheckIds")
    @_utilities.deprecated("""Field 'abandon_able_check_id' has been deprecated since provider version 1.248.0. New field 'abandonable_check_id' instead.""")
    def abandon_able_check_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        . Field 'abandon_able_check_id' has been deprecated from provider version 1.249.0. New field 'abandonable_check_id' instead.
        """
        return pulumi.get(self, "abandon_able_check_ids")

    @_builtins.property
    @pulumi.getter(name="abandonableCheckIds")
    def abandonable_check_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The ID of the check item that can choose to abandon and continue to perform member deletion.
        The ID is obtained from the return parameter AbandonableChecks of GetAccountDeletionCheckResult.
        """
        return pulumi.get(self, "abandonable_check_ids")

    @_builtins.property
    @pulumi.getter(name="accountNamePrefix")
    def account_name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Account name prefix. Empty the system randomly generated.
        Format: English letters, numbers, and special characters_.-can be entered. It must start and end with an English letter or number, and continuous special characters_.-cannot be entered '_.-'.
        The format of the full account name is @< ResourceDirectoryId>.aliyunid.com, for example: 'alice @ rd-3G ****.aliyunid.com'
        The account name must be unique in the resource directory.
        """
        return pulumi.get(self, "account_name_prefix")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Member name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the parent folder
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to force delete the account.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="joinMethod")
    def join_method(self) -> pulumi.Output[_builtins.str]:
        """
        Ways for members to join the resource directory.  invited, created
        """
        return pulumi.get(self, "join_method")

    @_builtins.property
    @pulumi.getter(name="joinTime")
    def join_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the member joined the resource directory
        """
        return pulumi.get(self, "join_time")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> pulumi.Output[_builtins.str]:
        """
        The modification time of the invitation
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The settlement account ID. If it is left blank, the newly created member will be used for self-settlement.
        """
        return pulumi.get(self, "payer_account_id")

    @_builtins.property
    @pulumi.getter(name="resellAccountType")
    def resell_account_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identity type of the member. Valid values:
        - resell: The member is an account for a reseller. This is the default value. A relationship is automatically established between the member and the reseller. The management account of the resource directory must be used as the billing account of the member.
        - non_resell: The member is not an account for a reseller. The member is an account that is not associated with a reseller. You can directly use the account to purchase Alibaba Cloud resources. The member is used as its own billing account.

        > **NOTE:**  This parameter is available only for resellers at the international site (alibabacloud.com).
        """
        return pulumi.get(self, "resell_account_type")

    @_builtins.property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource directory ID
        """
        return pulumi.get(self, "resource_directory_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Member joining status.  CreateSuccess,CreateVerifying,CreateFailed,CreateExpired,CreateCancelled,PromoteVerifying,PromoteFailed,PromoteExpired,PromoteCancelled,PromoteSuccess,InviteSuccess,Removed
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Member type. The value of ResourceAccount indicates the resource account

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "type")

