# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackGroupArgs', 'StackGroup']

@pulumi.input_type
class StackGroupArgs:
    def __init__(__self__, *,
                 stack_group_name: pulumi.Input[_builtins.str],
                 account_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]] = None,
                 region_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StackGroup resource.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group. The name must be unique in a region.
        :param pulumi.Input[_builtins.str] account_ids: The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] operation_description: The description of the operation.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation settings, in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]] parameters: The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
        :param pulumi.Input[_builtins.str] region_ids: The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] template_body: The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
        :param pulumi.Input[_builtins.str] template_url: The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        pulumi.set(__self__, "stack_group_name", stack_group_name)
        if account_ids is not None:
            pulumi.set(__self__, "account_ids", account_ids)
        if administration_role_name is not None:
            pulumi.set(__self__, "administration_role_name", administration_role_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role_name is not None:
            pulumi.set(__self__, "execution_role_name", execution_role_name)
        if operation_description is not None:
            pulumi.set(__self__, "operation_description", operation_description)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region_ids is not None:
            pulumi.set(__self__, "region_ids", region_ids)
        if template_body is not None:
            pulumi.set(__self__, "template_body", template_body)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if template_version is not None:
            pulumi.set(__self__, "template_version", template_version)

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the stack group. The name must be unique in a region.
        """
        return pulumi.get(self, "stack_group_name")

    @stack_group_name.setter
    def stack_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_group_name", value)

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
        """
        return pulumi.get(self, "account_ids")

    @account_ids.setter
    def account_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_ids", value)

    @_builtins.property
    @pulumi.getter(name="administrationRoleName")
    def administration_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        """
        return pulumi.get(self, "administration_role_name")

    @administration_role_name.setter
    def administration_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administration_role_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the stack group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionRoleName")
    def execution_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        """
        return pulumi.get(self, "execution_role_name")

    @execution_role_name.setter
    def execution_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_role_name", value)

    @_builtins.property
    @pulumi.getter(name="operationDescription")
    def operation_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the operation.
        """
        return pulumi.get(self, "operation_description")

    @operation_description.setter
    def operation_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_description", value)

    @_builtins.property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation settings, in JSON format.
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_preferences", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]:
        """
        The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="regionIds")
    def region_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
        """
        return pulumi.get(self, "region_ids")

    @region_ids.setter
    def region_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_ids", value)

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_body", value)

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_url", value)

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the template.
        """
        return pulumi.get(self, "template_version")

    @template_version.setter
    def template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_version", value)


@pulumi.input_type
class _StackGroupState:
    def __init__(__self__, *,
                 account_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]] = None,
                 region_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StackGroup resources.
        :param pulumi.Input[_builtins.str] account_ids: The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] operation_description: The description of the operation.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation settings, in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]] parameters: The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
        :param pulumi.Input[_builtins.str] region_ids: The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] stack_group_id: The id of Stack Group.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group. The name must be unique in a region.
        :param pulumi.Input[_builtins.str] status: The status of Stack Group.
        :param pulumi.Input[_builtins.str] template_body: The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
        :param pulumi.Input[_builtins.str] template_url: The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        if account_ids is not None:
            pulumi.set(__self__, "account_ids", account_ids)
        if administration_role_name is not None:
            pulumi.set(__self__, "administration_role_name", administration_role_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role_name is not None:
            pulumi.set(__self__, "execution_role_name", execution_role_name)
        if operation_description is not None:
            pulumi.set(__self__, "operation_description", operation_description)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region_ids is not None:
            pulumi.set(__self__, "region_ids", region_ids)
        if stack_group_id is not None:
            pulumi.set(__self__, "stack_group_id", stack_group_id)
        if stack_group_name is not None:
            pulumi.set(__self__, "stack_group_name", stack_group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template_body is not None:
            pulumi.set(__self__, "template_body", template_body)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if template_version is not None:
            pulumi.set(__self__, "template_version", template_version)

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
        """
        return pulumi.get(self, "account_ids")

    @account_ids.setter
    def account_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_ids", value)

    @_builtins.property
    @pulumi.getter(name="administrationRoleName")
    def administration_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        """
        return pulumi.get(self, "administration_role_name")

    @administration_role_name.setter
    def administration_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administration_role_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the stack group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionRoleName")
    def execution_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        """
        return pulumi.get(self, "execution_role_name")

    @execution_role_name.setter
    def execution_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_role_name", value)

    @_builtins.property
    @pulumi.getter(name="operationDescription")
    def operation_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the operation.
        """
        return pulumi.get(self, "operation_description")

    @operation_description.setter
    def operation_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_description", value)

    @_builtins.property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation settings, in JSON format.
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_preferences", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]:
        """
        The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackGroupParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="regionIds")
    def region_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
        """
        return pulumi.get(self, "region_ids")

    @region_ids.setter
    def region_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_ids", value)

    @_builtins.property
    @pulumi.getter(name="stackGroupId")
    def stack_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of Stack Group.
        """
        return pulumi.get(self, "stack_group_id")

    @stack_group_id.setter
    def stack_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_group_id", value)

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the stack group. The name must be unique in a region.
        """
        return pulumi.get(self, "stack_group_name")

    @stack_group_name.setter
    def stack_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_group_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of Stack Group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_body", value)

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_url", value)

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the template.
        """
        return pulumi.get(self, "template_version")

    @template_version.setter
    def template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_version", value)


@pulumi.type_token("alicloud:ros/stackGroup:StackGroup")
class StackGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]]] = None,
                 region_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ROS Stack Group resource.

        For information about ROS Stack Group and how to use it, see [What is Stack Group](https://www.alibabacloud.com/help/en/doc-detail/151333.htm).

        > **NOTE:** Available since v1.107.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ros.StackGroup("example",
            stack_group_name="example_value",
            template_body=\"\"\"    {
            \\x09"ROSTemplateFormatVersion": "2015-09-01"
            }
        \"\"\")
        ```

        ## Import

        ROS Stack Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ros/stackGroup:StackGroup example <stack_group_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_ids: The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] operation_description: The description of the operation.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation settings, in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]] parameters: The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
        :param pulumi.Input[_builtins.str] region_ids: The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group. The name must be unique in a region.
        :param pulumi.Input[_builtins.str] template_body: The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
        :param pulumi.Input[_builtins.str] template_url: The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ROS Stack Group resource.

        For information about ROS Stack Group and how to use it, see [What is Stack Group](https://www.alibabacloud.com/help/en/doc-detail/151333.htm).

        > **NOTE:** Available since v1.107.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ros.StackGroup("example",
            stack_group_name="example_value",
            template_body=\"\"\"    {
            \\x09"ROSTemplateFormatVersion": "2015-09-01"
            }
        \"\"\")
        ```

        ## Import

        ROS Stack Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ros/stackGroup:StackGroup example <stack_group_name>
        ```

        :param str resource_name: The name of the resource.
        :param StackGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]]] = None,
                 region_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_body: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackGroupArgs.__new__(StackGroupArgs)

            __props__.__dict__["account_ids"] = account_ids
            __props__.__dict__["administration_role_name"] = administration_role_name
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_role_name"] = execution_role_name
            __props__.__dict__["operation_description"] = operation_description
            __props__.__dict__["operation_preferences"] = operation_preferences
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["region_ids"] = region_ids
            if stack_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'stack_group_name'")
            __props__.__dict__["stack_group_name"] = stack_group_name
            __props__.__dict__["template_body"] = template_body
            __props__.__dict__["template_url"] = template_url
            __props__.__dict__["template_version"] = template_version
            __props__.__dict__["stack_group_id"] = None
            __props__.__dict__["status"] = None
        super(StackGroup, __self__).__init__(
            'alicloud:ros/stackGroup:StackGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_ids: Optional[pulumi.Input[_builtins.str]] = None,
            administration_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execution_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            operation_description: Optional[pulumi.Input[_builtins.str]] = None,
            operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]]] = None,
            region_ids: Optional[pulumi.Input[_builtins.str]] = None,
            stack_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            template_body: Optional[pulumi.Input[_builtins.str]] = None,
            template_url: Optional[pulumi.Input[_builtins.str]] = None,
            template_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'StackGroup':
        """
        Get an existing StackGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_ids: The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] administration_role_name: The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] description: The description of the stack group.
        :param pulumi.Input[_builtins.str] execution_role_name: The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        :param pulumi.Input[_builtins.str] operation_description: The description of the operation.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation settings, in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackGroupParameterArgs', 'StackGroupParameterArgsDict']]]] parameters: The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
        :param pulumi.Input[_builtins.str] region_ids: The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
        :param pulumi.Input[_builtins.str] stack_group_id: The id of Stack Group.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group. The name must be unique in a region.
        :param pulumi.Input[_builtins.str] status: The status of Stack Group.
        :param pulumi.Input[_builtins.str] template_body: The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
        :param pulumi.Input[_builtins.str] template_url: The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
        :param pulumi.Input[_builtins.str] template_version: The version of the template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackGroupState.__new__(_StackGroupState)

        __props__.__dict__["account_ids"] = account_ids
        __props__.__dict__["administration_role_name"] = administration_role_name
        __props__.__dict__["description"] = description
        __props__.__dict__["execution_role_name"] = execution_role_name
        __props__.__dict__["operation_description"] = operation_description
        __props__.__dict__["operation_preferences"] = operation_preferences
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region_ids"] = region_ids
        __props__.__dict__["stack_group_id"] = stack_group_id
        __props__.__dict__["stack_group_name"] = stack_group_name
        __props__.__dict__["status"] = status
        __props__.__dict__["template_body"] = template_body
        __props__.__dict__["template_url"] = template_url
        __props__.__dict__["template_version"] = template_version
        return StackGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
        """
        return pulumi.get(self, "account_ids")

    @_builtins.property
    @pulumi.getter(name="administrationRoleName")
    def administration_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        """
        return pulumi.get(self, "administration_role_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the stack group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executionRoleName")
    def execution_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
        """
        return pulumi.get(self, "execution_role_name")

    @_builtins.property
    @pulumi.getter(name="operationDescription")
    def operation_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the operation.
        """
        return pulumi.get(self, "operation_description")

    @_builtins.property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operation settings, in JSON format.
        """
        return pulumi.get(self, "operation_preferences")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.StackGroupParameter']]]:
        """
        The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="regionIds")
    def region_ids(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
        """
        return pulumi.get(self, "region_ids")

    @_builtins.property
    @pulumi.getter(name="stackGroupId")
    def stack_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of Stack Group.
        """
        return pulumi.get(self, "stack_group_id")

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the stack group. The name must be unique in a region.
        """
        return pulumi.get(self, "stack_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of Stack Group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
        """
        return pulumi.get(self, "template_body")

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
        """
        return pulumi.get(self, "template_url")

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of the template.
        """
        return pulumi.get(self, "template_version")

