# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[_builtins.str],
                 package_type: pulumi.Input[_builtins.str],
                 replicas: pulumi.Input[_builtins.int],
                 acr_assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 acr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_enable_application_scaling_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 batch_wait_time: Optional[pulumi.Input[_builtins.int]] = None,
                 change_order_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_map_mount_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 config_map_mount_desc_v2s: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_host_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_host_alias_v2s: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]]] = None,
                 deploy: Optional[pulumi.Input[_builtins.bool]] = None,
                 edas_container_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ahas: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_grey_tag_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 envs: Optional[pulumi.Input[_builtins.str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[_builtins.str]] = None,
                 image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_args: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 jdk: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_configs: Optional[pulumi.Input['ApplicationKafkaConfigsArgs']] = None,
                 liveness: Optional[pulumi.Input[_builtins.str]] = None,
                 liveness_v2: Optional[pulumi.Input['ApplicationLivenessV2Args']] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 micro_registration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_ready_instance_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]]] = None,
                 oss_ak_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_ak_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs_v2s: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]]] = None,
                 package_url: Optional[pulumi.Input[_builtins.str]] = None,
                 package_version: Optional[pulumi.Input[_builtins.str]] = None,
                 php: Optional[pulumi.Input[_builtins.str]] = None,
                 php_arms_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start_v2: Optional[pulumi.Input['ApplicationPostStartV2Args']] = None,
                 pre_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_v2: Optional[pulumi.Input['ApplicationPreStopV2Args']] = None,
                 programming_language: Optional[pulumi.Input[_builtins.str]] = None,
                 pvtz_discovery_svc: Optional[pulumi.Input['ApplicationPvtzDiscoverySvcArgs']] = None,
                 readiness: Optional[pulumi.Input[_builtins.str]] = None,
                 readiness_v2: Optional[pulumi.Input['ApplicationReadinessV2Args']] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_configs: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config_v2: Optional[pulumi.Input['ApplicationTomcatConfigV2Args']] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 update_strategy_v2: Optional[pulumi.Input['ApplicationUpdateStrategyV2Args']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 war_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 web_container: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[_builtins.str] app_name: Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
        :param pulumi.Input[_builtins.str] package_type: Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
        :param pulumi.Input[_builtins.int] replicas: Initial number of instances.
        :param pulumi.Input[_builtins.str] acr_assume_role_arn: The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] acr_instance_id: The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] app_description: Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
        :param pulumi.Input[_builtins.bool] auto_config: The auto config. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] auto_enable_application_scaling_rule: The auto enable application scaling rule. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.int] batch_wait_time: The batch wait time.
        :param pulumi.Input[_builtins.str] change_order_desc: The change order desc.
        :param pulumi.Input[_builtins.str] command: Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
        :param pulumi.Input[_builtins.str] command_args: Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_args_v2s: The parameters of the image startup command.
        :param pulumi.Input[_builtins.str] config_map_mount_desc: ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]] config_map_mount_desc_v2s: The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
        :param pulumi.Input[_builtins.int] cpu: The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
        :param pulumi.Input[_builtins.str] custom_host_alias: Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127.0.0.1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]] custom_host_alias_v2s: The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
        :param pulumi.Input[_builtins.bool] deploy: The deploy. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] edas_container_version: The operating environment used by the Pandora application.
        :param pulumi.Input[_builtins.str] enable_ahas: The enable ahas. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_grey_tag_route: The enable grey tag route. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] envs: Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
        :param pulumi.Input[_builtins.str] image_pull_secrets: The ID of the corresponding Secret.
        :param pulumi.Input[_builtins.str] image_url: Mirror address. Only Image type applications can configure the mirror address.
        :param pulumi.Input[_builtins.str] jar_start_args: The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jar_start_options: The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jdk: The JDK version that the deployment package depends on. Image type applications are not supported.
        :param pulumi.Input['ApplicationKafkaConfigsArgs'] kafka_configs: The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
        :param pulumi.Input[_builtins.str] liveness: Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
               **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
        :param pulumi.Input['ApplicationLivenessV2Args'] liveness_v2: The liveness check settings of the container. See `liveness_v2` below.
        :param pulumi.Input[_builtins.int] memory: The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
        :param pulumi.Input[_builtins.str] micro_registration: Select the Nacos registry. Valid values: `0`, `1`, `2`.
        :param pulumi.Input[_builtins.int] min_ready_instance_ratio: Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
               * `-1`: Initialization value, indicating that percentages are not used.
               * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
        :param pulumi.Input[_builtins.int] min_ready_instances: The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
        :param pulumi.Input[_builtins.str] namespace_id: SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]] nas_configs: The configurations for mounting the NAS file system. See `nas_configs` below.
        :param pulumi.Input[_builtins.str] oss_ak_id: OSS AccessKey ID.
        :param pulumi.Input[_builtins.str] oss_ak_secret: OSS  AccessKey Secret.
        :param pulumi.Input[_builtins.str] oss_mount_descs: OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]] oss_mount_descs_v2s: The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
        :param pulumi.Input[_builtins.str] package_url: Deployment package address. Only FatJar or War type applications can configure the deployment package address.
        :param pulumi.Input[_builtins.str] package_version: The version number of the deployment package. Required when the Package Type is War and FatJar.
        :param pulumi.Input[_builtins.str] php: The Php environment.
        :param pulumi.Input[_builtins.str] php_arms_config_location: The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
        :param pulumi.Input[_builtins.str] php_config: PHP configuration file content.
        :param pulumi.Input[_builtins.str] php_config_location: PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
        :param pulumi.Input[_builtins.str] post_start: Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
        :param pulumi.Input['ApplicationPostStartV2Args'] post_start_v2: The script that is run immediately after the container is started. See `post_start_v2` below.
        :param pulumi.Input[_builtins.str] pre_stop: Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
        :param pulumi.Input['ApplicationPreStopV2Args'] pre_stop_v2: The script that is run before the container is stopped. See `pre_stop_v2` below.
        :param pulumi.Input[_builtins.str] programming_language: The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
        :param pulumi.Input['ApplicationPvtzDiscoverySvcArgs'] pvtz_discovery_svc: The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
        :param pulumi.Input[_builtins.str] readiness: Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start.sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
               **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
        :param pulumi.Input['ApplicationReadinessV2Args'] readiness_v2: The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        :param pulumi.Input[_builtins.str] sls_configs: Configuration for log collection to SLS. Valid parameter descriptions are as follows:
               * `projectName`: Configures the project name on SLS.
               * `logDir`: Path to the logs.
               * `logType`: Type of logs. stdout indicates container standard output logs, and only one can be set; if not set, it means collecting file logs.
               * `logstoreName`: Configures the log store name on SLS.
               * `logtailName`: Configures the log tail name on SLS; if not specified, it means creating a new log tail.
               
               If you no longer need to use the SLS collection feature, you should set the value of this field to an empty string. There are two examples:
               - Using SAE automatically created SLS resources: [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}].
               - Using custom SLS resources: [{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}].
               
               **NOTE:** Projects that are automatically created with applications will be deleted along with the application deletion. Therefore, when selecting existing projects, you cannot choose projects automatically created by SAE.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
        :param pulumi.Input[_builtins.str] timezone: Time zone. Default value: `Asia/Shanghai`.
        :param pulumi.Input[_builtins.str] tomcat_config: Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
               **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
        :param pulumi.Input['ApplicationTomcatConfigV2Args'] tomcat_config_v2: The Tomcat configuration. See `tomcat_config_v2` below.
        :param pulumi.Input[_builtins.str] update_strategy: The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
        :param pulumi.Input['ApplicationUpdateStrategyV2Args'] update_strategy_v2: The release policy. See `update_strategy_v2` below.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
        :param pulumi.Input[_builtins.str] war_start_options: WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
        :param pulumi.Input[_builtins.str] web_container: The version of tomcat that the deployment package depends on. Image type applications are not supported.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "replicas", replicas)
        if acr_assume_role_arn is not None:
            pulumi.set(__self__, "acr_assume_role_arn", acr_assume_role_arn)
        if acr_instance_id is not None:
            pulumi.set(__self__, "acr_instance_id", acr_instance_id)
        if app_description is not None:
            pulumi.set(__self__, "app_description", app_description)
        if auto_config is not None:
            pulumi.set(__self__, "auto_config", auto_config)
        if auto_enable_application_scaling_rule is not None:
            pulumi.set(__self__, "auto_enable_application_scaling_rule", auto_enable_application_scaling_rule)
        if batch_wait_time is not None:
            pulumi.set(__self__, "batch_wait_time", batch_wait_time)
        if change_order_desc is not None:
            pulumi.set(__self__, "change_order_desc", change_order_desc)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if command_args is not None:
            warnings.warn("""Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""command_args is deprecated: Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.""")
        if command_args is not None:
            pulumi.set(__self__, "command_args", command_args)
        if command_args_v2s is not None:
            pulumi.set(__self__, "command_args_v2s", command_args_v2s)
        if config_map_mount_desc is not None:
            warnings.warn("""Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""config_map_mount_desc is deprecated: Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.""")
        if config_map_mount_desc is not None:
            pulumi.set(__self__, "config_map_mount_desc", config_map_mount_desc)
        if config_map_mount_desc_v2s is not None:
            pulumi.set(__self__, "config_map_mount_desc_v2s", config_map_mount_desc_v2s)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if custom_host_alias is not None:
            warnings.warn("""Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""custom_host_alias is deprecated: Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.""")
        if custom_host_alias is not None:
            pulumi.set(__self__, "custom_host_alias", custom_host_alias)
        if custom_host_alias_v2s is not None:
            pulumi.set(__self__, "custom_host_alias_v2s", custom_host_alias_v2s)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if edas_container_version is not None:
            pulumi.set(__self__, "edas_container_version", edas_container_version)
        if enable_ahas is not None:
            pulumi.set(__self__, "enable_ahas", enable_ahas)
        if enable_grey_tag_route is not None:
            pulumi.set(__self__, "enable_grey_tag_route", enable_grey_tag_route)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if jar_start_args is not None:
            pulumi.set(__self__, "jar_start_args", jar_start_args)
        if jar_start_options is not None:
            pulumi.set(__self__, "jar_start_options", jar_start_options)
        if jdk is not None:
            pulumi.set(__self__, "jdk", jdk)
        if kafka_configs is not None:
            pulumi.set(__self__, "kafka_configs", kafka_configs)
        if liveness is not None:
            warnings.warn("""Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""liveness is deprecated: Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.""")
        if liveness is not None:
            pulumi.set(__self__, "liveness", liveness)
        if liveness_v2 is not None:
            pulumi.set(__self__, "liveness_v2", liveness_v2)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if micro_registration is not None:
            pulumi.set(__self__, "micro_registration", micro_registration)
        if min_ready_instance_ratio is not None:
            pulumi.set(__self__, "min_ready_instance_ratio", min_ready_instance_ratio)
        if min_ready_instances is not None:
            pulumi.set(__self__, "min_ready_instances", min_ready_instances)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if nas_configs is not None:
            pulumi.set(__self__, "nas_configs", nas_configs)
        if oss_ak_id is not None:
            pulumi.set(__self__, "oss_ak_id", oss_ak_id)
        if oss_ak_secret is not None:
            pulumi.set(__self__, "oss_ak_secret", oss_ak_secret)
        if oss_mount_descs is not None:
            warnings.warn("""Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""oss_mount_descs is deprecated: Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.""")
        if oss_mount_descs is not None:
            pulumi.set(__self__, "oss_mount_descs", oss_mount_descs)
        if oss_mount_descs_v2s is not None:
            pulumi.set(__self__, "oss_mount_descs_v2s", oss_mount_descs_v2s)
        if package_url is not None:
            pulumi.set(__self__, "package_url", package_url)
        if package_version is not None:
            pulumi.set(__self__, "package_version", package_version)
        if php is not None:
            pulumi.set(__self__, "php", php)
        if php_arms_config_location is not None:
            pulumi.set(__self__, "php_arms_config_location", php_arms_config_location)
        if php_config is not None:
            pulumi.set(__self__, "php_config", php_config)
        if php_config_location is not None:
            pulumi.set(__self__, "php_config_location", php_config_location)
        if post_start is not None:
            warnings.warn("""Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""post_start is deprecated: Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.""")
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if post_start_v2 is not None:
            pulumi.set(__self__, "post_start_v2", post_start_v2)
        if pre_stop is not None:
            warnings.warn("""Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""pre_stop is deprecated: Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.""")
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)
        if pre_stop_v2 is not None:
            pulumi.set(__self__, "pre_stop_v2", pre_stop_v2)
        if programming_language is not None:
            pulumi.set(__self__, "programming_language", programming_language)
        if pvtz_discovery_svc is not None:
            pulumi.set(__self__, "pvtz_discovery_svc", pvtz_discovery_svc)
        if readiness is not None:
            warnings.warn("""Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""readiness is deprecated: Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.""")
        if readiness is not None:
            pulumi.set(__self__, "readiness", readiness)
        if readiness_v2 is not None:
            pulumi.set(__self__, "readiness_v2", readiness_v2)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if sls_configs is not None:
            pulumi.set(__self__, "sls_configs", sls_configs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if tomcat_config is not None:
            warnings.warn("""Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""tomcat_config is deprecated: Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.""")
        if tomcat_config is not None:
            pulumi.set(__self__, "tomcat_config", tomcat_config)
        if tomcat_config_v2 is not None:
            pulumi.set(__self__, "tomcat_config_v2", tomcat_config_v2)
        if update_strategy is not None:
            warnings.warn("""Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""update_strategy is deprecated: Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.""")
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)
        if update_strategy_v2 is not None:
            pulumi.set(__self__, "update_strategy_v2", update_strategy_v2)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if war_start_options is not None:
            pulumi.set(__self__, "war_start_options", war_start_options)
        if web_container is not None:
            pulumi.set(__self__, "web_container", web_container)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[_builtins.str]:
        """
        Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Input[_builtins.str]:
        """
        Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[_builtins.int]:
        """
        Initial number of instances.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="acrAssumeRoleArn")
    def acr_assume_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
        """
        return pulumi.get(self, "acr_assume_role_arn")

    @acr_assume_role_arn.setter
    def acr_assume_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acr_assume_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="acrInstanceId")
    def acr_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
        """
        return pulumi.get(self, "acr_instance_id")

    @acr_instance_id.setter
    def acr_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acr_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="appDescription")
    def app_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
        """
        return pulumi.get(self, "app_description")

    @app_description.setter
    def app_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_description", value)

    @_builtins.property
    @pulumi.getter(name="autoConfig")
    def auto_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The auto config. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_config")

    @auto_config.setter
    def auto_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_config", value)

    @_builtins.property
    @pulumi.getter(name="autoEnableApplicationScalingRule")
    def auto_enable_application_scaling_rule(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The auto enable application scaling rule. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_enable_application_scaling_rule")

    @auto_enable_application_scaling_rule.setter
    def auto_enable_application_scaling_rule(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_enable_application_scaling_rule", value)

    @_builtins.property
    @pulumi.getter(name="batchWaitTime")
    def batch_wait_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The batch wait time.
        """
        return pulumi.get(self, "batch_wait_time")

    @batch_wait_time.setter
    def batch_wait_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "batch_wait_time", value)

    @_builtins.property
    @pulumi.getter(name="changeOrderDesc")
    def change_order_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The change order desc.
        """
        return pulumi.get(self, "change_order_desc")

    @change_order_desc.setter
    def change_order_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "change_order_desc", value)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter(name="commandArgs")
    @_utilities.deprecated("""Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.""")
    def command_args(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
        """
        return pulumi.get(self, "command_args")

    @command_args.setter
    def command_args(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command_args", value)

    @_builtins.property
    @pulumi.getter(name="commandArgsV2s")
    def command_args_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The parameters of the image startup command.
        """
        return pulumi.get(self, "command_args_v2s")

    @command_args_v2s.setter
    def command_args_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "command_args_v2s", value)

    @_builtins.property
    @pulumi.getter(name="configMapMountDesc")
    @_utilities.deprecated("""Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.""")
    def config_map_mount_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
        """
        return pulumi.get(self, "config_map_mount_desc")

    @config_map_mount_desc.setter
    def config_map_mount_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_map_mount_desc", value)

    @_builtins.property
    @pulumi.getter(name="configMapMountDescV2s")
    def config_map_mount_desc_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]]]:
        """
        The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
        """
        return pulumi.get(self, "config_map_mount_desc_v2s")

    @config_map_mount_desc_v2s.setter
    def config_map_mount_desc_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]]]):
        pulumi.set(self, "config_map_mount_desc_v2s", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="customHostAlias")
    @_utilities.deprecated("""Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.""")
    def custom_host_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127.0.0.1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
        """
        return pulumi.get(self, "custom_host_alias")

    @custom_host_alias.setter
    def custom_host_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_host_alias", value)

    @_builtins.property
    @pulumi.getter(name="customHostAliasV2s")
    def custom_host_alias_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]]]:
        """
        The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
        """
        return pulumi.get(self, "custom_host_alias_v2s")

    @custom_host_alias_v2s.setter
    def custom_host_alias_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]]]):
        pulumi.set(self, "custom_host_alias_v2s", value)

    @_builtins.property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The deploy. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deploy", value)

    @_builtins.property
    @pulumi.getter(name="edasContainerVersion")
    def edas_container_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating environment used by the Pandora application.
        """
        return pulumi.get(self, "edas_container_version")

    @edas_container_version.setter
    def edas_container_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edas_container_version", value)

    @_builtins.property
    @pulumi.getter(name="enableAhas")
    def enable_ahas(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enable ahas. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_ahas")

    @enable_ahas.setter
    def enable_ahas(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_ahas", value)

    @_builtins.property
    @pulumi.getter(name="enableGreyTagRoute")
    def enable_grey_tag_route(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The enable grey tag route. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_grey_tag_route")

    @enable_grey_tag_route.setter
    def enable_grey_tag_route(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_grey_tag_route", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the corresponding Secret.
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_pull_secrets", value)

    @_builtins.property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mirror address. Only Image type applications can configure the mirror address.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_url", value)

    @_builtins.property
    @pulumi.getter(name="jarStartArgs")
    def jar_start_args(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        """
        return pulumi.get(self, "jar_start_args")

    @jar_start_args.setter
    def jar_start_args(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jar_start_args", value)

    @_builtins.property
    @pulumi.getter(name="jarStartOptions")
    def jar_start_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        """
        return pulumi.get(self, "jar_start_options")

    @jar_start_options.setter
    def jar_start_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jar_start_options", value)

    @_builtins.property
    @pulumi.getter
    def jdk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JDK version that the deployment package depends on. Image type applications are not supported.
        """
        return pulumi.get(self, "jdk")

    @jdk.setter
    def jdk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdk", value)

    @_builtins.property
    @pulumi.getter(name="kafkaConfigs")
    def kafka_configs(self) -> Optional[pulumi.Input['ApplicationKafkaConfigsArgs']]:
        """
        The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
        """
        return pulumi.get(self, "kafka_configs")

    @kafka_configs.setter
    def kafka_configs(self, value: Optional[pulumi.Input['ApplicationKafkaConfigsArgs']]):
        pulumi.set(self, "kafka_configs", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.""")
    def liveness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
        **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
        """
        return pulumi.get(self, "liveness")

    @liveness.setter
    def liveness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "liveness", value)

    @_builtins.property
    @pulumi.getter(name="livenessV2")
    def liveness_v2(self) -> Optional[pulumi.Input['ApplicationLivenessV2Args']]:
        """
        The liveness check settings of the container. See `liveness_v2` below.
        """
        return pulumi.get(self, "liveness_v2")

    @liveness_v2.setter
    def liveness_v2(self, value: Optional[pulumi.Input['ApplicationLivenessV2Args']]):
        pulumi.set(self, "liveness_v2", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="microRegistration")
    def micro_registration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select the Nacos registry. Valid values: `0`, `1`, `2`.
        """
        return pulumi.get(self, "micro_registration")

    @micro_registration.setter
    def micro_registration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "micro_registration", value)

    @_builtins.property
    @pulumi.getter(name="minReadyInstanceRatio")
    def min_ready_instance_ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
        * `-1`: Initialization value, indicating that percentages are not used.
        * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
        """
        return pulumi.get(self, "min_ready_instance_ratio")

    @min_ready_instance_ratio.setter
    def min_ready_instance_ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ready_instance_ratio", value)

    @_builtins.property
    @pulumi.getter(name="minReadyInstances")
    def min_ready_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
        """
        return pulumi.get(self, "min_ready_instances")

    @min_ready_instances.setter
    def min_ready_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ready_instances", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="nasConfigs")
    def nas_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]]]:
        """
        The configurations for mounting the NAS file system. See `nas_configs` below.
        """
        return pulumi.get(self, "nas_configs")

    @nas_configs.setter
    def nas_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]]]):
        pulumi.set(self, "nas_configs", value)

    @_builtins.property
    @pulumi.getter(name="ossAkId")
    def oss_ak_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS AccessKey ID.
        """
        return pulumi.get(self, "oss_ak_id")

    @oss_ak_id.setter
    def oss_ak_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_ak_id", value)

    @_builtins.property
    @pulumi.getter(name="ossAkSecret")
    def oss_ak_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS  AccessKey Secret.
        """
        return pulumi.get(self, "oss_ak_secret")

    @oss_ak_secret.setter
    def oss_ak_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_ak_secret", value)

    @_builtins.property
    @pulumi.getter(name="ossMountDescs")
    @_utilities.deprecated("""Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.""")
    def oss_mount_descs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
        """
        return pulumi.get(self, "oss_mount_descs")

    @oss_mount_descs.setter
    def oss_mount_descs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_mount_descs", value)

    @_builtins.property
    @pulumi.getter(name="ossMountDescsV2s")
    def oss_mount_descs_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]]]:
        """
        The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
        """
        return pulumi.get(self, "oss_mount_descs_v2s")

    @oss_mount_descs_v2s.setter
    def oss_mount_descs_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]]]):
        pulumi.set(self, "oss_mount_descs_v2s", value)

    @_builtins.property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment package address. Only FatJar or War type applications can configure the deployment package address.
        """
        return pulumi.get(self, "package_url")

    @package_url.setter
    def package_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_url", value)

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number of the deployment package. Required when the Package Type is War and FatJar.
        """
        return pulumi.get(self, "package_version")

    @package_version.setter
    def package_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_version", value)

    @_builtins.property
    @pulumi.getter
    def php(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Php environment.
        """
        return pulumi.get(self, "php")

    @php.setter
    def php(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php", value)

    @_builtins.property
    @pulumi.getter(name="phpArmsConfigLocation")
    def php_arms_config_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
        """
        return pulumi.get(self, "php_arms_config_location")

    @php_arms_config_location.setter
    def php_arms_config_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php_arms_config_location", value)

    @_builtins.property
    @pulumi.getter(name="phpConfig")
    def php_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PHP configuration file content.
        """
        return pulumi.get(self, "php_config")

    @php_config.setter
    def php_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php_config", value)

    @_builtins.property
    @pulumi.getter(name="phpConfigLocation")
    def php_config_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
        """
        return pulumi.get(self, "php_config_location")

    @php_config_location.setter
    def php_config_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php_config_location", value)

    @_builtins.property
    @pulumi.getter(name="postStart")
    @_utilities.deprecated("""Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.""")
    def post_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
        """
        return pulumi.get(self, "post_start")

    @post_start.setter
    def post_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_start", value)

    @_builtins.property
    @pulumi.getter(name="postStartV2")
    def post_start_v2(self) -> Optional[pulumi.Input['ApplicationPostStartV2Args']]:
        """
        The script that is run immediately after the container is started. See `post_start_v2` below.
        """
        return pulumi.get(self, "post_start_v2")

    @post_start_v2.setter
    def post_start_v2(self, value: Optional[pulumi.Input['ApplicationPostStartV2Args']]):
        pulumi.set(self, "post_start_v2", value)

    @_builtins.property
    @pulumi.getter(name="preStop")
    @_utilities.deprecated("""Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.""")
    def pre_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
        """
        return pulumi.get(self, "pre_stop")

    @pre_stop.setter
    def pre_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_stop", value)

    @_builtins.property
    @pulumi.getter(name="preStopV2")
    def pre_stop_v2(self) -> Optional[pulumi.Input['ApplicationPreStopV2Args']]:
        """
        The script that is run before the container is stopped. See `pre_stop_v2` below.
        """
        return pulumi.get(self, "pre_stop_v2")

    @pre_stop_v2.setter
    def pre_stop_v2(self, value: Optional[pulumi.Input['ApplicationPreStopV2Args']]):
        pulumi.set(self, "pre_stop_v2", value)

    @_builtins.property
    @pulumi.getter(name="programmingLanguage")
    def programming_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
        """
        return pulumi.get(self, "programming_language")

    @programming_language.setter
    def programming_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "programming_language", value)

    @_builtins.property
    @pulumi.getter(name="pvtzDiscoverySvc")
    def pvtz_discovery_svc(self) -> Optional[pulumi.Input['ApplicationPvtzDiscoverySvcArgs']]:
        """
        The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
        """
        return pulumi.get(self, "pvtz_discovery_svc")

    @pvtz_discovery_svc.setter
    def pvtz_discovery_svc(self, value: Optional[pulumi.Input['ApplicationPvtzDiscoverySvcArgs']]):
        pulumi.set(self, "pvtz_discovery_svc", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.""")
    def readiness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start.sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
        **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
        """
        return pulumi.get(self, "readiness")

    @readiness.setter
    def readiness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "readiness", value)

    @_builtins.property
    @pulumi.getter(name="readinessV2")
    def readiness_v2(self) -> Optional[pulumi.Input['ApplicationReadinessV2Args']]:
        """
        The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
        """
        return pulumi.get(self, "readiness_v2")

    @readiness_v2.setter
    def readiness_v2(self, value: Optional[pulumi.Input['ApplicationReadinessV2Args']]):
        pulumi.set(self, "readiness_v2", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="slsConfigs")
    def sls_configs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration for log collection to SLS. Valid parameter descriptions are as follows:
        * `projectName`: Configures the project name on SLS.
        * `logDir`: Path to the logs.
        * `logType`: Type of logs. stdout indicates container standard output logs, and only one can be set; if not set, it means collecting file logs.
        * `logstoreName`: Configures the log store name on SLS.
        * `logtailName`: Configures the log tail name on SLS; if not specified, it means creating a new log tail.

        If you no longer need to use the SLS collection feature, you should set the value of this field to an empty string. There are two examples:
        - Using SAE automatically created SLS resources: [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}].
        - Using custom SLS resources: [{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}].

        **NOTE:** Projects that are automatically created with applications will be deleted along with the application deletion. Therefore, when selecting existing projects, you cannot choose projects automatically created by SAE.
        """
        return pulumi.get(self, "sls_configs")

    @sls_configs.setter
    def sls_configs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_configs", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone. Default value: `Asia/Shanghai`.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="tomcatConfig")
    @_utilities.deprecated("""Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.""")
    def tomcat_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
        **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
        """
        return pulumi.get(self, "tomcat_config")

    @tomcat_config.setter
    def tomcat_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tomcat_config", value)

    @_builtins.property
    @pulumi.getter(name="tomcatConfigV2")
    def tomcat_config_v2(self) -> Optional[pulumi.Input['ApplicationTomcatConfigV2Args']]:
        """
        The Tomcat configuration. See `tomcat_config_v2` below.
        """
        return pulumi.get(self, "tomcat_config_v2")

    @tomcat_config_v2.setter
    def tomcat_config_v2(self, value: Optional[pulumi.Input['ApplicationTomcatConfigV2Args']]):
        pulumi.set(self, "tomcat_config_v2", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    @_utilities.deprecated("""Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.""")
    def update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_strategy", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategyV2")
    def update_strategy_v2(self) -> Optional[pulumi.Input['ApplicationUpdateStrategyV2Args']]:
        """
        The release policy. See `update_strategy_v2` below.
        """
        return pulumi.get(self, "update_strategy_v2")

    @update_strategy_v2.setter
    def update_strategy_v2(self, value: Optional[pulumi.Input['ApplicationUpdateStrategyV2Args']]):
        pulumi.set(self, "update_strategy_v2", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="warStartOptions")
    def war_start_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
        """
        return pulumi.get(self, "war_start_options")

    @war_start_options.setter
    def war_start_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "war_start_options", value)

    @_builtins.property
    @pulumi.getter(name="webContainer")
    def web_container(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of tomcat that the deployment package depends on. Image type applications are not supported.
        """
        return pulumi.get(self, "web_container")

    @web_container.setter
    def web_container(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_container", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 acr_assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 acr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_enable_application_scaling_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 batch_wait_time: Optional[pulumi.Input[_builtins.int]] = None,
                 change_order_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_map_mount_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 config_map_mount_desc_v2s: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_host_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_host_alias_v2s: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]]] = None,
                 deploy: Optional[pulumi.Input[_builtins.bool]] = None,
                 edas_container_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ahas: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_grey_tag_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 envs: Optional[pulumi.Input[_builtins.str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[_builtins.str]] = None,
                 image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_args: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 jdk: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_configs: Optional[pulumi.Input['ApplicationKafkaConfigsArgs']] = None,
                 liveness: Optional[pulumi.Input[_builtins.str]] = None,
                 liveness_v2: Optional[pulumi.Input['ApplicationLivenessV2Args']] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 micro_registration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_ready_instance_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]]] = None,
                 oss_ak_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_ak_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs_v2s: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 package_url: Optional[pulumi.Input[_builtins.str]] = None,
                 package_version: Optional[pulumi.Input[_builtins.str]] = None,
                 php: Optional[pulumi.Input[_builtins.str]] = None,
                 php_arms_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start_v2: Optional[pulumi.Input['ApplicationPostStartV2Args']] = None,
                 pre_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_v2: Optional[pulumi.Input['ApplicationPreStopV2Args']] = None,
                 programming_language: Optional[pulumi.Input[_builtins.str]] = None,
                 pvtz_discovery_svc: Optional[pulumi.Input['ApplicationPvtzDiscoverySvcArgs']] = None,
                 readiness: Optional[pulumi.Input[_builtins.str]] = None,
                 readiness_v2: Optional[pulumi.Input['ApplicationReadinessV2Args']] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_configs: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config_v2: Optional[pulumi.Input['ApplicationTomcatConfigV2Args']] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 update_strategy_v2: Optional[pulumi.Input['ApplicationUpdateStrategyV2Args']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 war_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 web_container: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[_builtins.str] acr_assume_role_arn: The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] acr_instance_id: The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] app_description: Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
        :param pulumi.Input[_builtins.str] app_name: Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
        :param pulumi.Input[_builtins.bool] auto_config: The auto config. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] auto_enable_application_scaling_rule: The auto enable application scaling rule. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.int] batch_wait_time: The batch wait time.
        :param pulumi.Input[_builtins.str] change_order_desc: The change order desc.
        :param pulumi.Input[_builtins.str] command: Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
        :param pulumi.Input[_builtins.str] command_args: Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_args_v2s: The parameters of the image startup command.
        :param pulumi.Input[_builtins.str] config_map_mount_desc: ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]] config_map_mount_desc_v2s: The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
        :param pulumi.Input[_builtins.int] cpu: The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
        :param pulumi.Input[_builtins.str] custom_host_alias: Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127.0.0.1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]] custom_host_alias_v2s: The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
        :param pulumi.Input[_builtins.bool] deploy: The deploy. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] edas_container_version: The operating environment used by the Pandora application.
        :param pulumi.Input[_builtins.str] enable_ahas: The enable ahas. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_grey_tag_route: The enable grey tag route. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] envs: Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
        :param pulumi.Input[_builtins.str] image_pull_secrets: The ID of the corresponding Secret.
        :param pulumi.Input[_builtins.str] image_url: Mirror address. Only Image type applications can configure the mirror address.
        :param pulumi.Input[_builtins.str] jar_start_args: The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jar_start_options: The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jdk: The JDK version that the deployment package depends on. Image type applications are not supported.
        :param pulumi.Input['ApplicationKafkaConfigsArgs'] kafka_configs: The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
        :param pulumi.Input[_builtins.str] liveness: Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
               **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
        :param pulumi.Input['ApplicationLivenessV2Args'] liveness_v2: The liveness check settings of the container. See `liveness_v2` below.
        :param pulumi.Input[_builtins.int] memory: The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
        :param pulumi.Input[_builtins.str] micro_registration: Select the Nacos registry. Valid values: `0`, `1`, `2`.
        :param pulumi.Input[_builtins.int] min_ready_instance_ratio: Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
               * `-1`: Initialization value, indicating that percentages are not used.
               * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
        :param pulumi.Input[_builtins.int] min_ready_instances: The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
        :param pulumi.Input[_builtins.str] namespace_id: SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]] nas_configs: The configurations for mounting the NAS file system. See `nas_configs` below.
        :param pulumi.Input[_builtins.str] oss_ak_id: OSS AccessKey ID.
        :param pulumi.Input[_builtins.str] oss_ak_secret: OSS  AccessKey Secret.
        :param pulumi.Input[_builtins.str] oss_mount_descs: OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]] oss_mount_descs_v2s: The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
        :param pulumi.Input[_builtins.str] package_type: Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
        :param pulumi.Input[_builtins.str] package_url: Deployment package address. Only FatJar or War type applications can configure the deployment package address.
        :param pulumi.Input[_builtins.str] package_version: The version number of the deployment package. Required when the Package Type is War and FatJar.
        :param pulumi.Input[_builtins.str] php: The Php environment.
        :param pulumi.Input[_builtins.str] php_arms_config_location: The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
        :param pulumi.Input[_builtins.str] php_config: PHP configuration file content.
        :param pulumi.Input[_builtins.str] php_config_location: PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
        :param pulumi.Input[_builtins.str] post_start: Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
        :param pulumi.Input['ApplicationPostStartV2Args'] post_start_v2: The script that is run immediately after the container is started. See `post_start_v2` below.
        :param pulumi.Input[_builtins.str] pre_stop: Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
        :param pulumi.Input['ApplicationPreStopV2Args'] pre_stop_v2: The script that is run before the container is stopped. See `pre_stop_v2` below.
        :param pulumi.Input[_builtins.str] programming_language: The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
        :param pulumi.Input['ApplicationPvtzDiscoverySvcArgs'] pvtz_discovery_svc: The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
        :param pulumi.Input[_builtins.str] readiness: Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start.sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
               **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
        :param pulumi.Input['ApplicationReadinessV2Args'] readiness_v2: The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
        :param pulumi.Input[_builtins.int] replicas: Initial number of instances.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        :param pulumi.Input[_builtins.str] sls_configs: Configuration for log collection to SLS. Valid parameter descriptions are as follows:
               * `projectName`: Configures the project name on SLS.
               * `logDir`: Path to the logs.
               * `logType`: Type of logs. stdout indicates container standard output logs, and only one can be set; if not set, it means collecting file logs.
               * `logstoreName`: Configures the log store name on SLS.
               * `logtailName`: Configures the log tail name on SLS; if not specified, it means creating a new log tail.
               
               If you no longer need to use the SLS collection feature, you should set the value of this field to an empty string. There are two examples:
               - Using SAE automatically created SLS resources: [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}].
               - Using custom SLS resources: [{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}].
               
               **NOTE:** Projects that are automatically created with applications will be deleted along with the application deletion. Therefore, when selecting existing projects, you cannot choose projects automatically created by SAE.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
        :param pulumi.Input[_builtins.str] timezone: Time zone. Default value: `Asia/Shanghai`.
        :param pulumi.Input[_builtins.str] tomcat_config: Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
               **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
        :param pulumi.Input['ApplicationTomcatConfigV2Args'] tomcat_config_v2: The Tomcat configuration. See `tomcat_config_v2` below.
        :param pulumi.Input[_builtins.str] update_strategy: The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
        :param pulumi.Input['ApplicationUpdateStrategyV2Args'] update_strategy_v2: The release policy. See `update_strategy_v2` below.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
        :param pulumi.Input[_builtins.str] war_start_options: WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
        :param pulumi.Input[_builtins.str] web_container: The version of tomcat that the deployment package depends on. Image type applications are not supported.
        """
        if acr_assume_role_arn is not None:
            pulumi.set(__self__, "acr_assume_role_arn", acr_assume_role_arn)
        if acr_instance_id is not None:
            pulumi.set(__self__, "acr_instance_id", acr_instance_id)
        if app_description is not None:
            pulumi.set(__self__, "app_description", app_description)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if auto_config is not None:
            pulumi.set(__self__, "auto_config", auto_config)
        if auto_enable_application_scaling_rule is not None:
            pulumi.set(__self__, "auto_enable_application_scaling_rule", auto_enable_application_scaling_rule)
        if batch_wait_time is not None:
            pulumi.set(__self__, "batch_wait_time", batch_wait_time)
        if change_order_desc is not None:
            pulumi.set(__self__, "change_order_desc", change_order_desc)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if command_args is not None:
            warnings.warn("""Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""command_args is deprecated: Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.""")
        if command_args is not None:
            pulumi.set(__self__, "command_args", command_args)
        if command_args_v2s is not None:
            pulumi.set(__self__, "command_args_v2s", command_args_v2s)
        if config_map_mount_desc is not None:
            warnings.warn("""Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""config_map_mount_desc is deprecated: Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.""")
        if config_map_mount_desc is not None:
            pulumi.set(__self__, "config_map_mount_desc", config_map_mount_desc)
        if config_map_mount_desc_v2s is not None:
            pulumi.set(__self__, "config_map_mount_desc_v2s", config_map_mount_desc_v2s)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if custom_host_alias is not None:
            warnings.warn("""Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""custom_host_alias is deprecated: Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.""")
        if custom_host_alias is not None:
            pulumi.set(__self__, "custom_host_alias", custom_host_alias)
        if custom_host_alias_v2s is not None:
            pulumi.set(__self__, "custom_host_alias_v2s", custom_host_alias_v2s)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if edas_container_version is not None:
            pulumi.set(__self__, "edas_container_version", edas_container_version)
        if enable_ahas is not None:
            pulumi.set(__self__, "enable_ahas", enable_ahas)
        if enable_grey_tag_route is not None:
            pulumi.set(__self__, "enable_grey_tag_route", enable_grey_tag_route)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if jar_start_args is not None:
            pulumi.set(__self__, "jar_start_args", jar_start_args)
        if jar_start_options is not None:
            pulumi.set(__self__, "jar_start_options", jar_start_options)
        if jdk is not None:
            pulumi.set(__self__, "jdk", jdk)
        if kafka_configs is not None:
            pulumi.set(__self__, "kafka_configs", kafka_configs)
        if liveness is not None:
            warnings.warn("""Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""liveness is deprecated: Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.""")
        if liveness is not None:
            pulumi.set(__self__, "liveness", liveness)
        if liveness_v2 is not None:
            pulumi.set(__self__, "liveness_v2", liveness_v2)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if micro_registration is not None:
            pulumi.set(__self__, "micro_registration", micro_registration)
        if min_ready_instance_ratio is not None:
            pulumi.set(__self__, "min_ready_instance_ratio", min_ready_instance_ratio)
        if min_ready_instances is not None:
            pulumi.set(__self__, "min_ready_instances", min_ready_instances)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if nas_configs is not None:
            pulumi.set(__self__, "nas_configs", nas_configs)
        if oss_ak_id is not None:
            pulumi.set(__self__, "oss_ak_id", oss_ak_id)
        if oss_ak_secret is not None:
            pulumi.set(__self__, "oss_ak_secret", oss_ak_secret)
        if oss_mount_descs is not None:
            warnings.warn("""Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""oss_mount_descs is deprecated: Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.""")
        if oss_mount_descs is not None:
            pulumi.set(__self__, "oss_mount_descs", oss_mount_descs)
        if oss_mount_descs_v2s is not None:
            pulumi.set(__self__, "oss_mount_descs_v2s", oss_mount_descs_v2s)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if package_url is not None:
            pulumi.set(__self__, "package_url", package_url)
        if package_version is not None:
            pulumi.set(__self__, "package_version", package_version)
        if php is not None:
            pulumi.set(__self__, "php", php)
        if php_arms_config_location is not None:
            pulumi.set(__self__, "php_arms_config_location", php_arms_config_location)
        if php_config is not None:
            pulumi.set(__self__, "php_config", php_config)
        if php_config_location is not None:
            pulumi.set(__self__, "php_config_location", php_config_location)
        if post_start is not None:
            warnings.warn("""Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""post_start is deprecated: Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.""")
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if post_start_v2 is not None:
            pulumi.set(__self__, "post_start_v2", post_start_v2)
        if pre_stop is not None:
            warnings.warn("""Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""pre_stop is deprecated: Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.""")
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)
        if pre_stop_v2 is not None:
            pulumi.set(__self__, "pre_stop_v2", pre_stop_v2)
        if programming_language is not None:
            pulumi.set(__self__, "programming_language", programming_language)
        if pvtz_discovery_svc is not None:
            pulumi.set(__self__, "pvtz_discovery_svc", pvtz_discovery_svc)
        if readiness is not None:
            warnings.warn("""Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""readiness is deprecated: Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.""")
        if readiness is not None:
            pulumi.set(__self__, "readiness", readiness)
        if readiness_v2 is not None:
            pulumi.set(__self__, "readiness_v2", readiness_v2)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if sls_configs is not None:
            pulumi.set(__self__, "sls_configs", sls_configs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if tomcat_config is not None:
            warnings.warn("""Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""tomcat_config is deprecated: Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.""")
        if tomcat_config is not None:
            pulumi.set(__self__, "tomcat_config", tomcat_config)
        if tomcat_config_v2 is not None:
            pulumi.set(__self__, "tomcat_config_v2", tomcat_config_v2)
        if update_strategy is not None:
            warnings.warn("""Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.""", DeprecationWarning)
            pulumi.log.warn("""update_strategy is deprecated: Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.""")
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)
        if update_strategy_v2 is not None:
            pulumi.set(__self__, "update_strategy_v2", update_strategy_v2)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if war_start_options is not None:
            pulumi.set(__self__, "war_start_options", war_start_options)
        if web_container is not None:
            pulumi.set(__self__, "web_container", web_container)

    @_builtins.property
    @pulumi.getter(name="acrAssumeRoleArn")
    def acr_assume_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
        """
        return pulumi.get(self, "acr_assume_role_arn")

    @acr_assume_role_arn.setter
    def acr_assume_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acr_assume_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="acrInstanceId")
    def acr_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
        """
        return pulumi.get(self, "acr_instance_id")

    @acr_instance_id.setter
    def acr_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acr_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="appDescription")
    def app_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
        """
        return pulumi.get(self, "app_description")

    @app_description.setter
    def app_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_description", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="autoConfig")
    def auto_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The auto config. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_config")

    @auto_config.setter
    def auto_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_config", value)

    @_builtins.property
    @pulumi.getter(name="autoEnableApplicationScalingRule")
    def auto_enable_application_scaling_rule(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The auto enable application scaling rule. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_enable_application_scaling_rule")

    @auto_enable_application_scaling_rule.setter
    def auto_enable_application_scaling_rule(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_enable_application_scaling_rule", value)

    @_builtins.property
    @pulumi.getter(name="batchWaitTime")
    def batch_wait_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The batch wait time.
        """
        return pulumi.get(self, "batch_wait_time")

    @batch_wait_time.setter
    def batch_wait_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "batch_wait_time", value)

    @_builtins.property
    @pulumi.getter(name="changeOrderDesc")
    def change_order_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The change order desc.
        """
        return pulumi.get(self, "change_order_desc")

    @change_order_desc.setter
    def change_order_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "change_order_desc", value)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter(name="commandArgs")
    @_utilities.deprecated("""Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.""")
    def command_args(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
        """
        return pulumi.get(self, "command_args")

    @command_args.setter
    def command_args(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command_args", value)

    @_builtins.property
    @pulumi.getter(name="commandArgsV2s")
    def command_args_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The parameters of the image startup command.
        """
        return pulumi.get(self, "command_args_v2s")

    @command_args_v2s.setter
    def command_args_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "command_args_v2s", value)

    @_builtins.property
    @pulumi.getter(name="configMapMountDesc")
    @_utilities.deprecated("""Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.""")
    def config_map_mount_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
        """
        return pulumi.get(self, "config_map_mount_desc")

    @config_map_mount_desc.setter
    def config_map_mount_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_map_mount_desc", value)

    @_builtins.property
    @pulumi.getter(name="configMapMountDescV2s")
    def config_map_mount_desc_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]]]:
        """
        The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
        """
        return pulumi.get(self, "config_map_mount_desc_v2s")

    @config_map_mount_desc_v2s.setter
    def config_map_mount_desc_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationConfigMapMountDescV2Args']]]]):
        pulumi.set(self, "config_map_mount_desc_v2s", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="customHostAlias")
    @_utilities.deprecated("""Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.""")
    def custom_host_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127.0.0.1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
        """
        return pulumi.get(self, "custom_host_alias")

    @custom_host_alias.setter
    def custom_host_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_host_alias", value)

    @_builtins.property
    @pulumi.getter(name="customHostAliasV2s")
    def custom_host_alias_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]]]:
        """
        The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
        """
        return pulumi.get(self, "custom_host_alias_v2s")

    @custom_host_alias_v2s.setter
    def custom_host_alias_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationCustomHostAliasV2Args']]]]):
        pulumi.set(self, "custom_host_alias_v2s", value)

    @_builtins.property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The deploy. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deploy", value)

    @_builtins.property
    @pulumi.getter(name="edasContainerVersion")
    def edas_container_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating environment used by the Pandora application.
        """
        return pulumi.get(self, "edas_container_version")

    @edas_container_version.setter
    def edas_container_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edas_container_version", value)

    @_builtins.property
    @pulumi.getter(name="enableAhas")
    def enable_ahas(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enable ahas. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_ahas")

    @enable_ahas.setter
    def enable_ahas(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_ahas", value)

    @_builtins.property
    @pulumi.getter(name="enableGreyTagRoute")
    def enable_grey_tag_route(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The enable grey tag route. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_grey_tag_route")

    @enable_grey_tag_route.setter
    def enable_grey_tag_route(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_grey_tag_route", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the corresponding Secret.
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_pull_secrets", value)

    @_builtins.property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mirror address. Only Image type applications can configure the mirror address.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_url", value)

    @_builtins.property
    @pulumi.getter(name="jarStartArgs")
    def jar_start_args(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        """
        return pulumi.get(self, "jar_start_args")

    @jar_start_args.setter
    def jar_start_args(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jar_start_args", value)

    @_builtins.property
    @pulumi.getter(name="jarStartOptions")
    def jar_start_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        """
        return pulumi.get(self, "jar_start_options")

    @jar_start_options.setter
    def jar_start_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jar_start_options", value)

    @_builtins.property
    @pulumi.getter
    def jdk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JDK version that the deployment package depends on. Image type applications are not supported.
        """
        return pulumi.get(self, "jdk")

    @jdk.setter
    def jdk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdk", value)

    @_builtins.property
    @pulumi.getter(name="kafkaConfigs")
    def kafka_configs(self) -> Optional[pulumi.Input['ApplicationKafkaConfigsArgs']]:
        """
        The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
        """
        return pulumi.get(self, "kafka_configs")

    @kafka_configs.setter
    def kafka_configs(self, value: Optional[pulumi.Input['ApplicationKafkaConfigsArgs']]):
        pulumi.set(self, "kafka_configs", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.""")
    def liveness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
        **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
        """
        return pulumi.get(self, "liveness")

    @liveness.setter
    def liveness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "liveness", value)

    @_builtins.property
    @pulumi.getter(name="livenessV2")
    def liveness_v2(self) -> Optional[pulumi.Input['ApplicationLivenessV2Args']]:
        """
        The liveness check settings of the container. See `liveness_v2` below.
        """
        return pulumi.get(self, "liveness_v2")

    @liveness_v2.setter
    def liveness_v2(self, value: Optional[pulumi.Input['ApplicationLivenessV2Args']]):
        pulumi.set(self, "liveness_v2", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="microRegistration")
    def micro_registration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select the Nacos registry. Valid values: `0`, `1`, `2`.
        """
        return pulumi.get(self, "micro_registration")

    @micro_registration.setter
    def micro_registration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "micro_registration", value)

    @_builtins.property
    @pulumi.getter(name="minReadyInstanceRatio")
    def min_ready_instance_ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
        * `-1`: Initialization value, indicating that percentages are not used.
        * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
        """
        return pulumi.get(self, "min_ready_instance_ratio")

    @min_ready_instance_ratio.setter
    def min_ready_instance_ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ready_instance_ratio", value)

    @_builtins.property
    @pulumi.getter(name="minReadyInstances")
    def min_ready_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
        """
        return pulumi.get(self, "min_ready_instances")

    @min_ready_instances.setter
    def min_ready_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ready_instances", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="nasConfigs")
    def nas_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]]]:
        """
        The configurations for mounting the NAS file system. See `nas_configs` below.
        """
        return pulumi.get(self, "nas_configs")

    @nas_configs.setter
    def nas_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationNasConfigArgs']]]]):
        pulumi.set(self, "nas_configs", value)

    @_builtins.property
    @pulumi.getter(name="ossAkId")
    def oss_ak_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS AccessKey ID.
        """
        return pulumi.get(self, "oss_ak_id")

    @oss_ak_id.setter
    def oss_ak_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_ak_id", value)

    @_builtins.property
    @pulumi.getter(name="ossAkSecret")
    def oss_ak_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS  AccessKey Secret.
        """
        return pulumi.get(self, "oss_ak_secret")

    @oss_ak_secret.setter
    def oss_ak_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_ak_secret", value)

    @_builtins.property
    @pulumi.getter(name="ossMountDescs")
    @_utilities.deprecated("""Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.""")
    def oss_mount_descs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
        """
        return pulumi.get(self, "oss_mount_descs")

    @oss_mount_descs.setter
    def oss_mount_descs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_mount_descs", value)

    @_builtins.property
    @pulumi.getter(name="ossMountDescsV2s")
    def oss_mount_descs_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]]]:
        """
        The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
        """
        return pulumi.get(self, "oss_mount_descs_v2s")

    @oss_mount_descs_v2s.setter
    def oss_mount_descs_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationOssMountDescsV2Args']]]]):
        pulumi.set(self, "oss_mount_descs_v2s", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment package address. Only FatJar or War type applications can configure the deployment package address.
        """
        return pulumi.get(self, "package_url")

    @package_url.setter
    def package_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_url", value)

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number of the deployment package. Required when the Package Type is War and FatJar.
        """
        return pulumi.get(self, "package_version")

    @package_version.setter
    def package_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_version", value)

    @_builtins.property
    @pulumi.getter
    def php(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Php environment.
        """
        return pulumi.get(self, "php")

    @php.setter
    def php(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php", value)

    @_builtins.property
    @pulumi.getter(name="phpArmsConfigLocation")
    def php_arms_config_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
        """
        return pulumi.get(self, "php_arms_config_location")

    @php_arms_config_location.setter
    def php_arms_config_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php_arms_config_location", value)

    @_builtins.property
    @pulumi.getter(name="phpConfig")
    def php_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PHP configuration file content.
        """
        return pulumi.get(self, "php_config")

    @php_config.setter
    def php_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php_config", value)

    @_builtins.property
    @pulumi.getter(name="phpConfigLocation")
    def php_config_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
        """
        return pulumi.get(self, "php_config_location")

    @php_config_location.setter
    def php_config_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "php_config_location", value)

    @_builtins.property
    @pulumi.getter(name="postStart")
    @_utilities.deprecated("""Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.""")
    def post_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
        """
        return pulumi.get(self, "post_start")

    @post_start.setter
    def post_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_start", value)

    @_builtins.property
    @pulumi.getter(name="postStartV2")
    def post_start_v2(self) -> Optional[pulumi.Input['ApplicationPostStartV2Args']]:
        """
        The script that is run immediately after the container is started. See `post_start_v2` below.
        """
        return pulumi.get(self, "post_start_v2")

    @post_start_v2.setter
    def post_start_v2(self, value: Optional[pulumi.Input['ApplicationPostStartV2Args']]):
        pulumi.set(self, "post_start_v2", value)

    @_builtins.property
    @pulumi.getter(name="preStop")
    @_utilities.deprecated("""Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.""")
    def pre_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
        """
        return pulumi.get(self, "pre_stop")

    @pre_stop.setter
    def pre_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_stop", value)

    @_builtins.property
    @pulumi.getter(name="preStopV2")
    def pre_stop_v2(self) -> Optional[pulumi.Input['ApplicationPreStopV2Args']]:
        """
        The script that is run before the container is stopped. See `pre_stop_v2` below.
        """
        return pulumi.get(self, "pre_stop_v2")

    @pre_stop_v2.setter
    def pre_stop_v2(self, value: Optional[pulumi.Input['ApplicationPreStopV2Args']]):
        pulumi.set(self, "pre_stop_v2", value)

    @_builtins.property
    @pulumi.getter(name="programmingLanguage")
    def programming_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
        """
        return pulumi.get(self, "programming_language")

    @programming_language.setter
    def programming_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "programming_language", value)

    @_builtins.property
    @pulumi.getter(name="pvtzDiscoverySvc")
    def pvtz_discovery_svc(self) -> Optional[pulumi.Input['ApplicationPvtzDiscoverySvcArgs']]:
        """
        The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
        """
        return pulumi.get(self, "pvtz_discovery_svc")

    @pvtz_discovery_svc.setter
    def pvtz_discovery_svc(self, value: Optional[pulumi.Input['ApplicationPvtzDiscoverySvcArgs']]):
        pulumi.set(self, "pvtz_discovery_svc", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.""")
    def readiness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start.sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
        **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
        """
        return pulumi.get(self, "readiness")

    @readiness.setter
    def readiness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "readiness", value)

    @_builtins.property
    @pulumi.getter(name="readinessV2")
    def readiness_v2(self) -> Optional[pulumi.Input['ApplicationReadinessV2Args']]:
        """
        The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
        """
        return pulumi.get(self, "readiness_v2")

    @readiness_v2.setter
    def readiness_v2(self, value: Optional[pulumi.Input['ApplicationReadinessV2Args']]):
        pulumi.set(self, "readiness_v2", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Initial number of instances.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="slsConfigs")
    def sls_configs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration for log collection to SLS. Valid parameter descriptions are as follows:
        * `projectName`: Configures the project name on SLS.
        * `logDir`: Path to the logs.
        * `logType`: Type of logs. stdout indicates container standard output logs, and only one can be set; if not set, it means collecting file logs.
        * `logstoreName`: Configures the log store name on SLS.
        * `logtailName`: Configures the log tail name on SLS; if not specified, it means creating a new log tail.

        If you no longer need to use the SLS collection feature, you should set the value of this field to an empty string. There are two examples:
        - Using SAE automatically created SLS resources: [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}].
        - Using custom SLS resources: [{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}].

        **NOTE:** Projects that are automatically created with applications will be deleted along with the application deletion. Therefore, when selecting existing projects, you cannot choose projects automatically created by SAE.
        """
        return pulumi.get(self, "sls_configs")

    @sls_configs.setter
    def sls_configs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_configs", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone. Default value: `Asia/Shanghai`.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="tomcatConfig")
    @_utilities.deprecated("""Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.""")
    def tomcat_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
        **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
        """
        return pulumi.get(self, "tomcat_config")

    @tomcat_config.setter
    def tomcat_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tomcat_config", value)

    @_builtins.property
    @pulumi.getter(name="tomcatConfigV2")
    def tomcat_config_v2(self) -> Optional[pulumi.Input['ApplicationTomcatConfigV2Args']]:
        """
        The Tomcat configuration. See `tomcat_config_v2` below.
        """
        return pulumi.get(self, "tomcat_config_v2")

    @tomcat_config_v2.setter
    def tomcat_config_v2(self, value: Optional[pulumi.Input['ApplicationTomcatConfigV2Args']]):
        pulumi.set(self, "tomcat_config_v2", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    @_utilities.deprecated("""Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.""")
    def update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_strategy", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategyV2")
    def update_strategy_v2(self) -> Optional[pulumi.Input['ApplicationUpdateStrategyV2Args']]:
        """
        The release policy. See `update_strategy_v2` below.
        """
        return pulumi.get(self, "update_strategy_v2")

    @update_strategy_v2.setter
    def update_strategy_v2(self, value: Optional[pulumi.Input['ApplicationUpdateStrategyV2Args']]):
        pulumi.set(self, "update_strategy_v2", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="warStartOptions")
    def war_start_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
        """
        return pulumi.get(self, "war_start_options")

    @war_start_options.setter
    def war_start_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "war_start_options", value)

    @_builtins.property
    @pulumi.getter(name="webContainer")
    def web_container(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of tomcat that the deployment package depends on. Image type applications are not supported.
        """
        return pulumi.get(self, "web_container")

    @web_container.setter
    def web_container(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_container", value)


@pulumi.type_token("alicloud:sae/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 acr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_enable_application_scaling_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 batch_wait_time: Optional[pulumi.Input[_builtins.int]] = None,
                 change_order_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_map_mount_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 config_map_mount_desc_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationConfigMapMountDescV2Args', 'ApplicationConfigMapMountDescV2ArgsDict']]]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_host_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_host_alias_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomHostAliasV2Args', 'ApplicationCustomHostAliasV2ArgsDict']]]]] = None,
                 deploy: Optional[pulumi.Input[_builtins.bool]] = None,
                 edas_container_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ahas: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_grey_tag_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 envs: Optional[pulumi.Input[_builtins.str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[_builtins.str]] = None,
                 image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_args: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 jdk: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_configs: Optional[pulumi.Input[Union['ApplicationKafkaConfigsArgs', 'ApplicationKafkaConfigsArgsDict']]] = None,
                 liveness: Optional[pulumi.Input[_builtins.str]] = None,
                 liveness_v2: Optional[pulumi.Input[Union['ApplicationLivenessV2Args', 'ApplicationLivenessV2ArgsDict']]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 micro_registration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_ready_instance_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationNasConfigArgs', 'ApplicationNasConfigArgsDict']]]]] = None,
                 oss_ak_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_ak_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationOssMountDescsV2Args', 'ApplicationOssMountDescsV2ArgsDict']]]]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 package_url: Optional[pulumi.Input[_builtins.str]] = None,
                 package_version: Optional[pulumi.Input[_builtins.str]] = None,
                 php: Optional[pulumi.Input[_builtins.str]] = None,
                 php_arms_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start_v2: Optional[pulumi.Input[Union['ApplicationPostStartV2Args', 'ApplicationPostStartV2ArgsDict']]] = None,
                 pre_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_v2: Optional[pulumi.Input[Union['ApplicationPreStopV2Args', 'ApplicationPreStopV2ArgsDict']]] = None,
                 programming_language: Optional[pulumi.Input[_builtins.str]] = None,
                 pvtz_discovery_svc: Optional[pulumi.Input[Union['ApplicationPvtzDiscoverySvcArgs', 'ApplicationPvtzDiscoverySvcArgsDict']]] = None,
                 readiness: Optional[pulumi.Input[_builtins.str]] = None,
                 readiness_v2: Optional[pulumi.Input[Union['ApplicationReadinessV2Args', 'ApplicationReadinessV2ArgsDict']]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_configs: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config_v2: Optional[pulumi.Input[Union['ApplicationTomcatConfigV2Args', 'ApplicationTomcatConfigV2ArgsDict']]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 update_strategy_v2: Optional[pulumi.Input[Union['ApplicationUpdateStrategyV2Args', 'ApplicationUpdateStrategyV2ArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 war_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 web_container: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Serverless App Engine (SAE) Application resource.

        For information about Serverless App Engine (SAE) Application and how to use it, see [What is Application](https://www.alibabacloud.com/help/en/sae/latest/createapplication).

        > **NOTE:** Available since v1.161.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default = alicloud.get_regions(current=True)
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("default",
            namespace_id=f"{default.regions[0].id}:example{default_integer['result']}",
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("default",
            app_description=name,
            app_name=f"{name}-{default_integer['result']}",
            namespace_id=default_namespace.id,
            image_url=f"registry-vpc.{default.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0",
            package_type="Image",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048)
        ```

        ## Import

        Serverless App Engine (SAE) Application can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sae/application:Application example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acr_assume_role_arn: The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] acr_instance_id: The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] app_description: Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
        :param pulumi.Input[_builtins.str] app_name: Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
        :param pulumi.Input[_builtins.bool] auto_config: The auto config. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] auto_enable_application_scaling_rule: The auto enable application scaling rule. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.int] batch_wait_time: The batch wait time.
        :param pulumi.Input[_builtins.str] change_order_desc: The change order desc.
        :param pulumi.Input[_builtins.str] command: Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
        :param pulumi.Input[_builtins.str] command_args: Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_args_v2s: The parameters of the image startup command.
        :param pulumi.Input[_builtins.str] config_map_mount_desc: ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationConfigMapMountDescV2Args', 'ApplicationConfigMapMountDescV2ArgsDict']]]] config_map_mount_desc_v2s: The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
        :param pulumi.Input[_builtins.int] cpu: The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
        :param pulumi.Input[_builtins.str] custom_host_alias: Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127.0.0.1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomHostAliasV2Args', 'ApplicationCustomHostAliasV2ArgsDict']]]] custom_host_alias_v2s: The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
        :param pulumi.Input[_builtins.bool] deploy: The deploy. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] edas_container_version: The operating environment used by the Pandora application.
        :param pulumi.Input[_builtins.str] enable_ahas: The enable ahas. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_grey_tag_route: The enable grey tag route. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] envs: Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
        :param pulumi.Input[_builtins.str] image_pull_secrets: The ID of the corresponding Secret.
        :param pulumi.Input[_builtins.str] image_url: Mirror address. Only Image type applications can configure the mirror address.
        :param pulumi.Input[_builtins.str] jar_start_args: The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jar_start_options: The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jdk: The JDK version that the deployment package depends on. Image type applications are not supported.
        :param pulumi.Input[Union['ApplicationKafkaConfigsArgs', 'ApplicationKafkaConfigsArgsDict']] kafka_configs: The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
        :param pulumi.Input[_builtins.str] liveness: Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
               **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
        :param pulumi.Input[Union['ApplicationLivenessV2Args', 'ApplicationLivenessV2ArgsDict']] liveness_v2: The liveness check settings of the container. See `liveness_v2` below.
        :param pulumi.Input[_builtins.int] memory: The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
        :param pulumi.Input[_builtins.str] micro_registration: Select the Nacos registry. Valid values: `0`, `1`, `2`.
        :param pulumi.Input[_builtins.int] min_ready_instance_ratio: Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
               * `-1`: Initialization value, indicating that percentages are not used.
               * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
        :param pulumi.Input[_builtins.int] min_ready_instances: The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
        :param pulumi.Input[_builtins.str] namespace_id: SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationNasConfigArgs', 'ApplicationNasConfigArgsDict']]]] nas_configs: The configurations for mounting the NAS file system. See `nas_configs` below.
        :param pulumi.Input[_builtins.str] oss_ak_id: OSS AccessKey ID.
        :param pulumi.Input[_builtins.str] oss_ak_secret: OSS  AccessKey Secret.
        :param pulumi.Input[_builtins.str] oss_mount_descs: OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationOssMountDescsV2Args', 'ApplicationOssMountDescsV2ArgsDict']]]] oss_mount_descs_v2s: The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
        :param pulumi.Input[_builtins.str] package_type: Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
        :param pulumi.Input[_builtins.str] package_url: Deployment package address. Only FatJar or War type applications can configure the deployment package address.
        :param pulumi.Input[_builtins.str] package_version: The version number of the deployment package. Required when the Package Type is War and FatJar.
        :param pulumi.Input[_builtins.str] php: The Php environment.
        :param pulumi.Input[_builtins.str] php_arms_config_location: The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
        :param pulumi.Input[_builtins.str] php_config: PHP configuration file content.
        :param pulumi.Input[_builtins.str] php_config_location: PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
        :param pulumi.Input[_builtins.str] post_start: Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
        :param pulumi.Input[Union['ApplicationPostStartV2Args', 'ApplicationPostStartV2ArgsDict']] post_start_v2: The script that is run immediately after the container is started. See `post_start_v2` below.
        :param pulumi.Input[_builtins.str] pre_stop: Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
        :param pulumi.Input[Union['ApplicationPreStopV2Args', 'ApplicationPreStopV2ArgsDict']] pre_stop_v2: The script that is run before the container is stopped. See `pre_stop_v2` below.
        :param pulumi.Input[_builtins.str] programming_language: The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
        :param pulumi.Input[Union['ApplicationPvtzDiscoverySvcArgs', 'ApplicationPvtzDiscoverySvcArgsDict']] pvtz_discovery_svc: The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
        :param pulumi.Input[_builtins.str] readiness: Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start.sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
               **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
        :param pulumi.Input[Union['ApplicationReadinessV2Args', 'ApplicationReadinessV2ArgsDict']] readiness_v2: The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
        :param pulumi.Input[_builtins.int] replicas: Initial number of instances.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        :param pulumi.Input[_builtins.str] sls_configs: Configuration for log collection to SLS. Valid parameter descriptions are as follows:
               * `projectName`: Configures the project name on SLS.
               * `logDir`: Path to the logs.
               * `logType`: Type of logs. stdout indicates container standard output logs, and only one can be set; if not set, it means collecting file logs.
               * `logstoreName`: Configures the log store name on SLS.
               * `logtailName`: Configures the log tail name on SLS; if not specified, it means creating a new log tail.
               
               If you no longer need to use the SLS collection feature, you should set the value of this field to an empty string. There are two examples:
               - Using SAE automatically created SLS resources: [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}].
               - Using custom SLS resources: [{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}].
               
               **NOTE:** Projects that are automatically created with applications will be deleted along with the application deletion. Therefore, when selecting existing projects, you cannot choose projects automatically created by SAE.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
        :param pulumi.Input[_builtins.str] timezone: Time zone. Default value: `Asia/Shanghai`.
        :param pulumi.Input[_builtins.str] tomcat_config: Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
               **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
        :param pulumi.Input[Union['ApplicationTomcatConfigV2Args', 'ApplicationTomcatConfigV2ArgsDict']] tomcat_config_v2: The Tomcat configuration. See `tomcat_config_v2` below.
        :param pulumi.Input[_builtins.str] update_strategy: The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
        :param pulumi.Input[Union['ApplicationUpdateStrategyV2Args', 'ApplicationUpdateStrategyV2ArgsDict']] update_strategy_v2: The release policy. See `update_strategy_v2` below.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
        :param pulumi.Input[_builtins.str] war_start_options: WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
        :param pulumi.Input[_builtins.str] web_container: The version of tomcat that the deployment package depends on. Image type applications are not supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Serverless App Engine (SAE) Application resource.

        For information about Serverless App Engine (SAE) Application and how to use it, see [What is Application](https://www.alibabacloud.com/help/en/sae/latest/createapplication).

        > **NOTE:** Available since v1.161.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default = alicloud.get_regions(current=True)
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("default",
            namespace_id=f"{default.regions[0].id}:example{default_integer['result']}",
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("default",
            app_description=name,
            app_name=f"{name}-{default_integer['result']}",
            namespace_id=default_namespace.id,
            image_url=f"registry-vpc.{default.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0",
            package_type="Image",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048)
        ```

        ## Import

        Serverless App Engine (SAE) Application can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sae/application:Application example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 acr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_description: Optional[pulumi.Input[_builtins.str]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_enable_application_scaling_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 batch_wait_time: Optional[pulumi.Input[_builtins.int]] = None,
                 change_order_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args: Optional[pulumi.Input[_builtins.str]] = None,
                 command_args_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 config_map_mount_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 config_map_mount_desc_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationConfigMapMountDescV2Args', 'ApplicationConfigMapMountDescV2ArgsDict']]]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_host_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_host_alias_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomHostAliasV2Args', 'ApplicationCustomHostAliasV2ArgsDict']]]]] = None,
                 deploy: Optional[pulumi.Input[_builtins.bool]] = None,
                 edas_container_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ahas: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_grey_tag_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 envs: Optional[pulumi.Input[_builtins.str]] = None,
                 image_pull_secrets: Optional[pulumi.Input[_builtins.str]] = None,
                 image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_args: Optional[pulumi.Input[_builtins.str]] = None,
                 jar_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 jdk: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_configs: Optional[pulumi.Input[Union['ApplicationKafkaConfigsArgs', 'ApplicationKafkaConfigsArgsDict']]] = None,
                 liveness: Optional[pulumi.Input[_builtins.str]] = None,
                 liveness_v2: Optional[pulumi.Input[Union['ApplicationLivenessV2Args', 'ApplicationLivenessV2ArgsDict']]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 micro_registration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_ready_instance_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationNasConfigArgs', 'ApplicationNasConfigArgsDict']]]]] = None,
                 oss_ak_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_ak_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_mount_descs_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationOssMountDescsV2Args', 'ApplicationOssMountDescsV2ArgsDict']]]]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 package_url: Optional[pulumi.Input[_builtins.str]] = None,
                 package_version: Optional[pulumi.Input[_builtins.str]] = None,
                 php: Optional[pulumi.Input[_builtins.str]] = None,
                 php_arms_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config: Optional[pulumi.Input[_builtins.str]] = None,
                 php_config_location: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start: Optional[pulumi.Input[_builtins.str]] = None,
                 post_start_v2: Optional[pulumi.Input[Union['ApplicationPostStartV2Args', 'ApplicationPostStartV2ArgsDict']]] = None,
                 pre_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_v2: Optional[pulumi.Input[Union['ApplicationPreStopV2Args', 'ApplicationPreStopV2ArgsDict']]] = None,
                 programming_language: Optional[pulumi.Input[_builtins.str]] = None,
                 pvtz_discovery_svc: Optional[pulumi.Input[Union['ApplicationPvtzDiscoverySvcArgs', 'ApplicationPvtzDiscoverySvcArgsDict']]] = None,
                 readiness: Optional[pulumi.Input[_builtins.str]] = None,
                 readiness_v2: Optional[pulumi.Input[Union['ApplicationReadinessV2Args', 'ApplicationReadinessV2ArgsDict']]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_configs: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tomcat_config_v2: Optional[pulumi.Input[Union['ApplicationTomcatConfigV2Args', 'ApplicationTomcatConfigV2ArgsDict']]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 update_strategy_v2: Optional[pulumi.Input[Union['ApplicationUpdateStrategyV2Args', 'ApplicationUpdateStrategyV2ArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 war_start_options: Optional[pulumi.Input[_builtins.str]] = None,
                 web_container: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["acr_assume_role_arn"] = acr_assume_role_arn
            __props__.__dict__["acr_instance_id"] = acr_instance_id
            __props__.__dict__["app_description"] = app_description
            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["auto_config"] = auto_config
            __props__.__dict__["auto_enable_application_scaling_rule"] = auto_enable_application_scaling_rule
            __props__.__dict__["batch_wait_time"] = batch_wait_time
            __props__.__dict__["change_order_desc"] = change_order_desc
            __props__.__dict__["command"] = command
            __props__.__dict__["command_args"] = command_args
            __props__.__dict__["command_args_v2s"] = command_args_v2s
            __props__.__dict__["config_map_mount_desc"] = config_map_mount_desc
            __props__.__dict__["config_map_mount_desc_v2s"] = config_map_mount_desc_v2s
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["custom_host_alias"] = custom_host_alias
            __props__.__dict__["custom_host_alias_v2s"] = custom_host_alias_v2s
            __props__.__dict__["deploy"] = deploy
            __props__.__dict__["edas_container_version"] = edas_container_version
            __props__.__dict__["enable_ahas"] = enable_ahas
            __props__.__dict__["enable_grey_tag_route"] = enable_grey_tag_route
            __props__.__dict__["envs"] = envs
            __props__.__dict__["image_pull_secrets"] = image_pull_secrets
            __props__.__dict__["image_url"] = image_url
            __props__.__dict__["jar_start_args"] = jar_start_args
            __props__.__dict__["jar_start_options"] = jar_start_options
            __props__.__dict__["jdk"] = jdk
            __props__.__dict__["kafka_configs"] = kafka_configs
            __props__.__dict__["liveness"] = liveness
            __props__.__dict__["liveness_v2"] = liveness_v2
            __props__.__dict__["memory"] = memory
            __props__.__dict__["micro_registration"] = micro_registration
            __props__.__dict__["min_ready_instance_ratio"] = min_ready_instance_ratio
            __props__.__dict__["min_ready_instances"] = min_ready_instances
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["nas_configs"] = nas_configs
            __props__.__dict__["oss_ak_id"] = None if oss_ak_id is None else pulumi.Output.secret(oss_ak_id)
            __props__.__dict__["oss_ak_secret"] = None if oss_ak_secret is None else pulumi.Output.secret(oss_ak_secret)
            __props__.__dict__["oss_mount_descs"] = oss_mount_descs
            __props__.__dict__["oss_mount_descs_v2s"] = oss_mount_descs_v2s
            if package_type is None and not opts.urn:
                raise TypeError("Missing required property 'package_type'")
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["package_url"] = package_url
            __props__.__dict__["package_version"] = package_version
            __props__.__dict__["php"] = php
            __props__.__dict__["php_arms_config_location"] = php_arms_config_location
            __props__.__dict__["php_config"] = php_config
            __props__.__dict__["php_config_location"] = php_config_location
            __props__.__dict__["post_start"] = post_start
            __props__.__dict__["post_start_v2"] = post_start_v2
            __props__.__dict__["pre_stop"] = pre_stop
            __props__.__dict__["pre_stop_v2"] = pre_stop_v2
            __props__.__dict__["programming_language"] = programming_language
            __props__.__dict__["pvtz_discovery_svc"] = pvtz_discovery_svc
            __props__.__dict__["readiness"] = readiness
            __props__.__dict__["readiness_v2"] = readiness_v2
            if replicas is None and not opts.urn:
                raise TypeError("Missing required property 'replicas'")
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["sls_configs"] = sls_configs
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_grace_period_seconds"] = termination_grace_period_seconds
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["tomcat_config"] = tomcat_config
            __props__.__dict__["tomcat_config_v2"] = tomcat_config_v2
            __props__.__dict__["update_strategy"] = update_strategy
            __props__.__dict__["update_strategy_v2"] = update_strategy_v2
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["war_start_options"] = war_start_options
            __props__.__dict__["web_container"] = web_container
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["ossAkId", "ossAkSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Application, __self__).__init__(
            'alicloud:sae/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acr_assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            acr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            app_description: Optional[pulumi.Input[_builtins.str]] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            auto_config: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_enable_application_scaling_rule: Optional[pulumi.Input[_builtins.bool]] = None,
            batch_wait_time: Optional[pulumi.Input[_builtins.int]] = None,
            change_order_desc: Optional[pulumi.Input[_builtins.str]] = None,
            command: Optional[pulumi.Input[_builtins.str]] = None,
            command_args: Optional[pulumi.Input[_builtins.str]] = None,
            command_args_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            config_map_mount_desc: Optional[pulumi.Input[_builtins.str]] = None,
            config_map_mount_desc_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationConfigMapMountDescV2Args', 'ApplicationConfigMapMountDescV2ArgsDict']]]]] = None,
            cpu: Optional[pulumi.Input[_builtins.int]] = None,
            custom_host_alias: Optional[pulumi.Input[_builtins.str]] = None,
            custom_host_alias_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomHostAliasV2Args', 'ApplicationCustomHostAliasV2ArgsDict']]]]] = None,
            deploy: Optional[pulumi.Input[_builtins.bool]] = None,
            edas_container_version: Optional[pulumi.Input[_builtins.str]] = None,
            enable_ahas: Optional[pulumi.Input[_builtins.str]] = None,
            enable_grey_tag_route: Optional[pulumi.Input[_builtins.bool]] = None,
            envs: Optional[pulumi.Input[_builtins.str]] = None,
            image_pull_secrets: Optional[pulumi.Input[_builtins.str]] = None,
            image_url: Optional[pulumi.Input[_builtins.str]] = None,
            jar_start_args: Optional[pulumi.Input[_builtins.str]] = None,
            jar_start_options: Optional[pulumi.Input[_builtins.str]] = None,
            jdk: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_configs: Optional[pulumi.Input[Union['ApplicationKafkaConfigsArgs', 'ApplicationKafkaConfigsArgsDict']]] = None,
            liveness: Optional[pulumi.Input[_builtins.str]] = None,
            liveness_v2: Optional[pulumi.Input[Union['ApplicationLivenessV2Args', 'ApplicationLivenessV2ArgsDict']]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            micro_registration: Optional[pulumi.Input[_builtins.str]] = None,
            min_ready_instance_ratio: Optional[pulumi.Input[_builtins.int]] = None,
            min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
            namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
            nas_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationNasConfigArgs', 'ApplicationNasConfigArgsDict']]]]] = None,
            oss_ak_id: Optional[pulumi.Input[_builtins.str]] = None,
            oss_ak_secret: Optional[pulumi.Input[_builtins.str]] = None,
            oss_mount_descs: Optional[pulumi.Input[_builtins.str]] = None,
            oss_mount_descs_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationOssMountDescsV2Args', 'ApplicationOssMountDescsV2ArgsDict']]]]] = None,
            package_type: Optional[pulumi.Input[_builtins.str]] = None,
            package_url: Optional[pulumi.Input[_builtins.str]] = None,
            package_version: Optional[pulumi.Input[_builtins.str]] = None,
            php: Optional[pulumi.Input[_builtins.str]] = None,
            php_arms_config_location: Optional[pulumi.Input[_builtins.str]] = None,
            php_config: Optional[pulumi.Input[_builtins.str]] = None,
            php_config_location: Optional[pulumi.Input[_builtins.str]] = None,
            post_start: Optional[pulumi.Input[_builtins.str]] = None,
            post_start_v2: Optional[pulumi.Input[Union['ApplicationPostStartV2Args', 'ApplicationPostStartV2ArgsDict']]] = None,
            pre_stop: Optional[pulumi.Input[_builtins.str]] = None,
            pre_stop_v2: Optional[pulumi.Input[Union['ApplicationPreStopV2Args', 'ApplicationPreStopV2ArgsDict']]] = None,
            programming_language: Optional[pulumi.Input[_builtins.str]] = None,
            pvtz_discovery_svc: Optional[pulumi.Input[Union['ApplicationPvtzDiscoverySvcArgs', 'ApplicationPvtzDiscoverySvcArgsDict']]] = None,
            readiness: Optional[pulumi.Input[_builtins.str]] = None,
            readiness_v2: Optional[pulumi.Input[Union['ApplicationReadinessV2Args', 'ApplicationReadinessV2ArgsDict']]] = None,
            replicas: Optional[pulumi.Input[_builtins.int]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            sls_configs: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            tomcat_config: Optional[pulumi.Input[_builtins.str]] = None,
            tomcat_config_v2: Optional[pulumi.Input[Union['ApplicationTomcatConfigV2Args', 'ApplicationTomcatConfigV2ArgsDict']]] = None,
            update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            update_strategy_v2: Optional[pulumi.Input[Union['ApplicationUpdateStrategyV2Args', 'ApplicationUpdateStrategyV2ArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            war_start_options: Optional[pulumi.Input[_builtins.str]] = None,
            web_container: Optional[pulumi.Input[_builtins.str]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acr_assume_role_arn: The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] acr_instance_id: The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
        :param pulumi.Input[_builtins.str] app_description: Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
        :param pulumi.Input[_builtins.str] app_name: Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
        :param pulumi.Input[_builtins.bool] auto_config: The auto config. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] auto_enable_application_scaling_rule: The auto enable application scaling rule. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.int] batch_wait_time: The batch wait time.
        :param pulumi.Input[_builtins.str] change_order_desc: The change order desc.
        :param pulumi.Input[_builtins.str] command: Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
        :param pulumi.Input[_builtins.str] command_args: Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_args_v2s: The parameters of the image startup command.
        :param pulumi.Input[_builtins.str] config_map_mount_desc: ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationConfigMapMountDescV2Args', 'ApplicationConfigMapMountDescV2ArgsDict']]]] config_map_mount_desc_v2s: The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
        :param pulumi.Input[_builtins.int] cpu: The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
        :param pulumi.Input[_builtins.str] custom_host_alias: Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127.0.0.1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationCustomHostAliasV2Args', 'ApplicationCustomHostAliasV2ArgsDict']]]] custom_host_alias_v2s: The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
        :param pulumi.Input[_builtins.bool] deploy: The deploy. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] edas_container_version: The operating environment used by the Pandora application.
        :param pulumi.Input[_builtins.str] enable_ahas: The enable ahas. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_grey_tag_route: The enable grey tag route. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] envs: Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
        :param pulumi.Input[_builtins.str] image_pull_secrets: The ID of the corresponding Secret.
        :param pulumi.Input[_builtins.str] image_url: Mirror address. Only Image type applications can configure the mirror address.
        :param pulumi.Input[_builtins.str] jar_start_args: The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jar_start_options: The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        :param pulumi.Input[_builtins.str] jdk: The JDK version that the deployment package depends on. Image type applications are not supported.
        :param pulumi.Input[Union['ApplicationKafkaConfigsArgs', 'ApplicationKafkaConfigsArgsDict']] kafka_configs: The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
        :param pulumi.Input[_builtins.str] liveness: Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
               **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
        :param pulumi.Input[Union['ApplicationLivenessV2Args', 'ApplicationLivenessV2ArgsDict']] liveness_v2: The liveness check settings of the container. See `liveness_v2` below.
        :param pulumi.Input[_builtins.int] memory: The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
        :param pulumi.Input[_builtins.str] micro_registration: Select the Nacos registry. Valid values: `0`, `1`, `2`.
        :param pulumi.Input[_builtins.int] min_ready_instance_ratio: Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
               * `-1`: Initialization value, indicating that percentages are not used.
               * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
        :param pulumi.Input[_builtins.int] min_ready_instances: The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
        :param pulumi.Input[_builtins.str] namespace_id: SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationNasConfigArgs', 'ApplicationNasConfigArgsDict']]]] nas_configs: The configurations for mounting the NAS file system. See `nas_configs` below.
        :param pulumi.Input[_builtins.str] oss_ak_id: OSS AccessKey ID.
        :param pulumi.Input[_builtins.str] oss_ak_secret: OSS  AccessKey Secret.
        :param pulumi.Input[_builtins.str] oss_mount_descs: OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationOssMountDescsV2Args', 'ApplicationOssMountDescsV2ArgsDict']]]] oss_mount_descs_v2s: The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
        :param pulumi.Input[_builtins.str] package_type: Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
        :param pulumi.Input[_builtins.str] package_url: Deployment package address. Only FatJar or War type applications can configure the deployment package address.
        :param pulumi.Input[_builtins.str] package_version: The version number of the deployment package. Required when the Package Type is War and FatJar.
        :param pulumi.Input[_builtins.str] php: The Php environment.
        :param pulumi.Input[_builtins.str] php_arms_config_location: The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
        :param pulumi.Input[_builtins.str] php_config: PHP configuration file content.
        :param pulumi.Input[_builtins.str] php_config_location: PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
        :param pulumi.Input[_builtins.str] post_start: Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
        :param pulumi.Input[Union['ApplicationPostStartV2Args', 'ApplicationPostStartV2ArgsDict']] post_start_v2: The script that is run immediately after the container is started. See `post_start_v2` below.
        :param pulumi.Input[_builtins.str] pre_stop: Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
        :param pulumi.Input[Union['ApplicationPreStopV2Args', 'ApplicationPreStopV2ArgsDict']] pre_stop_v2: The script that is run before the container is stopped. See `pre_stop_v2` below.
        :param pulumi.Input[_builtins.str] programming_language: The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
        :param pulumi.Input[Union['ApplicationPvtzDiscoverySvcArgs', 'ApplicationPvtzDiscoverySvcArgsDict']] pvtz_discovery_svc: The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
        :param pulumi.Input[_builtins.str] readiness: Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start.sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
               **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
        :param pulumi.Input[Union['ApplicationReadinessV2Args', 'ApplicationReadinessV2ArgsDict']] readiness_v2: The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
        :param pulumi.Input[_builtins.int] replicas: Initial number of instances.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        :param pulumi.Input[_builtins.str] sls_configs: Configuration for log collection to SLS. Valid parameter descriptions are as follows:
               * `projectName`: Configures the project name on SLS.
               * `logDir`: Path to the logs.
               * `logType`: Type of logs. stdout indicates container standard output logs, and only one can be set; if not set, it means collecting file logs.
               * `logstoreName`: Configures the log store name on SLS.
               * `logtailName`: Configures the log tail name on SLS; if not specified, it means creating a new log tail.
               
               If you no longer need to use the SLS collection feature, you should set the value of this field to an empty string. There are two examples:
               - Using SAE automatically created SLS resources: [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}].
               - Using custom SLS resources: [{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}].
               
               **NOTE:** Projects that are automatically created with applications will be deleted along with the application deletion. Therefore, when selecting existing projects, you cannot choose projects automatically created by SAE.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
        :param pulumi.Input[_builtins.str] timezone: Time zone. Default value: `Asia/Shanghai`.
        :param pulumi.Input[_builtins.str] tomcat_config: Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
               **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
        :param pulumi.Input[Union['ApplicationTomcatConfigV2Args', 'ApplicationTomcatConfigV2ArgsDict']] tomcat_config_v2: The Tomcat configuration. See `tomcat_config_v2` below.
        :param pulumi.Input[_builtins.str] update_strategy: The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
        :param pulumi.Input[Union['ApplicationUpdateStrategyV2Args', 'ApplicationUpdateStrategyV2ArgsDict']] update_strategy_v2: The release policy. See `update_strategy_v2` below.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
        :param pulumi.Input[_builtins.str] war_start_options: WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
        :param pulumi.Input[_builtins.str] web_container: The version of tomcat that the deployment package depends on. Image type applications are not supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["acr_assume_role_arn"] = acr_assume_role_arn
        __props__.__dict__["acr_instance_id"] = acr_instance_id
        __props__.__dict__["app_description"] = app_description
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["auto_config"] = auto_config
        __props__.__dict__["auto_enable_application_scaling_rule"] = auto_enable_application_scaling_rule
        __props__.__dict__["batch_wait_time"] = batch_wait_time
        __props__.__dict__["change_order_desc"] = change_order_desc
        __props__.__dict__["command"] = command
        __props__.__dict__["command_args"] = command_args
        __props__.__dict__["command_args_v2s"] = command_args_v2s
        __props__.__dict__["config_map_mount_desc"] = config_map_mount_desc
        __props__.__dict__["config_map_mount_desc_v2s"] = config_map_mount_desc_v2s
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["custom_host_alias"] = custom_host_alias
        __props__.__dict__["custom_host_alias_v2s"] = custom_host_alias_v2s
        __props__.__dict__["deploy"] = deploy
        __props__.__dict__["edas_container_version"] = edas_container_version
        __props__.__dict__["enable_ahas"] = enable_ahas
        __props__.__dict__["enable_grey_tag_route"] = enable_grey_tag_route
        __props__.__dict__["envs"] = envs
        __props__.__dict__["image_pull_secrets"] = image_pull_secrets
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["jar_start_args"] = jar_start_args
        __props__.__dict__["jar_start_options"] = jar_start_options
        __props__.__dict__["jdk"] = jdk
        __props__.__dict__["kafka_configs"] = kafka_configs
        __props__.__dict__["liveness"] = liveness
        __props__.__dict__["liveness_v2"] = liveness_v2
        __props__.__dict__["memory"] = memory
        __props__.__dict__["micro_registration"] = micro_registration
        __props__.__dict__["min_ready_instance_ratio"] = min_ready_instance_ratio
        __props__.__dict__["min_ready_instances"] = min_ready_instances
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["nas_configs"] = nas_configs
        __props__.__dict__["oss_ak_id"] = oss_ak_id
        __props__.__dict__["oss_ak_secret"] = oss_ak_secret
        __props__.__dict__["oss_mount_descs"] = oss_mount_descs
        __props__.__dict__["oss_mount_descs_v2s"] = oss_mount_descs_v2s
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["package_url"] = package_url
        __props__.__dict__["package_version"] = package_version
        __props__.__dict__["php"] = php
        __props__.__dict__["php_arms_config_location"] = php_arms_config_location
        __props__.__dict__["php_config"] = php_config
        __props__.__dict__["php_config_location"] = php_config_location
        __props__.__dict__["post_start"] = post_start
        __props__.__dict__["post_start_v2"] = post_start_v2
        __props__.__dict__["pre_stop"] = pre_stop
        __props__.__dict__["pre_stop_v2"] = pre_stop_v2
        __props__.__dict__["programming_language"] = programming_language
        __props__.__dict__["pvtz_discovery_svc"] = pvtz_discovery_svc
        __props__.__dict__["readiness"] = readiness
        __props__.__dict__["readiness_v2"] = readiness_v2
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["sls_configs"] = sls_configs
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_grace_period_seconds"] = termination_grace_period_seconds
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["tomcat_config"] = tomcat_config
        __props__.__dict__["tomcat_config_v2"] = tomcat_config_v2
        __props__.__dict__["update_strategy"] = update_strategy
        __props__.__dict__["update_strategy_v2"] = update_strategy_v2
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["war_start_options"] = war_start_options
        __props__.__dict__["web_container"] = web_container
        return Application(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acrAssumeRoleArn")
    def acr_assume_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
        """
        return pulumi.get(self, "acr_assume_role_arn")

    @_builtins.property
    @pulumi.getter(name="acrInstanceId")
    def acr_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
        """
        return pulumi.get(self, "acr_instance_id")

    @_builtins.property
    @pulumi.getter(name="appDescription")
    def app_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
        """
        return pulumi.get(self, "app_description")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[_builtins.str]:
        """
        Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="autoConfig")
    def auto_config(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The auto config. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_config")

    @_builtins.property
    @pulumi.getter(name="autoEnableApplicationScalingRule")
    def auto_enable_application_scaling_rule(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The auto enable application scaling rule. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_enable_application_scaling_rule")

    @_builtins.property
    @pulumi.getter(name="batchWaitTime")
    def batch_wait_time(self) -> pulumi.Output[_builtins.int]:
        """
        The batch wait time.
        """
        return pulumi.get(self, "batch_wait_time")

    @_builtins.property
    @pulumi.getter(name="changeOrderDesc")
    def change_order_desc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The change order desc.
        """
        return pulumi.get(self, "change_order_desc")

    @_builtins.property
    @pulumi.getter
    def command(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter(name="commandArgs")
    @_utilities.deprecated("""Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.""")
    def command_args(self) -> pulumi.Output[_builtins.str]:
        """
        Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
        """
        return pulumi.get(self, "command_args")

    @_builtins.property
    @pulumi.getter(name="commandArgsV2s")
    def command_args_v2s(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The parameters of the image startup command.
        """
        return pulumi.get(self, "command_args_v2s")

    @_builtins.property
    @pulumi.getter(name="configMapMountDesc")
    @_utilities.deprecated("""Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.""")
    def config_map_mount_desc(self) -> pulumi.Output[_builtins.str]:
        """
        ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
        """
        return pulumi.get(self, "config_map_mount_desc")

    @_builtins.property
    @pulumi.getter(name="configMapMountDescV2s")
    def config_map_mount_desc_v2s(self) -> pulumi.Output[Sequence['outputs.ApplicationConfigMapMountDescV2']]:
        """
        The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
        """
        return pulumi.get(self, "config_map_mount_desc_v2s")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="customHostAlias")
    @_utilities.deprecated("""Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.""")
    def custom_host_alias(self) -> pulumi.Output[_builtins.str]:
        """
        Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127.0.0.1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
        """
        return pulumi.get(self, "custom_host_alias")

    @_builtins.property
    @pulumi.getter(name="customHostAliasV2s")
    def custom_host_alias_v2s(self) -> pulumi.Output[Sequence['outputs.ApplicationCustomHostAliasV2']]:
        """
        The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
        """
        return pulumi.get(self, "custom_host_alias_v2s")

    @_builtins.property
    @pulumi.getter
    def deploy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The deploy. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "deploy")

    @_builtins.property
    @pulumi.getter(name="edasContainerVersion")
    def edas_container_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operating environment used by the Pandora application.
        """
        return pulumi.get(self, "edas_container_version")

    @_builtins.property
    @pulumi.getter(name="enableAhas")
    def enable_ahas(self) -> pulumi.Output[_builtins.str]:
        """
        The enable ahas. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_ahas")

    @_builtins.property
    @pulumi.getter(name="enableGreyTagRoute")
    def enable_grey_tag_route(self) -> pulumi.Output[_builtins.bool]:
        """
        The enable grey tag route. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_grey_tag_route")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> pulumi.Output[_builtins.str]:
        """
        Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the corresponding Secret.
        """
        return pulumi.get(self, "image_pull_secrets")

    @_builtins.property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mirror address. Only Image type applications can configure the mirror address.
        """
        return pulumi.get(self, "image_url")

    @_builtins.property
    @pulumi.getter(name="jarStartArgs")
    def jar_start_args(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        """
        return pulumi.get(self, "jar_start_args")

    @_builtins.property
    @pulumi.getter(name="jarStartOptions")
    def jar_start_options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
        """
        return pulumi.get(self, "jar_start_options")

    @_builtins.property
    @pulumi.getter
    def jdk(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The JDK version that the deployment package depends on. Image type applications are not supported.
        """
        return pulumi.get(self, "jdk")

    @_builtins.property
    @pulumi.getter(name="kafkaConfigs")
    def kafka_configs(self) -> pulumi.Output[Optional['outputs.ApplicationKafkaConfigs']]:
        """
        The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
        """
        return pulumi.get(self, "kafka_configs")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.""")
    def liveness(self) -> pulumi.Output[_builtins.str]:
        """
        Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
        **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
        """
        return pulumi.get(self, "liveness")

    @_builtins.property
    @pulumi.getter(name="livenessV2")
    def liveness_v2(self) -> pulumi.Output['outputs.ApplicationLivenessV2']:
        """
        The liveness check settings of the container. See `liveness_v2` below.
        """
        return pulumi.get(self, "liveness_v2")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="microRegistration")
    def micro_registration(self) -> pulumi.Output[_builtins.str]:
        """
        Select the Nacos registry. Valid values: `0`, `1`, `2`.
        """
        return pulumi.get(self, "micro_registration")

    @_builtins.property
    @pulumi.getter(name="minReadyInstanceRatio")
    def min_ready_instance_ratio(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
        * `-1`: Initialization value, indicating that percentages are not used.
        * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
        """
        return pulumi.get(self, "min_ready_instance_ratio")

    @_builtins.property
    @pulumi.getter(name="minReadyInstances")
    def min_ready_instances(self) -> pulumi.Output[_builtins.int]:
        """
        The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
        """
        return pulumi.get(self, "min_ready_instances")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="nasConfigs")
    def nas_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationNasConfig']]]:
        """
        The configurations for mounting the NAS file system. See `nas_configs` below.
        """
        return pulumi.get(self, "nas_configs")

    @_builtins.property
    @pulumi.getter(name="ossAkId")
    def oss_ak_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OSS AccessKey ID.
        """
        return pulumi.get(self, "oss_ak_id")

    @_builtins.property
    @pulumi.getter(name="ossAkSecret")
    def oss_ak_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OSS  AccessKey Secret.
        """
        return pulumi.get(self, "oss_ak_secret")

    @_builtins.property
    @pulumi.getter(name="ossMountDescs")
    @_utilities.deprecated("""Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.""")
    def oss_mount_descs(self) -> pulumi.Output[_builtins.str]:
        """
        OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
        """
        return pulumi.get(self, "oss_mount_descs")

    @_builtins.property
    @pulumi.getter(name="ossMountDescsV2s")
    def oss_mount_descs_v2s(self) -> pulumi.Output[Sequence['outputs.ApplicationOssMountDescsV2']]:
        """
        The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
        """
        return pulumi.get(self, "oss_mount_descs_v2s")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[_builtins.str]:
        """
        Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deployment package address. Only FatJar or War type applications can configure the deployment package address.
        """
        return pulumi.get(self, "package_url")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version number of the deployment package. Required when the Package Type is War and FatJar.
        """
        return pulumi.get(self, "package_version")

    @_builtins.property
    @pulumi.getter
    def php(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Php environment.
        """
        return pulumi.get(self, "php")

    @_builtins.property
    @pulumi.getter(name="phpArmsConfigLocation")
    def php_arms_config_location(self) -> pulumi.Output[_builtins.str]:
        """
        The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
        """
        return pulumi.get(self, "php_arms_config_location")

    @_builtins.property
    @pulumi.getter(name="phpConfig")
    def php_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PHP configuration file content.
        """
        return pulumi.get(self, "php_config")

    @_builtins.property
    @pulumi.getter(name="phpConfigLocation")
    def php_config_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
        """
        return pulumi.get(self, "php_config_location")

    @_builtins.property
    @pulumi.getter(name="postStart")
    @_utilities.deprecated("""Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.""")
    def post_start(self) -> pulumi.Output[_builtins.str]:
        """
        Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
        """
        return pulumi.get(self, "post_start")

    @_builtins.property
    @pulumi.getter(name="postStartV2")
    def post_start_v2(self) -> pulumi.Output['outputs.ApplicationPostStartV2']:
        """
        The script that is run immediately after the container is started. See `post_start_v2` below.
        """
        return pulumi.get(self, "post_start_v2")

    @_builtins.property
    @pulumi.getter(name="preStop")
    @_utilities.deprecated("""Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.""")
    def pre_stop(self) -> pulumi.Output[_builtins.str]:
        """
        Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
        """
        return pulumi.get(self, "pre_stop")

    @_builtins.property
    @pulumi.getter(name="preStopV2")
    def pre_stop_v2(self) -> pulumi.Output['outputs.ApplicationPreStopV2']:
        """
        The script that is run before the container is stopped. See `pre_stop_v2` below.
        """
        return pulumi.get(self, "pre_stop_v2")

    @_builtins.property
    @pulumi.getter(name="programmingLanguage")
    def programming_language(self) -> pulumi.Output[_builtins.str]:
        """
        The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
        """
        return pulumi.get(self, "programming_language")

    @_builtins.property
    @pulumi.getter(name="pvtzDiscoverySvc")
    def pvtz_discovery_svc(self) -> pulumi.Output[Optional['outputs.ApplicationPvtzDiscoverySvc']]:
        """
        The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
        """
        return pulumi.get(self, "pvtz_discovery_svc")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.""")
    def readiness(self) -> pulumi.Output[_builtins.str]:
        """
        Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start.sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
        **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
        """
        return pulumi.get(self, "readiness")

    @_builtins.property
    @pulumi.getter(name="readinessV2")
    def readiness_v2(self) -> pulumi.Output['outputs.ApplicationReadinessV2']:
        """
        The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
        """
        return pulumi.get(self, "readiness_v2")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[_builtins.int]:
        """
        Initial number of instances.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="slsConfigs")
    def sls_configs(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Configuration for log collection to SLS. Valid parameter descriptions are as follows:
        * `projectName`: Configures the project name on SLS.
        * `logDir`: Path to the logs.
        * `logType`: Type of logs. stdout indicates container standard output logs, and only one can be set; if not set, it means collecting file logs.
        * `logstoreName`: Configures the log store name on SLS.
        * `logtailName`: Configures the log tail name on SLS; if not specified, it means creating a new log tail.

        If you no longer need to use the SLS collection feature, you should set the value of this field to an empty string. There are two examples:
        - Using SAE automatically created SLS resources: [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}].
        - Using custom SLS resources: [{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}].

        **NOTE:** Projects that are automatically created with applications will be deleted along with the application deletion. Therefore, when selecting existing projects, you cannot choose projects automatically created by SAE.
        """
        return pulumi.get(self, "sls_configs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        Time zone. Default value: `Asia/Shanghai`.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="tomcatConfig")
    @_utilities.deprecated("""Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.""")
    def tomcat_config(self) -> pulumi.Output[_builtins.str]:
        """
        Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
        **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
        """
        return pulumi.get(self, "tomcat_config")

    @_builtins.property
    @pulumi.getter(name="tomcatConfigV2")
    def tomcat_config_v2(self) -> pulumi.Output['outputs.ApplicationTomcatConfigV2']:
        """
        The Tomcat configuration. See `tomcat_config_v2` below.
        """
        return pulumi.get(self, "tomcat_config_v2")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    @_utilities.deprecated("""Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.""")
    def update_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
        """
        return pulumi.get(self, "update_strategy")

    @_builtins.property
    @pulumi.getter(name="updateStrategyV2")
    def update_strategy_v2(self) -> pulumi.Output['outputs.ApplicationUpdateStrategyV2']:
        """
        The release policy. See `update_strategy_v2` below.
        """
        return pulumi.get(self, "update_strategy_v2")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="warStartOptions")
    def war_start_options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
        """
        return pulumi.get(self, "war_start_options")

    @_builtins.property
    @pulumi.getter(name="webContainer")
    def web_container(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of tomcat that the deployment package depends on. Image type applications are not supported.
        """
        return pulumi.get(self, "web_container")

