# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbClustersResult',
    'AwaitableGetDbClustersResult',
    'get_db_clusters',
    'get_db_clusters_output',
]

@pulumi.output_type
class GetDbClustersResult:
    """
    A collection of values returned by getDbClusters.
    """
    def __init__(__self__, clusters=None, id=None, ids=None, output_file=None):
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetDbClustersClusterResult']:
        """
        A list of SelectDB DBClusters. Each element contains the following attributes:
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetDbClustersResult(GetDbClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbClustersResult(
            clusters=self.clusters,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file)


def get_db_clusters(ids: Optional[Sequence[_builtins.str]] = None,
                    output_file: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbClustersResult:
    """
    This data source provides the SelectDB DBCluster of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.229.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.get_zones(available_resource_creation="VSwitch")
    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform_example"
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=default.zones[0].id)
    default_db_instance = alicloud.selectdb.DbInstance("default",
        db_instance_class="selectdb.xlarge",
        db_instance_description=name,
        cache_size=200,
        payment_type="PayAsYouGo",
        engine_minor_version="3.0.12",
        vpc_id=default_get_switches.vswitches[0].vpc_id,
        zone_id=default_get_switches.vswitches[0].zone_id,
        vswitch_id=default_get_switches.vswitches[0].id)
    default_db_cluster = alicloud.selectdb.DbCluster("default",
        db_instance_id=default_db_instance.id,
        db_cluster_description=name,
        db_cluster_class="selectdb.2xlarge",
        cache_size=400,
        payment_type="PayAsYouGo")
    default_get_db_clusters = alicloud.selectdb.get_db_clusters_output(ids=[default_db_cluster.id])
    pulumi.export("dbCluster", default_get_db_clusters.ids[0])
    ```


    :param Sequence[_builtins.str] ids: A list of DBCluster IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:selectdb/getDbClusters:getDbClusters', __args__, opts=opts, typ=GetDbClustersResult).value

    return AwaitableGetDbClustersResult(
        clusters=pulumi.get(__ret__, 'clusters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_db_clusters_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbClustersResult]:
    """
    This data source provides the SelectDB DBCluster of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.229.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.get_zones(available_resource_creation="VSwitch")
    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform_example"
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=default.zones[0].id)
    default_db_instance = alicloud.selectdb.DbInstance("default",
        db_instance_class="selectdb.xlarge",
        db_instance_description=name,
        cache_size=200,
        payment_type="PayAsYouGo",
        engine_minor_version="3.0.12",
        vpc_id=default_get_switches.vswitches[0].vpc_id,
        zone_id=default_get_switches.vswitches[0].zone_id,
        vswitch_id=default_get_switches.vswitches[0].id)
    default_db_cluster = alicloud.selectdb.DbCluster("default",
        db_instance_id=default_db_instance.id,
        db_cluster_description=name,
        db_cluster_class="selectdb.2xlarge",
        cache_size=400,
        payment_type="PayAsYouGo")
    default_get_db_clusters = alicloud.selectdb.get_db_clusters_output(ids=[default_db_cluster.id])
    pulumi.export("dbCluster", default_get_db_clusters.ids[0])
    ```


    :param Sequence[_builtins.str] ids: A list of DBCluster IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:selectdb/getDbClusters:getDbClusters', __args__, opts=opts, typ=GetDbClustersResult)
    return __ret__.apply(lambda __response__: GetDbClustersResult(
        clusters=pulumi.get(__response__, 'clusters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file')))
