# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProductArgs', 'Product']

@pulumi.input_type
class ProductArgs:
    def __init__(__self__, *,
                 product_name: pulumi.Input[_builtins.str],
                 product_type: pulumi.Input[_builtins.str],
                 provider_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Product resource.
        :param pulumi.Input[_builtins.str] product_name: The name of the product
        :param pulumi.Input[_builtins.str] product_type: The type of the product
        :param pulumi.Input[_builtins.str] provider_name: The provider name of the product
        :param pulumi.Input[_builtins.str] description: The description of the product
        """
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "product_type", product_type)
        pulumi.set(__self__, "provider_name", provider_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the product
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_name", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the product
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Input[_builtins.str]:
        """
        The provider name of the product
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the product
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ProductState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 product_name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Product resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the product
        :param pulumi.Input[_builtins.str] description: The description of the product
        :param pulumi.Input[_builtins.str] product_name: The name of the product
        :param pulumi.Input[_builtins.str] product_type: The type of the product
        :param pulumi.Input[_builtins.str] provider_name: The provider name of the product
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the product
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the product
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the product
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_name", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the product
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The provider name of the product
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_name", value)


@pulumi.type_token("alicloud:servicecatalog/product:Product")
class Product(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 product_name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Service Catalog Product resource.

        Service catalog product, IaC template encapsulation concept.

        For information about Service Catalog Product and how to use it, see [What is Product](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-createproduct).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.servicecatalog.Product("default",
            provider_name=name,
            description="desc",
            product_name=name,
            product_type="Ros")
        ```

        ## Import

        Service Catalog Product can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/product:Product example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the product
        :param pulumi.Input[_builtins.str] product_name: The name of the product
        :param pulumi.Input[_builtins.str] product_type: The type of the product
        :param pulumi.Input[_builtins.str] provider_name: The provider name of the product
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProductArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Service Catalog Product resource.

        Service catalog product, IaC template encapsulation concept.

        For information about Service Catalog Product and how to use it, see [What is Product](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-createproduct).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.servicecatalog.Product("default",
            provider_name=name,
            description="desc",
            product_name=name,
            product_type="Ros")
        ```

        ## Import

        Service Catalog Product can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/product:Product example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ProductArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProductArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 product_name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProductArgs.__new__(ProductArgs)

            __props__.__dict__["description"] = description
            if product_name is None and not opts.urn:
                raise TypeError("Missing required property 'product_name'")
            __props__.__dict__["product_name"] = product_name
            if product_type is None and not opts.urn:
                raise TypeError("Missing required property 'product_type'")
            __props__.__dict__["product_type"] = product_type
            if provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_name'")
            __props__.__dict__["provider_name"] = provider_name
            __props__.__dict__["create_time"] = None
        super(Product, __self__).__init__(
            'alicloud:servicecatalog/product:Product',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            product_name: Optional[pulumi.Input[_builtins.str]] = None,
            product_type: Optional[pulumi.Input[_builtins.str]] = None,
            provider_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Product':
        """
        Get an existing Product resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the product
        :param pulumi.Input[_builtins.str] description: The description of the product
        :param pulumi.Input[_builtins.str] product_name: The name of the product
        :param pulumi.Input[_builtins.str] product_type: The type of the product
        :param pulumi.Input[_builtins.str] provider_name: The provider name of the product
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProductState.__new__(_ProductState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["product_name"] = product_name
        __props__.__dict__["product_type"] = product_type
        __props__.__dict__["provider_name"] = provider_name
        return Product(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the product
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the product
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the product
        """
        return pulumi.get(self, "product_name")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the product
        """
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[_builtins.str]:
        """
        The provider name of the product
        """
        return pulumi.get(self, "provider_name")

