# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MetaTagArgs', 'MetaTag']

@pulumi.input_type
class MetaTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a MetaTag resource.
        :param pulumi.Input[_builtins.str] key: The key of the tag meta tag. key must be 1 to 128 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The values of the tag meta tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the tag meta tag. key must be 1 to 128 characters in length.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The values of the tag meta tag.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class _MetaTagState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering MetaTag resources.
        :param pulumi.Input[_builtins.str] key: The key of the tag meta tag. key must be 1 to 128 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The values of the tag meta tag.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the tag meta tag. key must be 1 to 128 characters in length.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The values of the tag meta tag.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)


@pulumi.type_token("alicloud:tag/metaTag:MetaTag")
class MetaTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Tag Meta Tag resource.

        For information about Tag Meta Tag and how to use it,
        see [What is Meta Tag](https://www.alibabacloud.com/help/en/resource-management/latest/createtags).

        > **NOTE:** Available since v1.209.0.

        > **NOTE:** Meta Tag Only Support `cn-hangzhou` Region

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.tag.MetaTag("example",
            key="Name1",
            values=["Desc2"])
        ```

        ## Import

        Tag Meta Tag can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:tag/metaTag:MetaTag example <regionId>:<key>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key: The key of the tag meta tag. key must be 1 to 128 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The values of the tag meta tag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetaTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Tag Meta Tag resource.

        For information about Tag Meta Tag and how to use it,
        see [What is Meta Tag](https://www.alibabacloud.com/help/en/resource-management/latest/createtags).

        > **NOTE:** Available since v1.209.0.

        > **NOTE:** Meta Tag Only Support `cn-hangzhou` Region

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.tag.MetaTag("example",
            key="Name1",
            values=["Desc2"])
        ```

        ## Import

        Tag Meta Tag can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:tag/metaTag:MetaTag example <regionId>:<key>
        ```

        :param str resource_name: The name of the resource.
        :param MetaTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetaTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetaTagArgs.__new__(MetaTagArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if values is None and not opts.urn:
                raise TypeError("Missing required property 'values'")
            __props__.__dict__["values"] = values
        super(MetaTag, __self__).__init__(
            'alicloud:tag/metaTag:MetaTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'MetaTag':
        """
        Get an existing MetaTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key: The key of the tag meta tag. key must be 1 to 128 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The values of the tag meta tag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetaTagState.__new__(_MetaTagState)

        __props__.__dict__["key"] = key
        __props__.__dict__["values"] = values
        return MetaTag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the tag meta tag. key must be 1 to 128 characters in length.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The values of the tag meta tag.
        """
        return pulumi.get(self, "values")

