# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHoneyPotsResult',
    'AwaitableGetHoneyPotsResult',
    'get_honey_pots',
    'get_honey_pots_output',
]

@pulumi.output_type
class GetHoneyPotsResult:
    """
    A collection of values returned by getHoneyPots.
    """
    def __init__(__self__, honeypot_id=None, honeypot_name=None, id=None, ids=None, name_regex=None, node_id=None, node_name=None, output_file=None, pots=None):
        if honeypot_id and not isinstance(honeypot_id, str):
            raise TypeError("Expected argument 'honeypot_id' to be a str")
        pulumi.set(__self__, "honeypot_id", honeypot_id)
        if honeypot_name and not isinstance(honeypot_name, str):
            raise TypeError("Expected argument 'honeypot_name' to be a str")
        pulumi.set(__self__, "honeypot_name", honeypot_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if node_name and not isinstance(node_name, str):
            raise TypeError("Expected argument 'node_name' to be a str")
        pulumi.set(__self__, "node_name", node_name)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if pots and not isinstance(pots, list):
            raise TypeError("Expected argument 'pots' to be a list")
        pulumi.set(__self__, "pots", pots)

    @_builtins.property
    @pulumi.getter(name="honeypotId")
    def honeypot_id(self) -> Optional[_builtins.str]:
        """
        Honeypot ID.
        """
        return pulumi.get(self, "honeypot_id")

    @_builtins.property
    @pulumi.getter(name="honeypotName")
    def honeypot_name(self) -> Optional[_builtins.str]:
        """
        Honeypot custom name.
        """
        return pulumi.get(self, "honeypot_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Honey Pot IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        The ID of the honeypot management node.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_name")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def pots(self) -> Sequence['outputs.GetHoneyPotsPotResult']:
        """
        A list of Honey Pot Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "pots")


class AwaitableGetHoneyPotsResult(GetHoneyPotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHoneyPotsResult(
            honeypot_id=self.honeypot_id,
            honeypot_name=self.honeypot_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            node_id=self.node_id,
            node_name=self.node_name,
            output_file=self.output_file,
            pots=self.pots)


def get_honey_pots(honeypot_id: Optional[_builtins.str] = None,
                   honeypot_name: Optional[_builtins.str] = None,
                   ids: Optional[Sequence[_builtins.str]] = None,
                   name_regex: Optional[_builtins.str] = None,
                   node_id: Optional[_builtins.str] = None,
                   node_name: Optional[_builtins.str] = None,
                   output_file: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHoneyPotsResult:
    """
    This data source provides Threat Detection Honey Pot available to the user.[What is Honey Pot](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypot)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.threatdetection.get_honey_pots(ids=["xxxx"],
        honeypot_name="tf-example",
        node_id="a44e1ab3-6945-444c-889d-5bacee7056e8")
    pulumi.export("alicloudThreatDetectionHoneyPotExampleId", default.pots[0].id)
    ```


    :param _builtins.str honeypot_id: Honeypot ID.
    :param _builtins.str honeypot_name: Honeypot custom name.
    :param Sequence[_builtins.str] ids: A list of Honey Pot IDs.
    :param _builtins.str name_regex: A regex string to filter results by honey pot name.
    :param _builtins.str node_id: The ID of the honeypot management node.
    :param _builtins.str node_name: The name of the honeypot management node.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['honeypotId'] = honeypot_id
    __args__['honeypotName'] = honeypot_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['nodeId'] = node_id
    __args__['nodeName'] = node_name
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:threatdetection/getHoneyPots:getHoneyPots', __args__, opts=opts, typ=GetHoneyPotsResult).value

    return AwaitableGetHoneyPotsResult(
        honeypot_id=pulumi.get(__ret__, 'honeypot_id'),
        honeypot_name=pulumi.get(__ret__, 'honeypot_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        node_id=pulumi.get(__ret__, 'node_id'),
        node_name=pulumi.get(__ret__, 'node_name'),
        output_file=pulumi.get(__ret__, 'output_file'),
        pots=pulumi.get(__ret__, 'pots'))
def get_honey_pots_output(honeypot_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          honeypot_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                          name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          node_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          node_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHoneyPotsResult]:
    """
    This data source provides Threat Detection Honey Pot available to the user.[What is Honey Pot](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypot)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.threatdetection.get_honey_pots(ids=["xxxx"],
        honeypot_name="tf-example",
        node_id="a44e1ab3-6945-444c-889d-5bacee7056e8")
    pulumi.export("alicloudThreatDetectionHoneyPotExampleId", default.pots[0].id)
    ```


    :param _builtins.str honeypot_id: Honeypot ID.
    :param _builtins.str honeypot_name: Honeypot custom name.
    :param Sequence[_builtins.str] ids: A list of Honey Pot IDs.
    :param _builtins.str name_regex: A regex string to filter results by honey pot name.
    :param _builtins.str node_id: The ID of the honeypot management node.
    :param _builtins.str node_name: The name of the honeypot management node.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['honeypotId'] = honeypot_id
    __args__['honeypotName'] = honeypot_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['nodeId'] = node_id
    __args__['nodeName'] = node_name
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:threatdetection/getHoneyPots:getHoneyPots', __args__, opts=opts, typ=GetHoneyPotsResult)
    return __ret__.apply(lambda __response__: GetHoneyPotsResult(
        honeypot_id=pulumi.get(__response__, 'honeypot_id'),
        honeypot_name=pulumi.get(__response__, 'honeypot_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        node_id=pulumi.get(__response__, 'node_id'),
        node_name=pulumi.get(__response__, 'node_name'),
        output_file=pulumi.get(__response__, 'output_file'),
        pots=pulumi.get(__response__, 'pots')))
