# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogMetaArgs', 'LogMeta']

@pulumi.input_type
class LogMetaArgs:
    def __init__(__self__, *,
                 log_meta_name: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a LogMeta resource.
        :param pulumi.Input[_builtins.str] log_meta_name: The name of the exclusive Logstore where logs are stored. Value:
               - aegis-log-client: client event log
               - aegis-log-crack: Brute Force log
               - aegis-log-dns-query:DNS request log
               - aegis-log-login: login log
               - aegis-log-network: network connection log
               - aegis-log-process: process startup log
               - aegis-snapshot-host: account snapshot log
               - aegis-snapshot-port: port snapshot log
               - aegis-snapshot-process: process snapshot log
               - local-dns: local DNS log
               - sas-log-dns:DNS resolution log
               - sas-log-http:WEB access log
               - sas-log-session: Web session log
               - sas-security-log: alarm log
               - sas-vul-log: Vulnerability log
               - sas-cspm-log: Cloud platform configuration check log
               - sas-hc-log: baseline log
               - sas-rasp-log: Application Protection Log
               - sas-filedetect-log: file detection log
               - sas-net-block: Network Defense Log
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        pulumi.set(__self__, "log_meta_name", log_meta_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="logMetaName")
    def log_meta_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the exclusive Logstore where logs are stored. Value:
        - aegis-log-client: client event log
        - aegis-log-crack: Brute Force log
        - aegis-log-dns-query:DNS request log
        - aegis-log-login: login log
        - aegis-log-network: network connection log
        - aegis-log-process: process startup log
        - aegis-snapshot-host: account snapshot log
        - aegis-snapshot-port: port snapshot log
        - aegis-snapshot-process: process snapshot log
        - local-dns: local DNS log
        - sas-log-dns:DNS resolution log
        - sas-log-http:WEB access log
        - sas-log-session: Web session log
        - sas-security-log: alarm log
        - sas-vul-log: Vulnerability log
        - sas-cspm-log: Cloud platform configuration check log
        - sas-hc-log: baseline log
        - sas-rasp-log: Application Protection Log
        - sas-filedetect-log: file detection log
        - sas-net-block: Network Defense Log
        """
        return pulumi.get(self, "log_meta_name")

    @log_meta_name.setter
    def log_meta_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_meta_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _LogMetaState:
    def __init__(__self__, *,
                 log_meta_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogMeta resources.
        :param pulumi.Input[_builtins.str] log_meta_name: The name of the exclusive Logstore where logs are stored. Value:
               - aegis-log-client: client event log
               - aegis-log-crack: Brute Force log
               - aegis-log-dns-query:DNS request log
               - aegis-log-login: login log
               - aegis-log-network: network connection log
               - aegis-log-process: process startup log
               - aegis-snapshot-host: account snapshot log
               - aegis-snapshot-port: port snapshot log
               - aegis-snapshot-process: process snapshot log
               - local-dns: local DNS log
               - sas-log-dns:DNS resolution log
               - sas-log-http:WEB access log
               - sas-log-session: Web session log
               - sas-security-log: alarm log
               - sas-vul-log: Vulnerability log
               - sas-cspm-log: Cloud platform configuration check log
               - sas-hc-log: baseline log
               - sas-rasp-log: Application Protection Log
               - sas-filedetect-log: file detection log
               - sas-net-block: Network Defense Log
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if log_meta_name is not None:
            pulumi.set(__self__, "log_meta_name", log_meta_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="logMetaName")
    def log_meta_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the exclusive Logstore where logs are stored. Value:
        - aegis-log-client: client event log
        - aegis-log-crack: Brute Force log
        - aegis-log-dns-query:DNS request log
        - aegis-log-login: login log
        - aegis-log-network: network connection log
        - aegis-log-process: process startup log
        - aegis-snapshot-host: account snapshot log
        - aegis-snapshot-port: port snapshot log
        - aegis-snapshot-process: process snapshot log
        - local-dns: local DNS log
        - sas-log-dns:DNS resolution log
        - sas-log-http:WEB access log
        - sas-log-session: Web session log
        - sas-security-log: alarm log
        - sas-vul-log: Vulnerability log
        - sas-cspm-log: Cloud platform configuration check log
        - sas-hc-log: baseline log
        - sas-rasp-log: Application Protection Log
        - sas-filedetect-log: file detection log
        - sas-net-block: Network Defense Log
        """
        return pulumi.get(self, "log_meta_name")

    @log_meta_name.setter
    def log_meta_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_meta_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:threatdetection/logMeta:LogMeta")
class LogMeta(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_meta_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Threat Detection Log Meta can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/logMeta:LogMeta example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] log_meta_name: The name of the exclusive Logstore where logs are stored. Value:
               - aegis-log-client: client event log
               - aegis-log-crack: Brute Force log
               - aegis-log-dns-query:DNS request log
               - aegis-log-login: login log
               - aegis-log-network: network connection log
               - aegis-log-process: process startup log
               - aegis-snapshot-host: account snapshot log
               - aegis-snapshot-port: port snapshot log
               - aegis-snapshot-process: process snapshot log
               - local-dns: local DNS log
               - sas-log-dns:DNS resolution log
               - sas-log-http:WEB access log
               - sas-log-session: Web session log
               - sas-security-log: alarm log
               - sas-vul-log: Vulnerability log
               - sas-cspm-log: Cloud platform configuration check log
               - sas-hc-log: baseline log
               - sas-rasp-log: Application Protection Log
               - sas-filedetect-log: file detection log
               - sas-net-block: Network Defense Log
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogMetaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Threat Detection Log Meta can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/logMeta:LogMeta example <id>
        ```

        :param str resource_name: The name of the resource.
        :param LogMetaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogMetaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_meta_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogMetaArgs.__new__(LogMetaArgs)

            if log_meta_name is None and not opts.urn:
                raise TypeError("Missing required property 'log_meta_name'")
            __props__.__dict__["log_meta_name"] = log_meta_name
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
        super(LogMeta, __self__).__init__(
            'alicloud:threatdetection/logMeta:LogMeta',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            log_meta_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogMeta':
        """
        Get an existing LogMeta resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] log_meta_name: The name of the exclusive Logstore where logs are stored. Value:
               - aegis-log-client: client event log
               - aegis-log-crack: Brute Force log
               - aegis-log-dns-query:DNS request log
               - aegis-log-login: login log
               - aegis-log-network: network connection log
               - aegis-log-process: process startup log
               - aegis-snapshot-host: account snapshot log
               - aegis-snapshot-port: port snapshot log
               - aegis-snapshot-process: process snapshot log
               - local-dns: local DNS log
               - sas-log-dns:DNS resolution log
               - sas-log-http:WEB access log
               - sas-log-session: Web session log
               - sas-security-log: alarm log
               - sas-vul-log: Vulnerability log
               - sas-cspm-log: Cloud platform configuration check log
               - sas-hc-log: baseline log
               - sas-rasp-log: Application Protection Log
               - sas-filedetect-log: file detection log
               - sas-net-block: Network Defense Log
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogMetaState.__new__(_LogMetaState)

        __props__.__dict__["log_meta_name"] = log_meta_name
        __props__.__dict__["status"] = status
        return LogMeta(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="logMetaName")
    def log_meta_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the exclusive Logstore where logs are stored. Value:
        - aegis-log-client: client event log
        - aegis-log-crack: Brute Force log
        - aegis-log-dns-query:DNS request log
        - aegis-log-login: login log
        - aegis-log-network: network connection log
        - aegis-log-process: process startup log
        - aegis-snapshot-host: account snapshot log
        - aegis-snapshot-port: port snapshot log
        - aegis-snapshot-process: process snapshot log
        - local-dns: local DNS log
        - sas-log-dns:DNS resolution log
        - sas-log-http:WEB access log
        - sas-log-session: Web session log
        - sas-security-log: alarm log
        - sas-vul-log: Vulnerability log
        - sas-cspm-log: Cloud platform configuration check log
        - sas-hc-log: baseline log
        - sas-rasp-log: Application Protection Log
        - sas-filedetect-log: file detection log
        - sas-net-block: Network Defense Log
        """
        return pulumi.get(self, "log_meta_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

