# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayEndpointArgs', 'GatewayEndpoint']

@pulumi.input_type
class GatewayEndpointArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 gateway_endpoint_descrption: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a GatewayEndpoint resource.
        :param pulumi.Input[_builtins.str] service_name: The endpoint service name.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] gateway_endpoint_descrption: The description of the VPC gateway endpoint.
               The length of the description information is between 1 and 255 characters.
        :param pulumi.Input[_builtins.str] gateway_endpoint_name: The name of the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] policy_document: Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] route_tables: The ID list of the route table associated with the VPC gateway endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of the resource.
        """
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if gateway_endpoint_descrption is not None:
            pulumi.set(__self__, "gateway_endpoint_descrption", gateway_endpoint_descrption)
        if gateway_endpoint_name is not None:
            pulumi.set(__self__, "gateway_endpoint_name", gateway_endpoint_name)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The endpoint service name.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointDescrption")
    def gateway_endpoint_descrption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPC gateway endpoint.
        The length of the description information is between 1 and 255 characters.
        """
        return pulumi.get(self, "gateway_endpoint_descrption")

    @gateway_endpoint_descrption.setter
    def gateway_endpoint_descrption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_endpoint_descrption", value)

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointName")
    def gateway_endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC gateway endpoint.
        """
        return pulumi.get(self, "gateway_endpoint_name")

    @gateway_endpoint_name.setter
    def gateway_endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID list of the route table associated with the VPC gateway endpoint.
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "route_tables", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GatewayEndpointState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_endpoint_descrption: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayEndpoint resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] gateway_endpoint_descrption: The description of the VPC gateway endpoint.
               The length of the description information is between 1 and 255 characters.
        :param pulumi.Input[_builtins.str] gateway_endpoint_name: The name of the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] policy_document: Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] route_tables: The ID list of the route table associated with the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] service_name: The endpoint service name.
        :param pulumi.Input[_builtins.str] status: The status of VPC gateway endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if gateway_endpoint_descrption is not None:
            pulumi.set(__self__, "gateway_endpoint_descrption", gateway_endpoint_descrption)
        if gateway_endpoint_name is not None:
            pulumi.set(__self__, "gateway_endpoint_name", gateway_endpoint_name)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the VPC gateway endpoint.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointDescrption")
    def gateway_endpoint_descrption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPC gateway endpoint.
        The length of the description information is between 1 and 255 characters.
        """
        return pulumi.get(self, "gateway_endpoint_descrption")

    @gateway_endpoint_descrption.setter
    def gateway_endpoint_descrption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_endpoint_descrption", value)

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointName")
    def gateway_endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC gateway endpoint.
        """
        return pulumi.get(self, "gateway_endpoint_name")

    @gateway_endpoint_name.setter
    def gateway_endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID list of the route table associated with the VPC gateway endpoint.
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "route_tables", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint service name.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of VPC gateway endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:vpc/gatewayEndpoint:GatewayEndpoint")
class GatewayEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_endpoint_descrption: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Gateway Endpoint resource.

        VPC gateway endpoint.

        For information about VPC Gateway Endpoint and how to use it, see [What is Gateway Endpoint](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/gateway-endpoint).

        > **NOTE:** Available since v1.208.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        domain = config.get("domain")
        if domain is None:
            domain = "com.aliyun.cn-hangzhou.oss"
        default_vpc = alicloud.vpc.Network("defaultVpc", description="tf-example")
        default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
            display_name="tf-example-497",
            resource_group_name=name)
        default = alicloud.vpc.GatewayEndpoint("default",
            gateway_endpoint_descrption="test-gateway-endpoint",
            gateway_endpoint_name=name,
            vpc_id=default_vpc.id,
            resource_group_id=default_rg.id,
            service_name=domain,
            policy_document=\"\"\"      {
                "Version": "1",
                "Statement": [{
                  "Effect": "Allow",
                  "Resource": ["*"],
                  "Action": ["*"],
                  "Principal": ["*"]
                }]
              }
        \"\"\")
        ```

        ## Import

        VPC Gateway Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/gatewayEndpoint:GatewayEndpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_endpoint_descrption: The description of the VPC gateway endpoint.
               The length of the description information is between 1 and 255 characters.
        :param pulumi.Input[_builtins.str] gateway_endpoint_name: The name of the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] policy_document: Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] route_tables: The ID list of the route table associated with the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] service_name: The endpoint service name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Gateway Endpoint resource.

        VPC gateway endpoint.

        For information about VPC Gateway Endpoint and how to use it, see [What is Gateway Endpoint](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/gateway-endpoint).

        > **NOTE:** Available since v1.208.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        domain = config.get("domain")
        if domain is None:
            domain = "com.aliyun.cn-hangzhou.oss"
        default_vpc = alicloud.vpc.Network("defaultVpc", description="tf-example")
        default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
            display_name="tf-example-497",
            resource_group_name=name)
        default = alicloud.vpc.GatewayEndpoint("default",
            gateway_endpoint_descrption="test-gateway-endpoint",
            gateway_endpoint_name=name,
            vpc_id=default_vpc.id,
            resource_group_id=default_rg.id,
            service_name=domain,
            policy_document=\"\"\"      {
                "Version": "1",
                "Statement": [{
                  "Effect": "Allow",
                  "Resource": ["*"],
                  "Action": ["*"],
                  "Principal": ["*"]
                }]
              }
        \"\"\")
        ```

        ## Import

        VPC Gateway Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/gatewayEndpoint:GatewayEndpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_endpoint_descrption: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayEndpointArgs.__new__(GatewayEndpointArgs)

            __props__.__dict__["gateway_endpoint_descrption"] = gateway_endpoint_descrption
            __props__.__dict__["gateway_endpoint_name"] = gateway_endpoint_name
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["route_tables"] = route_tables
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(GatewayEndpoint, __self__).__init__(
            'alicloud:vpc/gatewayEndpoint:GatewayEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_endpoint_descrption: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_document: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayEndpoint':
        """
        Get an existing GatewayEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] gateway_endpoint_descrption: The description of the VPC gateway endpoint.
               The length of the description information is between 1 and 255 characters.
        :param pulumi.Input[_builtins.str] gateway_endpoint_name: The name of the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] policy_document: Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] route_tables: The ID list of the route table associated with the VPC gateway endpoint.
        :param pulumi.Input[_builtins.str] service_name: The endpoint service name.
        :param pulumi.Input[_builtins.str] status: The status of VPC gateway endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayEndpointState.__new__(_GatewayEndpointState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["gateway_endpoint_descrption"] = gateway_endpoint_descrption
        __props__.__dict__["gateway_endpoint_name"] = gateway_endpoint_name
        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["route_tables"] = route_tables
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return GatewayEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the VPC gateway endpoint.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointDescrption")
    def gateway_endpoint_descrption(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the VPC gateway endpoint.
        The length of the description information is between 1 and 255 characters.
        """
        return pulumi.get(self, "gateway_endpoint_descrption")

    @_builtins.property
    @pulumi.getter(name="gatewayEndpointName")
    def gateway_endpoint_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the VPC gateway endpoint.
        """
        return pulumi.get(self, "gateway_endpoint_name")

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
        """
        return pulumi.get(self, "policy_document")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The ID list of the route table associated with the VPC gateway endpoint.
        """
        return pulumi.get(self, "route_tables")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint service name.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of VPC gateway endpoint.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

