# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNatGatewaysResult',
    'AwaitableGetNatGatewaysResult',
    'get_nat_gateways',
    'get_nat_gateways_output',
]

@pulumi.output_type
class GetNatGatewaysResult:
    """
    A collection of values returned by getNatGateways.
    """
    def __init__(__self__, dry_run=None, enable_details=None, gateways=None, id=None, ids=None, name_regex=None, names=None, nat_gateway_name=None, nat_type=None, output_file=None, page_number=None, page_size=None, payment_type=None, resource_group_id=None, specification=None, status=None, tags=None, total_count=None, vpc_id=None):
        if dry_run and not isinstance(dry_run, bool):
            raise TypeError("Expected argument 'dry_run' to be a bool")
        pulumi.set(__self__, "dry_run", dry_run)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if nat_gateway_name and not isinstance(nat_gateway_name, str):
            raise TypeError("Expected argument 'nat_gateway_name' to be a str")
        pulumi.set(__self__, "nat_gateway_name", nat_gateway_name)
        if nat_type and not isinstance(nat_type, str):
            raise TypeError("Expected argument 'nat_type' to be a str")
        pulumi.set(__self__, "nat_type", nat_type)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if payment_type and not isinstance(payment_type, str):
            raise TypeError("Expected argument 'payment_type' to be a str")
        pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if specification and not isinstance(specification, str):
            raise TypeError("Expected argument 'specification' to be a str")
        pulumi.set(__self__, "specification", specification)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetNatGatewaysGatewayResult']:
        """
        A list of Nat gateways. Each element contains the following attributes:
        """
        return pulumi.get(self, "gateways")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        (Optional) A list of Nat gateways IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Nat gateways names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> Optional[_builtins.str]:
        """
        The name of the NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_name")

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> Optional[_builtins.str]:
        """
        The type of the NAT gateway.
        """
        return pulumi.get(self, "nat_type")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[_builtins.str]:
        """
        The billing method of the NAT gateway.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[_builtins.str]:
        """
        The specification of the NAT gateway.
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the NAT gateway.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tags of NAT gateway.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        return pulumi.get(self, "total_count")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetNatGatewaysResult(GetNatGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNatGatewaysResult(
            dry_run=self.dry_run,
            enable_details=self.enable_details,
            gateways=self.gateways,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            nat_gateway_name=self.nat_gateway_name,
            nat_type=self.nat_type,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            payment_type=self.payment_type,
            resource_group_id=self.resource_group_id,
            specification=self.specification,
            status=self.status,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id)


def get_nat_gateways(dry_run: Optional[_builtins.bool] = None,
                     enable_details: Optional[_builtins.bool] = None,
                     ids: Optional[Sequence[_builtins.str]] = None,
                     name_regex: Optional[_builtins.str] = None,
                     nat_gateway_name: Optional[_builtins.str] = None,
                     nat_type: Optional[_builtins.str] = None,
                     output_file: Optional[_builtins.str] = None,
                     page_number: Optional[_builtins.int] = None,
                     page_size: Optional[_builtins.int] = None,
                     payment_type: Optional[_builtins.str] = None,
                     resource_group_id: Optional[_builtins.str] = None,
                     specification: Optional[_builtins.str] = None,
                     status: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     vpc_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNatGatewaysResult:
    """
    This data source provides a list of Nat Gateways owned by an Alibaba Cloud account.

    > **NOTE:** Available since v1.37.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "natGatewaysDatasource"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    foo_network = alicloud.vpc.Network("foo",
        vpc_name=name,
        cidr_block="172.16.0.0/12")
    foo_nat_gateway = alicloud.vpc.NatGateway("foo",
        vpc_id=foo_network.id,
        specification="Small",
        nat_gateway_name=name)
    foo = alicloud.vpc.get_nat_gateways_output(vpc_id=foo_network.id,
        name_regex=foo_nat_gateway.name,
        ids=[foo_nat_gateway.id])
    ```


    :param _builtins.bool dry_run: Specifies whether to only precheck the request.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of NAT gateways IDs.
    :param _builtins.str name_regex: A regex string to filter nat gateways by name.
    :param _builtins.str nat_gateway_name: The name of NAT gateway.
    :param _builtins.str nat_type: The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
    :param _builtins.str resource_group_id: The resource group id of NAT gateway.
    :param _builtins.str specification: The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
    :param _builtins.str status: The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
    :param Mapping[str, _builtins.str] tags: The tags of NAT gateway.
    :param _builtins.str vpc_id: The ID of the VPC.
    """
    __args__ = dict()
    __args__['dryRun'] = dry_run
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['natGatewayName'] = nat_gateway_name
    __args__['natType'] = nat_type
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['paymentType'] = payment_type
    __args__['resourceGroupId'] = resource_group_id
    __args__['specification'] = specification
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getNatGateways:getNatGateways', __args__, opts=opts, typ=GetNatGatewaysResult).value

    return AwaitableGetNatGatewaysResult(
        dry_run=pulumi.get(__ret__, 'dry_run'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        gateways=pulumi.get(__ret__, 'gateways'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        nat_gateway_name=pulumi.get(__ret__, 'nat_gateway_name'),
        nat_type=pulumi.get(__ret__, 'nat_type'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        payment_type=pulumi.get(__ret__, 'payment_type'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        specification=pulumi.get(__ret__, 'specification'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_nat_gateways_output(dry_run: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                            enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                            ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            nat_gateway_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            nat_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            payment_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            specification: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNatGatewaysResult]:
    """
    This data source provides a list of Nat Gateways owned by an Alibaba Cloud account.

    > **NOTE:** Available since v1.37.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "natGatewaysDatasource"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    foo_network = alicloud.vpc.Network("foo",
        vpc_name=name,
        cidr_block="172.16.0.0/12")
    foo_nat_gateway = alicloud.vpc.NatGateway("foo",
        vpc_id=foo_network.id,
        specification="Small",
        nat_gateway_name=name)
    foo = alicloud.vpc.get_nat_gateways_output(vpc_id=foo_network.id,
        name_regex=foo_nat_gateway.name,
        ids=[foo_nat_gateway.id])
    ```


    :param _builtins.bool dry_run: Specifies whether to only precheck the request.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of NAT gateways IDs.
    :param _builtins.str name_regex: A regex string to filter nat gateways by name.
    :param _builtins.str nat_gateway_name: The name of NAT gateway.
    :param _builtins.str nat_type: The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
    :param _builtins.str resource_group_id: The resource group id of NAT gateway.
    :param _builtins.str specification: The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
    :param _builtins.str status: The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
    :param Mapping[str, _builtins.str] tags: The tags of NAT gateway.
    :param _builtins.str vpc_id: The ID of the VPC.
    """
    __args__ = dict()
    __args__['dryRun'] = dry_run
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['natGatewayName'] = nat_gateway_name
    __args__['natType'] = nat_type
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['paymentType'] = payment_type
    __args__['resourceGroupId'] = resource_group_id
    __args__['specification'] = specification
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getNatGateways:getNatGateways', __args__, opts=opts, typ=GetNatGatewaysResult)
    return __ret__.apply(lambda __response__: GetNatGatewaysResult(
        dry_run=pulumi.get(__response__, 'dry_run'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        gateways=pulumi.get(__response__, 'gateways'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        nat_gateway_name=pulumi.get(__response__, 'nat_gateway_name'),
        nat_type=pulumi.get(__response__, 'nat_type'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        payment_type=pulumi.get(__response__, 'payment_type'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        specification=pulumi.get(__response__, 'specification'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        total_count=pulumi.get(__response__, 'total_count'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
