# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworksResult',
    'AwaitableGetNetworksResult',
    'get_networks',
    'get_networks_output',
]

@pulumi.output_type
class GetNetworksResult:
    """
    A collection of values returned by getNetworks.
    """
    def __init__(__self__, cidr_block=None, dhcp_options_set_id=None, dry_run=None, enable_details=None, id=None, ids=None, is_default=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, resource_group_id=None, status=None, tags=None, total_count=None, vpc_name=None, vpc_owner_id=None, vpcs=None, vswitch_id=None):
        if cidr_block and not isinstance(cidr_block, str):
            raise TypeError("Expected argument 'cidr_block' to be a str")
        pulumi.set(__self__, "cidr_block", cidr_block)
        if dhcp_options_set_id and not isinstance(dhcp_options_set_id, str):
            raise TypeError("Expected argument 'dhcp_options_set_id' to be a str")
        pulumi.set(__self__, "dhcp_options_set_id", dhcp_options_set_id)
        if dry_run and not isinstance(dry_run, bool):
            raise TypeError("Expected argument 'dry_run' to be a bool")
        pulumi.set(__self__, "dry_run", dry_run)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_name and not isinstance(vpc_name, str):
            raise TypeError("Expected argument 'vpc_name' to be a str")
        pulumi.set(__self__, "vpc_name", vpc_name)
        if vpc_owner_id and not isinstance(vpc_owner_id, int):
            raise TypeError("Expected argument 'vpc_owner_id' to be a int")
        pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)
        if vswitch_id and not isinstance(vswitch_id, str):
            raise TypeError("Expected argument 'vswitch_id' to be a str")
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[_builtins.str]:
        """
        CIDR block of the VPC.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="dhcpOptionsSetId")
    def dhcp_options_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the DHCP options set.
        """
        return pulumi.get(self, "dhcp_options_set_id")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of VPC IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[_builtins.bool]:
        """
        Whether the VPC is the default VPC in the region.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of VPC names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the VPC.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the VPC.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        return pulumi.get(self, "total_count")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[_builtins.str]:
        """
        Name of the VPC.
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "vpc_owner_id")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Sequence['outputs.GetNetworksVpcResult']:
        """
        A list of VPCs. Each element contains the following attributes:
        """
        return pulumi.get(self, "vpcs")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vswitch_id")


class AwaitableGetNetworksResult(GetNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworksResult(
            cidr_block=self.cidr_block,
            dhcp_options_set_id=self.dhcp_options_set_id,
            dry_run=self.dry_run,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            is_default=self.is_default,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            resource_group_id=self.resource_group_id,
            status=self.status,
            tags=self.tags,
            total_count=self.total_count,
            vpc_name=self.vpc_name,
            vpc_owner_id=self.vpc_owner_id,
            vpcs=self.vpcs,
            vswitch_id=self.vswitch_id)


def get_networks(cidr_block: Optional[_builtins.str] = None,
                 dhcp_options_set_id: Optional[_builtins.str] = None,
                 dry_run: Optional[_builtins.bool] = None,
                 enable_details: Optional[_builtins.bool] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 is_default: Optional[_builtins.bool] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 page_number: Optional[_builtins.int] = None,
                 page_size: Optional[_builtins.int] = None,
                 resource_group_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 vpc_name: Optional[_builtins.str] = None,
                 vpc_owner_id: Optional[_builtins.int] = None,
                 vswitch_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworksResult:
    """
    This data source provides VPCs available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    vpcs_ds = alicloud.vpc.get_networks(cidr_block="172.16.0.0/12",
        status="Available",
        name_regex="^foo")
    pulumi.export("firstVpcId", vpcs_ds.vpcs[0].id)
    ```


    :param _builtins.str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
    :param _builtins.str dhcp_options_set_id: The ID of dhcp options set.
    :param _builtins.bool dry_run: Indicates whether to check this request only. Valid values: `true` and `false`.
    :param _builtins.bool enable_details: Default to `true`. Set it to true can output the `route_table_id`.
    :param Sequence[_builtins.str] ids: A list of VPC IDs.
    :param _builtins.bool is_default: Indicate whether the VPC is the default one in the specified region.
    :param _builtins.str name_regex: A regex string to filter VPCs by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The Id of resource group which VPC belongs.
    :param _builtins.str status: Filter results by a specific status. Valid value are `Pending` and `Available`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_name: The name of the VPC.
    :param _builtins.int vpc_owner_id: The owner ID of VPC.
    :param _builtins.str vswitch_id: Filter results by the specified vSwitch.
    """
    __args__ = dict()
    __args__['cidrBlock'] = cidr_block
    __args__['dhcpOptionsSetId'] = dhcp_options_set_id
    __args__['dryRun'] = dry_run
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['isDefault'] = is_default
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcName'] = vpc_name
    __args__['vpcOwnerId'] = vpc_owner_id
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getNetworks:getNetworks', __args__, opts=opts, typ=GetNetworksResult).value

    return AwaitableGetNetworksResult(
        cidr_block=pulumi.get(__ret__, 'cidr_block'),
        dhcp_options_set_id=pulumi.get(__ret__, 'dhcp_options_set_id'),
        dry_run=pulumi.get(__ret__, 'dry_run'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        is_default=pulumi.get(__ret__, 'is_default'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_name=pulumi.get(__ret__, 'vpc_name'),
        vpc_owner_id=pulumi.get(__ret__, 'vpc_owner_id'),
        vpcs=pulumi.get(__ret__, 'vpcs'),
        vswitch_id=pulumi.get(__ret__, 'vswitch_id'))
def get_networks_output(cidr_block: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        dhcp_options_set_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        dry_run: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        is_default: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                        vpc_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        vpc_owner_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        vswitch_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworksResult]:
    """
    This data source provides VPCs available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    vpcs_ds = alicloud.vpc.get_networks(cidr_block="172.16.0.0/12",
        status="Available",
        name_regex="^foo")
    pulumi.export("firstVpcId", vpcs_ds.vpcs[0].id)
    ```


    :param _builtins.str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
    :param _builtins.str dhcp_options_set_id: The ID of dhcp options set.
    :param _builtins.bool dry_run: Indicates whether to check this request only. Valid values: `true` and `false`.
    :param _builtins.bool enable_details: Default to `true`. Set it to true can output the `route_table_id`.
    :param Sequence[_builtins.str] ids: A list of VPC IDs.
    :param _builtins.bool is_default: Indicate whether the VPC is the default one in the specified region.
    :param _builtins.str name_regex: A regex string to filter VPCs by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The Id of resource group which VPC belongs.
    :param _builtins.str status: Filter results by a specific status. Valid value are `Pending` and `Available`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_name: The name of the VPC.
    :param _builtins.int vpc_owner_id: The owner ID of VPC.
    :param _builtins.str vswitch_id: Filter results by the specified vSwitch.
    """
    __args__ = dict()
    __args__['cidrBlock'] = cidr_block
    __args__['dhcpOptionsSetId'] = dhcp_options_set_id
    __args__['dryRun'] = dry_run
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['isDefault'] = is_default
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcName'] = vpc_name
    __args__['vpcOwnerId'] = vpc_owner_id
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getNetworks:getNetworks', __args__, opts=opts, typ=GetNetworksResult)
    return __ret__.apply(lambda __response__: GetNetworksResult(
        cidr_block=pulumi.get(__response__, 'cidr_block'),
        dhcp_options_set_id=pulumi.get(__response__, 'dhcp_options_set_id'),
        dry_run=pulumi.get(__response__, 'dry_run'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        is_default=pulumi.get(__response__, 'is_default'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        total_count=pulumi.get(__response__, 'total_count'),
        vpc_name=pulumi.get(__response__, 'vpc_name'),
        vpc_owner_id=pulumi.get(__response__, 'vpc_owner_id'),
        vpcs=pulumi.get(__response__, 'vpcs'),
        vswitch_id=pulumi.get(__response__, 'vswitch_id')))
