# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPeerConnectionsResult',
    'AwaitableGetPeerConnectionsResult',
    'get_peer_connections',
    'get_peer_connections_output',
]

@pulumi.output_type
class GetPeerConnectionsResult:
    """
    A collection of values returned by getPeerConnections.
    """
    def __init__(__self__, connections=None, id=None, ids=None, name_regex=None, names=None, output_file=None, peer_connection_name=None, status=None, vpc_id=None):
        if connections and not isinstance(connections, list):
            raise TypeError("Expected argument 'connections' to be a list")
        pulumi.set(__self__, "connections", connections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if peer_connection_name and not isinstance(peer_connection_name, str):
            raise TypeError("Expected argument 'peer_connection_name' to be a str")
        pulumi.set(__self__, "peer_connection_name", peer_connection_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetPeerConnectionsConnectionResult']:
        """
        A list of Vpc Peer Connections. Each element contains the following attributes:
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of PeerConnection names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="peerConnectionName")
    def peer_connection_name(self) -> Optional[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "peer_connection_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the requester VPC.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetPeerConnectionsResult(GetPeerConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPeerConnectionsResult(
            connections=self.connections,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            peer_connection_name=self.peer_connection_name,
            status=self.status,
            vpc_id=self.vpc_id)


def get_peer_connections(ids: Optional[Sequence[_builtins.str]] = None,
                         name_regex: Optional[_builtins.str] = None,
                         output_file: Optional[_builtins.str] = None,
                         peer_connection_name: Optional[_builtins.str] = None,
                         status: Optional[_builtins.str] = None,
                         vpc_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPeerConnectionsResult:
    """
    This data source provides the Vpc Peer Connections of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.186.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_peer_connections()
    pulumi.export("vpcPeerConnectionId1", ids.connections[0].id)
    name_regex = alicloud.vpc.get_peer_connections(name_regex="^my-PeerConnection")
    pulumi.export("vpcPeerConnectionId2", name_regex.connections[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of PeerConnection IDs.
    :param _builtins.str name_regex: A regex string to filter results by PeerConnection name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str peer_connection_name: The name of the resource.
    :param _builtins.str status: The status of the resource. Valid values: `Accepting`, `Activated`, `Creating`, `Deleted`, `Deleting`, `Expired`, `Rejected`, `Updating`.
    :param _builtins.str vpc_id: The ID of the requester VPC.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['peerConnectionName'] = peer_connection_name
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getPeerConnections:getPeerConnections', __args__, opts=opts, typ=GetPeerConnectionsResult).value

    return AwaitableGetPeerConnectionsResult(
        connections=pulumi.get(__ret__, 'connections'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        peer_connection_name=pulumi.get(__ret__, 'peer_connection_name'),
        status=pulumi.get(__ret__, 'status'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_peer_connections_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                peer_connection_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPeerConnectionsResult]:
    """
    This data source provides the Vpc Peer Connections of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.186.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_peer_connections()
    pulumi.export("vpcPeerConnectionId1", ids.connections[0].id)
    name_regex = alicloud.vpc.get_peer_connections(name_regex="^my-PeerConnection")
    pulumi.export("vpcPeerConnectionId2", name_regex.connections[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of PeerConnection IDs.
    :param _builtins.str name_regex: A regex string to filter results by PeerConnection name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str peer_connection_name: The name of the resource.
    :param _builtins.str status: The status of the resource. Valid values: `Accepting`, `Activated`, `Creating`, `Deleted`, `Deleting`, `Expired`, `Rejected`, `Updating`.
    :param _builtins.str vpc_id: The ID of the requester VPC.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['peerConnectionName'] = peer_connection_name
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getPeerConnections:getPeerConnections', __args__, opts=opts, typ=GetPeerConnectionsResult)
    return __ret__.apply(lambda __response__: GetPeerConnectionsResult(
        connections=pulumi.get(__response__, 'connections'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        peer_connection_name=pulumi.get(__response__, 'peer_connection_name'),
        status=pulumi.get(__response__, 'status'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
