# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSwitchesResult',
    'AwaitableGetSwitchesResult',
    'get_switches',
    'get_switches_output',
]

@pulumi.output_type
class GetSwitchesResult:
    """
    A collection of values returned by getSwitches.
    """
    def __init__(__self__, cidr_block=None, dry_run=None, id=None, ids=None, is_default=None, name_regex=None, names=None, output_file=None, resource_group_id=None, route_table_id=None, status=None, tags=None, vpc_id=None, vswitch_name=None, vswitch_owner_id=None, vswitches=None, zone_id=None):
        if cidr_block and not isinstance(cidr_block, str):
            raise TypeError("Expected argument 'cidr_block' to be a str")
        pulumi.set(__self__, "cidr_block", cidr_block)
        if dry_run and not isinstance(dry_run, bool):
            raise TypeError("Expected argument 'dry_run' to be a bool")
        pulumi.set(__self__, "dry_run", dry_run)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_name and not isinstance(vswitch_name, str):
            raise TypeError("Expected argument 'vswitch_name' to be a str")
        pulumi.set(__self__, "vswitch_name", vswitch_name)
        if vswitch_owner_id and not isinstance(vswitch_owner_id, int):
            raise TypeError("Expected argument 'vswitch_owner_id' to be a int")
        pulumi.set(__self__, "vswitch_owner_id", vswitch_owner_id)
        if vswitches and not isinstance(vswitches, list):
            raise TypeError("Expected argument 'vswitches' to be a list")
        pulumi.set(__self__, "vswitches", vswitches)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[_builtins.str]:
        """
        CIDR block of the vSwitch.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of vSwitch IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[_builtins.bool]:
        """
        Whether the vSwitch is the default one in the region.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of vSwitch names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The resource group ID of the vSwitch.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[_builtins.str]:
        """
        The route table ID of the vSwitch.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the vSwitch.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The Tags of the vSwitch.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        ID of the VPC that owns the vSwitch.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchName")
    def vswitch_name(self) -> Optional[_builtins.str]:
        """
        Name of the vSwitch.
        """
        return pulumi.get(self, "vswitch_name")

    @_builtins.property
    @pulumi.getter(name="vswitchOwnerId")
    def vswitch_owner_id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "vswitch_owner_id")

    @_builtins.property
    @pulumi.getter
    def vswitches(self) -> Sequence['outputs.GetSwitchesVswitchResult']:
        """
        A list of VSwitches. Each element contains the following attributes:
        """
        return pulumi.get(self, "vswitches")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        ID of the availability zone where the vSwitch is located.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetSwitchesResult(GetSwitchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwitchesResult(
            cidr_block=self.cidr_block,
            dry_run=self.dry_run,
            id=self.id,
            ids=self.ids,
            is_default=self.is_default,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            route_table_id=self.route_table_id,
            status=self.status,
            tags=self.tags,
            vpc_id=self.vpc_id,
            vswitch_name=self.vswitch_name,
            vswitch_owner_id=self.vswitch_owner_id,
            vswitches=self.vswitches,
            zone_id=self.zone_id)


def get_switches(cidr_block: Optional[_builtins.str] = None,
                 dry_run: Optional[_builtins.bool] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 is_default: Optional[_builtins.bool] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 resource_group_id: Optional[_builtins.str] = None,
                 route_table_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vswitch_name: Optional[_builtins.str] = None,
                 vswitch_owner_id: Optional[_builtins.int] = None,
                 zone_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwitchesResult:
    """
    This data source provides a list of VSwitches owned by an Alibaba Cloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "vswitchDatasourceName"
    default = alicloud.get_zones()
    vpc = alicloud.vpc.Network("vpc",
        cidr_block="172.16.0.0/16",
        vpc_name=name)
    vswitch = alicloud.vpc.Switch("vswitch",
        vswitch_name=name,
        cidr_block="172.16.0.0/24",
        vpc_id=vpc.id,
        availability_zone=default.zones[0].id)
    default_get_switches = alicloud.vpc.get_switches_output(name_regex=vswitch.vswitch_name)
    ```


    :param _builtins.str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
    :param _builtins.bool dry_run: Specifies whether to precheck this request only. Valid values: `true` and `false`.
    :param Sequence[_builtins.str] ids: A list of vSwitch IDs.
    :param _builtins.bool is_default: Indicate whether the vSwitch is created by the system.
    :param _builtins.str name_regex: A regex string to filter results by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The Id of resource group which VSWitch belongs.
    :param _builtins.str route_table_id: The route table ID of the vSwitch.
    :param _builtins.str status: The status of the vSwitch. Valid values: `Available` and `Pending`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: ID of the VPC that owns the vSwitch.
    :param _builtins.str vswitch_name: The name of the vSwitch.
    :param _builtins.int vswitch_owner_id: The vSwitch owner id.
    :param _builtins.str zone_id: The availability zone of the vSwitch.
    """
    __args__ = dict()
    __args__['cidrBlock'] = cidr_block
    __args__['dryRun'] = dry_run
    __args__['ids'] = ids
    __args__['isDefault'] = is_default
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['routeTableId'] = route_table_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vswitchName'] = vswitch_name
    __args__['vswitchOwnerId'] = vswitch_owner_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getSwitches:getSwitches', __args__, opts=opts, typ=GetSwitchesResult).value

    return AwaitableGetSwitchesResult(
        cidr_block=pulumi.get(__ret__, 'cidr_block'),
        dry_run=pulumi.get(__ret__, 'dry_run'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        is_default=pulumi.get(__ret__, 'is_default'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vswitch_name=pulumi.get(__ret__, 'vswitch_name'),
        vswitch_owner_id=pulumi.get(__ret__, 'vswitch_owner_id'),
        vswitches=pulumi.get(__ret__, 'vswitches'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_switches_output(cidr_block: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        dry_run: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        is_default: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        route_table_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                        vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        vswitch_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        vswitch_owner_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSwitchesResult]:
    """
    This data source provides a list of VSwitches owned by an Alibaba Cloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "vswitchDatasourceName"
    default = alicloud.get_zones()
    vpc = alicloud.vpc.Network("vpc",
        cidr_block="172.16.0.0/16",
        vpc_name=name)
    vswitch = alicloud.vpc.Switch("vswitch",
        vswitch_name=name,
        cidr_block="172.16.0.0/24",
        vpc_id=vpc.id,
        availability_zone=default.zones[0].id)
    default_get_switches = alicloud.vpc.get_switches_output(name_regex=vswitch.vswitch_name)
    ```


    :param _builtins.str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
    :param _builtins.bool dry_run: Specifies whether to precheck this request only. Valid values: `true` and `false`.
    :param Sequence[_builtins.str] ids: A list of vSwitch IDs.
    :param _builtins.bool is_default: Indicate whether the vSwitch is created by the system.
    :param _builtins.str name_regex: A regex string to filter results by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The Id of resource group which VSWitch belongs.
    :param _builtins.str route_table_id: The route table ID of the vSwitch.
    :param _builtins.str status: The status of the vSwitch. Valid values: `Available` and `Pending`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: ID of the VPC that owns the vSwitch.
    :param _builtins.str vswitch_name: The name of the vSwitch.
    :param _builtins.int vswitch_owner_id: The vSwitch owner id.
    :param _builtins.str zone_id: The availability zone of the vSwitch.
    """
    __args__ = dict()
    __args__['cidrBlock'] = cidr_block
    __args__['dryRun'] = dry_run
    __args__['ids'] = ids
    __args__['isDefault'] = is_default
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['routeTableId'] = route_table_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vswitchName'] = vswitch_name
    __args__['vswitchOwnerId'] = vswitch_owner_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getSwitches:getSwitches', __args__, opts=opts, typ=GetSwitchesResult)
    return __ret__.apply(lambda __response__: GetSwitchesResult(
        cidr_block=pulumi.get(__response__, 'cidr_block'),
        dry_run=pulumi.get(__response__, 'dry_run'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        is_default=pulumi.get(__response__, 'is_default'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        route_table_id=pulumi.get(__response__, 'route_table_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vswitch_name=pulumi.get(__response__, 'vswitch_name'),
        vswitch_owner_id=pulumi.get(__response__, 'vswitch_owner_id'),
        vswitches=pulumi.get(__response__, 'vswitches'),
        zone_id=pulumi.get(__response__, 'zone_id')))
