# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpamIpamPoolCidrArgs', 'IpamIpamPoolCidr']

@pulumi.input_type
class IpamIpamPoolCidrArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[_builtins.str],
                 ipam_pool_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a IpamIpamPoolCidr resource.
        :param pulumi.Input[_builtins.str] cidr: The CIDR address segment to be preset.
               
               > **NOTE:**  currently, only IPv4 address segments are supported.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the IPAM pool instance.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[_builtins.str]:
        """
        The CIDR address segment to be preset.

        > **NOTE:**  currently, only IPv4 address segments are supported.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the IPAM pool instance.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipam_pool_id", value)


@pulumi.input_type
class _IpamIpamPoolCidrState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpamIpamPoolCidr resources.
        :param pulumi.Input[_builtins.str] cidr: The CIDR address segment to be preset.
               
               > **NOTE:**  currently, only IPv4 address segments are supported.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the IPAM pool instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if ipam_pool_id is not None:
            pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR address segment to be preset.

        > **NOTE:**  currently, only IPv4 address segments are supported.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IPAM pool instance.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:vpc/ipamIpamPoolCidr:IpamIpamPoolCidr")
class IpamIpamPoolCidr(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vpc Ipam Ipam Pool Cidr resource.

        Ipam address pool preset CIDR.

        For information about Vpc Ipam Ipam Pool Cidr and how to use it, see [What is Ipam Pool Cidr](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/AddIpamPoolCidr).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_ipam = alicloud.vpc.IpamIpam("defaultIpam", operating_region_lists=["cn-hangzhou"])
        default_ipam_pool = alicloud.vpc.IpamIpamPool("defaultIpamPool",
            ipam_scope_id=default_ipam.private_default_scope_id,
            pool_region_id=default_ipam.region_id,
            ip_version="IPv4")
        default = alicloud.vpc.IpamIpamPoolCidr("default",
            cidr="10.0.0.0/8",
            ipam_pool_id=default_ipam_pool.id)
        ```

        ## Import

        Vpc Ipam Ipam Pool Cidr can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpamPoolCidr:IpamIpamPoolCidr example <ipam_pool_id>:<cidr>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: The CIDR address segment to be preset.
               
               > **NOTE:**  currently, only IPv4 address segments are supported.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the IPAM pool instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpamIpamPoolCidrArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Ipam Ipam Pool Cidr resource.

        Ipam address pool preset CIDR.

        For information about Vpc Ipam Ipam Pool Cidr and how to use it, see [What is Ipam Pool Cidr](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/AddIpamPoolCidr).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_ipam = alicloud.vpc.IpamIpam("defaultIpam", operating_region_lists=["cn-hangzhou"])
        default_ipam_pool = alicloud.vpc.IpamIpamPool("defaultIpamPool",
            ipam_scope_id=default_ipam.private_default_scope_id,
            pool_region_id=default_ipam.region_id,
            ip_version="IPv4")
        default = alicloud.vpc.IpamIpamPoolCidr("default",
            cidr="10.0.0.0/8",
            ipam_pool_id=default_ipam_pool.id)
        ```

        ## Import

        Vpc Ipam Ipam Pool Cidr can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpamPoolCidr:IpamIpamPoolCidr example <ipam_pool_id>:<cidr>
        ```

        :param str resource_name: The name of the resource.
        :param IpamIpamPoolCidrArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamIpamPoolCidrArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamIpamPoolCidrArgs.__new__(IpamIpamPoolCidrArgs)

            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            if ipam_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_pool_id'")
            __props__.__dict__["ipam_pool_id"] = ipam_pool_id
            __props__.__dict__["status"] = None
        super(IpamIpamPoolCidr, __self__).__init__(
            'alicloud:vpc/ipamIpamPoolCidr:IpamIpamPoolCidr',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpamIpamPoolCidr':
        """
        Get an existing IpamIpamPoolCidr resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: The CIDR address segment to be preset.
               
               > **NOTE:**  currently, only IPv4 address segments are supported.
        :param pulumi.Input[_builtins.str] ipam_pool_id: The ID of the IPAM pool instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpamIpamPoolCidrState.__new__(_IpamIpamPoolCidrState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["ipam_pool_id"] = ipam_pool_id
        __props__.__dict__["status"] = status
        return IpamIpamPoolCidr(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR address segment to be preset.

        > **NOTE:**  currently, only IPv4 address segments are supported.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IPAM pool instance.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

