# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['Ipv6GatewayArgs', 'Ipv6Gateway']

@pulumi.input_type
class Ipv6GatewayArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Ipv6Gateway resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
        :param pulumi.Input[_builtins.str] description: The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] ipv6_gateway_name: The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spec: IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ipv6_gateway_name is not None:
            pulumi.set(__self__, "ipv6_gateway_name", ipv6_gateway_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if spec is not None:
            warnings.warn("""Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish between specifications. This parameter is no longer used.""", DeprecationWarning)
            pulumi.log.warn("""spec is deprecated: Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish between specifications. This parameter is no longer used.""")
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayName")
    def ipv6_gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_gateway_name")

    @ipv6_gateway_name.setter
    def ipv6_gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish between specifications. This parameter is no longer used.""")
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags for the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _Ipv6GatewayState:
    def __init__(__self__, *,
                 business_status: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ipv6Gateway resources.
        :param pulumi.Input[_builtins.str] business_status: The status of the IPv6 gateway.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] description: The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] expired_time: The expiration time of IPv6 gateway.
        :param pulumi.Input[_builtins.str] instance_charge_type: The charge type of IPv6 gateway.
        :param pulumi.Input[_builtins.str] ipv6_gateway_id: Resource primary key attribute field.
        :param pulumi.Input[_builtins.str] ipv6_gateway_name: The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spec: IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: Available, Pending and Deleting.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
        """
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if ipv6_gateway_id is not None:
            pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        if ipv6_gateway_name is not None:
            pulumi.set(__self__, "ipv6_gateway_name", ipv6_gateway_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if spec is not None:
            warnings.warn("""Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish between specifications. This parameter is no longer used.""", DeprecationWarning)
            pulumi.log.warn("""spec is deprecated: Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish between specifications. This parameter is no longer used.""")
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the IPv6 gateway.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_status", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of IPv6 gateway.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The charge type of IPv6 gateway.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource primary key attribute field.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @ipv6_gateway_id.setter
    def ipv6_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayName")
    def ipv6_gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_gateway_name")

    @ipv6_gateway_name.setter
    def ipv6_gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish between specifications. This parameter is no longer used.""")
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: Available, Pending and Deleting.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags for the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:vpc/ipv6Gateway:Ipv6Gateway")
class Ipv6Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vpc Ipv6 Gateway resource. Gateway Based on Internet Protocol Version 6.

        For information about Vpc Ipv6 Gateway and how to use it, see [What is Ipv6 Gateway](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createipv6gateway).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-testacc-example"
        default_vpc = alicloud.vpc.Network("defaultVpc",
            description="tf-testacc",
            enable_ipv6=True)
        default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
            display_name="tf-testacc-ipv6gateway503",
            resource_group_name=f"{name}1")
        change_rg = alicloud.resourcemanager.ResourceGroup("changeRg",
            display_name="tf-testacc-ipv6gateway311",
            resource_group_name=f"{name}2")
        default = alicloud.vpc.Ipv6Gateway("default",
            description="test",
            ipv6_gateway_name=name,
            vpc_id=default_vpc.id,
            resource_group_id=default_rg.id)
        ```

        ## Import

        Vpc Ipv6 Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv6Gateway:Ipv6Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] ipv6_gateway_name: The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spec: IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Ipv6GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Ipv6 Gateway resource. Gateway Based on Internet Protocol Version 6.

        For information about Vpc Ipv6 Gateway and how to use it, see [What is Ipv6 Gateway](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createipv6gateway).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-testacc-example"
        default_vpc = alicloud.vpc.Network("defaultVpc",
            description="tf-testacc",
            enable_ipv6=True)
        default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
            display_name="tf-testacc-ipv6gateway503",
            resource_group_name=f"{name}1")
        change_rg = alicloud.resourcemanager.ResourceGroup("changeRg",
            display_name="tf-testacc-ipv6gateway311",
            resource_group_name=f"{name}2")
        default = alicloud.vpc.Ipv6Gateway("default",
            description="test",
            ipv6_gateway_name=name,
            vpc_id=default_vpc.id,
            resource_group_id=default_rg.id)
        ```

        ## Import

        Vpc Ipv6 Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv6Gateway:Ipv6Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param Ipv6GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ipv6GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ipv6GatewayArgs.__new__(Ipv6GatewayArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["ipv6_gateway_name"] = ipv6_gateway_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["spec"] = spec
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["business_status"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["instance_charge_type"] = None
            __props__.__dict__["ipv6_gateway_id"] = None
            __props__.__dict__["status"] = None
        super(Ipv6Gateway, __self__).__init__(
            'alicloud:vpc/ipv6Gateway:Ipv6Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            business_status: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expired_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ipv6Gateway':
        """
        Get an existing Ipv6Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] business_status: The status of the IPv6 gateway.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] description: The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] expired_time: The expiration time of IPv6 gateway.
        :param pulumi.Input[_builtins.str] instance_charge_type: The charge type of IPv6 gateway.
        :param pulumi.Input[_builtins.str] ipv6_gateway_id: Resource primary key attribute field.
        :param pulumi.Input[_builtins.str] ipv6_gateway_name: The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spec: IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: Available, Pending and Deleting.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ipv6GatewayState.__new__(_Ipv6GatewayState)

        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["ipv6_gateway_id"] = ipv6_gateway_id
        __props__.__dict__["ipv6_gateway_name"] = ipv6_gateway_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Ipv6Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the IPv6 gateway.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration time of IPv6 gateway.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The charge type of IPv6 gateway.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource primary key attribute field.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @_builtins.property
    @pulumi.getter(name="ipv6GatewayName")
    def ipv6_gateway_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_gateway_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish between specifications. This parameter is no longer used.""")
    def spec(self) -> pulumi.Output[_builtins.str]:
        """
        IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: Available, Pending and Deleting.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags for the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
        """
        return pulumi.get(self, "vpc_id")

