# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicIpAddressPoolArgs', 'PublicIpAddressPool']

@pulumi.input_type
class PublicIpAddressPoolArgs:
    def __init__(__self__, *,
                 biz_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PublicIpAddressPool resource.
        :param pulumi.Input[_builtins.str] biz_type: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - If the configuration is empty, the default value is DDoS protection (Basic edition).
               - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of PrefixList.
        """
        if biz_type is not None:
            pulumi.set(__self__, "biz_type", biz_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if public_ip_address_pool_name is not None:
            pulumi.set(__self__, "public_ip_address_pool_name", public_ip_address_pool_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="bizType")
    def biz_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "biz_type")

    @biz_type.setter
    def biz_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "biz_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @public_ip_address_pool_name.setter
    def public_ip_address_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID of the VPC Public IP address pool.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Security protection level.
        - If the configuration is empty, the default value is DDoS protection (Basic edition).
        - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of PrefixList.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PublicIpAddressPoolState:
    def __init__(__self__, *,
                 biz_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_remaining: Optional[pulumi.Input[_builtins.bool]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 total_ip_num: Optional[pulumi.Input[_builtins.int]] = None,
                 used_ip_num: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PublicIpAddressPool resources.
        :param pulumi.Input[_builtins.str] biz_type: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.bool] ip_address_remaining: Whether there is a free IP address.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - If the configuration is empty, the default value is DDoS protection (Basic edition).
               - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
        :param pulumi.Input[_builtins.str] status: The status of the VPC Public IP address pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of PrefixList.
        :param pulumi.Input[_builtins.int] total_ip_num: The total number of public IP address pools.
        :param pulumi.Input[_builtins.int] used_ip_num: The number of used IP addresses in the public IP address pool.
        """
        if biz_type is not None:
            pulumi.set(__self__, "biz_type", biz_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address_remaining is not None:
            pulumi.set(__self__, "ip_address_remaining", ip_address_remaining)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if public_ip_address_pool_name is not None:
            pulumi.set(__self__, "public_ip_address_pool_name", public_ip_address_pool_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if total_ip_num is not None:
            pulumi.set(__self__, "total_ip_num", total_ip_num)
        if used_ip_num is not None:
            pulumi.set(__self__, "used_ip_num", used_ip_num)

    @_builtins.property
    @pulumi.getter(name="bizType")
    def biz_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "biz_type")

    @biz_type.setter
    def biz_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "biz_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressRemaining")
    def ip_address_remaining(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether there is a free IP address.
        """
        return pulumi.get(self, "ip_address_remaining")

    @ip_address_remaining.setter
    def ip_address_remaining(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_address_remaining", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @public_ip_address_pool_name.setter
    def public_ip_address_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID of the VPC Public IP address pool.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Security protection level.
        - If the configuration is empty, the default value is DDoS protection (Basic edition).
        - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPC Public IP address pool.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of PrefixList.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of public IP address pools.
        """
        return pulumi.get(self, "total_ip_num")

    @total_ip_num.setter
    def total_ip_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_ip_num", value)

    @_builtins.property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of used IP addresses in the public IP address pool.
        """
        return pulumi.get(self, "used_ip_num")

    @used_ip_num.setter
    def used_ip_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_ip_num", value)


@pulumi.type_token("alicloud:vpc/publicIpAddressPool:PublicIpAddressPool")
class PublicIpAddressPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a VPC Public Ip Address Pool resource.

        For information about VPC Public Ip Address Pool and how to use it, see [What is Public Ip Address Pool](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createpublicipaddresspool).

        > **NOTE:** Available since v1.186.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_public_ip_address_pool = alicloud.vpc.PublicIpAddressPool("default",
            description=name,
            public_ip_address_pool_name=name,
            isp="BGP",
            resource_group_id=default.ids[0])
        ```

        ## Import

        VPC Public Ip Address Pool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/publicIpAddressPool:PublicIpAddressPool example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] biz_type: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - If the configuration is empty, the default value is DDoS protection (Basic edition).
               - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of PrefixList.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PublicIpAddressPoolArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Public Ip Address Pool resource.

        For information about VPC Public Ip Address Pool and how to use it, see [What is Public Ip Address Pool](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createpublicipaddresspool).

        > **NOTE:** Available since v1.186.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_public_ip_address_pool = alicloud.vpc.PublicIpAddressPool("default",
            description=name,
            public_ip_address_pool_name=name,
            isp="BGP",
            resource_group_id=default.ids[0])
        ```

        ## Import

        VPC Public Ip Address Pool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/publicIpAddressPool:PublicIpAddressPool example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PublicIpAddressPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicIpAddressPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicIpAddressPoolArgs.__new__(PublicIpAddressPoolArgs)

            __props__.__dict__["biz_type"] = biz_type
            __props__.__dict__["description"] = description
            __props__.__dict__["isp"] = isp
            __props__.__dict__["public_ip_address_pool_name"] = public_ip_address_pool_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_protection_types"] = security_protection_types
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["ip_address_remaining"] = None
            __props__.__dict__["public_ip_address_pool_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["total_ip_num"] = None
            __props__.__dict__["used_ip_num"] = None
        super(PublicIpAddressPool, __self__).__init__(
            'alicloud:vpc/publicIpAddressPool:PublicIpAddressPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            biz_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address_remaining: Optional[pulumi.Input[_builtins.bool]] = None,
            isp: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            total_ip_num: Optional[pulumi.Input[_builtins.int]] = None,
            used_ip_num: Optional[pulumi.Input[_builtins.int]] = None) -> 'PublicIpAddressPool':
        """
        Get an existing PublicIpAddressPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] biz_type: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.bool] ip_address_remaining: Whether there is a free IP address.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[_builtins.str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_protection_types: Security protection level.
               - If the configuration is empty, the default value is DDoS protection (Basic edition).
               - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
        :param pulumi.Input[_builtins.str] status: The status of the VPC Public IP address pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of PrefixList.
        :param pulumi.Input[_builtins.int] total_ip_num: The total number of public IP address pools.
        :param pulumi.Input[_builtins.int] used_ip_num: The number of used IP addresses in the public IP address pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicIpAddressPoolState.__new__(_PublicIpAddressPoolState)

        __props__.__dict__["biz_type"] = biz_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address_remaining"] = ip_address_remaining
        __props__.__dict__["isp"] = isp
        __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
        __props__.__dict__["public_ip_address_pool_name"] = public_ip_address_pool_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_protection_types"] = security_protection_types
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["total_ip_num"] = total_ip_num
        __props__.__dict__["used_ip_num"] = used_ip_num
        return PublicIpAddressPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bizType")
    def biz_type(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "biz_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ipAddressRemaining")
    def ip_address_remaining(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether there is a free IP address.
        """
        return pulumi.get(self, "ip_address_remaining")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> pulumi.Output[_builtins.str]:
        """
        The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "public_ip_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource group ID of the VPC Public IP address pool.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Security protection level.
        - If the configuration is empty, the default value is DDoS protection (Basic edition).
        - `AntiDDoS_Enhanced` indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the VPC Public IP address pool.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags of PrefixList.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of public IP address pools.
        """
        return pulumi.get(self, "total_ip_num")

    @_builtins.property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> pulumi.Output[_builtins.int]:
        """
        The number of used IP addresses in the public IP address pool.
        """
        return pulumi.get(self, "used_ip_num")

