# secontrol

`secontrol` — это высокоуровневый клиент для взаимодействия с Redis-шлюзом Space Engineers. Библиотека упрощает получение телеметрии, отправку команд и реализацию автоматизаций, используя устойчивые подписки на ключевые события.

## Возможности

- Подключение к Redis с помощью конфигурации из `.env` или аргументов конструктора.
- Наблюдение за ключами и каналами с автоматическим восстановлением подписок.
- Утилиты для получения идентификаторов владельца, игрока и грида.
- Примеры, демонстрирующие публикацию команд и мониторинг состояний.

## Установка

После публикации на PyPI библиотеку можно будет установить стандартным способом:

```bash
pip install secontrol
```

До публикации можно установить пакет из исходников:

```bash
pip install .
```

## Быстрый старт

```python
from secontrol.common import prepare_grid

#Первый грид игрока
client, grid = prepare_grid()
#Устройства на гриде
print(", ".join((d.name or f"{d.device_type}:{d.device_id}") for d in grid.devices.values()) or "(no devices)")

```

### Переменные окружения

| Переменная        | Назначение                                              |
| ----------------- | ------------------------------------------------------- |
| `REDIS_URL`       | URL Redis-инстанса (по умолчанию `redis://api.outenemy.ru:6379/0`). |
| `REDIS_USERNAME`  | Имя пользователя для авторизации.                       |
| `REDIS_PASSWORD`  | Пароль для подключения.                                 |
| `SE_PLAYER_ID`    | Идентификатор игрока Space Engineers.                   |
| `SE_GRID_ID`      | Идентификатор грида. Если не задан, используется первый доступный. |

Переменные можно определить в файле `.env` в корне проекта или системы. Модуль автоматически читает файл с помощью [`python-dotenv`](https://pypi.org/project/python-dotenv/).

## Примеры

Готовые скрипты находятся в каталоге [`sepy/examples`](src/secontrol/examples_direct_connect). Чтобы запустить пример:

```bash
python -m secontrol.examples_direct_connect.list_grids
```

## Подключение плагинов

Для работы с дополнительными расширениями, такими как [se-grid-controller](https://github.com/rootfabric/se_grid_controller),
в репозитории добавлен файл `repositories.yaml`. Он сообщает инструментам разработки, где искать внешние зависимости и
на какой ветке они находятся.

```yaml
repositories:
  - name: se-grid-controller
    url: git@github.com:rootfabric/se-grid-controller.git
    branch: main
```

При необходимости добавьте в этот файл другие плагины в том же формате.

## Лицензия

Проект распространяется по лицензии MIT. См. файл [LICENSE](LICENSE).

