# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DetectorArgs', 'Detector']

@pulumi.input_type
class DetectorArgs:
    def __init__(__self__, *,
                 program_text: pulumi.Input[_builtins.str],
                 rules: pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]],
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 min_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]]] = None):
        """
        The set of arguments for constructing a Detector resource.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the detector. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]] rules: Set of rules used for alerting.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's team id (or user id in `authorized_writer_users`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`).
        :param pulumi.Input[_builtins.str] description: Description of the detector.
        :param pulumi.Input[_builtins.str] detector_origin: Indicates how a detector was created. The possible values are: Standard and AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.bool] disable_sampling: When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[_builtins.int] max_delay: allows Splunk Observability Cloud to continue with computation if there is a lag in receiving data points.
        :param pulumi.Input[_builtins.int] min_delay: How long (in seconds) to wait even if the datapoints are arriving in a timely fashion. Max value is 900 (15m).
        :param pulumi.Input[_builtins.str] name: Name of the detector.
        :param pulumi.Input[_builtins.str] parent_detector_id: ID of the AutoDetect parent detector from which this detector is customized and created. This property is required for detectors with detectorOrigin of type AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.bool] show_data_markers: When `true`, markers will be drawn for each datapoint within the visualization. `true` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the detector.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the detector to.
        :param pulumi.Input[_builtins.int] time_range: Seconds to display in the visualization. This is a rolling range from the current time. Example: `3600` corresponds to `-1h` in web UI. `3600` by default.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        pulumi.set(__self__, "program_text", program_text)
        pulumi.set(__self__, "rules", rules)
        if authorized_writer_teams is not None:
            pulumi.set(__self__, "authorized_writer_teams", authorized_writer_teams)
        if authorized_writer_users is not None:
            pulumi.set(__self__, "authorized_writer_users", authorized_writer_users)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detector_origin is not None:
            pulumi.set(__self__, "detector_origin", detector_origin)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if min_delay is not None:
            pulumi.set(__self__, "min_delay", min_delay)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_detector_id is not None:
            pulumi.set(__self__, "parent_detector_id", parent_detector_id)
        if show_data_markers is not None:
            pulumi.set(__self__, "show_data_markers", show_data_markers)
        if show_event_lines is not None:
            pulumi.set(__self__, "show_event_lines", show_event_lines)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if time_range is not None:
            pulumi.set(__self__, "time_range", time_range)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Input[_builtins.str]:
        """
        Signalflow program text for the detector. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]]:
        """
        Set of rules used for alerting.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterTeams")
    def authorized_writer_teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's team id (or user id in `authorized_writer_users`).
        """
        return pulumi.get(self, "authorized_writer_teams")

    @authorized_writer_teams.setter
    def authorized_writer_teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_teams", value)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterUsers")
    def authorized_writer_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        User IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`).
        """
        return pulumi.get(self, "authorized_writer_users")

    @authorized_writer_users.setter
    def authorized_writer_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_users", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the detector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectorOrigin")
    def detector_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates how a detector was created. The possible values are: Standard and AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        """
        return pulumi.get(self, "detector_origin")

    @detector_origin.setter
    def detector_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detector_origin", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        allows Splunk Observability Cloud to continue with computation if there is a lag in receiving data points.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="minDelay")
    def min_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait even if the datapoints are arriving in a timely fashion. Max value is 900 (15m).
        """
        return pulumi.get(self, "min_delay")

    @min_delay.setter
    def min_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_delay", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the detector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentDetectorId")
    def parent_detector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the AutoDetect parent detector from which this detector is customized and created. This property is required for detectors with detectorOrigin of type AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        """
        return pulumi.get(self, "parent_detector_id")

    @parent_detector_id.setter
    def parent_detector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_detector_id", value)

    @_builtins.property
    @pulumi.getter(name="showDataMarkers")
    def show_data_markers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, markers will be drawn for each datapoint within the visualization. `true` by default.
        """
        return pulumi.get(self, "show_data_markers")

    @show_data_markers.setter
    def show_data_markers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_data_markers", value)

    @_builtins.property
    @pulumi.getter(name="showEventLines")
    def show_event_lines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        """
        return pulumi.get(self, "show_event_lines")

    @show_event_lines.setter
    def show_event_lines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_event_lines", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the detector.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs to associate the detector to.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds to display in the visualization. This is a rolling range from the current time. Example: `3600` corresponds to `-1h` in web UI. `3600` by default.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_range", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.input_type
class _DetectorState:
    def __init__(__self__, *,
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 label_resolutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 min_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering Detector resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's team id (or user id in `authorized_writer_users`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`).
        :param pulumi.Input[_builtins.str] description: Description of the detector.
        :param pulumi.Input[_builtins.str] detector_origin: Indicates how a detector was created. The possible values are: Standard and AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.bool] disable_sampling: When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]] label_resolutions: The resolutions of the detector alerts in milliseconds that indicate how often data is analyzed to determine if an alert should be triggered.
        :param pulumi.Input[_builtins.int] max_delay: allows Splunk Observability Cloud to continue with computation if there is a lag in receiving data points.
        :param pulumi.Input[_builtins.int] min_delay: How long (in seconds) to wait even if the datapoints are arriving in a timely fashion. Max value is 900 (15m).
        :param pulumi.Input[_builtins.str] name: Name of the detector.
        :param pulumi.Input[_builtins.str] parent_detector_id: ID of the AutoDetect parent detector from which this detector is customized and created. This property is required for detectors with detectorOrigin of type AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the detector. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]] rules: Set of rules used for alerting.
        :param pulumi.Input[_builtins.bool] show_data_markers: When `true`, markers will be drawn for each datapoint within the visualization. `true` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the detector.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the detector to.
        :param pulumi.Input[_builtins.int] time_range: Seconds to display in the visualization. This is a rolling range from the current time. Example: `3600` corresponds to `-1h` in web UI. `3600` by default.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[_builtins.str] url: The URL of the detector.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        if authorized_writer_teams is not None:
            pulumi.set(__self__, "authorized_writer_teams", authorized_writer_teams)
        if authorized_writer_users is not None:
            pulumi.set(__self__, "authorized_writer_users", authorized_writer_users)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detector_origin is not None:
            pulumi.set(__self__, "detector_origin", detector_origin)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if label_resolutions is not None:
            pulumi.set(__self__, "label_resolutions", label_resolutions)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if min_delay is not None:
            pulumi.set(__self__, "min_delay", min_delay)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_detector_id is not None:
            pulumi.set(__self__, "parent_detector_id", parent_detector_id)
        if program_text is not None:
            pulumi.set(__self__, "program_text", program_text)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if show_data_markers is not None:
            pulumi.set(__self__, "show_data_markers", show_data_markers)
        if show_event_lines is not None:
            pulumi.set(__self__, "show_event_lines", show_event_lines)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if time_range is not None:
            pulumi.set(__self__, "time_range", time_range)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterTeams")
    def authorized_writer_teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's team id (or user id in `authorized_writer_users`).
        """
        return pulumi.get(self, "authorized_writer_teams")

    @authorized_writer_teams.setter
    def authorized_writer_teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_teams", value)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterUsers")
    def authorized_writer_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        User IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`).
        """
        return pulumi.get(self, "authorized_writer_users")

    @authorized_writer_users.setter
    def authorized_writer_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_writer_users", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the detector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectorOrigin")
    def detector_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates how a detector was created. The possible values are: Standard and AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        """
        return pulumi.get(self, "detector_origin")

    @detector_origin.setter
    def detector_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detector_origin", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="labelResolutions")
    def label_resolutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]]:
        """
        The resolutions of the detector alerts in milliseconds that indicate how often data is analyzed to determine if an alert should be triggered.
        """
        return pulumi.get(self, "label_resolutions")

    @label_resolutions.setter
    def label_resolutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "label_resolutions", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        allows Splunk Observability Cloud to continue with computation if there is a lag in receiving data points.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="minDelay")
    def min_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait even if the datapoints are arriving in a timely fashion. Max value is 900 (15m).
        """
        return pulumi.get(self, "min_delay")

    @min_delay.setter
    def min_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_delay", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the detector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentDetectorId")
    def parent_detector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the AutoDetect parent detector from which this detector is customized and created. This property is required for detectors with detectorOrigin of type AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        """
        return pulumi.get(self, "parent_detector_id")

    @parent_detector_id.setter
    def parent_detector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_detector_id", value)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signalflow program text for the detector. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]]]:
        """
        Set of rules used for alerting.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="showDataMarkers")
    def show_data_markers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, markers will be drawn for each datapoint within the visualization. `true` by default.
        """
        return pulumi.get(self, "show_data_markers")

    @show_data_markers.setter
    def show_data_markers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_data_markers", value)

    @_builtins.property
    @pulumi.getter(name="showEventLines")
    def show_event_lines(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        """
        return pulumi.get(self, "show_event_lines")

    @show_event_lines.setter
    def show_event_lines(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_event_lines", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the detector.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Team IDs to associate the detector to.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds to display in the visualization. This is a rolling range from the current time. Example: `3600` corresponds to `-1h` in web UI. `3600` by default.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_range", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the detector.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.type_token("signalfx:index/detector:Detector")
class Detector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 min_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorRuleArgs', 'DetectorRuleArgsDict']]]]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorVizOptionArgs', 'DetectorVizOptionArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Splunk Observability Cloud detector resource. This can be used to create and manage detectors.

        If you're interested in using Splunk Observability Cloud detector features such as Historical Anomaly, Resource Running Out, or others, consider building them in the UI first and then use the "Show SignalFlow" feature to extract the value for `program_text`. You can also see the [documentation for detector functions in signalflow-library](https://github.com/signalfx/signalflow-library/tree/master/library/signalfx/detectors).

        > **NOTE** When you want to change or remove write permissions for a user other than yourself regarding detectors, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator).

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        config = pulumi.Config()
        clusters = config.get_object("clusters")
        if clusters is None:
            clusters = [
                "clusterA",
                "clusterB",
            ]
        application_delay = []
        for range in [{"value": i} for i in range(0, len(clusters))]:
            application_delay.append(signalfx.Detector(f"application_delay-{range['value']}",
                name=f" max average delay - {clusters[range['value']]}",
                description=f"your application is slow - {clusters[range['value']]}",
                max_delay=30,
                tags=[
                    "app-backend",
                    "staging",
                ],
                authorized_writer_teams=[mycoolteam["id"]],
                authorized_writer_users=["abc123"],
                program_text=f\"\"\"signal = data('app.delay', filter('cluster','{clusters[range["value"]]}'), extrapolation='last_value', maxExtrapolations=5).max()
        detect(when(signal > 60, '5m')).publish('Processing old messages 5m')
        detect(when(signal > 60, '30m')).publish('Processing old messages 30m')
        \"\"\",
                rules=[
                    {
                        "description": "maximum > 60 for 5m",
                        "severity": "Warning",
                        "detect_label": "Processing old messages 5m",
                        "notifications": ["Email,foo-alerts@bar.com"],
                    },
                    {
                        "description": "maximum > 60 for 30m",
                        "severity": "Critical",
                        "detect_label": "Processing old messages 30m",
                        "notifications": ["Email,foo-alerts@bar.com"],
                    },
                ]))
        ```

        ## Notification format

        As Splunk Observability Cloud supports different notification mechanisms, use a comma-delimited string to provide inputs. If you want to specify multiple notifications, each must be a member in the list, like so:

        See [Splunk Observability Cloud Docs](https://dev.splunk.com/observability/reference/api/detectors/latest) for more information.

        Here are some example of how to configure each notification type:

        ### Email

        ### Jira

        Note that the `credentialId` is the Splunk-provided ID shown after setting up your Jira integration. See also `jira.Integration`.

        ### OpsGenie

        Note that the `credentialId` is the Splunk-provided ID shown after setting up your Opsgenie integration. `Team` here is hardcoded as the `responderType` as that is the only acceptable type as per the API docs.

        ### PagerDuty

        ### Slack

        Exclude the `#` on the channel name:

        ### Team

        Sends [notifications to a team](https://docs.signalfx.com/en/latest/managing/teams/team-notifications.html).

        ### TeamEmail

        Sends an email to every member of a team.

        ### Splunk On-Call (formerly VictorOps)

        ### Webhooks

        You need to include all the commas even if you only use a credential id.

        You can either configure a Webhook to use an existing integration's credential id:

        Or configure one inline:

        ## Import

        Detectors can be imported using their string ID (recoverable from URL: `/#/detector/v2/abc123/edit`, e.g.

        ```sh
        $ pulumi import signalfx:index/detector:Detector application_delay abc123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's team id (or user id in `authorized_writer_users`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`).
        :param pulumi.Input[_builtins.str] description: Description of the detector.
        :param pulumi.Input[_builtins.str] detector_origin: Indicates how a detector was created. The possible values are: Standard and AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.bool] disable_sampling: When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[_builtins.int] max_delay: allows Splunk Observability Cloud to continue with computation if there is a lag in receiving data points.
        :param pulumi.Input[_builtins.int] min_delay: How long (in seconds) to wait even if the datapoints are arriving in a timely fashion. Max value is 900 (15m).
        :param pulumi.Input[_builtins.str] name: Name of the detector.
        :param pulumi.Input[_builtins.str] parent_detector_id: ID of the AutoDetect parent detector from which this detector is customized and created. This property is required for detectors with detectorOrigin of type AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the detector. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorRuleArgs', 'DetectorRuleArgsDict']]]] rules: Set of rules used for alerting.
        :param pulumi.Input[_builtins.bool] show_data_markers: When `true`, markers will be drawn for each datapoint within the visualization. `true` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the detector.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the detector to.
        :param pulumi.Input[_builtins.int] time_range: Seconds to display in the visualization. This is a rolling range from the current time. Example: `3600` corresponds to `-1h` in web UI. `3600` by default.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorVizOptionArgs', 'DetectorVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DetectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Splunk Observability Cloud detector resource. This can be used to create and manage detectors.

        If you're interested in using Splunk Observability Cloud detector features such as Historical Anomaly, Resource Running Out, or others, consider building them in the UI first and then use the "Show SignalFlow" feature to extract the value for `program_text`. You can also see the [documentation for detector functions in signalflow-library](https://github.com/signalfx/signalflow-library/tree/master/library/signalfx/detectors).

        > **NOTE** When you want to change or remove write permissions for a user other than yourself regarding detectors, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator).

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        config = pulumi.Config()
        clusters = config.get_object("clusters")
        if clusters is None:
            clusters = [
                "clusterA",
                "clusterB",
            ]
        application_delay = []
        for range in [{"value": i} for i in range(0, len(clusters))]:
            application_delay.append(signalfx.Detector(f"application_delay-{range['value']}",
                name=f" max average delay - {clusters[range['value']]}",
                description=f"your application is slow - {clusters[range['value']]}",
                max_delay=30,
                tags=[
                    "app-backend",
                    "staging",
                ],
                authorized_writer_teams=[mycoolteam["id"]],
                authorized_writer_users=["abc123"],
                program_text=f\"\"\"signal = data('app.delay', filter('cluster','{clusters[range["value"]]}'), extrapolation='last_value', maxExtrapolations=5).max()
        detect(when(signal > 60, '5m')).publish('Processing old messages 5m')
        detect(when(signal > 60, '30m')).publish('Processing old messages 30m')
        \"\"\",
                rules=[
                    {
                        "description": "maximum > 60 for 5m",
                        "severity": "Warning",
                        "detect_label": "Processing old messages 5m",
                        "notifications": ["Email,foo-alerts@bar.com"],
                    },
                    {
                        "description": "maximum > 60 for 30m",
                        "severity": "Critical",
                        "detect_label": "Processing old messages 30m",
                        "notifications": ["Email,foo-alerts@bar.com"],
                    },
                ]))
        ```

        ## Notification format

        As Splunk Observability Cloud supports different notification mechanisms, use a comma-delimited string to provide inputs. If you want to specify multiple notifications, each must be a member in the list, like so:

        See [Splunk Observability Cloud Docs](https://dev.splunk.com/observability/reference/api/detectors/latest) for more information.

        Here are some example of how to configure each notification type:

        ### Email

        ### Jira

        Note that the `credentialId` is the Splunk-provided ID shown after setting up your Jira integration. See also `jira.Integration`.

        ### OpsGenie

        Note that the `credentialId` is the Splunk-provided ID shown after setting up your Opsgenie integration. `Team` here is hardcoded as the `responderType` as that is the only acceptable type as per the API docs.

        ### PagerDuty

        ### Slack

        Exclude the `#` on the channel name:

        ### Team

        Sends [notifications to a team](https://docs.signalfx.com/en/latest/managing/teams/team-notifications.html).

        ### TeamEmail

        Sends an email to every member of a team.

        ### Splunk On-Call (formerly VictorOps)

        ### Webhooks

        You need to include all the commas even if you only use a credential id.

        You can either configure a Webhook to use an existing integration's credential id:

        Or configure one inline:

        ## Import

        Detectors can be imported using their string ID (recoverable from URL: `/#/detector/v2/abc123/edit`, e.g.

        ```sh
        $ pulumi import signalfx:index/detector:Detector application_delay abc123
        ```

        :param str resource_name: The name of the resource.
        :param DetectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DetectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 min_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorRuleArgs', 'DetectorRuleArgsDict']]]]] = None,
                 show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
                 show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorVizOptionArgs', 'DetectorVizOptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DetectorArgs.__new__(DetectorArgs)

            __props__.__dict__["authorized_writer_teams"] = authorized_writer_teams
            __props__.__dict__["authorized_writer_users"] = authorized_writer_users
            __props__.__dict__["description"] = description
            __props__.__dict__["detector_origin"] = detector_origin
            __props__.__dict__["disable_sampling"] = disable_sampling
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["max_delay"] = max_delay
            __props__.__dict__["min_delay"] = min_delay
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_detector_id"] = parent_detector_id
            if program_text is None and not opts.urn:
                raise TypeError("Missing required property 'program_text'")
            __props__.__dict__["program_text"] = program_text
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["show_data_markers"] = show_data_markers
            __props__.__dict__["show_event_lines"] = show_event_lines
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["teams"] = teams
            __props__.__dict__["time_range"] = time_range
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["viz_options"] = viz_options
            __props__.__dict__["label_resolutions"] = None
            __props__.__dict__["url"] = None
        super(Detector, __self__).__init__(
            'signalfx:index/detector:Detector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorized_writer_teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authorized_writer_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            detector_origin: Optional[pulumi.Input[_builtins.str]] = None,
            disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
            end_time: Optional[pulumi.Input[_builtins.int]] = None,
            label_resolutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]] = None,
            max_delay: Optional[pulumi.Input[_builtins.int]] = None,
            min_delay: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_detector_id: Optional[pulumi.Input[_builtins.str]] = None,
            program_text: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorRuleArgs', 'DetectorRuleArgsDict']]]]] = None,
            show_data_markers: Optional[pulumi.Input[_builtins.bool]] = None,
            show_event_lines: Optional[pulumi.Input[_builtins.bool]] = None,
            start_time: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_range: Optional[pulumi.Input[_builtins.int]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DetectorVizOptionArgs', 'DetectorVizOptionArgsDict']]]]] = None) -> 'Detector':
        """
        Get an existing Detector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_teams: Team IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's team id (or user id in `authorized_writer_users`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_writer_users: User IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`).
        :param pulumi.Input[_builtins.str] description: Description of the detector.
        :param pulumi.Input[_builtins.str] detector_origin: Indicates how a detector was created. The possible values are: Standard and AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.bool] disable_sampling: When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]] label_resolutions: The resolutions of the detector alerts in milliseconds that indicate how often data is analyzed to determine if an alert should be triggered.
        :param pulumi.Input[_builtins.int] max_delay: allows Splunk Observability Cloud to continue with computation if there is a lag in receiving data points.
        :param pulumi.Input[_builtins.int] min_delay: How long (in seconds) to wait even if the datapoints are arriving in a timely fashion. Max value is 900 (15m).
        :param pulumi.Input[_builtins.str] name: Name of the detector.
        :param pulumi.Input[_builtins.str] parent_detector_id: ID of the AutoDetect parent detector from which this detector is customized and created. This property is required for detectors with detectorOrigin of type AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the detector. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorRuleArgs', 'DetectorRuleArgsDict']]]] rules: Set of rules used for alerting.
        :param pulumi.Input[_builtins.bool] show_data_markers: When `true`, markers will be drawn for each datapoint within the visualization. `true` by default.
        :param pulumi.Input[_builtins.bool] show_event_lines: When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the detector.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: Team IDs to associate the detector to.
        :param pulumi.Input[_builtins.int] time_range: Seconds to display in the visualization. This is a rolling range from the current time. Example: `3600` corresponds to `-1h` in web UI. `3600` by default.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        :param pulumi.Input[_builtins.str] url: The URL of the detector.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DetectorVizOptionArgs', 'DetectorVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DetectorState.__new__(_DetectorState)

        __props__.__dict__["authorized_writer_teams"] = authorized_writer_teams
        __props__.__dict__["authorized_writer_users"] = authorized_writer_users
        __props__.__dict__["description"] = description
        __props__.__dict__["detector_origin"] = detector_origin
        __props__.__dict__["disable_sampling"] = disable_sampling
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["label_resolutions"] = label_resolutions
        __props__.__dict__["max_delay"] = max_delay
        __props__.__dict__["min_delay"] = min_delay
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_detector_id"] = parent_detector_id
        __props__.__dict__["program_text"] = program_text
        __props__.__dict__["rules"] = rules
        __props__.__dict__["show_data_markers"] = show_data_markers
        __props__.__dict__["show_event_lines"] = show_event_lines
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["teams"] = teams
        __props__.__dict__["time_range"] = time_range
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["url"] = url
        __props__.__dict__["viz_options"] = viz_options
        return Detector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizedWriterTeams")
    def authorized_writer_teams(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Team IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's team id (or user id in `authorized_writer_users`).
        """
        return pulumi.get(self, "authorized_writer_teams")

    @_builtins.property
    @pulumi.getter(name="authorizedWriterUsers")
    def authorized_writer_users(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        User IDs that have write access to this detector. Remember to use an admin's token if using this feature and to include that admin's user id (or team id in `authorized_writer_teams`).
        """
        return pulumi.get(self, "authorized_writer_users")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the detector.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detectorOrigin")
    def detector_origin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates how a detector was created. The possible values are: Standard and AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        """
        return pulumi.get(self, "detector_origin")

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When `false`, the visualization may sample the output timeseries rather than displaying them all. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="labelResolutions")
    def label_resolutions(self) -> pulumi.Output[Mapping[str, _builtins.int]]:
        """
        The resolutions of the detector alerts in milliseconds that indicate how often data is analyzed to determine if an alert should be triggered.
        """
        return pulumi.get(self, "label_resolutions")

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        allows Splunk Observability Cloud to continue with computation if there is a lag in receiving data points.
        """
        return pulumi.get(self, "max_delay")

    @_builtins.property
    @pulumi.getter(name="minDelay")
    def min_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long (in seconds) to wait even if the datapoints are arriving in a timely fashion. Max value is 900 (15m).
        """
        return pulumi.get(self, "min_delay")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the detector.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentDetectorId")
    def parent_detector_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the AutoDetect parent detector from which this detector is customized and created. This property is required for detectors with detectorOrigin of type AutoDetectCustomization. The value can only be set when creating the detector and cannot be modified later.
        """
        return pulumi.get(self, "parent_detector_id")

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Output[_builtins.str]:
        """
        Signalflow program text for the detector. More info [in the Splunk Observability Cloud docs](https://dev.splunk.com/observability/docs/signalflow/).
        """
        return pulumi.get(self, "program_text")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.DetectorRule']]:
        """
        Set of rules used for alerting.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="showDataMarkers")
    def show_data_markers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When `true`, markers will be drawn for each datapoint within the visualization. `true` by default.
        """
        return pulumi.get(self, "show_data_markers")

    @_builtins.property
    @pulumi.getter(name="showEventLines")
    def show_event_lines(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When `true`, the visualization will display a vertical line for each event trigger. `false` by default.
        """
        return pulumi.get(self, "show_event_lines")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags associated with the detector.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Team IDs to associate the detector to.
        """
        return pulumi.get(self, "teams")

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds to display in the visualization. This is a rolling range from the current time. Example: `3600` corresponds to `-1h` in web UI. `3600` by default.
        """
        return pulumi.get(self, "time_range")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (e.g. Australia/Sydney)
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the detector.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> pulumi.Output[Optional[Sequence['outputs.DetectorVizOption']]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

