# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AlertMutingRuleFilter',
    'AlertMutingRuleRecurrence',
    'DashboardChart',
    'DashboardColumn',
    'DashboardEventOverlay',
    'DashboardEventOverlaySource',
    'DashboardFilter',
    'DashboardGrid',
    'DashboardGroupDashboard',
    'DashboardGroupDashboardFilterOverride',
    'DashboardGroupDashboardVariableOverride',
    'DashboardGroupImportQualifier',
    'DashboardGroupImportQualifierFilter',
    'DashboardGroupPermission',
    'DashboardPermissions',
    'DashboardPermissionsAcl',
    'DashboardSelectedEventOverlay',
    'DashboardSelectedEventOverlaySource',
    'DashboardVariable',
    'DataLinkTargetAppdUrl',
    'DataLinkTargetExternalUrl',
    'DataLinkTargetSignalfxDashboard',
    'DataLinkTargetSplunk',
    'DetectorRule',
    'DetectorRuleReminderNotification',
    'DetectorVizOption',
    'HeatmapChartColorRange',
    'HeatmapChartColorScale',
    'ListChartColorScale',
    'ListChartLegendOptionsField',
    'ListChartVizOption',
    'MetricRulesetAggregationRule',
    'MetricRulesetAggregationRuleAggregator',
    'MetricRulesetAggregationRuleMatcher',
    'MetricRulesetAggregationRuleMatcherFilter',
    'MetricRulesetExceptionRule',
    'MetricRulesetExceptionRuleMatcher',
    'MetricRulesetExceptionRuleMatcherFilter',
    'MetricRulesetExceptionRuleRestoration',
    'MetricRulesetRoutingRule',
    'OrgTokenDpmLimits',
    'OrgTokenHostOrUsageLimits',
    'SingleValueChartColorScale',
    'SingleValueChartVizOption',
    'SloInput',
    'SloTarget',
    'SloTargetAlertRule',
    'SloTargetAlertRuleRule',
    'SloTargetAlertRuleRuleParameters',
    'SloTargetAlertRuleRuleReminderNotification',
    'TableChartVizOption',
    'TimeChartAxisLeft',
    'TimeChartAxisLeftWatermark',
    'TimeChartAxisRight',
    'TimeChartAxisRightWatermark',
    'TimeChartEventOption',
    'TimeChartHistogramOption',
    'TimeChartLegendOptionsField',
    'TimeChartVizOption',
    'WebhookIntegrationHeader',
]

@pulumi.output_type
class AlertMutingRuleFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyValue":
            suggest = "property_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertMutingRuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertMutingRuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertMutingRuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property: _builtins.str,
                 property_value: _builtins.str,
                 negated: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: The property to filter.
        :param _builtins.str property_value: The property value to filter.
        :param _builtins.bool negated: Determines if this is a "not" filter. Defaults to `false`.
        """
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "property_value", property_value)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        The property to filter.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> _builtins.str:
        """
        The property value to filter.
        """
        return pulumi.get(self, "property_value")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> Optional[_builtins.bool]:
        """
        Determines if this is a "not" filter. Defaults to `false`.
        """
        return pulumi.get(self, "negated")


@pulumi.output_type
class AlertMutingRuleRecurrence(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str unit: The unit of the period. Can be days (d) or weeks (w).
        :param _builtins.int value: The amount of time, expressed as an integer, applicable to the unit specified.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        """
        The unit of the period. Can be days (d) or weeks (w).
        """
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        The amount of time, expressed as an integer, applicable to the unit specified.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DashboardChart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartId":
            suggest = "chart_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardChart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardChart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardChart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_id: _builtins.str,
                 column: Optional[_builtins.int] = None,
                 height: Optional[_builtins.int] = None,
                 row: Optional[_builtins.int] = None,
                 width: Optional[_builtins.int] = None):
        """
        :param _builtins.str chart_id: ID of the chart to display.
        :param _builtins.int column: The column to show the chart in (zero-based); this value always represents the leftmost column of the chart (between `0` and `11`).
        :param _builtins.int height: How many rows the chart should take up (greater than or equal to `1`). `1` by default.
        :param _builtins.int row: The row to show the chart in (zero-based); if `height > 1`, this value represents the topmost row of the chart (greater than or equal to `0`).
        :param _builtins.int width: How many columns (out of a total of 12) the chart should take up (between `1` and `12`). `12` by default.
        """
        pulumi.set(__self__, "chart_id", chart_id)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if row is not None:
            pulumi.set(__self__, "row", row)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @_builtins.property
    @pulumi.getter(name="chartId")
    def chart_id(self) -> _builtins.str:
        """
        ID of the chart to display.
        """
        return pulumi.get(self, "chart_id")

    @_builtins.property
    @pulumi.getter
    def column(self) -> Optional[_builtins.int]:
        """
        The column to show the chart in (zero-based); this value always represents the leftmost column of the chart (between `0` and `11`).
        """
        return pulumi.get(self, "column")

    @_builtins.property
    @pulumi.getter
    def height(self) -> Optional[_builtins.int]:
        """
        How many rows the chart should take up (greater than or equal to `1`). `1` by default.
        """
        return pulumi.get(self, "height")

    @_builtins.property
    @pulumi.getter
    def row(self) -> Optional[_builtins.int]:
        """
        The row to show the chart in (zero-based); if `height > 1`, this value represents the topmost row of the chart (greater than or equal to `0`).
        """
        return pulumi.get(self, "row")

    @_builtins.property
    @pulumi.getter
    def width(self) -> Optional[_builtins.int]:
        """
        How many columns (out of a total of 12) the chart should take up (between `1` and `12`). `12` by default.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class DashboardColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartIds":
            suggest = "chart_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_ids: Sequence[_builtins.str],
                 column: Optional[_builtins.int] = None,
                 height: Optional[_builtins.int] = None,
                 width: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] chart_ids: List of IDs of the charts to display.
        :param _builtins.int column: Column number for the layout.
        :param _builtins.int height: How many rows every chart should take up (greater than or equal to 1). 1 by default.
        :param _builtins.int width: How many columns (out of a total of `12`) every chart should take up (between `1` and `12`). `12` by default.
        """
        pulumi.set(__self__, "chart_ids", chart_ids)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @_builtins.property
    @pulumi.getter(name="chartIds")
    def chart_ids(self) -> Sequence[_builtins.str]:
        """
        List of IDs of the charts to display.
        """
        return pulumi.get(self, "chart_ids")

    @_builtins.property
    @pulumi.getter
    def column(self) -> Optional[_builtins.int]:
        """
        Column number for the layout.
        """
        return pulumi.get(self, "column")

    @_builtins.property
    @pulumi.getter
    def height(self) -> Optional[_builtins.int]:
        """
        How many rows every chart should take up (greater than or equal to 1). 1 by default.
        """
        return pulumi.get(self, "height")

    @_builtins.property
    @pulumi.getter
    def width(self) -> Optional[_builtins.int]:
        """
        How many columns (out of a total of `12`) every chart should take up (between `1` and `12`). `12` by default.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class DashboardEventOverlay(dict):
    def __init__(__self__, *,
                 signal: _builtins.str,
                 color: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 line: Optional[_builtins.bool] = None,
                 sources: Optional[Sequence['outputs.DashboardEventOverlaySource']] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str signal: Search term used to choose the events shown in the overlay.
        :param _builtins.str color: Color to use : gray, blue, azure, navy, brown, orange, yellow, iris, magenta, pink, purple, violet, lilac, emerald, green, aquamarine.
        :param _builtins.str label: Text shown in the dropdown when selecting this overlay from the menu.
        :param _builtins.bool line: Show a vertical line for the event. `false` by default.
        :param Sequence['DashboardEventOverlaySourceArgs'] sources: Each element specifies a filter to use against the signal specified in the `signal`.
        :param _builtins.str type: Can be set to `eventTimeSeries` (the default) to refer to externally reported events, or `detectorEvents` to refer to events from detector triggers.
        """
        pulumi.set(__self__, "signal", signal)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if line is not None:
            pulumi.set(__self__, "line", line)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def signal(self) -> _builtins.str:
        """
        Search term used to choose the events shown in the overlay.
        """
        return pulumi.get(self, "signal")

    @_builtins.property
    @pulumi.getter
    def color(self) -> Optional[_builtins.str]:
        """
        Color to use : gray, blue, azure, navy, brown, orange, yellow, iris, magenta, pink, purple, violet, lilac, emerald, green, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Text shown in the dropdown when selecting this overlay from the menu.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def line(self) -> Optional[_builtins.bool]:
        """
        Show a vertical line for the event. `false` by default.
        """
        return pulumi.get(self, "line")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.DashboardEventOverlaySource']]:
        """
        Each element specifies a filter to use against the signal specified in the `signal`.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Can be set to `eventTimeSeries` (the default) to refer to externally reported events, or `detectorEvents` to refer to events from detector triggers.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DashboardEventOverlaySource(dict):
    def __init__(__self__, *,
                 property: _builtins.str,
                 values: Sequence[_builtins.str],
                 negated: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: The name of a dimension to filter against.
        :param Sequence[_builtins.str] values: A list of values to be used with the `property`, they will be combined via `OR`.
        :param _builtins.bool negated: If true, only data that does not match the specified value of the specified property appear in the event overlay. Defaults to `false`.
        """
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "values", values)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        The name of a dimension to filter against.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values to be used with the `property`, they will be combined via `OR`.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> Optional[_builtins.bool]:
        """
        If true, only data that does not match the specified value of the specified property appear in the event overlay. Defaults to `false`.
        """
        return pulumi.get(self, "negated")


@pulumi.output_type
class DashboardFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyIfExist":
            suggest = "apply_if_exist"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property: _builtins.str,
                 values: Sequence[_builtins.str],
                 apply_if_exist: Optional[_builtins.bool] = None,
                 negated: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: A metric time series dimension or property name.
        :param Sequence[_builtins.str] values: List of of strings (which will be treated as an OR filter on the property).
        :param _builtins.bool apply_if_exist: If true, this filter will also match data that doesn't have this property at all.
        :param _builtins.bool negated: Whether this filter should be a not filter. `false` by default.
        """
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "values", values)
        if apply_if_exist is not None:
            pulumi.set(__self__, "apply_if_exist", apply_if_exist)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        A metric time series dimension or property name.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        List of of strings (which will be treated as an OR filter on the property).
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter(name="applyIfExist")
    def apply_if_exist(self) -> Optional[_builtins.bool]:
        """
        If true, this filter will also match data that doesn't have this property at all.
        """
        return pulumi.get(self, "apply_if_exist")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> Optional[_builtins.bool]:
        """
        Whether this filter should be a not filter. `false` by default.
        """
        return pulumi.get(self, "negated")


@pulumi.output_type
class DashboardGrid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartIds":
            suggest = "chart_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardGrid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardGrid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardGrid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_ids: Sequence[_builtins.str],
                 height: Optional[_builtins.int] = None,
                 width: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] chart_ids: List of IDs of the charts to display.
        :param _builtins.int height: How many rows every chart should take up (greater than or equal to `1`). `1` by default.
        :param _builtins.int width: How many columns (out of a total of 12) every chart should take up (between `1` and `12`). `12` by default.
        """
        pulumi.set(__self__, "chart_ids", chart_ids)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @_builtins.property
    @pulumi.getter(name="chartIds")
    def chart_ids(self) -> Sequence[_builtins.str]:
        """
        List of IDs of the charts to display.
        """
        return pulumi.get(self, "chart_ids")

    @_builtins.property
    @pulumi.getter
    def height(self) -> Optional[_builtins.int]:
        """
        How many rows every chart should take up (greater than or equal to `1`). `1` by default.
        """
        return pulumi.get(self, "height")

    @_builtins.property
    @pulumi.getter
    def width(self) -> Optional[_builtins.int]:
        """
        How many columns (out of a total of 12) every chart should take up (between `1` and `12`). `12` by default.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class DashboardGroupDashboard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dashboardId":
            suggest = "dashboard_id"
        elif key == "configId":
            suggest = "config_id"
        elif key == "descriptionOverride":
            suggest = "description_override"
        elif key == "filterOverrides":
            suggest = "filter_overrides"
        elif key == "nameOverride":
            suggest = "name_override"
        elif key == "variableOverrides":
            suggest = "variable_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardGroupDashboard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardGroupDashboard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardGroupDashboard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dashboard_id: _builtins.str,
                 config_id: Optional[_builtins.str] = None,
                 description_override: Optional[_builtins.str] = None,
                 filter_overrides: Optional[Sequence['outputs.DashboardGroupDashboardFilterOverride']] = None,
                 name_override: Optional[_builtins.str] = None,
                 variable_overrides: Optional[Sequence['outputs.DashboardGroupDashboardVariableOverride']] = None):
        """
        :param _builtins.str dashboard_id: The dashboard id to mirror
        :param _builtins.str config_id: The ID of the association between the dashboard group and the dashboard
        :param _builtins.str description_override: The description that will override the original dashboards's description.
        :param Sequence['DashboardGroupDashboardFilterOverrideArgs'] filter_overrides: The description that will override the original dashboards's description.
        :param _builtins.str name_override: The name that will override the original dashboards's name.
        :param Sequence['DashboardGroupDashboardVariableOverrideArgs'] variable_overrides: Dashboard variable to apply to each chart in the dashboard
        """
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if description_override is not None:
            pulumi.set(__self__, "description_override", description_override)
        if filter_overrides is not None:
            pulumi.set(__self__, "filter_overrides", filter_overrides)
        if name_override is not None:
            pulumi.set(__self__, "name_override", name_override)
        if variable_overrides is not None:
            pulumi.set(__self__, "variable_overrides", variable_overrides)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> _builtins.str:
        """
        The dashboard id to mirror
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[_builtins.str]:
        """
        The ID of the association between the dashboard group and the dashboard
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="descriptionOverride")
    def description_override(self) -> Optional[_builtins.str]:
        """
        The description that will override the original dashboards's description.
        """
        return pulumi.get(self, "description_override")

    @_builtins.property
    @pulumi.getter(name="filterOverrides")
    def filter_overrides(self) -> Optional[Sequence['outputs.DashboardGroupDashboardFilterOverride']]:
        """
        The description that will override the original dashboards's description.
        """
        return pulumi.get(self, "filter_overrides")

    @_builtins.property
    @pulumi.getter(name="nameOverride")
    def name_override(self) -> Optional[_builtins.str]:
        """
        The name that will override the original dashboards's name.
        """
        return pulumi.get(self, "name_override")

    @_builtins.property
    @pulumi.getter(name="variableOverrides")
    def variable_overrides(self) -> Optional[Sequence['outputs.DashboardGroupDashboardVariableOverride']]:
        """
        Dashboard variable to apply to each chart in the dashboard
        """
        return pulumi.get(self, "variable_overrides")


@pulumi.output_type
class DashboardGroupDashboardFilterOverride(dict):
    def __init__(__self__, *,
                 property: _builtins.str,
                 values: Sequence[_builtins.str],
                 negated: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: A metric time series dimension or property name.
        :param Sequence[_builtins.str] values: (Optional) List of of strings (which will be treated as an OR filter on the property).
        :param _builtins.bool negated: If true, only data that does not match the specified value of the specified property appear in the event overlay. Defaults to `false`.
        """
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "values", values)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        A metric time series dimension or property name.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of of strings (which will be treated as an OR filter on the property).
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> Optional[_builtins.bool]:
        """
        If true, only data that does not match the specified value of the specified property appear in the event overlay. Defaults to `false`.
        """
        return pulumi.get(self, "negated")


@pulumi.output_type
class DashboardGroupDashboardVariableOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valuesSuggesteds":
            suggest = "values_suggesteds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardGroupDashboardVariableOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardGroupDashboardVariableOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardGroupDashboardVariableOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property: _builtins.str,
                 values: Optional[Sequence[_builtins.str]] = None,
                 values_suggesteds: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str property: A metric time series dimension or property name
        :param Sequence[_builtins.str] values: List of strings (which will be treated as an OR filter on the property)
        :param Sequence[_builtins.str] values_suggesteds: A list of strings of suggested values for this variable; these suggestions will receive priority when values are autosuggested for this variable
        """
        pulumi.set(__self__, "property", property)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if values_suggesteds is not None:
            pulumi.set(__self__, "values_suggesteds", values_suggesteds)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        A metric time series dimension or property name
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of strings (which will be treated as an OR filter on the property)
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter(name="valuesSuggesteds")
    def values_suggesteds(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of strings of suggested values for this variable; these suggestions will receive priority when values are autosuggested for this variable
        """
        return pulumi.get(self, "values_suggesteds")


@pulumi.output_type
class DashboardGroupImportQualifier(dict):
    def __init__(__self__, *,
                 filters: Optional[Sequence['outputs.DashboardGroupImportQualifierFilter']] = None,
                 metric: Optional[_builtins.str] = None):
        """
        :param Sequence['DashboardGroupImportQualifierFilterArgs'] filters: Filter to apply to each chart in the dashboard
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.DashboardGroupImportQualifierFilter']]:
        """
        Filter to apply to each chart in the dashboard
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "metric")


@pulumi.output_type
class DashboardGroupImportQualifierFilter(dict):
    def __init__(__self__, *,
                 property: _builtins.str,
                 values: Sequence[_builtins.str],
                 negated: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: A metric time series dimension or property name
        :param Sequence[_builtins.str] values: List of strings (which will be treated as an OR filter on the property)
        :param _builtins.bool negated: (false by default) Whether this filter should be a "not" filter
        """
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "values", values)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        A metric time series dimension or property name
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        List of strings (which will be treated as an OR filter on the property)
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> Optional[_builtins.bool]:
        """
        (false by default) Whether this filter should be a "not" filter
        """
        return pulumi.get(self, "negated")


@pulumi.output_type
class DashboardGroupPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "principalType":
            suggest = "principal_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardGroupPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardGroupPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardGroupPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 principal_type: _builtins.str,
                 actions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str principal_id: ID of the user, team, or organization for which you're granting permissions.
        :param _builtins.str principal_type: Clarify whether this permission configuration is for a user, a team, or an organization. Value can be one of "USER", "TEAM", or "ORG".
        :param Sequence[_builtins.str] actions: Action the user, team, or organization can take with the dashboard group. List of values (value can be "READ" or "WRITE").
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        ID of the user, team, or organization for which you're granting permissions.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> _builtins.str:
        """
        Clarify whether this permission configuration is for a user, a team, or an organization. Value can be one of "USER", "TEAM", or "ORG".
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Action the user, team, or organization can take with the dashboard group. List of values (value can be "READ" or "WRITE").
        """
        return pulumi.get(self, "actions")


@pulumi.output_type
class DashboardPermissions(dict):
    def __init__(__self__, *,
                 acls: Optional[Sequence['outputs.DashboardPermissionsAcl']] = None,
                 parent: Optional[_builtins.str] = None):
        """
        :param Sequence['DashboardPermissionsAclArgs'] acls: List of read and write permission configurations to specify which user, team, and organization can view and/or edit your dashboard. Use the `permissions.parent` instead if you want to inherit permissions.
        :param _builtins.str parent: ID of the dashboard group you want your dashboard to inherit permissions from. Use the `permissions.acl` instead if you want to specify various read and write permission configurations.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[Sequence['outputs.DashboardPermissionsAcl']]:
        """
        List of read and write permission configurations to specify which user, team, and organization can view and/or edit your dashboard. Use the `permissions.parent` instead if you want to inherit permissions.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[_builtins.str]:
        """
        ID of the dashboard group you want your dashboard to inherit permissions from. Use the `permissions.acl` instead if you want to specify various read and write permission configurations.
        """
        return pulumi.get(self, "parent")


@pulumi.output_type
class DashboardPermissionsAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "principalType":
            suggest = "principal_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardPermissionsAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardPermissionsAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardPermissionsAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 principal_type: _builtins.str,
                 actions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str principal_id: ID of the user, team, or organization for which you're granting permissions.
        :param _builtins.str principal_type: Clarify whether this permission configuration is for a user, a team, or an organization. Value can be one of "USER", "TEAM", or "ORG".
        :param Sequence[_builtins.str] actions: Action the user, team, or organization can take with the dashboard. List of values (value can be "READ" or "WRITE").
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        ID of the user, team, or organization for which you're granting permissions.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> _builtins.str:
        """
        Clarify whether this permission configuration is for a user, a team, or an organization. Value can be one of "USER", "TEAM", or "ORG".
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Action the user, team, or organization can take with the dashboard. List of values (value can be "READ" or "WRITE").
        """
        return pulumi.get(self, "actions")


@pulumi.output_type
class DashboardSelectedEventOverlay(dict):
    def __init__(__self__, *,
                 signal: _builtins.str,
                 sources: Optional[Sequence['outputs.DashboardSelectedEventOverlaySource']] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str signal: Search term used to choose the events shown in the overlay.
        :param Sequence['DashboardSelectedEventOverlaySourceArgs'] sources: Each element specifies a filter to use against the signal specified in the `signal`.
        :param _builtins.str type: Can be set to `eventTimeSeries` (the default) to refer to externally reported events, or `detectorEvents` to refer to events from detector triggers.
        """
        pulumi.set(__self__, "signal", signal)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def signal(self) -> _builtins.str:
        """
        Search term used to choose the events shown in the overlay.
        """
        return pulumi.get(self, "signal")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.DashboardSelectedEventOverlaySource']]:
        """
        Each element specifies a filter to use against the signal specified in the `signal`.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Can be set to `eventTimeSeries` (the default) to refer to externally reported events, or `detectorEvents` to refer to events from detector triggers.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DashboardSelectedEventOverlaySource(dict):
    def __init__(__self__, *,
                 property: _builtins.str,
                 values: Sequence[_builtins.str],
                 negated: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: The name of a dimension to filter against.
        :param Sequence[_builtins.str] values: A list of values to be used with the `property`, they will be combined via `OR`.
        :param _builtins.bool negated: If true, only data that does not match the specified value of the specified property appear in the event overlay. Defaults to `false`.
        """
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "values", values)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        The name of a dimension to filter against.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values to be used with the `property`, they will be combined via `OR`.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> Optional[_builtins.bool]:
        """
        If true, only data that does not match the specified value of the specified property appear in the event overlay. Defaults to `false`.
        """
        return pulumi.get(self, "negated")


@pulumi.output_type
class DashboardVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyIfExist":
            suggest = "apply_if_exist"
        elif key == "replaceOnly":
            suggest = "replace_only"
        elif key == "restrictedSuggestions":
            suggest = "restricted_suggestions"
        elif key == "valueRequired":
            suggest = "value_required"
        elif key == "valuesSuggesteds":
            suggest = "values_suggesteds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias: _builtins.str,
                 property: _builtins.str,
                 apply_if_exist: Optional[_builtins.bool] = None,
                 description: Optional[_builtins.str] = None,
                 replace_only: Optional[_builtins.bool] = None,
                 restricted_suggestions: Optional[_builtins.bool] = None,
                 value_required: Optional[_builtins.bool] = None,
                 values: Optional[Sequence[_builtins.str]] = None,
                 values_suggesteds: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str alias: An alias for the dashboard variable. This text will appear as the label for the dropdown field on the dashboard.
        :param _builtins.str property: A metric time series dimension or property name.
        :param _builtins.bool apply_if_exist: If true, this variable will also match data that doesn't have this property at all.
        :param _builtins.str description: Variable description.
        :param _builtins.bool replace_only: If `true`, this variable will only apply to charts that have a filter for the property.
        :param _builtins.bool restricted_suggestions: If `true`, this variable may only be set to the values listed in `values_suggested` and only these values will appear in autosuggestion menus. `false` by default.
        :param _builtins.bool value_required: Determines whether a value is required for this variable (and therefore whether it will be possible to view this dashboard without this filter applied). `false` by default.
        :param Sequence[_builtins.str] values: List of of strings (which will be treated as an OR filter on the property).
        :param Sequence[_builtins.str] values_suggesteds: A list of strings of suggested values for this variable; these suggestions will receive priority when values are autosuggested for this variable.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "property", property)
        if apply_if_exist is not None:
            pulumi.set(__self__, "apply_if_exist", apply_if_exist)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if replace_only is not None:
            pulumi.set(__self__, "replace_only", replace_only)
        if restricted_suggestions is not None:
            pulumi.set(__self__, "restricted_suggestions", restricted_suggestions)
        if value_required is not None:
            pulumi.set(__self__, "value_required", value_required)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if values_suggesteds is not None:
            pulumi.set(__self__, "values_suggesteds", values_suggesteds)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> _builtins.str:
        """
        An alias for the dashboard variable. This text will appear as the label for the dropdown field on the dashboard.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        A metric time series dimension or property name.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter(name="applyIfExist")
    def apply_if_exist(self) -> Optional[_builtins.bool]:
        """
        If true, this variable will also match data that doesn't have this property at all.
        """
        return pulumi.get(self, "apply_if_exist")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Variable description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="replaceOnly")
    def replace_only(self) -> Optional[_builtins.bool]:
        """
        If `true`, this variable will only apply to charts that have a filter for the property.
        """
        return pulumi.get(self, "replace_only")

    @_builtins.property
    @pulumi.getter(name="restrictedSuggestions")
    def restricted_suggestions(self) -> Optional[_builtins.bool]:
        """
        If `true`, this variable may only be set to the values listed in `values_suggested` and only these values will appear in autosuggestion menus. `false` by default.
        """
        return pulumi.get(self, "restricted_suggestions")

    @_builtins.property
    @pulumi.getter(name="valueRequired")
    def value_required(self) -> Optional[_builtins.bool]:
        """
        Determines whether a value is required for this variable (and therefore whether it will be possible to view this dashboard without this filter applied). `false` by default.
        """
        return pulumi.get(self, "value_required")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of of strings (which will be treated as an OR filter on the property).
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter(name="valuesSuggesteds")
    def values_suggesteds(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of strings of suggested values for this variable; these suggestions will receive priority when values are autosuggested for this variable.
        """
        return pulumi.get(self, "values_suggesteds")


@pulumi.output_type
class DataLinkTargetAppdUrl(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str name: User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        :param _builtins.str url: URL string for an AppDynamics instance.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL string for an AppDynamics instance.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DataLinkTargetExternalUrl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumTimeWindow":
            suggest = "minimum_time_window"
        elif key == "propertyKeyMapping":
            suggest = "property_key_mapping"
        elif key == "timeFormat":
            suggest = "time_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLinkTargetExternalUrl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLinkTargetExternalUrl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLinkTargetExternalUrl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str,
                 minimum_time_window: Optional[_builtins.str] = None,
                 property_key_mapping: Optional[Mapping[str, _builtins.str]] = None,
                 time_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        :param _builtins.str url: URL string for a Splunk instance or external system data link target. [See the supported template variables](https://dev.splunk.com/observability/docs/administration/datalinks/).
        :param _builtins.str minimum_time_window: The [minimum time window](https://dev.splunk.com/observability/docs/administration/datalinks/) for a search sent to an external site. Defaults to `6000`
        :param Mapping[str, _builtins.str] property_key_mapping: Describes the relationship between Splunk Observability Cloud metadata keys and external system properties when the key names are different.
        :param _builtins.str time_format: [Designates the format](https://dev.splunk.com/observability/docs/administration/datalinks/) of `minimum_time_window` in the same data link target object. Must be one of `"ISO8601"`, `"EpochSeconds"` or `"Epoch"` (which is milliseconds). Defaults to `"ISO8601"`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if minimum_time_window is not None:
            pulumi.set(__self__, "minimum_time_window", minimum_time_window)
        if property_key_mapping is not None:
            pulumi.set(__self__, "property_key_mapping", property_key_mapping)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL string for a Splunk instance or external system data link target. [See the supported template variables](https://dev.splunk.com/observability/docs/administration/datalinks/).
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="minimumTimeWindow")
    def minimum_time_window(self) -> Optional[_builtins.str]:
        """
        The [minimum time window](https://dev.splunk.com/observability/docs/administration/datalinks/) for a search sent to an external site. Defaults to `6000`
        """
        return pulumi.get(self, "minimum_time_window")

    @_builtins.property
    @pulumi.getter(name="propertyKeyMapping")
    def property_key_mapping(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Describes the relationship between Splunk Observability Cloud metadata keys and external system properties when the key names are different.
        """
        return pulumi.get(self, "property_key_mapping")

    @_builtins.property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[_builtins.str]:
        """
        [Designates the format](https://dev.splunk.com/observability/docs/administration/datalinks/) of `minimum_time_window` in the same data link target object. Must be one of `"ISO8601"`, `"EpochSeconds"` or `"Epoch"` (which is milliseconds). Defaults to `"ISO8601"`.
        """
        return pulumi.get(self, "time_format")


@pulumi.output_type
class DataLinkTargetSignalfxDashboard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dashboardGroupId":
            suggest = "dashboard_group_id"
        elif key == "dashboardId":
            suggest = "dashboard_id"
        elif key == "isDefault":
            suggest = "is_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLinkTargetSignalfxDashboard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLinkTargetSignalfxDashboard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLinkTargetSignalfxDashboard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dashboard_group_id: _builtins.str,
                 dashboard_id: _builtins.str,
                 name: _builtins.str,
                 is_default: Optional[_builtins.bool] = None):
        """
        :param _builtins.str dashboard_group_id: SignalFx-assigned ID of the dashboard link target's dashboard group
        :param _builtins.str dashboard_id: SignalFx-assigned ID of the dashboard link target
        :param _builtins.str name: User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        :param _builtins.bool is_default: Flag that designates a target as the default for a data link object. `true` by default
        """
        pulumi.set(__self__, "dashboard_group_id", dashboard_group_id)
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        pulumi.set(__self__, "name", name)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)

    @_builtins.property
    @pulumi.getter(name="dashboardGroupId")
    def dashboard_group_id(self) -> _builtins.str:
        """
        SignalFx-assigned ID of the dashboard link target's dashboard group
        """
        return pulumi.get(self, "dashboard_group_id")

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> _builtins.str:
        """
        SignalFx-assigned ID of the dashboard link target
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[_builtins.bool]:
        """
        Flag that designates a target as the default for a data link object. `true` by default
        """
        return pulumi.get(self, "is_default")


@pulumi.output_type
class DataLinkTargetSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyKeyMapping":
            suggest = "property_key_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLinkTargetSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLinkTargetSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLinkTargetSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 property_key_mapping: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str name: User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        :param Mapping[str, _builtins.str] property_key_mapping: Describes the relationship between Splunk Observability Cloud metadata keys and external system properties when the key names are different.
        """
        pulumi.set(__self__, "name", name)
        if property_key_mapping is not None:
            pulumi.set(__self__, "property_key_mapping", property_key_mapping)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        User-assigned target name. Use this value to differentiate between the link targets for a data link object.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="propertyKeyMapping")
    def property_key_mapping(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Describes the relationship between Splunk Observability Cloud metadata keys and external system properties when the key names are different.
        """
        return pulumi.get(self, "property_key_mapping")


@pulumi.output_type
class DetectorRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectLabel":
            suggest = "detect_label"
        elif key == "parameterizedBody":
            suggest = "parameterized_body"
        elif key == "parameterizedSubject":
            suggest = "parameterized_subject"
        elif key == "reminderNotification":
            suggest = "reminder_notification"
        elif key == "runbookUrl":
            suggest = "runbook_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detect_label: _builtins.str,
                 severity: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 notifications: Optional[Sequence[_builtins.str]] = None,
                 parameterized_body: Optional[_builtins.str] = None,
                 parameterized_subject: Optional[_builtins.str] = None,
                 reminder_notification: Optional['outputs.DetectorRuleReminderNotification'] = None,
                 runbook_url: Optional[_builtins.str] = None,
                 tip: Optional[_builtins.str] = None):
        """
        :param _builtins.str detect_label: A detect label which matches a detect label within `program_text`.
        :param _builtins.str severity: The severity of the rule, must be one of: `"Critical"`, `"Major"`, `"Minor"`, `"Warning"`, `"Info"`.
        :param _builtins.str description: Description for the rule. Displays as the alert condition in the Alert Rules tab of the detector editor in the web UI.
        :param _builtins.bool disabled: When true, notifications and events will not be generated for the detect label. `false` by default.
        :param Sequence[_builtins.str] notifications: List of strings specifying where notifications will be sent when an incident occurs. See [Create A Single Detector](https://dev.splunk.com/observability/reference/api/detectors/latest) for more info.
        :param _builtins.str parameterized_body: Custom notification message body when an alert is triggered. See [Set Up Detectors to Trigger Alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html) for more info.
        :param _builtins.str parameterized_subject: Custom notification message subject when an alert is triggered. See [Set Up Detectors to Trigger Alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html) for more info.
        :param 'DetectorRuleReminderNotificationArgs' reminder_notification: Reminder notification in a detector rule lets you send multiple notifications for active alerts over a defined period of time. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        :param _builtins.str runbook_url: URL of page to consult when an alert is triggered. This can be used with custom notification messages.
        :param _builtins.str tip: Plain text suggested first course of action, such as a command line to execute. This can be used with custom notification messages.
        """
        pulumi.set(__self__, "detect_label", detect_label)
        pulumi.set(__self__, "severity", severity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if parameterized_body is not None:
            pulumi.set(__self__, "parameterized_body", parameterized_body)
        if parameterized_subject is not None:
            pulumi.set(__self__, "parameterized_subject", parameterized_subject)
        if reminder_notification is not None:
            pulumi.set(__self__, "reminder_notification", reminder_notification)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if tip is not None:
            pulumi.set(__self__, "tip", tip)

    @_builtins.property
    @pulumi.getter(name="detectLabel")
    def detect_label(self) -> _builtins.str:
        """
        A detect label which matches a detect label within `program_text`.
        """
        return pulumi.get(self, "detect_label")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        The severity of the rule, must be one of: `"Critical"`, `"Major"`, `"Minor"`, `"Warning"`, `"Info"`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description for the rule. Displays as the alert condition in the Alert Rules tab of the detector editor in the web UI.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        When true, notifications and events will not be generated for the detect label. `false` by default.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of strings specifying where notifications will be sent when an incident occurs. See [Create A Single Detector](https://dev.splunk.com/observability/reference/api/detectors/latest) for more info.
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter(name="parameterizedBody")
    def parameterized_body(self) -> Optional[_builtins.str]:
        """
        Custom notification message body when an alert is triggered. See [Set Up Detectors to Trigger Alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html) for more info.
        """
        return pulumi.get(self, "parameterized_body")

    @_builtins.property
    @pulumi.getter(name="parameterizedSubject")
    def parameterized_subject(self) -> Optional[_builtins.str]:
        """
        Custom notification message subject when an alert is triggered. See [Set Up Detectors to Trigger Alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html) for more info.
        """
        return pulumi.get(self, "parameterized_subject")

    @_builtins.property
    @pulumi.getter(name="reminderNotification")
    def reminder_notification(self) -> Optional['outputs.DetectorRuleReminderNotification']:
        """
        Reminder notification in a detector rule lets you send multiple notifications for active alerts over a defined period of time. **Note:** This feature is not present in all accounts. Please contact support if you are unsure.
        """
        return pulumi.get(self, "reminder_notification")

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[_builtins.str]:
        """
        URL of page to consult when an alert is triggered. This can be used with custom notification messages.
        """
        return pulumi.get(self, "runbook_url")

    @_builtins.property
    @pulumi.getter
    def tip(self) -> Optional[_builtins.str]:
        """
        Plain text suggested first course of action, such as a command line to execute. This can be used with custom notification messages.
        """
        return pulumi.get(self, "tip")


@pulumi.output_type
class DetectorRuleReminderNotification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalMs":
            suggest = "interval_ms"
        elif key == "timeoutMs":
            suggest = "timeout_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorRuleReminderNotification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorRuleReminderNotification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorRuleReminderNotification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_ms: _builtins.int,
                 type: _builtins.str,
                 timeout_ms: Optional[_builtins.int] = None):
        """
        :param _builtins.int interval_ms: The interval at which you want to receive the notifications, in milliseconds.
        :param _builtins.str type: Type of reminder notification. Currently, the only supported value is TIMEOUT.
        :param _builtins.int timeout_ms: The duration during which repeat notifications are sent, in milliseconds.
        """
        pulumi.set(__self__, "interval_ms", interval_ms)
        pulumi.set(__self__, "type", type)
        if timeout_ms is not None:
            pulumi.set(__self__, "timeout_ms", timeout_ms)

    @_builtins.property
    @pulumi.getter(name="intervalMs")
    def interval_ms(self) -> _builtins.int:
        """
        The interval at which you want to receive the notifications, in milliseconds.
        """
        return pulumi.get(self, "interval_ms")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of reminder notification. Currently, the only supported value is TIMEOUT.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="timeoutMs")
    def timeout_ms(self) -> Optional[_builtins.int]:
        """
        The duration during which repeat notifications are sent, in milliseconds.
        """
        return pulumi.get(self, "timeout_ms")


@pulumi.output_type
class DetectorVizOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "valuePrefix":
            suggest = "value_prefix"
        elif key == "valueSuffix":
            suggest = "value_suffix"
        elif key == "valueUnit":
            suggest = "value_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorVizOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorVizOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorVizOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 color: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 value_prefix: Optional[_builtins.str] = None,
                 value_suffix: Optional[_builtins.str] = None,
                 value_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        :param _builtins.str color: Color to use : gray, blue, azure, navy, brown, orange, yellow, iris, magenta, pink, purple, violet, lilac, emerald, green, aquamarine.
        :param _builtins.str display_name: Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        :param _builtins.str value_prefix: , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
               
               **Notes**
               
               Use both `max_delay` in your detector configuration and an `extrapolation` policy in your program text to reduce false positives and false negatives.
        :param _builtins.str value_suffix: An arbitrary suffix to display with the value of this plot
        :param _builtins.str value_unit: A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        pulumi.set(__self__, "label", label)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if value_prefix is not None:
            pulumi.set(__self__, "value_prefix", value_prefix)
        if value_suffix is not None:
            pulumi.set(__self__, "value_suffix", value_suffix)
        if value_unit is not None:
            pulumi.set(__self__, "value_unit", value_unit)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def color(self) -> Optional[_builtins.str]:
        """
        Color to use : gray, blue, azure, navy, brown, orange, yellow, iris, magenta, pink, purple, violet, lilac, emerald, green, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="valuePrefix")
    def value_prefix(self) -> Optional[_builtins.str]:
        """
        , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.

        **Notes**

        Use both `max_delay` in your detector configuration and an `extrapolation` policy in your program text to reduce false positives and false negatives.
        """
        return pulumi.get(self, "value_prefix")

    @_builtins.property
    @pulumi.getter(name="valueSuffix")
    def value_suffix(self) -> Optional[_builtins.str]:
        """
        An arbitrary suffix to display with the value of this plot
        """
        return pulumi.get(self, "value_suffix")

    @_builtins.property
    @pulumi.getter(name="valueUnit")
    def value_unit(self) -> Optional[_builtins.str]:
        """
        A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        return pulumi.get(self, "value_unit")


@pulumi.output_type
class HeatmapChartColorRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeatmapChartColorRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeatmapChartColorRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeatmapChartColorRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 color: _builtins.str,
                 max_value: Optional[_builtins.float] = None,
                 min_value: Optional[_builtins.float] = None):
        """
        :param _builtins.str color: The color range to use. The starting hex color value for data values in a heatmap chart. Specify the value as a 6-character hexadecimal value preceded by the '#' character, for example "#ea1849" (grass green).
        :param _builtins.float max_value: The maximum value within the coloring range.
        :param _builtins.float min_value: The minimum value within the coloring range.
        """
        pulumi.set(__self__, "color", color)
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)

    @_builtins.property
    @pulumi.getter
    def color(self) -> _builtins.str:
        """
        The color range to use. The starting hex color value for data values in a heatmap chart. Specify the value as a 6-character hexadecimal value preceded by the '#' character, for example "#ea1849" (grass green).
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[_builtins.float]:
        """
        The maximum value within the coloring range.
        """
        return pulumi.get(self, "max_value")

    @_builtins.property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[_builtins.float]:
        """
        The minimum value within the coloring range.
        """
        return pulumi.get(self, "min_value")


@pulumi.output_type
class HeatmapChartColorScale(dict):
    def __init__(__self__, *,
                 color: _builtins.str,
                 gt: Optional[_builtins.float] = None,
                 gte: Optional[_builtins.float] = None,
                 lt: Optional[_builtins.float] = None,
                 lte: Optional[_builtins.float] = None):
        """
        :param _builtins.str color: The color range to use. Hex values are not supported here. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        :param _builtins.float gt: Indicates the lower threshold non-inclusive value for this range.
        :param _builtins.float gte: Indicates the lower threshold inclusive value for this range.
        :param _builtins.float lt: Indicates the upper threshold non-inclusive value for this range.
        :param _builtins.float lte: Indicates the upper threshold inclusive value for this range.
        """
        pulumi.set(__self__, "color", color)
        if gt is not None:
            pulumi.set(__self__, "gt", gt)
        if gte is not None:
            pulumi.set(__self__, "gte", gte)
        if lt is not None:
            pulumi.set(__self__, "lt", lt)
        if lte is not None:
            pulumi.set(__self__, "lte", lte)

    @_builtins.property
    @pulumi.getter
    def color(self) -> _builtins.str:
        """
        The color range to use. Hex values are not supported here. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter
    def gt(self) -> Optional[_builtins.float]:
        """
        Indicates the lower threshold non-inclusive value for this range.
        """
        return pulumi.get(self, "gt")

    @_builtins.property
    @pulumi.getter
    def gte(self) -> Optional[_builtins.float]:
        """
        Indicates the lower threshold inclusive value for this range.
        """
        return pulumi.get(self, "gte")

    @_builtins.property
    @pulumi.getter
    def lt(self) -> Optional[_builtins.float]:
        """
        Indicates the upper threshold non-inclusive value for this range.
        """
        return pulumi.get(self, "lt")

    @_builtins.property
    @pulumi.getter
    def lte(self) -> Optional[_builtins.float]:
        """
        Indicates the upper threshold inclusive value for this range.
        """
        return pulumi.get(self, "lte")


@pulumi.output_type
class ListChartColorScale(dict):
    def __init__(__self__, *,
                 color: _builtins.str,
                 gt: Optional[_builtins.float] = None,
                 gte: Optional[_builtins.float] = None,
                 lt: Optional[_builtins.float] = None,
                 lte: Optional[_builtins.float] = None):
        """
        :param _builtins.str color: The color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        :param _builtins.float gt: Indicates the lower threshold non-inclusive value for this range.
        :param _builtins.float gte: Indicates the lower threshold inclusive value for this range.
        :param _builtins.float lt: Indicates the upper threshold non-inculsive value for this range.
        :param _builtins.float lte: Indicates the upper threshold inclusive value for this range.
        """
        pulumi.set(__self__, "color", color)
        if gt is not None:
            pulumi.set(__self__, "gt", gt)
        if gte is not None:
            pulumi.set(__self__, "gte", gte)
        if lt is not None:
            pulumi.set(__self__, "lt", lt)
        if lte is not None:
            pulumi.set(__self__, "lte", lte)

    @_builtins.property
    @pulumi.getter
    def color(self) -> _builtins.str:
        """
        The color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter
    def gt(self) -> Optional[_builtins.float]:
        """
        Indicates the lower threshold non-inclusive value for this range.
        """
        return pulumi.get(self, "gt")

    @_builtins.property
    @pulumi.getter
    def gte(self) -> Optional[_builtins.float]:
        """
        Indicates the lower threshold inclusive value for this range.
        """
        return pulumi.get(self, "gte")

    @_builtins.property
    @pulumi.getter
    def lt(self) -> Optional[_builtins.float]:
        """
        Indicates the upper threshold non-inculsive value for this range.
        """
        return pulumi.get(self, "lt")

    @_builtins.property
    @pulumi.getter
    def lte(self) -> Optional[_builtins.float]:
        """
        Indicates the upper threshold inclusive value for this range.
        """
        return pulumi.get(self, "lte")


@pulumi.output_type
class ListChartLegendOptionsField(dict):
    def __init__(__self__, *,
                 property: _builtins.str,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: The name of the property to display. Note the special values of `sf_metric` (corresponding with the API's `Plot Name`) which shows the label of the time series `publish()` and `sf_originatingMetric` (corresponding with the API's `metric (sf metric)`) that shows the [name of the metric](https://dev.splunk.com/observability/docs/signalflow/functions/data_function/) for the time series being displayed.
        :param _builtins.bool enabled: True or False depending on if you want the property to be shown or hidden.
        """
        pulumi.set(__self__, "property", property)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        The name of the property to display. Note the special values of `sf_metric` (corresponding with the API's `Plot Name`) which shows the label of the time series `publish()` and `sf_originatingMetric` (corresponding with the API's `metric (sf metric)`) that shows the [name of the metric](https://dev.splunk.com/observability/docs/signalflow/functions/data_function/) for the time series being displayed.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        True or False depending on if you want the property to be shown or hidden.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ListChartVizOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "valuePrefix":
            suggest = "value_prefix"
        elif key == "valueSuffix":
            suggest = "value_suffix"
        elif key == "valueUnit":
            suggest = "value_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListChartVizOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListChartVizOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListChartVizOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 color: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 value_prefix: Optional[_builtins.str] = None,
                 value_suffix: Optional[_builtins.str] = None,
                 value_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        :param _builtins.str color: The color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        :param _builtins.str display_name: Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        :param _builtins.str value_prefix: , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
        :param _builtins.str value_suffix: An arbitrary suffix to display with the value of this plot
        :param _builtins.str value_unit: A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        pulumi.set(__self__, "label", label)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if value_prefix is not None:
            pulumi.set(__self__, "value_prefix", value_prefix)
        if value_suffix is not None:
            pulumi.set(__self__, "value_suffix", value_suffix)
        if value_unit is not None:
            pulumi.set(__self__, "value_unit", value_unit)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def color(self) -> Optional[_builtins.str]:
        """
        The color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="valuePrefix")
    def value_prefix(self) -> Optional[_builtins.str]:
        """
        , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
        """
        return pulumi.get(self, "value_prefix")

    @_builtins.property
    @pulumi.getter(name="valueSuffix")
    def value_suffix(self) -> Optional[_builtins.str]:
        """
        An arbitrary suffix to display with the value of this plot
        """
        return pulumi.get(self, "value_suffix")

    @_builtins.property
    @pulumi.getter(name="valueUnit")
    def value_unit(self) -> Optional[_builtins.str]:
        """
        A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        return pulumi.get(self, "value_unit")


@pulumi.output_type
class MetricRulesetAggregationRule(dict):
    def __init__(__self__, *,
                 aggregators: Sequence['outputs.MetricRulesetAggregationRuleAggregator'],
                 enabled: _builtins.bool,
                 matchers: Sequence['outputs.MetricRulesetAggregationRuleMatcher'],
                 description: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param Sequence['MetricRulesetAggregationRuleAggregatorArgs'] aggregators: Aggregator object
        :param _builtins.bool enabled: When false, this rule will not generate aggregated MTSs
        :param Sequence['MetricRulesetAggregationRuleMatcherArgs'] matchers: Matcher object
        :param _builtins.str description: Information about an aggregation rule
        :param _builtins.str name: name of the aggregation rule
        """
        pulumi.set(__self__, "aggregators", aggregators)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "matchers", matchers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def aggregators(self) -> Sequence['outputs.MetricRulesetAggregationRuleAggregator']:
        """
        Aggregator object
        """
        return pulumi.get(self, "aggregators")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        When false, this rule will not generate aggregated MTSs
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def matchers(self) -> Sequence['outputs.MetricRulesetAggregationRuleMatcher']:
        """
        Matcher object
        """
        return pulumi.get(self, "matchers")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Information about an aggregation rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name of the aggregation rule
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MetricRulesetAggregationRuleAggregator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropDimensions":
            suggest = "drop_dimensions"
        elif key == "outputName":
            suggest = "output_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricRulesetAggregationRuleAggregator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricRulesetAggregationRuleAggregator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricRulesetAggregationRuleAggregator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Sequence[_builtins.str],
                 drop_dimensions: _builtins.bool,
                 output_name: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] dimensions: List of dimensions to either be kept or dropped in the new aggregated MTSs
        :param _builtins.bool drop_dimensions: when true, the specified dimensions will be dropped from the aggregated MTSs
        :param _builtins.str output_name: name of the new aggregated metric
        :param _builtins.str type: Type of aggregator. Must always be "rollup"
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "drop_dimensions", drop_dimensions)
        pulumi.set(__self__, "output_name", output_name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence[_builtins.str]:
        """
        List of dimensions to either be kept or dropped in the new aggregated MTSs
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="dropDimensions")
    def drop_dimensions(self) -> _builtins.bool:
        """
        when true, the specified dimensions will be dropped from the aggregated MTSs
        """
        return pulumi.get(self, "drop_dimensions")

    @_builtins.property
    @pulumi.getter(name="outputName")
    def output_name(self) -> _builtins.str:
        """
        name of the new aggregated metric
        """
        return pulumi.get(self, "output_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of aggregator. Must always be "rollup"
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MetricRulesetAggregationRuleMatcher(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 filters: Optional[Sequence['outputs.MetricRulesetAggregationRuleMatcherFilter']] = None):
        """
        :param _builtins.str type: Type of matcher. Must always be "dimension"
        :param Sequence['MetricRulesetAggregationRuleMatcherFilterArgs'] filters: List of filters to filter the set of input MTSs
        """
        pulumi.set(__self__, "type", type)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of matcher. Must always be "dimension"
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.MetricRulesetAggregationRuleMatcherFilter']]:
        """
        List of filters to filter the set of input MTSs
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class MetricRulesetAggregationRuleMatcherFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "not":
            suggest = "not_"
        elif key == "propertyValues":
            suggest = "property_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricRulesetAggregationRuleMatcherFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricRulesetAggregationRuleMatcherFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricRulesetAggregationRuleMatcherFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 not_: _builtins.bool,
                 property: _builtins.str,
                 property_values: Sequence[_builtins.str]):
        """
        :param _builtins.bool not_: When true, this filter will match all values not matching the property_values
        :param _builtins.str property: Name of the dimension
        :param Sequence[_builtins.str] property_values: Value of the dimension
        """
        pulumi.set(__self__, "not_", not_)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "property_values", property_values)

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> _builtins.bool:
        """
        When true, this filter will match all values not matching the property_values
        """
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        Name of the dimension
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Sequence[_builtins.str]:
        """
        Value of the dimension
        """
        return pulumi.get(self, "property_values")


@pulumi.output_type
class MetricRulesetExceptionRule(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 matchers: Sequence['outputs.MetricRulesetExceptionRuleMatcher'],
                 description: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 restorations: Optional[Sequence['outputs.MetricRulesetExceptionRuleRestoration']] = None):
        """
        :param _builtins.bool enabled: When false, this rule will not route matched data to real-time
        :param Sequence['MetricRulesetExceptionRuleMatcherArgs'] matchers: Matcher object
        :param _builtins.str description: Information about an exception rule
        :param _builtins.str name: name of the exception rule
        :param Sequence['MetricRulesetExceptionRuleRestorationArgs'] restorations: Properties of a restoration job
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "matchers", matchers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restorations is not None:
            pulumi.set(__self__, "restorations", restorations)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        When false, this rule will not route matched data to real-time
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def matchers(self) -> Sequence['outputs.MetricRulesetExceptionRuleMatcher']:
        """
        Matcher object
        """
        return pulumi.get(self, "matchers")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Information about an exception rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name of the exception rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def restorations(self) -> Optional[Sequence['outputs.MetricRulesetExceptionRuleRestoration']]:
        """
        Properties of a restoration job
        """
        return pulumi.get(self, "restorations")


@pulumi.output_type
class MetricRulesetExceptionRuleMatcher(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 filters: Optional[Sequence['outputs.MetricRulesetExceptionRuleMatcherFilter']] = None):
        """
        :param _builtins.str type: Type of matcher. Must always be "dimension"
        :param Sequence['MetricRulesetExceptionRuleMatcherFilterArgs'] filters: List of filters to filter the set of input MTSs
        """
        pulumi.set(__self__, "type", type)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of matcher. Must always be "dimension"
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.MetricRulesetExceptionRuleMatcherFilter']]:
        """
        List of filters to filter the set of input MTSs
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class MetricRulesetExceptionRuleMatcherFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "not":
            suggest = "not_"
        elif key == "propertyValues":
            suggest = "property_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricRulesetExceptionRuleMatcherFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricRulesetExceptionRuleMatcherFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricRulesetExceptionRuleMatcherFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 not_: _builtins.bool,
                 property: _builtins.str,
                 property_values: Sequence[_builtins.str]):
        """
        :param _builtins.bool not_: When true, this filter will match all values not matching the property_values
        :param _builtins.str property: Name of the dimension
        :param Sequence[_builtins.str] property_values: Value of the dimension
        """
        pulumi.set(__self__, "not_", not_)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "property_values", property_values)

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> _builtins.bool:
        """
        When true, this filter will match all values not matching the property_values
        """
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        Name of the dimension
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Sequence[_builtins.str]:
        """
        Value of the dimension
        """
        return pulumi.get(self, "property_values")


@pulumi.output_type
class MetricRulesetExceptionRuleRestoration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "restorationId":
            suggest = "restoration_id"
        elif key == "stopTime":
            suggest = "stop_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricRulesetExceptionRuleRestoration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricRulesetExceptionRuleRestoration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricRulesetExceptionRuleRestoration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: _builtins.str,
                 restoration_id: Optional[_builtins.str] = None,
                 stop_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str start_time: Time from which the restoration job will restore archived data, in the form of *nix time in milliseconds
        :param _builtins.str restoration_id: ID of the restoration job.
        :param _builtins.str stop_time: Time to which the restoration job will restore archived data, in the form of *nix time in milliseconds
        """
        pulumi.set(__self__, "start_time", start_time)
        if restoration_id is not None:
            pulumi.set(__self__, "restoration_id", restoration_id)
        if stop_time is not None:
            pulumi.set(__self__, "stop_time", stop_time)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Time from which the restoration job will restore archived data, in the form of *nix time in milliseconds
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="restorationId")
    def restoration_id(self) -> Optional[_builtins.str]:
        """
        ID of the restoration job.
        """
        return pulumi.get(self, "restoration_id")

    @_builtins.property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> Optional[_builtins.str]:
        """
        Time to which the restoration job will restore archived data, in the form of *nix time in milliseconds
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class MetricRulesetRoutingRule(dict):
    def __init__(__self__, *,
                 destination: _builtins.str):
        """
        :param _builtins.str destination: end destination of the input metric. Must be `RealTime`, `Archived`, or `Drop`
        """
        pulumi.set(__self__, "destination", destination)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        end destination of the input metric. Must be `RealTime`, `Archived`, or `Drop`
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class OrgTokenDpmLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dpmLimit":
            suggest = "dpm_limit"
        elif key == "dpmNotificationThreshold":
            suggest = "dpm_notification_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgTokenDpmLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgTokenDpmLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgTokenDpmLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dpm_limit: _builtins.int,
                 dpm_notification_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int dpm_limit: The datapoints per minute (dpm) limit for this token. If you exceed this limit, Splunk Observability Cloud sends out an alert.
        :param _builtins.int dpm_notification_threshold: DPM level at which Splunk Observability Cloud sends the notification for this token. If you don't specify a notification, Splunk Observability Cloud sends the generic notification.
        """
        pulumi.set(__self__, "dpm_limit", dpm_limit)
        if dpm_notification_threshold is not None:
            pulumi.set(__self__, "dpm_notification_threshold", dpm_notification_threshold)

    @_builtins.property
    @pulumi.getter(name="dpmLimit")
    def dpm_limit(self) -> _builtins.int:
        """
        The datapoints per minute (dpm) limit for this token. If you exceed this limit, Splunk Observability Cloud sends out an alert.
        """
        return pulumi.get(self, "dpm_limit")

    @_builtins.property
    @pulumi.getter(name="dpmNotificationThreshold")
    def dpm_notification_threshold(self) -> Optional[_builtins.int]:
        """
        DPM level at which Splunk Observability Cloud sends the notification for this token. If you don't specify a notification, Splunk Observability Cloud sends the generic notification.
        """
        return pulumi.get(self, "dpm_notification_threshold")


@pulumi.output_type
class OrgTokenHostOrUsageLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerLimit":
            suggest = "container_limit"
        elif key == "containerNotificationThreshold":
            suggest = "container_notification_threshold"
        elif key == "customMetricsLimit":
            suggest = "custom_metrics_limit"
        elif key == "customMetricsNotificationThreshold":
            suggest = "custom_metrics_notification_threshold"
        elif key == "highResMetricsLimit":
            suggest = "high_res_metrics_limit"
        elif key == "highResMetricsNotificationThreshold":
            suggest = "high_res_metrics_notification_threshold"
        elif key == "hostLimit":
            suggest = "host_limit"
        elif key == "hostNotificationThreshold":
            suggest = "host_notification_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgTokenHostOrUsageLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgTokenHostOrUsageLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgTokenHostOrUsageLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_limit: Optional[_builtins.int] = None,
                 container_notification_threshold: Optional[_builtins.int] = None,
                 custom_metrics_limit: Optional[_builtins.int] = None,
                 custom_metrics_notification_threshold: Optional[_builtins.int] = None,
                 high_res_metrics_limit: Optional[_builtins.int] = None,
                 high_res_metrics_notification_threshold: Optional[_builtins.int] = None,
                 host_limit: Optional[_builtins.int] = None,
                 host_notification_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int container_limit: Max number of Docker containers that can use this token
        :param _builtins.int container_notification_threshold: Notification threshold for Docker containers
        :param _builtins.int custom_metrics_limit: Max number of custom metrics that can be sent with this token
        :param _builtins.int custom_metrics_notification_threshold: Notification threshold for custom metrics
        :param _builtins.int high_res_metrics_limit: Max number of hi-res metrics that can be sent with this toke
        :param _builtins.int high_res_metrics_notification_threshold: Notification threshold for hi-res metrics
        :param _builtins.int host_limit: Max number of hosts that can use this token
        :param _builtins.int host_notification_threshold: Notification threshold for hosts
        """
        if container_limit is not None:
            pulumi.set(__self__, "container_limit", container_limit)
        if container_notification_threshold is not None:
            pulumi.set(__self__, "container_notification_threshold", container_notification_threshold)
        if custom_metrics_limit is not None:
            pulumi.set(__self__, "custom_metrics_limit", custom_metrics_limit)
        if custom_metrics_notification_threshold is not None:
            pulumi.set(__self__, "custom_metrics_notification_threshold", custom_metrics_notification_threshold)
        if high_res_metrics_limit is not None:
            pulumi.set(__self__, "high_res_metrics_limit", high_res_metrics_limit)
        if high_res_metrics_notification_threshold is not None:
            pulumi.set(__self__, "high_res_metrics_notification_threshold", high_res_metrics_notification_threshold)
        if host_limit is not None:
            pulumi.set(__self__, "host_limit", host_limit)
        if host_notification_threshold is not None:
            pulumi.set(__self__, "host_notification_threshold", host_notification_threshold)

    @_builtins.property
    @pulumi.getter(name="containerLimit")
    def container_limit(self) -> Optional[_builtins.int]:
        """
        Max number of Docker containers that can use this token
        """
        return pulumi.get(self, "container_limit")

    @_builtins.property
    @pulumi.getter(name="containerNotificationThreshold")
    def container_notification_threshold(self) -> Optional[_builtins.int]:
        """
        Notification threshold for Docker containers
        """
        return pulumi.get(self, "container_notification_threshold")

    @_builtins.property
    @pulumi.getter(name="customMetricsLimit")
    def custom_metrics_limit(self) -> Optional[_builtins.int]:
        """
        Max number of custom metrics that can be sent with this token
        """
        return pulumi.get(self, "custom_metrics_limit")

    @_builtins.property
    @pulumi.getter(name="customMetricsNotificationThreshold")
    def custom_metrics_notification_threshold(self) -> Optional[_builtins.int]:
        """
        Notification threshold for custom metrics
        """
        return pulumi.get(self, "custom_metrics_notification_threshold")

    @_builtins.property
    @pulumi.getter(name="highResMetricsLimit")
    def high_res_metrics_limit(self) -> Optional[_builtins.int]:
        """
        Max number of hi-res metrics that can be sent with this toke
        """
        return pulumi.get(self, "high_res_metrics_limit")

    @_builtins.property
    @pulumi.getter(name="highResMetricsNotificationThreshold")
    def high_res_metrics_notification_threshold(self) -> Optional[_builtins.int]:
        """
        Notification threshold for hi-res metrics
        """
        return pulumi.get(self, "high_res_metrics_notification_threshold")

    @_builtins.property
    @pulumi.getter(name="hostLimit")
    def host_limit(self) -> Optional[_builtins.int]:
        """
        Max number of hosts that can use this token
        """
        return pulumi.get(self, "host_limit")

    @_builtins.property
    @pulumi.getter(name="hostNotificationThreshold")
    def host_notification_threshold(self) -> Optional[_builtins.int]:
        """
        Notification threshold for hosts
        """
        return pulumi.get(self, "host_notification_threshold")


@pulumi.output_type
class SingleValueChartColorScale(dict):
    def __init__(__self__, *,
                 color: _builtins.str,
                 gt: Optional[_builtins.float] = None,
                 gte: Optional[_builtins.float] = None,
                 lt: Optional[_builtins.float] = None,
                 lte: Optional[_builtins.float] = None):
        """
        :param _builtins.str color: The color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        :param _builtins.float gt: Indicates the lower threshold non-inclusive value for this range.
        :param _builtins.float gte: Indicates the lower threshold inclusive value for this range.
        :param _builtins.float lt: Indicates the upper threshold non-inculsive value for this range.
        :param _builtins.float lte: Indicates the upper threshold inclusive value for this range.
        """
        pulumi.set(__self__, "color", color)
        if gt is not None:
            pulumi.set(__self__, "gt", gt)
        if gte is not None:
            pulumi.set(__self__, "gte", gte)
        if lt is not None:
            pulumi.set(__self__, "lt", lt)
        if lte is not None:
            pulumi.set(__self__, "lte", lte)

    @_builtins.property
    @pulumi.getter
    def color(self) -> _builtins.str:
        """
        The color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter
    def gt(self) -> Optional[_builtins.float]:
        """
        Indicates the lower threshold non-inclusive value for this range.
        """
        return pulumi.get(self, "gt")

    @_builtins.property
    @pulumi.getter
    def gte(self) -> Optional[_builtins.float]:
        """
        Indicates the lower threshold inclusive value for this range.
        """
        return pulumi.get(self, "gte")

    @_builtins.property
    @pulumi.getter
    def lt(self) -> Optional[_builtins.float]:
        """
        Indicates the upper threshold non-inculsive value for this range.
        """
        return pulumi.get(self, "lt")

    @_builtins.property
    @pulumi.getter
    def lte(self) -> Optional[_builtins.float]:
        """
        Indicates the upper threshold inclusive value for this range.
        """
        return pulumi.get(self, "lte")


@pulumi.output_type
class SingleValueChartVizOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "valuePrefix":
            suggest = "value_prefix"
        elif key == "valueSuffix":
            suggest = "value_suffix"
        elif key == "valueUnit":
            suggest = "value_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SingleValueChartVizOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SingleValueChartVizOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SingleValueChartVizOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 color: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 value_prefix: Optional[_builtins.str] = None,
                 value_suffix: Optional[_builtins.str] = None,
                 value_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        :param _builtins.str color: The color to use. Must be one of gray, blue, light_blue, navy, dark_orange, orange, dark_yellow, magenta, cerise, pink, violet, purple, gray_blue, dark_green, green, aquamarine, red, yellow, vivid_yellow, light_green, or lime_green.
        :param _builtins.str display_name: Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        :param _builtins.str value_prefix: , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
        :param _builtins.str value_suffix: An arbitrary suffix to display with the value of this plot
        :param _builtins.str value_unit: A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        pulumi.set(__self__, "label", label)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if value_prefix is not None:
            pulumi.set(__self__, "value_prefix", value_prefix)
        if value_suffix is not None:
            pulumi.set(__self__, "value_suffix", value_suffix)
        if value_unit is not None:
            pulumi.set(__self__, "value_unit", value_unit)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def color(self) -> Optional[_builtins.str]:
        """
        The color to use. Must be one of gray, blue, light_blue, navy, dark_orange, orange, dark_yellow, magenta, cerise, pink, violet, purple, gray_blue, dark_green, green, aquamarine, red, yellow, vivid_yellow, light_green, or lime_green.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="valuePrefix")
    def value_prefix(self) -> Optional[_builtins.str]:
        """
        , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
        """
        return pulumi.get(self, "value_prefix")

    @_builtins.property
    @pulumi.getter(name="valueSuffix")
    def value_suffix(self) -> Optional[_builtins.str]:
        """
        An arbitrary suffix to display with the value of this plot
        """
        return pulumi.get(self, "value_suffix")

    @_builtins.property
    @pulumi.getter(name="valueUnit")
    def value_unit(self) -> Optional[_builtins.str]:
        """
        A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        return pulumi.get(self, "value_unit")


@pulumi.output_type
class SloInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "programText":
            suggest = "program_text"
        elif key == "goodEventsLabel":
            suggest = "good_events_label"
        elif key == "totalEventsLabel":
            suggest = "total_events_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 program_text: _builtins.str,
                 good_events_label: Optional[_builtins.str] = None,
                 total_events_label: Optional[_builtins.str] = None):
        """
        :param _builtins.str program_text: SignalFlow program and arguments text strings that define the streams used as successful event count and total event count
        :param _builtins.str good_events_label: Label used in `"program_text"` that refers to the data block which contains the stream of successful events
        :param _builtins.str total_events_label: Label used in `"program_text"` that refers to the data block which contains the stream of total events
        """
        pulumi.set(__self__, "program_text", program_text)
        if good_events_label is not None:
            pulumi.set(__self__, "good_events_label", good_events_label)
        if total_events_label is not None:
            pulumi.set(__self__, "total_events_label", total_events_label)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> _builtins.str:
        """
        SignalFlow program and arguments text strings that define the streams used as successful event count and total event count
        """
        return pulumi.get(self, "program_text")

    @_builtins.property
    @pulumi.getter(name="goodEventsLabel")
    def good_events_label(self) -> Optional[_builtins.str]:
        """
        Label used in `"program_text"` that refers to the data block which contains the stream of successful events
        """
        return pulumi.get(self, "good_events_label")

    @_builtins.property
    @pulumi.getter(name="totalEventsLabel")
    def total_events_label(self) -> Optional[_builtins.str]:
        """
        Label used in `"program_text"` that refers to the data block which contains the stream of total events
        """
        return pulumi.get(self, "total_events_label")


@pulumi.output_type
class SloTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertRules":
            suggest = "alert_rules"
        elif key == "compliancePeriod":
            suggest = "compliance_period"
        elif key == "cycleStart":
            suggest = "cycle_start"
        elif key == "cycleType":
            suggest = "cycle_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_rules: Sequence['outputs.SloTargetAlertRule'],
                 slo: _builtins.float,
                 type: _builtins.str,
                 compliance_period: Optional[_builtins.str] = None,
                 cycle_start: Optional[_builtins.str] = None,
                 cycle_type: Optional[_builtins.str] = None):
        """
        :param Sequence['SloTargetAlertRuleArgs'] alert_rules: List of alert rules you want to set for this SLO target. An SLO alert rule of type BREACH is always required.
        :param _builtins.float slo: Target value in the form of a percentage
        :param _builtins.str type: SLO target type can be the following type: `"RollingWindow"`, `"CalendarWindow"`
        :param _builtins.str compliance_period: Compliance period of this SLO. This value must be within the range of 1d (1 days) to 30d (30 days), inclusive.
        :param _builtins.str cycle_start: It can be used to change the cycle start time. For example, you can specify sunday as the start of the week (instead of the default monday)
        :param _builtins.str cycle_type: The cycle type of the calendar window, e.g. week, month.
        """
        pulumi.set(__self__, "alert_rules", alert_rules)
        pulumi.set(__self__, "slo", slo)
        pulumi.set(__self__, "type", type)
        if compliance_period is not None:
            pulumi.set(__self__, "compliance_period", compliance_period)
        if cycle_start is not None:
            pulumi.set(__self__, "cycle_start", cycle_start)
        if cycle_type is not None:
            pulumi.set(__self__, "cycle_type", cycle_type)

    @_builtins.property
    @pulumi.getter(name="alertRules")
    def alert_rules(self) -> Sequence['outputs.SloTargetAlertRule']:
        """
        List of alert rules you want to set for this SLO target. An SLO alert rule of type BREACH is always required.
        """
        return pulumi.get(self, "alert_rules")

    @_builtins.property
    @pulumi.getter
    def slo(self) -> _builtins.float:
        """
        Target value in the form of a percentage
        """
        return pulumi.get(self, "slo")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        SLO target type can be the following type: `"RollingWindow"`, `"CalendarWindow"`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="compliancePeriod")
    def compliance_period(self) -> Optional[_builtins.str]:
        """
        Compliance period of this SLO. This value must be within the range of 1d (1 days) to 30d (30 days), inclusive.
        """
        return pulumi.get(self, "compliance_period")

    @_builtins.property
    @pulumi.getter(name="cycleStart")
    def cycle_start(self) -> Optional[_builtins.str]:
        """
        It can be used to change the cycle start time. For example, you can specify sunday as the start of the week (instead of the default monday)
        """
        return pulumi.get(self, "cycle_start")

    @_builtins.property
    @pulumi.getter(name="cycleType")
    def cycle_type(self) -> Optional[_builtins.str]:
        """
        The cycle type of the calendar window, e.g. week, month.
        """
        return pulumi.get(self, "cycle_type")


@pulumi.output_type
class SloTargetAlertRule(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.SloTargetAlertRuleRule'],
                 type: _builtins.str):
        """
        :param Sequence['SloTargetAlertRuleRuleArgs'] rules: Set of rules used for alerting.
        :param _builtins.str type: SLO alert rule can be one of the following types: BREACH, ERROR_BUDGET_LEFT, BURN_RATE. Within an SLO object, you can only specify one SLO alert_rule per type. For example, you can't specify two alert_rule of type BREACH. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.SloTargetAlertRuleRule']:
        """
        Set of rules used for alerting.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        SLO alert rule can be one of the following types: BREACH, ERROR_BUDGET_LEFT, BURN_RATE. Within an SLO object, you can only specify one SLO alert_rule per type. For example, you can't specify two alert_rule of type BREACH. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SloTargetAlertRuleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterizedBody":
            suggest = "parameterized_body"
        elif key == "parameterizedSubject":
            suggest = "parameterized_subject"
        elif key == "reminderNotification":
            suggest = "reminder_notification"
        elif key == "runbookUrl":
            suggest = "runbook_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloTargetAlertRuleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloTargetAlertRuleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloTargetAlertRuleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 severity: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 notifications: Optional[Sequence[_builtins.str]] = None,
                 parameterized_body: Optional[_builtins.str] = None,
                 parameterized_subject: Optional[_builtins.str] = None,
                 parameters: Optional['outputs.SloTargetAlertRuleRuleParameters'] = None,
                 reminder_notification: Optional['outputs.SloTargetAlertRuleRuleReminderNotification'] = None,
                 runbook_url: Optional[_builtins.str] = None,
                 tip: Optional[_builtins.str] = None):
        """
        :param _builtins.str severity: The severity of the rule, must be one of: `"Critical"`, `"Major"`, `"Minor"`, `"Warning"`, `"Info"`.
        :param _builtins.str description: Description for the rule. Displays as the alert condition in the Alert Rules tab of the detector editor in the web UI.
        :param _builtins.bool disabled: When true, notifications and events will not be generated for the detect label. `false` by default.
        :param Sequence[_builtins.str] notifications: List of strings specifying where notifications will be sent when an incident occurs. See [Create SLO](https://dev.splunk.com/observability/reference/api/slo/latest#endpoint-create-new-slo) for more info.
        :param _builtins.str parameterized_body: Custom notification message body when an alert is triggered. See [Alert message](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html#alert-messages) for more info.
        :param _builtins.str parameterized_subject: Custom notification message subject when an alert is triggered. See [Alert message](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html#alert-messages) for more info.
        :param 'SloTargetAlertRuleRuleParametersArgs' parameters: Parameters for the SLO alert rule. Each SLO alert rule type accepts different parameters. If not specified, default parameters are used.
        :param 'SloTargetAlertRuleRuleReminderNotificationArgs' reminder_notification: Reminder notification in a detector rule lets you send multiple notifications for active alerts over a defined period of time.
        :param _builtins.str runbook_url: URL of page to consult when an alert is triggered. This can be used with custom notification messages.
        :param _builtins.str tip: Plain text suggested first course of action, such as a command line to execute. This can be used with custom notification messages.
        """
        pulumi.set(__self__, "severity", severity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if parameterized_body is not None:
            pulumi.set(__self__, "parameterized_body", parameterized_body)
        if parameterized_subject is not None:
            pulumi.set(__self__, "parameterized_subject", parameterized_subject)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if reminder_notification is not None:
            pulumi.set(__self__, "reminder_notification", reminder_notification)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if tip is not None:
            pulumi.set(__self__, "tip", tip)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        The severity of the rule, must be one of: `"Critical"`, `"Major"`, `"Minor"`, `"Warning"`, `"Info"`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description for the rule. Displays as the alert condition in the Alert Rules tab of the detector editor in the web UI.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        When true, notifications and events will not be generated for the detect label. `false` by default.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of strings specifying where notifications will be sent when an incident occurs. See [Create SLO](https://dev.splunk.com/observability/reference/api/slo/latest#endpoint-create-new-slo) for more info.
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter(name="parameterizedBody")
    def parameterized_body(self) -> Optional[_builtins.str]:
        """
        Custom notification message body when an alert is triggered. See [Alert message](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html#alert-messages) for more info.
        """
        return pulumi.get(self, "parameterized_body")

    @_builtins.property
    @pulumi.getter(name="parameterizedSubject")
    def parameterized_subject(self) -> Optional[_builtins.str]:
        """
        Custom notification message subject when an alert is triggered. See [Alert message](https://docs.splunk.com/observability/en/alerts-detectors-notifications/create-detectors-for-alerts.html#alert-messages) for more info.
        """
        return pulumi.get(self, "parameterized_subject")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.SloTargetAlertRuleRuleParameters']:
        """
        Parameters for the SLO alert rule. Each SLO alert rule type accepts different parameters. If not specified, default parameters are used.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="reminderNotification")
    def reminder_notification(self) -> Optional['outputs.SloTargetAlertRuleRuleReminderNotification']:
        """
        Reminder notification in a detector rule lets you send multiple notifications for active alerts over a defined period of time.
        """
        return pulumi.get(self, "reminder_notification")

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[_builtins.str]:
        """
        URL of page to consult when an alert is triggered. This can be used with custom notification messages.
        """
        return pulumi.get(self, "runbook_url")

    @_builtins.property
    @pulumi.getter
    def tip(self) -> Optional[_builtins.str]:
        """
        Plain text suggested first course of action, such as a command line to execute. This can be used with custom notification messages.
        """
        return pulumi.get(self, "tip")


@pulumi.output_type
class SloTargetAlertRuleRuleParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "burnRateThreshold1":
            suggest = "burn_rate_threshold1"
        elif key == "burnRateThreshold2":
            suggest = "burn_rate_threshold2"
        elif key == "fireLasting":
            suggest = "fire_lasting"
        elif key == "longWindow1":
            suggest = "long_window1"
        elif key == "longWindow2":
            suggest = "long_window2"
        elif key == "percentErrorBudgetLeft":
            suggest = "percent_error_budget_left"
        elif key == "percentOfLasting":
            suggest = "percent_of_lasting"
        elif key == "shortWindow1":
            suggest = "short_window1"
        elif key == "shortWindow2":
            suggest = "short_window2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloTargetAlertRuleRuleParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloTargetAlertRuleRuleParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloTargetAlertRuleRuleParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 burn_rate_threshold1: Optional[_builtins.float] = None,
                 burn_rate_threshold2: Optional[_builtins.float] = None,
                 fire_lasting: Optional[_builtins.str] = None,
                 long_window1: Optional[_builtins.str] = None,
                 long_window2: Optional[_builtins.str] = None,
                 percent_error_budget_left: Optional[_builtins.float] = None,
                 percent_of_lasting: Optional[_builtins.float] = None,
                 short_window1: Optional[_builtins.str] = None,
                 short_window2: Optional[_builtins.str] = None):
        """
        :param _builtins.float burn_rate_threshold1: Burn rate threshold 1 used in burn rate alert calculation. This value must be between 0 and 100/(100-SLO target). Note: `"BURN_RATE"` alert rules use the `"burn_rate_threshold_1"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        :param _builtins.float burn_rate_threshold2: Burn rate threshold 2 used in burn rate alert calculation. This value must be between 0 and 100/(100-SLO target). Note: `"BURN_RATE"` alert rules use the `"burn_rate_threshold_2"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        :param _builtins.str fire_lasting: Duration that indicates how long the alert condition is met before the alert is triggered. The value must be positive and smaller than the compliance period of the SLO target. Note: `"BREACH"` and `"ERROR_BUDGET_LEFT"` alert rules use the fireLasting parameter. Default: `"5m"`
        :param _builtins.str long_window1: Long window 1 used in burn rate alert calculation. This value must be longer than `"short_window_1"` and shorter than 90 days. Note: `"BURN_RATE"` alert rules use the `"long_window_1"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        :param _builtins.str long_window2: Long window 2 used in burn rate alert calculation. This value must be longer than `"short_window_2"` and shorter than 90 days. Note: `"BURN_RATE"` alert rules use the `"long_window_2"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        :param _builtins.float percent_error_budget_left: Error budget must be equal to or smaller than this percentage for the alert to be triggered. Note: `"ERROR_BUDGET_LEFT"` alert rules use the `"percent_error_budget_left"` parameter. Default: `100`
        :param _builtins.float percent_of_lasting: Percentage of the `"fire_lasting"` duration that the alert condition is met before the alert is triggered. Note: `"BREACH"` and `"ERROR_BUDGET_LEFT"` alert rules use the `"percent_of_lasting"` parameter. Default: `100`
        :param _builtins.str short_window1: Short window 1 used in burn rate alert calculation. This value must be longer than 1/30 of `"long_window_1"`. Note: `"BURN_RATE"` alert rules use the `"short_window_1"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        :param _builtins.str short_window2: Short window 2 used in burn rate alert calculation. This value must be longer than 1/30 of `"long_window_2"`. Note: `"BURN_RATE"` alert rules use the `"short_window_2"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        if burn_rate_threshold1 is not None:
            pulumi.set(__self__, "burn_rate_threshold1", burn_rate_threshold1)
        if burn_rate_threshold2 is not None:
            pulumi.set(__self__, "burn_rate_threshold2", burn_rate_threshold2)
        if fire_lasting is not None:
            pulumi.set(__self__, "fire_lasting", fire_lasting)
        if long_window1 is not None:
            pulumi.set(__self__, "long_window1", long_window1)
        if long_window2 is not None:
            pulumi.set(__self__, "long_window2", long_window2)
        if percent_error_budget_left is not None:
            pulumi.set(__self__, "percent_error_budget_left", percent_error_budget_left)
        if percent_of_lasting is not None:
            pulumi.set(__self__, "percent_of_lasting", percent_of_lasting)
        if short_window1 is not None:
            pulumi.set(__self__, "short_window1", short_window1)
        if short_window2 is not None:
            pulumi.set(__self__, "short_window2", short_window2)

    @_builtins.property
    @pulumi.getter(name="burnRateThreshold1")
    def burn_rate_threshold1(self) -> Optional[_builtins.float]:
        """
        Burn rate threshold 1 used in burn rate alert calculation. This value must be between 0 and 100/(100-SLO target). Note: `"BURN_RATE"` alert rules use the `"burn_rate_threshold_1"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        return pulumi.get(self, "burn_rate_threshold1")

    @_builtins.property
    @pulumi.getter(name="burnRateThreshold2")
    def burn_rate_threshold2(self) -> Optional[_builtins.float]:
        """
        Burn rate threshold 2 used in burn rate alert calculation. This value must be between 0 and 100/(100-SLO target). Note: `"BURN_RATE"` alert rules use the `"burn_rate_threshold_2"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        return pulumi.get(self, "burn_rate_threshold2")

    @_builtins.property
    @pulumi.getter(name="fireLasting")
    def fire_lasting(self) -> Optional[_builtins.str]:
        """
        Duration that indicates how long the alert condition is met before the alert is triggered. The value must be positive and smaller than the compliance period of the SLO target. Note: `"BREACH"` and `"ERROR_BUDGET_LEFT"` alert rules use the fireLasting parameter. Default: `"5m"`
        """
        return pulumi.get(self, "fire_lasting")

    @_builtins.property
    @pulumi.getter(name="longWindow1")
    def long_window1(self) -> Optional[_builtins.str]:
        """
        Long window 1 used in burn rate alert calculation. This value must be longer than `"short_window_1"` and shorter than 90 days. Note: `"BURN_RATE"` alert rules use the `"long_window_1"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        return pulumi.get(self, "long_window1")

    @_builtins.property
    @pulumi.getter(name="longWindow2")
    def long_window2(self) -> Optional[_builtins.str]:
        """
        Long window 2 used in burn rate alert calculation. This value must be longer than `"short_window_2"` and shorter than 90 days. Note: `"BURN_RATE"` alert rules use the `"long_window_2"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        return pulumi.get(self, "long_window2")

    @_builtins.property
    @pulumi.getter(name="percentErrorBudgetLeft")
    def percent_error_budget_left(self) -> Optional[_builtins.float]:
        """
        Error budget must be equal to or smaller than this percentage for the alert to be triggered. Note: `"ERROR_BUDGET_LEFT"` alert rules use the `"percent_error_budget_left"` parameter. Default: `100`
        """
        return pulumi.get(self, "percent_error_budget_left")

    @_builtins.property
    @pulumi.getter(name="percentOfLasting")
    def percent_of_lasting(self) -> Optional[_builtins.float]:
        """
        Percentage of the `"fire_lasting"` duration that the alert condition is met before the alert is triggered. Note: `"BREACH"` and `"ERROR_BUDGET_LEFT"` alert rules use the `"percent_of_lasting"` parameter. Default: `100`
        """
        return pulumi.get(self, "percent_of_lasting")

    @_builtins.property
    @pulumi.getter(name="shortWindow1")
    def short_window1(self) -> Optional[_builtins.str]:
        """
        Short window 1 used in burn rate alert calculation. This value must be longer than 1/30 of `"long_window_1"`. Note: `"BURN_RATE"` alert rules use the `"short_window_1"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        return pulumi.get(self, "short_window1")

    @_builtins.property
    @pulumi.getter(name="shortWindow2")
    def short_window2(self) -> Optional[_builtins.str]:
        """
        Short window 2 used in burn rate alert calculation. This value must be longer than 1/30 of `"long_window_2"`. Note: `"BURN_RATE"` alert rules use the `"short_window_2"` parameter. See [SLO alerts](https://docs.splunk.com/observability/en/alerts-detectors-notifications/slo/burn-rate-alerts.html) for more info.
        """
        return pulumi.get(self, "short_window2")


@pulumi.output_type
class SloTargetAlertRuleRuleReminderNotification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalMs":
            suggest = "interval_ms"
        elif key == "timeoutMs":
            suggest = "timeout_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloTargetAlertRuleRuleReminderNotification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloTargetAlertRuleRuleReminderNotification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloTargetAlertRuleRuleReminderNotification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_ms: _builtins.int,
                 type: _builtins.str,
                 timeout_ms: Optional[_builtins.int] = None):
        """
        :param _builtins.int interval_ms: The interval at which you want to receive the notifications, in milliseconds.
        :param _builtins.str type: Type of the SLO. Currently just: `"RequestBased"` is supported.
        :param _builtins.int timeout_ms: The duration during which repeat notifications are sent, in milliseconds.
        """
        pulumi.set(__self__, "interval_ms", interval_ms)
        pulumi.set(__self__, "type", type)
        if timeout_ms is not None:
            pulumi.set(__self__, "timeout_ms", timeout_ms)

    @_builtins.property
    @pulumi.getter(name="intervalMs")
    def interval_ms(self) -> _builtins.int:
        """
        The interval at which you want to receive the notifications, in milliseconds.
        """
        return pulumi.get(self, "interval_ms")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the SLO. Currently just: `"RequestBased"` is supported.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="timeoutMs")
    def timeout_ms(self) -> Optional[_builtins.int]:
        """
        The duration during which repeat notifications are sent, in milliseconds.
        """
        return pulumi.get(self, "timeout_ms")


@pulumi.output_type
class TableChartVizOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "valuePrefix":
            suggest = "value_prefix"
        elif key == "valueSuffix":
            suggest = "value_suffix"
        elif key == "valueUnit":
            suggest = "value_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableChartVizOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableChartVizOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableChartVizOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 color: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 value_prefix: Optional[_builtins.str] = None,
                 value_suffix: Optional[_builtins.str] = None,
                 value_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: The label used in the publish statement that displays the plot (metric time series data) you want to customize
        :param _builtins.str color: The color to use. Must be one of gray, blue, azure, navy, brown, orange, yellow, magenta, red, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen.
        :param _builtins.str display_name: Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        :param _builtins.str value_prefix: An arbitrary prefix to display with the value of this plot
        :param _builtins.str value_suffix: An arbitrary suffix to display with the value of this plot
        :param _builtins.str value_unit: A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes)
        """
        pulumi.set(__self__, "label", label)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if value_prefix is not None:
            pulumi.set(__self__, "value_prefix", value_prefix)
        if value_suffix is not None:
            pulumi.set(__self__, "value_suffix", value_suffix)
        if value_unit is not None:
            pulumi.set(__self__, "value_unit", value_unit)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label used in the publish statement that displays the plot (metric time series data) you want to customize
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def color(self) -> Optional[_builtins.str]:
        """
        The color to use. Must be one of gray, blue, azure, navy, brown, orange, yellow, magenta, red, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="valuePrefix")
    def value_prefix(self) -> Optional[_builtins.str]:
        """
        An arbitrary prefix to display with the value of this plot
        """
        return pulumi.get(self, "value_prefix")

    @_builtins.property
    @pulumi.getter(name="valueSuffix")
    def value_suffix(self) -> Optional[_builtins.str]:
        """
        An arbitrary suffix to display with the value of this plot
        """
        return pulumi.get(self, "value_suffix")

    @_builtins.property
    @pulumi.getter(name="valueUnit")
    def value_unit(self) -> Optional[_builtins.str]:
        """
        A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes)
        """
        return pulumi.get(self, "value_unit")


@pulumi.output_type
class TimeChartAxisLeft(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highWatermark":
            suggest = "high_watermark"
        elif key == "highWatermarkLabel":
            suggest = "high_watermark_label"
        elif key == "lowWatermark":
            suggest = "low_watermark"
        elif key == "lowWatermarkLabel":
            suggest = "low_watermark_label"
        elif key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeChartAxisLeft. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeChartAxisLeft.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeChartAxisLeft.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_watermark: Optional[_builtins.float] = None,
                 high_watermark_label: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 low_watermark: Optional[_builtins.float] = None,
                 low_watermark_label: Optional[_builtins.str] = None,
                 max_value: Optional[_builtins.float] = None,
                 min_value: Optional[_builtins.float] = None,
                 watermarks: Optional[Sequence['outputs.TimeChartAxisLeftWatermark']] = None):
        """
        :param _builtins.float high_watermark: A line to draw as a high watermark.
        :param _builtins.str high_watermark_label: A label to attach to the high watermark line.
        :param _builtins.str label: Label of the left axis.
        :param _builtins.float low_watermark: A line to draw as a low watermark.
        :param _builtins.str low_watermark_label: A label to attach to the low watermark line.
        :param _builtins.float max_value: The maximum value for the left axis.
        :param _builtins.float min_value: The minimum value for the left axis.
        """
        if high_watermark is not None:
            pulumi.set(__self__, "high_watermark", high_watermark)
        if high_watermark_label is not None:
            pulumi.set(__self__, "high_watermark_label", high_watermark_label)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if low_watermark is not None:
            pulumi.set(__self__, "low_watermark", low_watermark)
        if low_watermark_label is not None:
            pulumi.set(__self__, "low_watermark_label", low_watermark_label)
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if watermarks is not None:
            pulumi.set(__self__, "watermarks", watermarks)

    @_builtins.property
    @pulumi.getter(name="highWatermark")
    def high_watermark(self) -> Optional[_builtins.float]:
        """
        A line to draw as a high watermark.
        """
        return pulumi.get(self, "high_watermark")

    @_builtins.property
    @pulumi.getter(name="highWatermarkLabel")
    def high_watermark_label(self) -> Optional[_builtins.str]:
        """
        A label to attach to the high watermark line.
        """
        return pulumi.get(self, "high_watermark_label")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Label of the left axis.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="lowWatermark")
    def low_watermark(self) -> Optional[_builtins.float]:
        """
        A line to draw as a low watermark.
        """
        return pulumi.get(self, "low_watermark")

    @_builtins.property
    @pulumi.getter(name="lowWatermarkLabel")
    def low_watermark_label(self) -> Optional[_builtins.str]:
        """
        A label to attach to the low watermark line.
        """
        return pulumi.get(self, "low_watermark_label")

    @_builtins.property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[_builtins.float]:
        """
        The maximum value for the left axis.
        """
        return pulumi.get(self, "max_value")

    @_builtins.property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[_builtins.float]:
        """
        The minimum value for the left axis.
        """
        return pulumi.get(self, "min_value")

    @_builtins.property
    @pulumi.getter
    def watermarks(self) -> Optional[Sequence['outputs.TimeChartAxisLeftWatermark']]:
        return pulumi.get(self, "watermarks")


@pulumi.output_type
class TimeChartAxisLeftWatermark(dict):
    def __init__(__self__, *,
                 value: _builtins.float,
                 label: Optional[_builtins.str] = None):
        """
        :param _builtins.float value: Axis value where the watermark line will be displayed
        :param _builtins.str label: Label to display associated with the watermark line
        """
        pulumi.set(__self__, "value", value)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        """
        Axis value where the watermark line will be displayed
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Label to display associated with the watermark line
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class TimeChartAxisRight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highWatermark":
            suggest = "high_watermark"
        elif key == "highWatermarkLabel":
            suggest = "high_watermark_label"
        elif key == "lowWatermark":
            suggest = "low_watermark"
        elif key == "lowWatermarkLabel":
            suggest = "low_watermark_label"
        elif key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeChartAxisRight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeChartAxisRight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeChartAxisRight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_watermark: Optional[_builtins.float] = None,
                 high_watermark_label: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 low_watermark: Optional[_builtins.float] = None,
                 low_watermark_label: Optional[_builtins.str] = None,
                 max_value: Optional[_builtins.float] = None,
                 min_value: Optional[_builtins.float] = None,
                 watermarks: Optional[Sequence['outputs.TimeChartAxisRightWatermark']] = None):
        """
        :param _builtins.float high_watermark: A line to draw as a high watermark.
        :param _builtins.str high_watermark_label: A label to attach to the high watermark line.
        :param _builtins.str label: Label of the right axis.
        :param _builtins.float low_watermark: A line to draw as a low watermark.
        :param _builtins.str low_watermark_label: A label to attach to the low watermark line.
        :param _builtins.float max_value: The maximum value for the right axis.
        :param _builtins.float min_value: The minimum value for the right axis.
        """
        if high_watermark is not None:
            pulumi.set(__self__, "high_watermark", high_watermark)
        if high_watermark_label is not None:
            pulumi.set(__self__, "high_watermark_label", high_watermark_label)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if low_watermark is not None:
            pulumi.set(__self__, "low_watermark", low_watermark)
        if low_watermark_label is not None:
            pulumi.set(__self__, "low_watermark_label", low_watermark_label)
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if watermarks is not None:
            pulumi.set(__self__, "watermarks", watermarks)

    @_builtins.property
    @pulumi.getter(name="highWatermark")
    def high_watermark(self) -> Optional[_builtins.float]:
        """
        A line to draw as a high watermark.
        """
        return pulumi.get(self, "high_watermark")

    @_builtins.property
    @pulumi.getter(name="highWatermarkLabel")
    def high_watermark_label(self) -> Optional[_builtins.str]:
        """
        A label to attach to the high watermark line.
        """
        return pulumi.get(self, "high_watermark_label")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Label of the right axis.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="lowWatermark")
    def low_watermark(self) -> Optional[_builtins.float]:
        """
        A line to draw as a low watermark.
        """
        return pulumi.get(self, "low_watermark")

    @_builtins.property
    @pulumi.getter(name="lowWatermarkLabel")
    def low_watermark_label(self) -> Optional[_builtins.str]:
        """
        A label to attach to the low watermark line.
        """
        return pulumi.get(self, "low_watermark_label")

    @_builtins.property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[_builtins.float]:
        """
        The maximum value for the right axis.
        """
        return pulumi.get(self, "max_value")

    @_builtins.property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[_builtins.float]:
        """
        The minimum value for the right axis.
        """
        return pulumi.get(self, "min_value")

    @_builtins.property
    @pulumi.getter
    def watermarks(self) -> Optional[Sequence['outputs.TimeChartAxisRightWatermark']]:
        return pulumi.get(self, "watermarks")


@pulumi.output_type
class TimeChartAxisRightWatermark(dict):
    def __init__(__self__, *,
                 value: _builtins.float,
                 label: Optional[_builtins.str] = None):
        """
        :param _builtins.float value: Axis value where the watermark line will be displayed
        :param _builtins.str label: Label to display associated with the watermark line
        """
        pulumi.set(__self__, "value", value)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        """
        Axis value where the watermark line will be displayed
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Label to display associated with the watermark line
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class TimeChartEventOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeChartEventOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeChartEventOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeChartEventOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 color: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: Label used in the publish statement that displays the event query you want to customize.
        :param _builtins.str color: Color to use : gray, blue, azure, navy, brown, orange, yellow, iris, magenta, pink, purple, violet, lilac, emerald, green, aquamarine.
        :param _builtins.str display_name: Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        """
        pulumi.set(__self__, "label", label)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label used in the publish statement that displays the event query you want to customize.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def color(self) -> Optional[_builtins.str]:
        """
        Color to use : gray, blue, azure, navy, brown, orange, yellow, iris, magenta, pink, purple, violet, lilac, emerald, green, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class TimeChartHistogramOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "colorTheme":
            suggest = "color_theme"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeChartHistogramOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeChartHistogramOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeChartHistogramOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 color_theme: Optional[_builtins.str] = None):
        """
        :param _builtins.str color_theme: Color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        """
        if color_theme is not None:
            pulumi.set(__self__, "color_theme", color_theme)

    @_builtins.property
    @pulumi.getter(name="colorTheme")
    def color_theme(self) -> Optional[_builtins.str]:
        """
        Color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        """
        return pulumi.get(self, "color_theme")


@pulumi.output_type
class TimeChartLegendOptionsField(dict):
    def __init__(__self__, *,
                 property: _builtins.str,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str property: The name of the property to display. Note the special values of `plot_label` (corresponding with the API's `sf_metric`) which shows the label of the time series `publish()` and `metric` (corresponding with the API's `sf_originatingMetric`) that shows the name of the metric for the time series being displayed.
        :param _builtins.bool enabled: True or False depending on if you want the property to be shown or hidden.
        """
        pulumi.set(__self__, "property", property)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        The name of the property to display. Note the special values of `plot_label` (corresponding with the API's `sf_metric`) which shows the label of the time series `publish()` and `metric` (corresponding with the API's `sf_originatingMetric`) that shows the name of the metric for the time series being displayed.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        True or False depending on if you want the property to be shown or hidden.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class TimeChartVizOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "plotType":
            suggest = "plot_type"
        elif key == "valuePrefix":
            suggest = "value_prefix"
        elif key == "valueSuffix":
            suggest = "value_suffix"
        elif key == "valueUnit":
            suggest = "value_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeChartVizOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeChartVizOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeChartVizOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 axis: Optional[_builtins.str] = None,
                 color: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 plot_type: Optional[_builtins.str] = None,
                 value_prefix: Optional[_builtins.str] = None,
                 value_suffix: Optional[_builtins.str] = None,
                 value_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        :param _builtins.str axis: Y-axis associated with values for this plot. Must be either `right` or `left`.
        :param _builtins.str color: Color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        :param _builtins.str display_name: Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        :param _builtins.str plot_type: The visualization style to use. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Chart level `plot_type` by default.
        :param _builtins.str value_prefix: , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
        :param _builtins.str value_suffix: An arbitrary suffix to display with the value of this plot
        :param _builtins.str value_unit: A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        pulumi.set(__self__, "label", label)
        if axis is not None:
            pulumi.set(__self__, "axis", axis)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if plot_type is not None:
            pulumi.set(__self__, "plot_type", plot_type)
        if value_prefix is not None:
            pulumi.set(__self__, "value_prefix", value_prefix)
        if value_suffix is not None:
            pulumi.set(__self__, "value_suffix", value_suffix)
        if value_unit is not None:
            pulumi.set(__self__, "value_unit", value_unit)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label used in the publish statement that displays the plot (metric time series data) you want to customize.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def axis(self) -> Optional[_builtins.str]:
        """
        Y-axis associated with values for this plot. Must be either `right` or `left`.
        """
        return pulumi.get(self, "axis")

    @_builtins.property
    @pulumi.getter
    def color(self) -> Optional[_builtins.str]:
        """
        Color to use. Must be one of red, gold, iris, green, jade, gray, blue, azure, navy, brown, orange, yellow, magenta, cerise, pink, violet, purple, lilac, emerald, chartreuse, yellowgreen, aquamarine.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Specifies an alternate value for the Plot Name column of the Data Table associated with the chart.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> Optional[_builtins.str]:
        """
        The visualization style to use. Must be `"LineChart"`, `"AreaChart"`, `"ColumnChart"`, or `"Histogram"`. Chart level `plot_type` by default.
        """
        return pulumi.get(self, "plot_type")

    @_builtins.property
    @pulumi.getter(name="valuePrefix")
    def value_prefix(self) -> Optional[_builtins.str]:
        """
        , `value_suffix` - (Optional) Arbitrary prefix/suffix to display with the value of this plot.
        """
        return pulumi.get(self, "value_prefix")

    @_builtins.property
    @pulumi.getter(name="valueSuffix")
    def value_suffix(self) -> Optional[_builtins.str]:
        """
        An arbitrary suffix to display with the value of this plot
        """
        return pulumi.get(self, "value_suffix")

    @_builtins.property
    @pulumi.getter(name="valueUnit")
    def value_unit(self) -> Optional[_builtins.str]:
        """
        A unit to attach to this plot. Units support automatic scaling (eg thousands of bytes will be displayed as kilobytes). Values values are `Bit, Kilobit, Megabit, Gigabit, Terabit, Petabit, Exabit, Zettabit, Yottabit, Byte, Kibibyte, Mebibyte, Gibibyte (note: this was previously typoed as Gigibyte), Tebibyte, Pebibyte, Exbibyte, Zebibyte, Yobibyte, Nanosecond, Microsecond, Millisecond, Second, Minute, Hour, Day, Week`.
        """
        return pulumi.get(self, "value_unit")


@pulumi.output_type
class WebhookIntegrationHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerKey":
            suggest = "header_key"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookIntegrationHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookIntegrationHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookIntegrationHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_key: _builtins.str,
                 header_value: _builtins.str):
        """
        :param _builtins.str header_key: The key of the header to send
        :param _builtins.str header_value: The value of the header to send
        """
        pulumi.set(__self__, "header_key", header_key)
        pulumi.set(__self__, "header_value", header_value)

    @_builtins.property
    @pulumi.getter(name="headerKey")
    def header_key(self) -> _builtins.str:
        """
        The key of the header to send
        """
        return pulumi.get(self, "header_key")

    @_builtins.property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> _builtins.str:
        """
        The value of the header to send
        """
        return pulumi.get(self, "header_value")


