# MeDIC
Metabolomic Dashboard for Interpretable Classification

## Description
The MeDIC is a tool to apply machine learning algorithms to untargeted metabolomics datasets acquired by liquid-chromatography mass spectrometry. The goal is to extract the most important features because they are potential novel biomarkers.
The interface is made to be easy to use and intuitive even for those with small to nonexistant experience in programming and AI.

More generally, it is a tool to apply interpretable machine learning algorithms to tabular data. It focuses on analyzing the features selected by the models.

## The documentation
You can find the documentation [here](https://elinaff.github.io/MeDIC/).
It explains how to use MeDIC but also how it works.

## Authors and contributors
 - [Élina Francovic-Fontaine](https://github.com/ElinaFF)
 - [Vincent Primpied](https://github.com/le-smog)
 - [Vincent Vilain](https://github.com/VincentVilain)
 - [Gabriel Leclerc](https://github.com/PandaGab)
 - [Thierry Moszkowicz](https://github.com/ThierryAM)
 - [Mathieu Bazinet](https://github.com/MathieuBazinet)
 - [Thibaud Godon](https://github.com/thibgo)
 - [Pier-Luc Plante](https://github.com/plpla)
 - [Baptiste Bauvin](https://github.com/babau1)
 - [Louis-Philippe Vignault](https://scholar.google.com/citations?user=QXye6lEAAAAJ&hl=fr)

## Disclaimer
MeDIC is still in development. If you encounter any issue or have any suggestion, feel free to contact us at [elina.francovic-fontaine.1@ulaval.ca](mailto:elina.francovic-fontaine.1@ulaval.ca). Or you can leave an issue [here](https://github.com/ElinaFF/MeDIC/issues) with the tag "bug".

## For developers

### Setup

Clone the project with :
```shell
git clone https://github.com/ElinaFF/MeDIC.git
```

It is recommanded to setup a virtual environment. When it's done, use your isolated python and install `medic` package locally and in editable mode with :
```shell
python -m pip install -e ".[dev]"
```

## License
<a href="https://github.com/ElinaFF/MeDIC">Metabolomic Dashboard for Interpretable Classification (MeDIC)</a> © 2025 by <a href="https://creativecommons.org">Elina Francovic-Fontaine</a> is licensed under <a href="https://creativecommons.org/licenses/by-nc-sa/4.0/">CC BY-NC-SA 4.0</a>

