"""
This type stub file was generated by cyright.
"""

import dearcygui as dcg


class DrawStream(dcg.DrawingList):
    """A drawing element that draws its children in a FIFO time stream fashion.

    Each child is associated with an expiration time.
    When the expiration time is reached, the queue
    moves onto the next child.

    Only the first child in the queue is shown.

    if time_modulus is set, the time is taken modulo
    time_modulus, and the queue loops back once the end
    is reached.

    Usage:
    ```python
    stream = DrawStream(context)
    # Add drawing element that will expire after 2 seconds
    expiration_time = time.monotonic() + 2.0 
    stream.push(DrawCircle(context),
                expiration_time)
    ```
    """
    @property
    def time(self): # -> double:
        """Return the current time (monotonic clock mod time_modulus) in seconds"""
        ...
    
    @property
    def allow_no_children(self): # -> bint:
        """
        If True, if the expiration date of the last
        child expires, the item is allowed to have
        no child.

        If False (default), always keep at least one child.
        """
        ...
    
    @allow_no_children.setter
    def allow_no_children(self, value: bool): # -> None:
        ...
    
    @property
    def no_skip_children(self): # -> bint:
        """
        If True, will always show each child
        at least one frame, even if their
        expiration time is reached.
        """
        ...
    
    @no_skip_children.setter
    def no_skip_children(self, value: bool): # -> None:
        ...
    
    @property
    def time_modulus(self): # -> double:
        """
        If non-zero, the monotonic clock
        time will be applied this value as
        modulus, and the queue will loop back.
        """
        ...
    
    @time_modulus.setter
    def time_modulus(self, value: float): # -> None:
        ...
    
    def clear(self, only_outdated=...): # -> None:
        """Clear the drawing queue and detaches the children
        
        if only_updated is True, only items
        with past timestamps are removed
        """
        ...
    
    def push(self, child, expiry_time: float): # -> None:
        """Push a drawing item to the queue.

        The item will be attached as child if it isn't already.
        Only items associated with a push() will be
        displayed.

        An item is allowed to be several times in the queue
        (it will be attach as child only once, but will appear
         several times in the queue)

        Elements in the queue remain there unless the
        item is deleted, or clear() is called.

        Parameters:
            child: Drawing element to attach
            expiry_time: Time when child should expire and drawing
                should move on to the next one in the queue.
                The time clock corresponds to time.monotonic().
        """
        ...
    


