"""
This type stub file was generated by cyright.
"""

import dearcygui as dcg
from typing import Tuple

class DrawTiledImage(dcg.drawingItem):
    """
    This item enables to easily display a possibly huge
    image by only loading the image times that are currently
    visible.

    The texture management is handled implicitly.
    """
    def get_tile_data(self, uuid: int) -> dict:
        """
        Get tile information
        """
        ...
    
    def get_tile_uuids(self) -> list[int]:
        """
        Get the list of uuids of the tiles.
        """
        ...
    
    def get_oldest_tile(self) -> int:
        """
        Get the uuid of the oldest tile (the one
        with smallest last_frame_count).
        """
        ...
    
    def add_tile(self, content, coord, opposite_coord=..., nearest_neighbor_upsampling=..., visible=...) -> None:
        """
        Add a tile to the list of tiles.
        Inputs:
            content: numpy array, the content of the tile.
                Alternatively a dcg.Texture object, in which
                case nearest_neighbor_upsampling is ignored.
            coord: the top-left coordinate of the tile
            opposite_coord (optional): if not given,
                defaults to coord + content.shape.
                Else corresponds to the opposite coordinate
                of the tile.
            visible (optional): whether the tile should start visible or not.
            nearest_neighbor_upsampling: whether to use nearest neighbor
                upsampling when rendering the tile.
        Outputs:
            Unique uuid of the tile.
        """
        ...
    
    def remove_tile(self, uuid) -> None:
        """
        Remove a tile from the list of tiles.
        Inputs:
            uuid: the unique identifier of the tile.
        """
        ...
    
    def set_tile_visibility(self, uuid, visible) -> None:
        """
        Set the visibility status of a tile.
        Inputs:
            uuid: the unique identifier of the tile.
            visible: Whether the tile should be visible or not.
        By default tiles start visible.
        """
        ...
    
    def update_tile(self, uuid, content) -> None:
        """
        Update the content of a tile.
        Inputs:
            uuid: the unique identifier of the tile.
            content: the new content of the tile.
        """
        ...
    


class SVGRenderer:
    """
    Base class for SVG renderers.
    """
    def __init__(self, svg_path: str) -> None:
        ...
    
    @property
    def content_bounds(self) -> Tuple[float, float, float, float]:
        """Get the SVG content bounds (x, y, width, height)"""
        ...
    
    def get_fit_scale(self, target_width: float, target_height: float) -> float:
        """Calculate scale factor to fit SVG in target dimensions while preserving aspect ratio"""
        ...
    
    def get_centered_translation(self, target_width: float, target_height: float, scalex: float, scaley: float) -> Tuple[float, float]:
        """Calculate translation to center SVG in target dimensions at given scale"""
        ...
    
    def allocate_texture(self, C: dcg.Context, width: int, height: int, allow_gpu: bool = ...): # -> None:
        """Allocate a texture for rendering the SVG content"""
        ...
    
    def render(self, scalex: float, scaley: float, tx: float, ty: float): # -> None:
        """Render the SVG content to the texture at given scale and position"""
        ...
    


class SkiaSVGRenderer(SVGRenderer):
    """
    A SVG renderer using Skia for rendering,
    with optional GPU acceleration.

    The renderer can be used to render SVG content
    to a texture. It is possible to render the SVG
    content at a specific scale and position.

    Skia is pretty fast. By default the GPU is not used,
    but it can be enabled by setting allow_gpu=True.

    GPU rendering is not always faster, it depends on
    the complexity of the SVG content and the target.
    The GPU backend might require moderngl.
    """
    def __init__(self, svg_path: str) -> None:
        ...
    
    @property
    def content_bounds(self) -> Tuple[float, float, float, float]:
        """Get the SVG content bounds (x, y, width, height)"""
        ...
    
    def get_fit_scale(self, target_width: float, target_height: float, preserve_ratio: bool = ...) -> float:
        """Calculate scale factor to fit SVG in target dimensions while preserving aspect ratio"""
        ...
    
    def get_centered_translation(self, target_width: float, target_height: float, scalex: float, scaley: float) -> Tuple[float, float]:
        """Calculate translation to center SVG in target dimensions at given scale"""
        ...
    
    def allocate_texture(self, C: dcg.Context, width: int, height: int, allow_gpu: bool = ...) -> None:
        """Allocate a texture for rendering the SVG content"""
        ...
    
    def render(self, scalex: float, scaley: float, tx: float, ty: float) -> None:
        """Render the SVG content to the texture at given scale and position"""
        ...
    


class DrawSVG(dcg.drawingItem):
    """
    Draw SVG content scaled to fit within given bounds.

    The SVG is rendered to a texture at an appropriate resolution
    based on the visible area, and reuses the texture when possible
    to avoid unnecessary re-rendering.
    """
    def __init__(self, *args, **kwargs) -> None:
        ...
    
    @property
    def svg_path(self): # -> str:
        """
        Path to the SVG file being displayed.

        This path identifies the SVG file loaded by the renderer. Setting this
        property will create a new renderer instance with the provided file.
        """
        ...
    
    @svg_path.setter
    def svg_path(self, value: str): # -> None:
        ...
    
    @property
    def pmin(self): # -> Coord:
        """
        Top-left position in coordinate space.

        Defines the upper-left corner of the rectangle where the SVG will be
        drawn. Together with pmax, this determines the display area bounds.
        """
        ...
    
    @pmin.setter
    def pmin(self, value): # -> None:
        ...
    
    @property
    def pmax(self): # -> Coord:
        """
        Bottom-right position in coordinate space.

        Defines the lower-right corner of the rectangle where the SVG will be
        drawn. Together with pmin, this determines the display area bounds.
        """
        ...
    
    @pmax.setter
    def pmax(self, value): # -> None:
        ...
    
    @property
    def no_preserve_ratio(self): # -> bool:
        """
        Whether to allow stretching the SVG to fit the area.

        When True, the SVG can be stretched in both dimensions independently to
        fill the entire display area. When False (default), the aspect ratio is
        preserved.
        """
        ...
    
    @no_preserve_ratio.setter
    def no_preserve_ratio(self, value: bool): # -> None:
        ...
    
    @property
    def no_centering(self): # -> bint:
        """
        Whether to align SVG to top-left instead of centering.

        When True, the SVG is aligned to the top-left corner of the display area.
        When False (default), the SVG is centered within the display area.
        """
        ...
    
    @no_centering.setter
    def no_centering(self, value: bool): # -> None:
        ...
    


