import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StringResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Arbitrary map of values that, when changed, will trigger recreation of resource. See [the main provider documentation](../index.html) for more information.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#keepers StringResource#keepers}
    */
    readonly keepers?: {
        [key: string]: string;
    };
    /**
    * The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#length StringResource#length}
    */
    readonly length: number;
    /**
    * Include lowercase alphabet characters in the result. Default value is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#lower StringResource#lower}
    */
    readonly lower?: boolean | cdktf.IResolvable;
    /**
    * Minimum number of lowercase alphabet characters in the result. Default value is `0`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#min_lower StringResource#min_lower}
    */
    readonly minLower?: number;
    /**
    * Minimum number of numeric characters in the result. Default value is `0`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#min_numeric StringResource#min_numeric}
    */
    readonly minNumeric?: number;
    /**
    * Minimum number of special characters in the result. Default value is `0`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#min_special StringResource#min_special}
    */
    readonly minSpecial?: number;
    /**
    * Minimum number of uppercase alphabet characters in the result. Default value is `0`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#min_upper StringResource#min_upper}
    */
    readonly minUpper?: number;
    /**
    * Include numeric characters in the result. Default value is `true`. **NOTE**: This is deprecated, use `numeric` instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#number StringResource#number}
    */
    readonly number?: boolean | cdktf.IResolvable;
    /**
    * Include numeric characters in the result. Default value is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#numeric StringResource#numeric}
    */
    readonly numeric?: boolean | cdktf.IResolvable;
    /**
    * Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#override_special StringResource#override_special}
    */
    readonly overrideSpecial?: string;
    /**
    * Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#special StringResource#special}
    */
    readonly special?: boolean | cdktf.IResolvable;
    /**
    * Include uppercase alphabet characters in the result. Default value is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/random/r/string#upper StringResource#upper}
    */
    readonly upper?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/random/r/string random_string}
*/
export declare class StringResource extends cdktf.TerraformResource {
    static readonly tfResourceType = "random_string";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/random/r/string random_string} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StringResourceConfig
    */
    constructor(scope: Construct, id: string, config: StringResourceConfig);
    get id(): string;
    private _keepers?;
    get keepers(): {
        [key: string]: string;
    };
    set keepers(value: {
        [key: string]: string;
    });
    resetKeepers(): void;
    get keepersInput(): {
        [key: string]: string;
    } | undefined;
    private _length?;
    get length(): number;
    set length(value: number);
    get lengthInput(): number | undefined;
    private _lower?;
    get lower(): boolean | cdktf.IResolvable;
    set lower(value: boolean | cdktf.IResolvable);
    resetLower(): void;
    get lowerInput(): boolean | cdktf.IResolvable | undefined;
    private _minLower?;
    get minLower(): number;
    set minLower(value: number);
    resetMinLower(): void;
    get minLowerInput(): number | undefined;
    private _minNumeric?;
    get minNumeric(): number;
    set minNumeric(value: number);
    resetMinNumeric(): void;
    get minNumericInput(): number | undefined;
    private _minSpecial?;
    get minSpecial(): number;
    set minSpecial(value: number);
    resetMinSpecial(): void;
    get minSpecialInput(): number | undefined;
    private _minUpper?;
    get minUpper(): number;
    set minUpper(value: number);
    resetMinUpper(): void;
    get minUpperInput(): number | undefined;
    private _number?;
    get number(): boolean | cdktf.IResolvable;
    set number(value: boolean | cdktf.IResolvable);
    resetNumber(): void;
    get numberInput(): boolean | cdktf.IResolvable | undefined;
    private _numeric?;
    get numeric(): boolean | cdktf.IResolvable;
    set numeric(value: boolean | cdktf.IResolvable);
    resetNumeric(): void;
    get numericInput(): boolean | cdktf.IResolvable | undefined;
    private _overrideSpecial?;
    get overrideSpecial(): string;
    set overrideSpecial(value: string);
    resetOverrideSpecial(): void;
    get overrideSpecialInput(): string | undefined;
    get result(): string;
    private _special?;
    get special(): boolean | cdktf.IResolvable;
    set special(value: boolean | cdktf.IResolvable);
    resetSpecial(): void;
    get specialInput(): boolean | cdktf.IResolvable | undefined;
    private _upper?;
    get upper(): boolean | cdktf.IResolvable;
    set upper(value: boolean | cdktf.IResolvable);
    resetUpper(): void;
    get upperInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
