"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/random/r/string random_string}
*/
class StringResource extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/random/r/string random_string} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StringResourceConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'random_string',
            terraformGeneratorMetadata: {
                providerName: 'random',
                providerVersion: '3.4.3',
                providerVersionConstraint: '~> 3.1'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._keepers = config.keepers;
        this._length = config.length;
        this._lower = config.lower;
        this._minLower = config.minLower;
        this._minNumeric = config.minNumeric;
        this._minSpecial = config.minSpecial;
        this._minUpper = config.minUpper;
        this._number = config.number;
        this._numeric = config.numeric;
        this._overrideSpecial = config.overrideSpecial;
        this._special = config.special;
        this._upper = config.upper;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get keepers() {
        return this.getStringMapAttribute('keepers');
    }
    set keepers(value) {
        this._keepers = value;
    }
    resetKeepers() {
        this._keepers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepersInput() {
        return this._keepers;
    }
    get length() {
        return this.getNumberAttribute('length');
    }
    set length(value) {
        this._length = value;
    }
    // Temporarily expose input value. Use with caution.
    get lengthInput() {
        return this._length;
    }
    get lower() {
        return this.getBooleanAttribute('lower');
    }
    set lower(value) {
        this._lower = value;
    }
    resetLower() {
        this._lower = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lowerInput() {
        return this._lower;
    }
    get minLower() {
        return this.getNumberAttribute('min_lower');
    }
    set minLower(value) {
        this._minLower = value;
    }
    resetMinLower() {
        this._minLower = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minLowerInput() {
        return this._minLower;
    }
    get minNumeric() {
        return this.getNumberAttribute('min_numeric');
    }
    set minNumeric(value) {
        this._minNumeric = value;
    }
    resetMinNumeric() {
        this._minNumeric = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minNumericInput() {
        return this._minNumeric;
    }
    get minSpecial() {
        return this.getNumberAttribute('min_special');
    }
    set minSpecial(value) {
        this._minSpecial = value;
    }
    resetMinSpecial() {
        this._minSpecial = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minSpecialInput() {
        return this._minSpecial;
    }
    get minUpper() {
        return this.getNumberAttribute('min_upper');
    }
    set minUpper(value) {
        this._minUpper = value;
    }
    resetMinUpper() {
        this._minUpper = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minUpperInput() {
        return this._minUpper;
    }
    get number() {
        return this.getBooleanAttribute('number');
    }
    set number(value) {
        this._number = value;
    }
    resetNumber() {
        this._number = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numberInput() {
        return this._number;
    }
    get numeric() {
        return this.getBooleanAttribute('numeric');
    }
    set numeric(value) {
        this._numeric = value;
    }
    resetNumeric() {
        this._numeric = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numericInput() {
        return this._numeric;
    }
    get overrideSpecial() {
        return this.getStringAttribute('override_special');
    }
    set overrideSpecial(value) {
        this._overrideSpecial = value;
    }
    resetOverrideSpecial() {
        this._overrideSpecial = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get overrideSpecialInput() {
        return this._overrideSpecial;
    }
    // result - computed: true, optional: false, required: false
    get result() {
        return this.getStringAttribute('result');
    }
    get special() {
        return this.getBooleanAttribute('special');
    }
    set special(value) {
        this._special = value;
    }
    resetSpecial() {
        this._special = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get specialInput() {
        return this._special;
    }
    get upper() {
        return this.getBooleanAttribute('upper');
    }
    set upper(value) {
        this._upper = value;
    }
    resetUpper() {
        this._upper = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upperInput() {
        return this._upper;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            keepers: cdktf.hashMapper(cdktf.stringToTerraform)(this._keepers),
            length: cdktf.numberToTerraform(this._length),
            lower: cdktf.booleanToTerraform(this._lower),
            min_lower: cdktf.numberToTerraform(this._minLower),
            min_numeric: cdktf.numberToTerraform(this._minNumeric),
            min_special: cdktf.numberToTerraform(this._minSpecial),
            min_upper: cdktf.numberToTerraform(this._minUpper),
            number: cdktf.booleanToTerraform(this._number),
            numeric: cdktf.booleanToTerraform(this._numeric),
            override_special: cdktf.stringToTerraform(this._overrideSpecial),
            special: cdktf.booleanToTerraform(this._special),
            upper: cdktf.booleanToTerraform(this._upper),
        };
    }
}
exports.StringResource = StringResource;
_a = JSII_RTTI_SYMBOL_1;
StringResource[_a] = { fqn: "@cdktf/provider-random.StringResource", version: "2.0.56" };
// =================
// STATIC PROPERTIES
// =================
StringResource.tfResourceType = "random_string";
//# sourceMappingURL=data:application/json;base64,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