# Copyright 2025 Rebellions Inc. All rights reserved.

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at:

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import TYPE_CHECKING

from transformers.utils import _LazyModule

from .__version__ import __version__
from .utils import check_version_compats


_import_structure = {
    "modeling": [
        "RBLNBaseModel",
        "RBLNModel",
    ],
    "configuration_utils": [
        "RBLNAutoConfig",
        "RBLNCompileConfig",
        "RBLNModelConfig",
    ],
    "transformers": [
        "RBLNASTForAudioClassification",
        "RBLNASTForAudioClassificationConfig",
        "RBLNAutoModel",
        "RBLNAutoModelForAudioClassification",
        "RBLNAutoModelForCausalLM",
        "RBLNAutoModelForCTC",
        "RBLNAutoModelForDepthEstimation",
        "RBLNAutoModelForImageClassification",
        "RBLNAutoModelForImageTextToText",
        "RBLNAutoModelForMaskedLM",
        "RBLNAutoModelForQuestionAnswering",
        "RBLNAutoModelForSeq2SeqLM",
        "RBLNAutoModelForSequenceClassification",
        "RBLNAutoModelForSpeechSeq2Seq",
        "RBLNAutoModelForVision2Seq",
        "RBLNAutoModelForTextEncoding",
        "RBLNAutoModelForZeroShotObjectDetection",
        "RBLNBartForConditionalGeneration",
        "RBLNBartForConditionalGenerationConfig",
        "RBLNBartModel",
        "RBLNBartModelConfig",
        "RBLNBertForMaskedLM",
        "RBLNBertForMaskedLMConfig",
        "RBLNBertForQuestionAnswering",
        "RBLNBertForQuestionAnsweringConfig",
        "RBLNBertModel",
        "RBLNBertModelConfig",
        "RBLNBlip2VisionModelConfig",
        "RBLNBlip2VisionModel",
        "RBLNBlip2QFormerModel",
        "RBLNBlip2QFormerModelConfig",
        "RBLNBlip2ForConditionalGeneration",
        "RBLNBlip2ForConditionalGenerationConfig",
        "RBLNCLIPTextModel",
        "RBLNCLIPTextModelConfig",
        "RBLNCLIPTextModelWithProjection",
        "RBLNCLIPTextModelWithProjectionConfig",
        "RBLNCLIPVisionModel",
        "RBLNCLIPVisionModelConfig",
        "RBLNCLIPVisionModelWithProjection",
        "RBLNCLIPVisionModelWithProjectionConfig",
        "RBLNColPaliForRetrieval",
        "RBLNColPaliForRetrievalConfig",
        "RBLNDecoderOnlyModelConfig",
        "RBLNDecoderOnlyModel",
        "RBLNDecoderOnlyModelForCausalLM",
        "RBLNDecoderOnlyModelForCausalLMConfig",
        "RBLNDistilBertForQuestionAnswering",
        "RBLNDistilBertForQuestionAnsweringConfig",
        "RBLNDPTForDepthEstimation",
        "RBLNDPTForDepthEstimationConfig",
        "RBLNDepthAnythingForDepthEstimationConfig",
        "RBLNDepthAnythingForDepthEstimation",
        "RBLNExaoneForCausalLM",
        "RBLNExaoneForCausalLMConfig",
        "RBLNGemmaModel",
        "RBLNGemmaModelConfig",
        "RBLNGemmaForCausalLM",
        "RBLNGemmaForCausalLMConfig",
        "RBLNGemma3ForCausalLM",
        "RBLNGemma3ForCausalLMConfig",
        "RBLNGemma3ForConditionalGeneration",
        "RBLNGemma3ForConditionalGenerationConfig",
        "RBLNGPT2Model",
        "RBLNGPT2ModelConfig",
        "RBLNGPT2LMHeadModel",
        "RBLNGPT2LMHeadModelConfig",
        "RBLNGroundingDinoDecoder",
        "RBLNGroundingDinoDecoderConfig",
        "RBLNGroundingDinoForObjectDetection",
        "RBLNGroundingDinoForObjectDetectionConfig",
        "RBLNGroundingDinoEncoder",
        "RBLNGroundingDinoEncoderConfig",
        "RBLNIdefics3VisionTransformer",
        "RBLNIdefics3ForConditionalGeneration",
        "RBLNIdefics3ForConditionalGenerationConfig",
        "RBLNIdefics3VisionTransformerConfig",
        "RBLNLlamaForCausalLM",
        "RBLNLlamaForCausalLMConfig",
        "RBLNLlamaModel",
        "RBLNLlamaModelConfig",
        "RBLNOPTForCausalLM",
        "RBLNOPTForCausalLMConfig",
        "RBLNLlavaForConditionalGeneration",
        "RBLNLlavaForConditionalGenerationConfig",
        "RBLNLlavaNextForConditionalGeneration",
        "RBLNLlavaNextForConditionalGenerationConfig",
        "RBLNMidmLMHeadModel",
        "RBLNMidmLMHeadModelConfig",
        "RBLNMistralModel",
        "RBLNMistralModelConfig",
        "RBLNMistralForCausalLM",
        "RBLNMistralForCausalLMConfig",
        "RBLNOPTModel",
        "RBLNOPTModelConfig",
        "RBLNPegasusForConditionalGeneration",
        "RBLNPegasusForConditionalGenerationConfig",
        "RBLNPegasusModel",
        "RBLNPegasusModelConfig",
        "RBLNPhiForCausalLM",
        "RBLNPhiForCausalLMConfig",
        "RBLNPixtralVisionModel",
        "RBLNPixtralVisionModelConfig",
        "RBLNPhiModel",
        "RBLNPhiModelConfig",
        "RBLNQwen2ForCausalLM",
        "RBLNQwen2ForCausalLMConfig",
        "RBLNQwen2_5_VisionTransformerPretrainedModel",
        "RBLNQwen2_5_VisionTransformerPretrainedModelConfig",
        "RBLNQwen2_5_VLForConditionalGeneration",
        "RBLNQwen2_5_VLForConditionalGenerationConfig",
        "RBLNQwen2Model",
        "RBLNQwen2ModelConfig",
        "RBLNQwen3ForCausalLM",
        "RBLNQwen3ForCausalLMConfig",
        "RBLNQwen3Model",
        "RBLNQwen3ModelConfig",
        "RBLNQwen2VisionTransformerPretrainedModel",
        "RBLNQwen2VisionTransformerPretrainedModelConfig",
        "RBLNQwen2VLForConditionalGeneration",
        "RBLNQwen2VLForConditionalGenerationConfig",
        "RBLNResNetForImageClassification",
        "RBLNResNetForImageClassificationConfig",
        "RBLNRobertaForMaskedLM",
        "RBLNRobertaForMaskedLMConfig",
        "RBLNRobertaForSequenceClassification",
        "RBLNRobertaForSequenceClassificationConfig",
        "RBLNSiglipVisionModel",
        "RBLNSiglipVisionModelConfig",
        "RBLNSwinBackbone",
        "RBLNSwinBackboneConfig",
        "RBLNT5EncoderModel",
        "RBLNT5EncoderModelConfig",
        "RBLNT5ForConditionalGeneration",
        "RBLNT5ForConditionalGenerationConfig",
        "RBLNTimeSeriesTransformerForPrediction",
        "RBLNTimeSeriesTransformerForPredictionConfig",
        "RBLNViTForImageClassification",
        "RBLNViTForImageClassificationConfig",
        "RBLNWav2Vec2ForCTC",
        "RBLNWav2Vec2ForCTCConfig",
        "RBLNWhisperForConditionalGeneration",
        "RBLNWhisperForConditionalGenerationConfig",
        "RBLNXLMRobertaForSequenceClassification",
        "RBLNXLMRobertaForSequenceClassificationConfig",
        "RBLNXLMRobertaModel",
        "RBLNXLMRobertaModelConfig",
    ],
    "diffusers": [
        "RBLNAutoencoderKL",
        "RBLNAutoencoderKLConfig",
        "RBLNAutoencoderKLCosmos",
        "RBLNAutoencoderKLCosmosConfig",
        "RBLNAutoPipelineForImage2Image",
        "RBLNAutoPipelineForInpainting",
        "RBLNAutoPipelineForText2Image",
        "RBLNControlNetModel",
        "RBLNControlNetModelConfig",
        "RBLNCosmosTextToWorldPipeline",
        "RBLNCosmosVideoToWorldPipeline",
        "RBLNCosmosTextToWorldPipelineConfig",
        "RBLNCosmosVideoToWorldPipelineConfig",
        "RBLNCosmosSafetyChecker",
        "RBLNCosmosTransformer3DModel",
        "RBLNCosmosTransformer3DModelConfig",
        "RBLNDiffusionMixin",
        "RBLNKandinskyV22CombinedPipeline",
        "RBLNKandinskyV22CombinedPipelineConfig",
        "RBLNKandinskyV22Img2ImgCombinedPipeline",
        "RBLNKandinskyV22Img2ImgCombinedPipelineConfig",
        "RBLNKandinskyV22Img2ImgPipeline",
        "RBLNKandinskyV22Img2ImgPipelineConfig",
        "RBLNKandinskyV22InpaintCombinedPipeline",
        "RBLNKandinskyV22InpaintCombinedPipelineConfig",
        "RBLNKandinskyV22InpaintPipeline",
        "RBLNKandinskyV22InpaintPipelineConfig",
        "RBLNKandinskyV22Pipeline",
        "RBLNKandinskyV22PipelineConfig",
        "RBLNKandinskyV22PriorPipeline",
        "RBLNKandinskyV22PriorPipelineConfig",
        "RBLNMultiControlNetModel",
        "RBLNPriorTransformer",
        "RBLNPriorTransformerConfig",
        "RBLNSD3Transformer2DModel",
        "RBLNSD3Transformer2DModelConfig",
        "RBLNStableDiffusion3Img2ImgPipeline",
        "RBLNStableDiffusion3Img2ImgPipelineConfig",
        "RBLNStableDiffusion3InpaintPipeline",
        "RBLNStableDiffusion3InpaintPipelineConfig",
        "RBLNStableDiffusion3Pipeline",
        "RBLNStableDiffusion3PipelineConfig",
        "RBLNStableDiffusionControlNetImg2ImgPipeline",
        "RBLNStableDiffusionControlNetImg2ImgPipelineConfig",
        "RBLNStableDiffusionControlNetPipeline",
        "RBLNStableDiffusionControlNetPipelineConfig",
        "RBLNStableDiffusionImg2ImgPipeline",
        "RBLNStableDiffusionImg2ImgPipelineConfig",
        "RBLNStableDiffusionInpaintPipeline",
        "RBLNStableDiffusionInpaintPipelineConfig",
        "RBLNStableDiffusionPipeline",
        "RBLNStableDiffusionPipelineConfig",
        "RBLNStableDiffusionXLControlNetImg2ImgPipeline",
        "RBLNStableDiffusionXLControlNetImg2ImgPipelineConfig",
        "RBLNStableDiffusionXLControlNetPipeline",
        "RBLNStableDiffusionXLControlNetPipelineConfig",
        "RBLNStableDiffusionXLImg2ImgPipeline",
        "RBLNStableDiffusionXLImg2ImgPipelineConfig",
        "RBLNStableDiffusionXLInpaintPipeline",
        "RBLNStableDiffusionXLInpaintPipelineConfig",
        "RBLNStableDiffusionXLPipeline",
        "RBLNStableDiffusionXLPipelineConfig",
        "RBLNUNet2DConditionModel",
        "RBLNUNet2DConditionModelConfig",
        "RBLNVQModel",
        "RBLNVQModelConfig",
    ],
}

if TYPE_CHECKING:
    from .configuration_utils import RBLNAutoConfig, RBLNCompileConfig, RBLNModelConfig
    from .diffusers import (
        RBLNAutoencoderKL,
        RBLNAutoencoderKLConfig,
        RBLNAutoencoderKLCosmos,
        RBLNAutoencoderKLCosmosConfig,
        RBLNAutoPipelineForImage2Image,
        RBLNAutoPipelineForInpainting,
        RBLNAutoPipelineForText2Image,
        RBLNControlNetModel,
        RBLNControlNetModelConfig,
        RBLNCosmosSafetyChecker,
        RBLNCosmosTextToWorldPipeline,
        RBLNCosmosTextToWorldPipelineConfig,
        RBLNCosmosTransformer3DModel,
        RBLNCosmosTransformer3DModelConfig,
        RBLNCosmosVideoToWorldPipeline,
        RBLNCosmosVideoToWorldPipelineConfig,
        RBLNDiffusionMixin,
        RBLNKandinskyV22CombinedPipeline,
        RBLNKandinskyV22CombinedPipelineConfig,
        RBLNKandinskyV22Img2ImgCombinedPipeline,
        RBLNKandinskyV22Img2ImgCombinedPipelineConfig,
        RBLNKandinskyV22Img2ImgPipeline,
        RBLNKandinskyV22Img2ImgPipelineConfig,
        RBLNKandinskyV22InpaintCombinedPipeline,
        RBLNKandinskyV22InpaintCombinedPipelineConfig,
        RBLNKandinskyV22InpaintPipeline,
        RBLNKandinskyV22InpaintPipelineConfig,
        RBLNKandinskyV22Pipeline,
        RBLNKandinskyV22PipelineConfig,
        RBLNKandinskyV22PriorPipeline,
        RBLNKandinskyV22PriorPipelineConfig,
        RBLNMultiControlNetModel,
        RBLNPriorTransformer,
        RBLNPriorTransformerConfig,
        RBLNSD3Transformer2DModel,
        RBLNSD3Transformer2DModelConfig,
        RBLNStableDiffusion3Img2ImgPipeline,
        RBLNStableDiffusion3Img2ImgPipelineConfig,
        RBLNStableDiffusion3InpaintPipeline,
        RBLNStableDiffusion3InpaintPipelineConfig,
        RBLNStableDiffusion3Pipeline,
        RBLNStableDiffusion3PipelineConfig,
        RBLNStableDiffusionControlNetImg2ImgPipeline,
        RBLNStableDiffusionControlNetImg2ImgPipelineConfig,
        RBLNStableDiffusionControlNetPipeline,
        RBLNStableDiffusionControlNetPipelineConfig,
        RBLNStableDiffusionImg2ImgPipeline,
        RBLNStableDiffusionImg2ImgPipelineConfig,
        RBLNStableDiffusionInpaintPipeline,
        RBLNStableDiffusionInpaintPipelineConfig,
        RBLNStableDiffusionPipeline,
        RBLNStableDiffusionPipelineConfig,
        RBLNStableDiffusionXLControlNetImg2ImgPipeline,
        RBLNStableDiffusionXLControlNetImg2ImgPipelineConfig,
        RBLNStableDiffusionXLControlNetPipeline,
        RBLNStableDiffusionXLControlNetPipelineConfig,
        RBLNStableDiffusionXLImg2ImgPipeline,
        RBLNStableDiffusionXLImg2ImgPipelineConfig,
        RBLNStableDiffusionXLInpaintPipeline,
        RBLNStableDiffusionXLInpaintPipelineConfig,
        RBLNStableDiffusionXLPipeline,
        RBLNStableDiffusionXLPipelineConfig,
        RBLNUNet2DConditionModel,
        RBLNUNet2DConditionModelConfig,
        RBLNVQModel,
        RBLNVQModelConfig,
    )
    from .modeling import RBLNBaseModel, RBLNModel
    from .transformers import (
        RBLNASTForAudioClassification,
        RBLNASTForAudioClassificationConfig,
        RBLNAutoModel,
        RBLNAutoModelForAudioClassification,
        RBLNAutoModelForCausalLM,
        RBLNAutoModelForCTC,
        RBLNAutoModelForDepthEstimation,
        RBLNAutoModelForImageClassification,
        RBLNAutoModelForImageTextToText,
        RBLNAutoModelForMaskedLM,
        RBLNAutoModelForQuestionAnswering,
        RBLNAutoModelForSeq2SeqLM,
        RBLNAutoModelForSequenceClassification,
        RBLNAutoModelForSpeechSeq2Seq,
        RBLNAutoModelForTextEncoding,
        RBLNAutoModelForVision2Seq,
        RBLNAutoModelForZeroShotObjectDetection,
        RBLNBartForConditionalGeneration,
        RBLNBartForConditionalGenerationConfig,
        RBLNBartModel,
        RBLNBartModelConfig,
        RBLNBertForMaskedLM,
        RBLNBertForMaskedLMConfig,
        RBLNBertForQuestionAnswering,
        RBLNBertForQuestionAnsweringConfig,
        RBLNBertModel,
        RBLNBertModelConfig,
        RBLNBlip2ForConditionalGeneration,
        RBLNBlip2ForConditionalGenerationConfig,
        RBLNBlip2QFormerModel,
        RBLNBlip2QFormerModelConfig,
        RBLNBlip2VisionModel,
        RBLNBlip2VisionModelConfig,
        RBLNCLIPTextModel,
        RBLNCLIPTextModelConfig,
        RBLNCLIPTextModelWithProjection,
        RBLNCLIPTextModelWithProjectionConfig,
        RBLNCLIPVisionModel,
        RBLNCLIPVisionModelConfig,
        RBLNCLIPVisionModelWithProjection,
        RBLNCLIPVisionModelWithProjectionConfig,
        RBLNColPaliForRetrieval,
        RBLNColPaliForRetrievalConfig,
        RBLNDecoderOnlyModel,
        RBLNDecoderOnlyModelConfig,
        RBLNDecoderOnlyModelForCausalLM,
        RBLNDecoderOnlyModelForCausalLMConfig,
        RBLNDepthAnythingForDepthEstimation,
        RBLNDepthAnythingForDepthEstimationConfig,
        RBLNDistilBertForQuestionAnswering,
        RBLNDistilBertForQuestionAnsweringConfig,
        RBLNDPTForDepthEstimation,
        RBLNDPTForDepthEstimationConfig,
        RBLNExaoneForCausalLM,
        RBLNExaoneForCausalLMConfig,
        RBLNGemma3ForCausalLM,
        RBLNGemma3ForCausalLMConfig,
        RBLNGemma3ForConditionalGeneration,
        RBLNGemma3ForConditionalGenerationConfig,
        RBLNGemmaForCausalLM,
        RBLNGemmaForCausalLMConfig,
        RBLNGemmaModel,
        RBLNGemmaModelConfig,
        RBLNGPT2LMHeadModel,
        RBLNGPT2LMHeadModelConfig,
        RBLNGPT2Model,
        RBLNGPT2ModelConfig,
        RBLNGroundingDinoDecoder,
        RBLNGroundingDinoDecoderConfig,
        RBLNGroundingDinoEncoder,
        RBLNGroundingDinoEncoderConfig,
        RBLNGroundingDinoForObjectDetection,
        RBLNGroundingDinoForObjectDetectionConfig,
        RBLNIdefics3ForConditionalGeneration,
        RBLNIdefics3ForConditionalGenerationConfig,
        RBLNIdefics3VisionTransformer,
        RBLNIdefics3VisionTransformerConfig,
        RBLNLlamaForCausalLM,
        RBLNLlamaForCausalLMConfig,
        RBLNLlamaModel,
        RBLNLlamaModelConfig,
        RBLNLlavaForConditionalGeneration,
        RBLNLlavaForConditionalGenerationConfig,
        RBLNLlavaNextForConditionalGeneration,
        RBLNLlavaNextForConditionalGenerationConfig,
        RBLNMidmLMHeadModel,
        RBLNMidmLMHeadModelConfig,
        RBLNMistralForCausalLM,
        RBLNMistralForCausalLMConfig,
        RBLNMistralModel,
        RBLNMistralModelConfig,
        RBLNOPTForCausalLM,
        RBLNOPTForCausalLMConfig,
        RBLNOPTModel,
        RBLNOPTModelConfig,
        RBLNPegasusForConditionalGeneration,
        RBLNPegasusForConditionalGenerationConfig,
        RBLNPegasusModel,
        RBLNPegasusModelConfig,
        RBLNPhiForCausalLM,
        RBLNPhiForCausalLMConfig,
        RBLNPhiModel,
        RBLNPhiModelConfig,
        RBLNPixtralVisionModel,
        RBLNPixtralVisionModelConfig,
        RBLNQwen2_5_VisionTransformerPretrainedModel,
        RBLNQwen2_5_VisionTransformerPretrainedModelConfig,
        RBLNQwen2_5_VLForConditionalGeneration,
        RBLNQwen2_5_VLForConditionalGenerationConfig,
        RBLNQwen2ForCausalLM,
        RBLNQwen2ForCausalLMConfig,
        RBLNQwen2Model,
        RBLNQwen2ModelConfig,
        RBLNQwen2VisionTransformerPretrainedModel,
        RBLNQwen2VisionTransformerPretrainedModelConfig,
        RBLNQwen2VLForConditionalGeneration,
        RBLNQwen2VLForConditionalGenerationConfig,
        RBLNQwen3ForCausalLM,
        RBLNQwen3ForCausalLMConfig,
        RBLNQwen3Model,
        RBLNQwen3ModelConfig,
        RBLNResNetForImageClassification,
        RBLNResNetForImageClassificationConfig,
        RBLNRobertaForMaskedLM,
        RBLNRobertaForMaskedLMConfig,
        RBLNRobertaForSequenceClassification,
        RBLNRobertaForSequenceClassificationConfig,
        RBLNSiglipVisionModel,
        RBLNSiglipVisionModelConfig,
        RBLNSwinBackbone,
        RBLNSwinBackboneConfig,
        RBLNT5EncoderModel,
        RBLNT5EncoderModelConfig,
        RBLNT5ForConditionalGeneration,
        RBLNT5ForConditionalGenerationConfig,
        RBLNTimeSeriesTransformerForPrediction,
        RBLNTimeSeriesTransformerForPredictionConfig,
        RBLNViTForImageClassification,
        RBLNViTForImageClassificationConfig,
        RBLNWav2Vec2ForCTC,
        RBLNWav2Vec2ForCTCConfig,
        RBLNWhisperForConditionalGeneration,
        RBLNWhisperForConditionalGenerationConfig,
        RBLNXLMRobertaForSequenceClassification,
        RBLNXLMRobertaForSequenceClassificationConfig,
        RBLNXLMRobertaModel,
        RBLNXLMRobertaModelConfig,
    )

else:
    import sys

    sys.modules[__name__] = _LazyModule(
        __name__,
        globals()["__file__"],
        _import_structure,
        module_spec=__spec__,
        extra_objects={"__version__": __version__},
    )


check_version_compats()
