# ContrAI 🛰️

*A Python library for contrail detection and analysis using AI models.*


![ContrAI overlay example](images/example_overlay.png)

---

## 🧠 Features
- Automated contrail detection using deep learning  
- Image preprocessing and overlay visualization  
- Easy-to-use Python API  

---

## 🚀 Installation
Create a conda environment:

```bash
conda create -n contrai_env python=3.10
conda activate contrai_env
```

Install the latest released version from PyPI:

```bash
pip install -U contrai
```

---
## 🧠 Jupyter Notebook Examples

Explore how to use this package with ready-to-run notebooks:
- 📕 **[GOES-16 Data Download Example](notebooks/goes16_download.ipynb)**  
  Explores accessing and downloading GOES-16 ABI satellite imagery.

- 📘 **[Contrail Detection Example](notebooks/detect_contrails.ipynb)**  
  Demonstrates how to run a contrail detection model on a .png ash RGB image file.

- 📗 **[Polygon Dataset Visualization](notebooks/polygon_based_opencontrails.ipynb)**  
  Shows how to visualize and inspect the polygon-based contrail dataset.

---
### 🌍 Interactive Contrail Detection Demo
Click the button below to view the fully interactive contrail detection output visualization:

<p align="center">
  <a href="https://aircraft-operations-lab.github.io/ContrAI/notebooks/contrail_detection_demo.html" target="_blank">
    <img src="https://img.shields.io/badge/Open%20Interactive%20Demo-0078D4?style=for-the-badge&logo=google-earth&logoColor=white" alt="View Interactive Demo">
  </a>
</p>

---
## 📚 Citation

If you use this package in your research, please cite:

[![DOI](https://img.shields.io/badge/DOI-10.1109%2FXYZ.2025.11230580-blue)](https://doi.org/10.1109/TGRS.2025.3629628)

[![IEEE Xplore](https://img.shields.io/badge/View%20on-IEEE%20Xplore-blue)](https://ieeexplore.ieee.org/document/11230580)

---

## ⚖️ License

This project is licensed under the [Apache 2.0 License](./LICENSE).

---

## 👥 Community

We welcome feedback, discussions, and contributions!  
If you have suggestions, find a bug, or want to collaborate, feel free to open an issue or start a discussion.
 
[![Open Issues](https://img.shields.io/badge/issues-view-yellow)](https://github.com/irortiza/ContrAI/issues)  
[![Pull Requests](https://img.shields.io/badge/pull%20requests-view-orange)](https://github.com/irortiza/ContrAI/pulls)

---

**Note: This is the first release and will be updated soon with additional features for satellite contrail analysis and improvements to current capabilities.**

---

![ContrAI logo](images/contrai_logo.png)

<p align="center">
  <sub> 2025 ContrAI. </sub>
</p>