Module blaxel.core.client.models.runtime
========================================

Classes
-------

`Runtime(args: blaxel.core.client.types.Unset | list[typing.Any] = <blaxel.core.client.types.Unset object>, command: blaxel.core.client.types.Unset | list[typing.Any] = <blaxel.core.client.types.Unset object>, configuration: blaxel.core.client.types.Unset | ForwardRef('RuntimeConfiguration') = <blaxel.core.client.types.Unset object>, cpu: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, endpoint_name: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, envs: blaxel.core.client.types.Unset | list[typing.Any] = <blaxel.core.client.types.Unset object>, generation: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, image: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, max_concurrent_tasks: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, max_retries: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, max_scale: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, memory: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, metric_port: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, min_scale: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, model: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, organization: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, ports: blaxel.core.client.types.Unset | list['Port'] = <blaxel.core.client.types.Unset object>, startup_probe: blaxel.core.client.types.Unset | ForwardRef('RuntimeStartupProbe') = <blaxel.core.client.types.Unset object>, timeout: blaxel.core.client.types.Unset | int = <blaxel.core.client.types.Unset object>, type_: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>)`
:   Set of configurations for a deployment
    
    Attributes:
        args (Union[Unset, list[Any]]): The arguments to pass to the deployment runtime
        command (Union[Unset, list[Any]]): The command to run the deployment
        configuration (Union[Unset, RuntimeConfiguration]): The configuration for the deployment
        cpu (Union[Unset, int]): The CPU for the deployment in cores, only available for private cluster
        endpoint_name (Union[Unset, str]): Endpoint Name of the model. In case of hf_private_endpoint, it is the
            endpoint name. In case of hf_public_endpoint, it is not used.
        envs (Union[Unset, list[Any]]): The env variables to set in the deployment. Should be a list of Kubernetes
            EnvVar types
        generation (Union[Unset, str]): The generation of the deployment
        image (Union[Unset, str]): The Docker image for the deployment
        max_concurrent_tasks (Union[Unset, int]): The maximum number of concurrent task for an execution
        max_retries (Union[Unset, int]): The maximum number of retries for the deployment
        max_scale (Union[Unset, int]): The minimum number of replicas for the deployment. Can be 0 or 1 (in which case
            the deployment is always running in at least one location).
        memory (Union[Unset, int]): The memory for the deployment in MB
        metric_port (Union[Unset, int]): The port to serve the metrics on
        min_scale (Union[Unset, int]): The maximum number of replicas for the deployment.
        model (Union[Unset, str]): The slug name of the origin model at HuggingFace.
        organization (Union[Unset, str]): The organization of the model
        ports (Union[Unset, list['Port']]): Set of ports for a resource
        startup_probe (Union[Unset, RuntimeStartupProbe]): The readiness probe. Should be a Kubernetes Probe type
        timeout (Union[Unset, int]): The timeout for the deployment in seconds
        type_ (Union[Unset, str]): The type of origin for the deployment (hf_private_endpoint, hf_public_endpoint)
    
    Method generated by attrs for class Runtime.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties`
    :

    `args`
    :

    `command`
    :

    `configuration`
    :

    `cpu`
    :

    `endpoint_name`
    :

    `envs`
    :

    `generation`
    :

    `image`
    :

    `max_concurrent_tasks`
    :

    `max_retries`
    :

    `max_scale`
    :

    `memory`
    :

    `metric_port`
    :

    `min_scale`
    :

    `model`
    :

    `organization`
    :

    `ports`
    :

    `startup_probe`
    :

    `timeout`
    :

    `type_`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :