window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"emailsec": {"fullname": "emailsec", "modulename": "emailsec", "kind": "module", "doc": "<p><a href=\"https://builds.sr.ht/~tsileo/emailsec?\"><img src=\"https://builds.sr.ht/~tsileo/emailsec.svg\" alt=\"builds.sr.ht status\" /></a>\n<a href=\"https://pypi.org/project/emailsec/\"><img src=\"https://badge.fury.io/py/emailsec.svg\" alt=\"PyPI version\" /></a></p>\n\n<p><code>emailsec</code> authenticates incoming emails with SPF, DKIM, DMARC, and ARC.</p>\n\n<p><strong>This project is still in early development.</strong></p>\n\n<h2 id=\"authentication-protocols\">Authentication Protocols</h2>\n\n<ul>\n<li><p><strong>SPF</strong> (Sender Policy Framework) - <a href=\"https://tools.ietf.org/html/rfc7208\">RFC 7208</a><br />\nVerifies the sending IP address is authorized to send email for a domain</p></li>\n<li><p><strong>DKIM</strong> (DomainKeys Identified Mail) - <a href=\"https://tools.ietf.org/html/rfc6376\">RFC 6376</a><br />\nValidates email authenticity using cryptographic signatures</p></li>\n<li><p><strong>DMARC</strong> (Domain-based Message Authentication, Reporting, and Conformance) - <a href=\"https://tools.ietf.org/html/rfc7489\">RFC 7489</a><br />\nCombines SPF and DKIM results with policy enforcement</p></li>\n<li><p><strong>ARC</strong> (Authenticated Received Chain) - <a href=\"https://tools.ietf.org/html/rfc8617\">RFC 8617</a><br />\nPreserves authentication results across email forwarding</p></li>\n</ul>\n\n<h2 id=\"message-authentication\">Message Authentication</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">asyncio</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">emailsec</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">authenticate_message</span><span class=\"p\">,</span> <span class=\"n\">SMTPContext</span>\n<span class=\"o\">&gt;&gt;&gt;</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">smtp_ctx</span> <span class=\"o\">=</span> <span class=\"n\">SMTPContext</span><span class=\"p\">(</span>\n<span class=\"o\">...</span>     <span class=\"n\">sender_ip_address</span><span class=\"o\">=</span><span class=\"s2\">&quot;203.0.113.42&quot;</span><span class=\"p\">,</span>\n<span class=\"o\">...</span>     <span class=\"n\">client_hostname</span><span class=\"o\">=</span><span class=\"s2\">&quot;mail.example.com&quot;</span><span class=\"p\">,</span>\n<span class=\"o\">...</span>     <span class=\"n\">mail_from</span><span class=\"o\">=</span><span class=\"s2\">&quot;alice@example.com&quot;</span><span class=\"p\">,</span>\n<span class=\"o\">...</span> <span class=\"p\">)</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">raw_email</span> <span class=\"o\">=</span> <span class=\"sa\">b</span><span class=\"s2\">&quot;&quot;&quot;From: Alice &lt;alice@example.com&gt;</span>\n<span class=\"s2\">... To: Bob &lt;bob@company.com&gt;</span>\n<span class=\"s2\">... Subject: Hello from the conference</span>\n<span class=\"s2\">... Date: Mon, 27 Jan 2025 10:30:45 +0000</span>\n<span class=\"s2\">... Message-ID: &lt;20250127103045.4A8B2@mail.example.com&gt;</span>\n<span class=\"s2\">... Content-Type: text/plain; charset=UTF-8</span>\n<span class=\"s2\">... DKIM-Signature: v=1; a=rsa-sha256; c=relaxed/relaxed; d=example.com;</span>\n<span class=\"s2\">...     s=selector1; h=from:to:subject:date:message-id;</span>\n<span class=\"s2\">...     bh=eKhvPb2btxd7/zv/sYlR5Z4ws09I2c1WJzPa=;</span>\n<span class=\"s2\">...     b=C70Bf8rWjJZJt/RcOnoFJquifA1XNB/yiKVP==</span>\n<span class=\"s2\">...</span>\n<span class=\"s2\">... Hi Bob,</span>\n<span class=\"s2\">...</span>\n<span class=\"s2\">... Cheers,</span>\n<span class=\"s2\">... Alice</span>\n<span class=\"s2\">... &quot;&quot;&quot;</span>\n<span class=\"o\">&gt;&gt;&gt;</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">asyncio</span><span class=\"o\">.</span><span class=\"n\">run</span><span class=\"p\">(</span><span class=\"n\">authenticate_message</span><span class=\"p\">(</span><span class=\"n\">smtp_ctx</span><span class=\"p\">,</span> <span class=\"n\">raw_email</span><span class=\"p\">))</span>\n<span class=\"n\">AuthenticationResult</span><span class=\"p\">(</span>\n    <span class=\"n\">delivery_action</span><span class=\"o\">=&lt;</span><span class=\"n\">DeliveryAction</span><span class=\"o\">.</span><span class=\"n\">ACCEPT</span><span class=\"p\">:</span> <span class=\"s1\">&#39;accept&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span>\n    <span class=\"n\">spf_check</span><span class=\"o\">=</span><span class=\"n\">SPFCheck</span><span class=\"p\">(</span>\n        <span class=\"n\">result</span><span class=\"o\">=&lt;</span><span class=\"n\">SPFResult</span><span class=\"o\">.</span><span class=\"n\">PASS</span><span class=\"p\">:</span> <span class=\"s1\">&#39;pass&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span>\n        <span class=\"n\">domain</span><span class=\"o\">=</span><span class=\"s2\">&quot;example.com&quot;</span><span class=\"p\">,</span>\n        <span class=\"n\">sender_ip</span><span class=\"o\">=</span><span class=\"s2\">&quot;203.0.113.42&quot;</span><span class=\"p\">,</span>\n        <span class=\"n\">exp</span><span class=\"o\">=</span><span class=\"s2\">&quot;&quot;</span>\n    <span class=\"p\">),</span>\n    <span class=\"n\">dkim_check</span><span class=\"o\">=</span><span class=\"n\">DKIMCheck</span><span class=\"p\">(</span>\n        <span class=\"n\">result</span><span class=\"o\">=&lt;</span><span class=\"n\">DKIMResult</span><span class=\"o\">.</span><span class=\"n\">SUCCESS</span><span class=\"p\">:</span> <span class=\"s1\">&#39;SUCCESS&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span>\n        <span class=\"n\">domain</span><span class=\"o\">=</span><span class=\"s2\">&quot;example.com&quot;</span><span class=\"p\">,</span>\n        <span class=\"n\">selector</span><span class=\"o\">=</span><span class=\"s2\">&quot;selector1&quot;</span><span class=\"p\">,</span>\n        <span class=\"n\">signature</span><span class=\"o\">=</span><span class=\"p\">{</span>\n            <span class=\"s1\">&#39;v&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;1&#39;</span><span class=\"p\">,</span>\n            <span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;rsa-sha256&#39;</span><span class=\"p\">,</span>\n            <span class=\"s1\">&#39;c&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;relaxed/relaxed&#39;</span><span class=\"p\">,</span>\n            <span class=\"s1\">&#39;d&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;example.com&#39;</span><span class=\"p\">,</span>\n            <span class=\"s1\">&#39;h&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;from:to:subject:date:message-id&#39;</span><span class=\"p\">,</span>\n            <span class=\"s1\">&#39;s&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;selector1&#39;</span><span class=\"p\">,</span>\n            <span class=\"s1\">&#39;bh&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;eKhvPb2btxd7/zv/sYlR5Z4ws09I2c1WJzPa...&#39;</span><span class=\"p\">,</span>\n            <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;C70Bf8rWjJZJt/RcOnoFJquifA1XNB/yiKVP...&#39;</span>\n        <span class=\"p\">}</span>\n    <span class=\"p\">),</span>\n    <span class=\"n\">dmarc_check</span><span class=\"o\">=</span><span class=\"n\">DMARCCheck</span><span class=\"p\">(</span>\n        <span class=\"n\">result</span><span class=\"o\">=&lt;</span><span class=\"n\">DMARCResult</span><span class=\"o\">.</span><span class=\"n\">PASS</span><span class=\"p\">:</span> <span class=\"s1\">&#39;pass&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span>\n        <span class=\"n\">policy</span><span class=\"o\">=&lt;</span><span class=\"n\">DMARCPolicy</span><span class=\"o\">.</span><span class=\"n\">QUARANTINE</span><span class=\"p\">:</span> <span class=\"s1\">&#39;quarantine&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span>\n        <span class=\"n\">spf_aligned</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">,</span>\n        <span class=\"n\">dkim_aligned</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">,</span>\n        <span class=\"n\">arc_override_applied</span><span class=\"o\">=</span><span class=\"kc\">False</span>\n    <span class=\"p\">),</span>\n    <span class=\"n\">arc_check</span><span class=\"o\">=</span><span class=\"n\">ARCCheck</span><span class=\"p\">(</span>\n        <span class=\"n\">result</span><span class=\"o\">=&lt;</span><span class=\"n\">ARCChainStatus</span><span class=\"o\">.</span><span class=\"n\">NONE</span><span class=\"p\">:</span> <span class=\"s1\">&#39;none&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span>\n        <span class=\"n\">exp</span><span class=\"o\">=</span><span class=\"s2\">&quot;No ARC Sets&quot;</span><span class=\"p\">,</span>\n        <span class=\"n\">signer</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">,</span>\n        <span class=\"n\">aar_header</span><span class=\"o\">=</span><span class=\"kc\">None</span>\n    <span class=\"p\">)</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"sender-policy-framework\">Sender Policy Framework</h2>\n\n<p><a href=\"https://datatracker.ietf.org/doc/html/rfc7208\">RFC 7208</a>-compliant parser and checker.</p>\n\n<h3 id=\"parser\">Parser</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">emailsec.spf.parser</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">parse_record</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">parse_record</span><span class=\"p\">(</span><span class=\"s2\">&quot;v=spf1 +a mx/30 mx:example.org/30 -all&quot;</span><span class=\"p\">)</span>\n<span class=\"p\">[</span><span class=\"n\">A</span><span class=\"p\">(</span><span class=\"n\">qualifier</span><span class=\"o\">=&lt;</span><span class=\"n\">Qualifier</span><span class=\"o\">.</span><span class=\"n\">PASS</span><span class=\"p\">:</span> <span class=\"s1\">&#39;+&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">domain_spec</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">cidr</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">),</span>\n <span class=\"n\">MX</span><span class=\"p\">(</span><span class=\"n\">qualifier</span><span class=\"o\">=&lt;</span><span class=\"n\">Qualifier</span><span class=\"o\">.</span><span class=\"n\">PASS</span><span class=\"p\">:</span> <span class=\"s1\">&#39;+&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">domain_spec</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">cidr</span><span class=\"o\">=</span><span class=\"s1\">&#39;/30&#39;</span><span class=\"p\">),</span>\n <span class=\"n\">MX</span><span class=\"p\">(</span><span class=\"n\">qualifier</span><span class=\"o\">=&lt;</span><span class=\"n\">Qualifier</span><span class=\"o\">.</span><span class=\"n\">PASS</span><span class=\"p\">:</span> <span class=\"s1\">&#39;+&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">domain_spec</span><span class=\"o\">=</span><span class=\"s1\">&#39;example.org&#39;</span><span class=\"p\">,</span> <span class=\"n\">cidr</span><span class=\"o\">=</span><span class=\"s1\">&#39;/30&#39;</span><span class=\"p\">),</span>\n <span class=\"n\">All</span><span class=\"p\">(</span><span class=\"n\">qualifier</span><span class=\"o\">=&lt;</span><span class=\"n\">Qualifier</span><span class=\"o\">.</span><span class=\"n\">FAIL</span><span class=\"p\">:</span> <span class=\"s1\">&#39;-&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">)]</span>\n</code></pre>\n</div>\n\n<h3 id=\"checker\">Checker</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">asyncio</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">emailsec.spf</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">check_spf</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">asyncio</span><span class=\"o\">.</span><span class=\"n\">run</span><span class=\"p\">(</span><span class=\"n\">check_spf</span><span class=\"p\">(</span><span class=\"n\">sender_ip</span><span class=\"o\">=</span><span class=\"s2\">&quot;192.0.2.10&quot;</span><span class=\"p\">,</span> <span class=\"n\">sender</span><span class=\"o\">=</span><span class=\"s2\">&quot;hello@example.com&quot;</span><span class=\"p\">))</span>\n<span class=\"n\">SPFCheck</span><span class=\"p\">(</span><span class=\"n\">result</span><span class=\"o\">=&lt;</span><span class=\"n\">SPFResult</span><span class=\"o\">.</span><span class=\"n\">PASS</span><span class=\"p\">:</span> <span class=\"s1\">&#39;pass&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">domain</span><span class=\"o\">=</span><span class=\"s1\">&#39;example.com&#39;</span><span class=\"p\">,</span> <span class=\"n\">sender_ip</span><span class=\"o\">=</span><span class=\"s1\">&#39;192.0.2.10&#39;</span><span class=\"p\">,</span> <span class=\"n\">exp</span><span class=\"o\">=</span><span class=\"s1\">&#39;&#39;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"documentation\">Documentation</h2>\n\n<p>Project documentation is available at <a href=\"https://emailsec.hexa.ninja/\">https://emailsec.hexa.ninja/</a>.</p>\n\n<h2 id=\"contribution\">Contribution</h2>\n\n<p>Contributions are welcome but please open an issue to start a discussion before starting something consequent.</p>\n\n<h2 id=\"license\">License</h2>\n\n<p>Copyright (c) 2025 Thomas Sileo and contributors. Released under the MIT license.</p>\n"}, "emailsec.arc": {"fullname": "emailsec.arc", "modulename": "emailsec.arc", "kind": "module", "doc": "<p></p>\n"}, "emailsec.arc.check_arc": {"fullname": "emailsec.arc.check_arc", "modulename": "emailsec.arc", "qualname": "check_arc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span>,</span><span class=\"param\">\t<span class=\"n\">body_and_headers</span><span class=\"p\">:</span> <span class=\"n\">BodyAndHeaders</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">arc</span><span class=\"o\">.</span><span class=\"n\">ARCCheck</span>:</span></span>", "funcdef": "async def"}, "emailsec.arc.ARCCheck": {"fullname": "emailsec.arc.ARCCheck", "modulename": "emailsec.arc", "qualname": "ARCCheck", "kind": "class", "doc": "<p></p>\n"}, "emailsec.arc.ARCCheck.__init__": {"fullname": "emailsec.arc.ARCCheck.__init__", "modulename": "emailsec.arc", "qualname": "ARCCheck.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">result</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">arc</span><span class=\"o\">.</span><span class=\"n\">ARCChainStatus</span>,</span><span class=\"param\">\t<span class=\"n\">exp</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">signer</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">aar_header</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "emailsec.arc.ARCCheck.result": {"fullname": "emailsec.arc.ARCCheck.result", "modulename": "emailsec.arc", "qualname": "ARCCheck.result", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.arc.ARCChainStatus"}, "emailsec.arc.ARCCheck.exp": {"fullname": "emailsec.arc.ARCCheck.exp", "modulename": "emailsec.arc", "qualname": "ARCCheck.exp", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.arc.ARCCheck.signer": {"fullname": "emailsec.arc.ARCCheck.signer", "modulename": "emailsec.arc", "qualname": "ARCCheck.signer", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None", "default_value": "None"}, "emailsec.arc.ARCCheck.aar_header": {"fullname": "emailsec.arc.ARCCheck.aar_header", "modulename": "emailsec.arc", "qualname": "ARCCheck.aar_header", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bytes | None", "default_value": "None"}, "emailsec.arc.ARCChainStatus": {"fullname": "emailsec.arc.ARCChainStatus", "modulename": "emailsec.arc", "qualname": "ARCChainStatus", "kind": "class", "doc": "<p></p>\n", "bases": "enum.StrEnum"}, "emailsec.arc.ARCChainStatus.NONE": {"fullname": "emailsec.arc.ARCChainStatus.NONE", "modulename": "emailsec.arc", "qualname": "ARCChainStatus.NONE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;ARCChainStatus.NONE: &#x27;none&#x27;&gt;"}, "emailsec.arc.ARCChainStatus.FAIL": {"fullname": "emailsec.arc.ARCChainStatus.FAIL", "modulename": "emailsec.arc", "qualname": "ARCChainStatus.FAIL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;ARCChainStatus.FAIL: &#x27;fail&#x27;&gt;"}, "emailsec.arc.ARCChainStatus.PASS": {"fullname": "emailsec.arc.ARCChainStatus.PASS", "modulename": "emailsec.arc", "qualname": "ARCChainStatus.PASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;ARCChainStatus.PASS: &#x27;pass&#x27;&gt;"}, "emailsec.auth": {"fullname": "emailsec.auth", "modulename": "emailsec.auth", "kind": "module", "doc": "<p></p>\n"}, "emailsec.auth.authenticate_message": {"fullname": "emailsec.auth.authenticate_message", "modulename": "emailsec.auth", "qualname": "authenticate_message", "kind": "function", "doc": "<p>Authenticate an incoming email using SPF, DKIM, and DMARC.</p>\n\n<p>Authentication flow:</p>\n\n<ol>\n<li>SPF (RFC 7208): Verify the sending IP is authorized for the envelope sender domain</li>\n<li>DKIM (RFC 6376): Verify cryptographic signatures on the email</li>\n<li>ARC (RFC 8617): Check authentication chain if present (for forwarded mail)</li>\n<li>DMARC (RFC 7489): Evaluate if SPF/DKIM align with the From header domain</li>\n<li>Make delivery decision based on combined results</li>\n</ol>\n\n<p>Delivery decision logic following RFC 7489.</p>\n\n<ol>\n<li>DMARC policy is enforced first (if the sender has one)</li>\n<li>If DMARC passes, then accept</li>\n<li>If no DMARC or policy is \"none\", then check individual SPF/DKIM</li>\n<li>Default to quarantine for unauthenticated mail</li>\n</ol>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">smtp_context</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">auth</span><span class=\"o\">.</span><span class=\"n\">SMTPContext</span>,</span><span class=\"param\">\t<span class=\"n\">raw_email</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span>,</span><span class=\"param\">\t<span class=\"n\">configuration</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">config</span><span class=\"o\">.</span><span class=\"n\">AuthenticationConfiguration</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">auth</span><span class=\"o\">.</span><span class=\"n\">AuthenticationResult</span>:</span></span>", "funcdef": "async def"}, "emailsec.auth.AuthenticationResult": {"fullname": "emailsec.auth.AuthenticationResult", "modulename": "emailsec.auth", "qualname": "AuthenticationResult", "kind": "class", "doc": "<p></p>\n"}, "emailsec.auth.AuthenticationResult.__init__": {"fullname": "emailsec.auth.AuthenticationResult.__init__", "modulename": "emailsec.auth", "qualname": "AuthenticationResult.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">delivery_action</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">auth</span><span class=\"o\">.</span><span class=\"n\">DeliveryAction</span>,</span><span class=\"param\">\t<span class=\"n\">spf_check</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">spf</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">SPFCheck</span>,</span><span class=\"param\">\t<span class=\"n\">dkim_check</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dkim</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">DKIMCheck</span>,</span><span class=\"param\">\t<span class=\"n\">dmarc_check</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dmarc</span><span class=\"o\">.</span><span class=\"n\">DMARCCheck</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">arc_check</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">arc</span><span class=\"o\">.</span><span class=\"n\">ARCCheck</span></span>)</span>"}, "emailsec.auth.AuthenticationResult.delivery_action": {"fullname": "emailsec.auth.AuthenticationResult.delivery_action", "modulename": "emailsec.auth", "qualname": "AuthenticationResult.delivery_action", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.auth.DeliveryAction"}, "emailsec.auth.AuthenticationResult.spf_check": {"fullname": "emailsec.auth.AuthenticationResult.spf_check", "modulename": "emailsec.auth", "qualname": "AuthenticationResult.spf_check", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.spf.checker.SPFCheck"}, "emailsec.auth.AuthenticationResult.dkim_check": {"fullname": "emailsec.auth.AuthenticationResult.dkim_check", "modulename": "emailsec.auth", "qualname": "AuthenticationResult.dkim_check", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.dkim.checker.DKIMCheck"}, "emailsec.auth.AuthenticationResult.dmarc_check": {"fullname": "emailsec.auth.AuthenticationResult.dmarc_check", "modulename": "emailsec.auth", "qualname": "AuthenticationResult.dmarc_check", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.dmarc.DMARCCheck | None"}, "emailsec.auth.AuthenticationResult.arc_check": {"fullname": "emailsec.auth.AuthenticationResult.arc_check", "modulename": "emailsec.auth", "qualname": "AuthenticationResult.arc_check", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.arc.ARCCheck"}, "emailsec.auth.DeliveryAction": {"fullname": "emailsec.auth.DeliveryAction", "modulename": "emailsec.auth", "qualname": "DeliveryAction", "kind": "class", "doc": "<p>Final delivery results based on the authentication checks.</p>\n", "bases": "enum.Enum"}, "emailsec.auth.DeliveryAction.ACCEPT": {"fullname": "emailsec.auth.DeliveryAction.ACCEPT", "modulename": "emailsec.auth", "qualname": "DeliveryAction.ACCEPT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DeliveryAction.ACCEPT: &#x27;accept&#x27;&gt;"}, "emailsec.auth.DeliveryAction.QUARANTINE": {"fullname": "emailsec.auth.DeliveryAction.QUARANTINE", "modulename": "emailsec.auth", "qualname": "DeliveryAction.QUARANTINE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DeliveryAction.QUARANTINE: &#x27;quarantine&#x27;&gt;"}, "emailsec.auth.DeliveryAction.REJECT": {"fullname": "emailsec.auth.DeliveryAction.REJECT", "modulename": "emailsec.auth", "qualname": "DeliveryAction.REJECT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DeliveryAction.REJECT: &#x27;reject&#x27;&gt;"}, "emailsec.auth.DeliveryAction.DEFER": {"fullname": "emailsec.auth.DeliveryAction.DEFER", "modulename": "emailsec.auth", "qualname": "DeliveryAction.DEFER", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DeliveryAction.DEFER: &#x27;defer&#x27;&gt;"}, "emailsec.auth.SMTPContext": {"fullname": "emailsec.auth.SMTPContext", "modulename": "emailsec.auth", "qualname": "SMTPContext", "kind": "class", "doc": "<p>Context from the SMTP server processing the incoming email.</p>\n"}, "emailsec.auth.SMTPContext.__init__": {"fullname": "emailsec.auth.SMTPContext.__init__", "modulename": "emailsec.auth", "qualname": "SMTPContext.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">sender_ip_address</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">client_hostname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">mail_from</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, "emailsec.auth.SMTPContext.sender_ip_address": {"fullname": "emailsec.auth.SMTPContext.sender_ip_address", "modulename": "emailsec.auth", "qualname": "SMTPContext.sender_ip_address", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.auth.SMTPContext.client_hostname": {"fullname": "emailsec.auth.SMTPContext.client_hostname", "modulename": "emailsec.auth", "qualname": "SMTPContext.client_hostname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None"}, "emailsec.auth.SMTPContext.mail_from": {"fullname": "emailsec.auth.SMTPContext.mail_from", "modulename": "emailsec.auth", "qualname": "SMTPContext.mail_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.config": {"fullname": "emailsec.config", "modulename": "emailsec.config", "kind": "module", "doc": "<p></p>\n"}, "emailsec.config.AuthenticationConfiguration": {"fullname": "emailsec.config.AuthenticationConfiguration", "modulename": "emailsec.config", "qualname": "AuthenticationConfiguration", "kind": "class", "doc": "<p>Configuration items to tweak the authentication behavior.</p>\n"}, "emailsec.config.AuthenticationConfiguration.__init__": {"fullname": "emailsec.config.AuthenticationConfiguration.__init__", "modulename": "emailsec.config", "qualname": "AuthenticationConfiguration.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">trusted_arc_signers</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"fullname": "emailsec.config.AuthenticationConfiguration.trusted_arc_signers", "modulename": "emailsec.config", "qualname": "AuthenticationConfiguration.trusted_arc_signers", "kind": "variable", "doc": "<p>Trusted ARC signers that will enable overriding DMARC results with the\nauthentication results from ARC.</p>\n", "annotation": ": list[str] | None", "default_value": "None"}, "emailsec.dkim": {"fullname": "emailsec.dkim", "modulename": "emailsec.dkim", "kind": "module", "doc": "<p></p>\n"}, "emailsec.dkim.check_dkim": {"fullname": "emailsec.dkim.check_dkim", "modulename": "emailsec.dkim", "qualname": "check_dkim", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span>,</span><span class=\"param\">\t<span class=\"n\">body_and_headers</span><span class=\"p\">:</span> <span class=\"n\">BodyAndHeaders</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dkim</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">DKIMCheck</span>:</span></span>", "funcdef": "async def"}, "emailsec.dkim.DKIMCheck": {"fullname": "emailsec.dkim.DKIMCheck", "modulename": "emailsec.dkim", "qualname": "DKIMCheck", "kind": "class", "doc": "<p></p>\n"}, "emailsec.dkim.DKIMCheck.__init__": {"fullname": "emailsec.dkim.DKIMCheck.__init__", "modulename": "emailsec.dkim", "qualname": "DKIMCheck.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">result</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dkim</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">DKIMResult</span>,</span><span class=\"param\">\t<span class=\"n\">domain</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">selector</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">signature</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dkim</span><span class=\"o\">.</span><span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">DKIMSignature</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "emailsec.dkim.DKIMCheck.result": {"fullname": "emailsec.dkim.DKIMCheck.result", "modulename": "emailsec.dkim", "qualname": "DKIMCheck.result", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.dkim.checker.DKIMResult"}, "emailsec.dkim.DKIMCheck.domain": {"fullname": "emailsec.dkim.DKIMCheck.domain", "modulename": "emailsec.dkim", "qualname": "DKIMCheck.domain", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None", "default_value": "None"}, "emailsec.dkim.DKIMCheck.selector": {"fullname": "emailsec.dkim.DKIMCheck.selector", "modulename": "emailsec.dkim", "qualname": "DKIMCheck.selector", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None", "default_value": "None"}, "emailsec.dkim.DKIMCheck.signature": {"fullname": "emailsec.dkim.DKIMCheck.signature", "modulename": "emailsec.dkim", "qualname": "DKIMCheck.signature", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.dkim.parser.DKIMSignature | None", "default_value": "None"}, "emailsec.dkim.DKIMResult": {"fullname": "emailsec.dkim.DKIMResult", "modulename": "emailsec.dkim", "qualname": "DKIMResult", "kind": "class", "doc": "<p></p>\n", "bases": "enum.StrEnum"}, "emailsec.dkim.DKIMResult.SUCCESS": {"fullname": "emailsec.dkim.DKIMResult.SUCCESS", "modulename": "emailsec.dkim", "qualname": "DKIMResult.SUCCESS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DKIMResult.SUCCESS: &#x27;SUCCESS&#x27;&gt;"}, "emailsec.dkim.DKIMResult.PERMFAIL": {"fullname": "emailsec.dkim.DKIMResult.PERMFAIL", "modulename": "emailsec.dkim", "qualname": "DKIMResult.PERMFAIL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DKIMResult.PERMFAIL: &#x27;PERMFAIL&#x27;&gt;"}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"fullname": "emailsec.dkim.DKIMResult.TEMPFAIL", "modulename": "emailsec.dkim", "qualname": "DKIMResult.TEMPFAIL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DKIMResult.TEMPFAIL: &#x27;TEMPFAIL&#x27;&gt;"}, "emailsec.dkim.DKIMSignature": {"fullname": "emailsec.dkim.DKIMSignature", "modulename": "emailsec.dkim", "qualname": "DKIMSignature", "kind": "class", "doc": "<p></p>\n", "bases": "typing.TypedDict"}, "emailsec.dkim.DKIMSignature.v": {"fullname": "emailsec.dkim.DKIMSignature.v", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.v", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.dkim.DKIMSignature.a": {"fullname": "emailsec.dkim.DKIMSignature.a", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.a", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.dkim.DKIMSignature.b": {"fullname": "emailsec.dkim.DKIMSignature.b", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.b", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.dkim.DKIMSignature.bh": {"fullname": "emailsec.dkim.DKIMSignature.bh", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.bh", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.dkim.DKIMSignature.c": {"fullname": "emailsec.dkim.DKIMSignature.c", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.c", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "emailsec.dkim.DKIMSignature.d": {"fullname": "emailsec.dkim.DKIMSignature.d", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.d", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.dkim.DKIMSignature.h": {"fullname": "emailsec.dkim.DKIMSignature.h", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.h", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.dkim.DKIMSignature.i": {"fullname": "emailsec.dkim.DKIMSignature.i", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.i", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "emailsec.dkim.DKIMSignature.l": {"fullname": "emailsec.dkim.DKIMSignature.l", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.l", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "emailsec.dkim.DKIMSignature.q": {"fullname": "emailsec.dkim.DKIMSignature.q", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.q", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "emailsec.dkim.DKIMSignature.s": {"fullname": "emailsec.dkim.DKIMSignature.s", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.s", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.dkim.DKIMSignature.t": {"fullname": "emailsec.dkim.DKIMSignature.t", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.t", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "emailsec.dkim.DKIMSignature.x": {"fullname": "emailsec.dkim.DKIMSignature.x", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.x", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "emailsec.dkim.DKIMSignature.z": {"fullname": "emailsec.dkim.DKIMSignature.z", "modulename": "emailsec.dkim", "qualname": "DKIMSignature.z", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "emailsec.dmarc": {"fullname": "emailsec.dmarc", "modulename": "emailsec.dmarc", "kind": "module", "doc": "<p></p>\n"}, "emailsec.dmarc.check_dmarc": {"fullname": "emailsec.dmarc.check_dmarc", "modulename": "emailsec.dmarc", "qualname": "check_dmarc", "kind": "function", "doc": "<p>DMARC evaluation per RFC 7489 Section 3 (Identifier Alignment).</p>\n\n<p>RFC 7489: \"A message satisfies the DMARC checks if at least one of the supported\nauthentication mechanisms: 1. produces a 'pass' result, and 2. produces that\nresult based on an identifier that is in alignment\"</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">header_from</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">envelope_from</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">spf_check</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">spf</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">SPFCheck</span>,</span><span class=\"param\">\t<span class=\"n\">dkim_check</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dkim</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">DKIMCheck</span>,</span><span class=\"param\">\t<span class=\"n\">arc_check</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">arc</span><span class=\"o\">.</span><span class=\"n\">ARCCheck</span>,</span><span class=\"param\">\t<span class=\"n\">configuration</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">config</span><span class=\"o\">.</span><span class=\"n\">AuthenticationConfiguration</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dmarc</span><span class=\"o\">.</span><span class=\"n\">DMARCCheck</span>:</span></span>", "funcdef": "async def"}, "emailsec.dmarc.get_dmarc_policy": {"fullname": "emailsec.dmarc.get_dmarc_policy", "modulename": "emailsec.dmarc", "qualname": "get_dmarc_policy", "kind": "function", "doc": "<p>Fetch DMARC policy according to RFC 7489 Section 6.1.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">domain</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dmarc</span><span class=\"o\">.</span><span class=\"n\">DMARCRecord</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">DMARCResult</span><span class=\"o\">.</span><span class=\"n\">TEMPERROR</span><span class=\"p\">:</span> <span class=\"s1\">&#39;temperror&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">DMARCResult</span><span class=\"o\">.</span><span class=\"n\">PERMERROR</span><span class=\"p\">:</span> <span class=\"s1\">&#39;permerror&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "async def"}, "emailsec.dmarc.DMARCCheck": {"fullname": "emailsec.dmarc.DMARCCheck", "modulename": "emailsec.dmarc", "qualname": "DMARCCheck", "kind": "class", "doc": "<p></p>\n"}, "emailsec.dmarc.DMARCCheck.__init__": {"fullname": "emailsec.dmarc.DMARCCheck.__init__", "modulename": "emailsec.dmarc", "qualname": "DMARCCheck.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">result</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dmarc</span><span class=\"o\">.</span><span class=\"n\">DMARCResult</span>,</span><span class=\"param\">\t<span class=\"n\">policy</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dmarc</span><span class=\"o\">.</span><span class=\"n\">DMARCPolicy</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">spf_aligned</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dkim_aligned</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">arc_override_applied</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "emailsec.dmarc.DMARCCheck.result": {"fullname": "emailsec.dmarc.DMARCCheck.result", "modulename": "emailsec.dmarc", "qualname": "DMARCCheck.result", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.dmarc.DMARCResult"}, "emailsec.dmarc.DMARCCheck.policy": {"fullname": "emailsec.dmarc.DMARCCheck.policy", "modulename": "emailsec.dmarc", "qualname": "DMARCCheck.policy", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.dmarc.DMARCPolicy | None"}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"fullname": "emailsec.dmarc.DMARCCheck.spf_aligned", "modulename": "emailsec.dmarc", "qualname": "DMARCCheck.spf_aligned", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | None", "default_value": "None"}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"fullname": "emailsec.dmarc.DMARCCheck.dkim_aligned", "modulename": "emailsec.dmarc", "qualname": "DMARCCheck.dkim_aligned", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | None", "default_value": "None"}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"fullname": "emailsec.dmarc.DMARCCheck.arc_override_applied", "modulename": "emailsec.dmarc", "qualname": "DMARCCheck.arc_override_applied", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "False"}, "emailsec.dmarc.DMARCResult": {"fullname": "emailsec.dmarc.DMARCResult", "modulename": "emailsec.dmarc", "qualname": "DMARCResult", "kind": "class", "doc": "<p>Defined in RFC 7489 Section 11.2</p>\n", "bases": "enum.StrEnum"}, "emailsec.dmarc.DMARCResult.PASS": {"fullname": "emailsec.dmarc.DMARCResult.PASS", "modulename": "emailsec.dmarc", "qualname": "DMARCResult.PASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCResult.PASS: &#x27;pass&#x27;&gt;"}, "emailsec.dmarc.DMARCResult.FAIL": {"fullname": "emailsec.dmarc.DMARCResult.FAIL", "modulename": "emailsec.dmarc", "qualname": "DMARCResult.FAIL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCResult.FAIL: &#x27;fail&#x27;&gt;"}, "emailsec.dmarc.DMARCResult.NONE": {"fullname": "emailsec.dmarc.DMARCResult.NONE", "modulename": "emailsec.dmarc", "qualname": "DMARCResult.NONE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCResult.NONE: &#x27;none&#x27;&gt;"}, "emailsec.dmarc.DMARCResult.PERMERROR": {"fullname": "emailsec.dmarc.DMARCResult.PERMERROR", "modulename": "emailsec.dmarc", "qualname": "DMARCResult.PERMERROR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCResult.PERMERROR: &#x27;permerror&#x27;&gt;"}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"fullname": "emailsec.dmarc.DMARCResult.TEMPERROR", "modulename": "emailsec.dmarc", "qualname": "DMARCResult.TEMPERROR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCResult.TEMPERROR: &#x27;temperror&#x27;&gt;"}, "emailsec.dmarc.DMARCPolicy": {"fullname": "emailsec.dmarc.DMARCPolicy", "modulename": "emailsec.dmarc", "qualname": "DMARCPolicy", "kind": "class", "doc": "<p></p>\n", "bases": "enum.StrEnum"}, "emailsec.dmarc.DMARCPolicy.NONE": {"fullname": "emailsec.dmarc.DMARCPolicy.NONE", "modulename": "emailsec.dmarc", "qualname": "DMARCPolicy.NONE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCPolicy.NONE: &#x27;none&#x27;&gt;"}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"fullname": "emailsec.dmarc.DMARCPolicy.QUARANTINE", "modulename": "emailsec.dmarc", "qualname": "DMARCPolicy.QUARANTINE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCPolicy.QUARANTINE: &#x27;quarantine&#x27;&gt;"}, "emailsec.dmarc.DMARCPolicy.REJECT": {"fullname": "emailsec.dmarc.DMARCPolicy.REJECT", "modulename": "emailsec.dmarc", "qualname": "DMARCPolicy.REJECT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;DMARCPolicy.REJECT: &#x27;reject&#x27;&gt;"}, "emailsec.dmarc.DMARCRecord": {"fullname": "emailsec.dmarc.DMARCRecord", "modulename": "emailsec.dmarc", "qualname": "DMARCRecord", "kind": "class", "doc": "<p>Holds a parsed DMARC DNS record.</p>\n"}, "emailsec.dmarc.DMARCRecord.__init__": {"fullname": "emailsec.dmarc.DMARCRecord.__init__", "modulename": "emailsec.dmarc", "qualname": "DMARCRecord.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">policy</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">dmarc</span><span class=\"o\">.</span><span class=\"n\">DMARCPolicy</span>,</span><span class=\"param\">\t<span class=\"n\">spf_mode</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;relaxed&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strict&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dkim_mode</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;relaxed&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strict&#39;</span><span class=\"p\">]</span></span>)</span>"}, "emailsec.dmarc.DMARCRecord.policy": {"fullname": "emailsec.dmarc.DMARCRecord.policy", "modulename": "emailsec.dmarc", "qualname": "DMARCRecord.policy", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.dmarc.DMARCPolicy"}, "emailsec.dmarc.DMARCRecord.spf_mode": {"fullname": "emailsec.dmarc.DMARCRecord.spf_mode", "modulename": "emailsec.dmarc", "qualname": "DMARCRecord.spf_mode", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;relaxed&#x27;, &#x27;strict&#x27;]"}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"fullname": "emailsec.dmarc.DMARCRecord.dkim_mode", "modulename": "emailsec.dmarc", "qualname": "DMARCRecord.dkim_mode", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;relaxed&#x27;, &#x27;strict&#x27;]"}, "emailsec.spf": {"fullname": "emailsec.spf", "modulename": "emailsec.spf", "kind": "module", "doc": "<p></p>\n"}, "emailsec.spf.check_spf": {"fullname": "emailsec.spf.check_spf", "modulename": "emailsec.spf", "qualname": "check_spf", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">sender_ip</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">spf</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">SPFCheck</span>:</span></span>", "funcdef": "async def"}, "emailsec.spf.SPFCheck": {"fullname": "emailsec.spf.SPFCheck", "modulename": "emailsec.spf", "qualname": "SPFCheck", "kind": "class", "doc": "<p></p>\n"}, "emailsec.spf.SPFCheck.__init__": {"fullname": "emailsec.spf.SPFCheck.__init__", "modulename": "emailsec.spf", "qualname": "SPFCheck.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">result</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">spf</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">SPFResult</span>,</span><span class=\"param\">\t<span class=\"n\">domain</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">sender_ip</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">exp</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, "emailsec.spf.SPFCheck.result": {"fullname": "emailsec.spf.SPFCheck.result", "modulename": "emailsec.spf", "qualname": "SPFCheck.result", "kind": "variable", "doc": "<p></p>\n", "annotation": ": emailsec.spf.checker.SPFResult"}, "emailsec.spf.SPFCheck.domain": {"fullname": "emailsec.spf.SPFCheck.domain", "modulename": "emailsec.spf", "qualname": "SPFCheck.domain", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.spf.SPFCheck.sender_ip": {"fullname": "emailsec.spf.SPFCheck.sender_ip", "modulename": "emailsec.spf", "qualname": "SPFCheck.sender_ip", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.spf.SPFCheck.exp": {"fullname": "emailsec.spf.SPFCheck.exp", "modulename": "emailsec.spf", "qualname": "SPFCheck.exp", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "emailsec.spf.SPFResult": {"fullname": "emailsec.spf.SPFResult", "modulename": "emailsec.spf", "qualname": "SPFResult", "kind": "class", "doc": "<p></p>\n", "bases": "enum.StrEnum"}, "emailsec.spf.SPFResult.NONE": {"fullname": "emailsec.spf.SPFResult.NONE", "modulename": "emailsec.spf", "qualname": "SPFResult.NONE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;SPFResult.NONE: &#x27;none&#x27;&gt;"}, "emailsec.spf.SPFResult.NEUTRAL": {"fullname": "emailsec.spf.SPFResult.NEUTRAL", "modulename": "emailsec.spf", "qualname": "SPFResult.NEUTRAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;SPFResult.NEUTRAL: &#x27;neutral&#x27;&gt;"}, "emailsec.spf.SPFResult.PASS": {"fullname": "emailsec.spf.SPFResult.PASS", "modulename": "emailsec.spf", "qualname": "SPFResult.PASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;SPFResult.PASS: &#x27;pass&#x27;&gt;"}, "emailsec.spf.SPFResult.FAIL": {"fullname": "emailsec.spf.SPFResult.FAIL", "modulename": "emailsec.spf", "qualname": "SPFResult.FAIL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;SPFResult.FAIL: &#x27;fail&#x27;&gt;"}, "emailsec.spf.SPFResult.SOFTFAIL": {"fullname": "emailsec.spf.SPFResult.SOFTFAIL", "modulename": "emailsec.spf", "qualname": "SPFResult.SOFTFAIL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;SPFResult.SOFTFAIL: &#x27;softfail&#x27;&gt;"}, "emailsec.spf.SPFResult.TEMPERROR": {"fullname": "emailsec.spf.SPFResult.TEMPERROR", "modulename": "emailsec.spf", "qualname": "SPFResult.TEMPERROR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;SPFResult.TEMPERROR: &#x27;temperror&#x27;&gt;"}, "emailsec.spf.SPFResult.PERMERROR": {"fullname": "emailsec.spf.SPFResult.PERMERROR", "modulename": "emailsec.spf", "qualname": "SPFResult.PERMERROR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;SPFResult.PERMERROR: &#x27;permerror&#x27;&gt;"}, "emailsec.spf.SPFResult.from_qualifier": {"fullname": "emailsec.spf.SPFResult.from_qualifier", "modulename": "emailsec.spf", "qualname": "SPFResult.from_qualifier", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">q</span><span class=\"p\">:</span> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">spf</span><span class=\"o\">.</span><span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Qualifier</span></span><span class=\"return-annotation\">) -> <span class=\"n\">emailsec</span><span class=\"o\">.</span><span class=\"n\">spf</span><span class=\"o\">.</span><span class=\"n\">checker</span><span class=\"o\">.</span><span class=\"n\">SPFResult</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"emailsec": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1621}, "emailsec.arc": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.check_arc": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 3}, "emailsec.arc.ARCCheck": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.ARCCheck.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 3}, "emailsec.arc.ARCCheck.result": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.ARCCheck.exp": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.ARCCheck.signer": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.ARCCheck.aar_header": {"qualname": 3, "fullname": 5, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.ARCChainStatus": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "emailsec.arc.ARCChainStatus.NONE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.ARCChainStatus.FAIL": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.arc.ARCChainStatus.PASS": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.authenticate_message": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 87, "bases": 0, "doc": 142}, "emailsec.auth.AuthenticationResult": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.AuthenticationResult.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 130, "bases": 0, "doc": 3}, "emailsec.auth.AuthenticationResult.delivery_action": {"qualname": 3, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.AuthenticationResult.spf_check": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.AuthenticationResult.dkim_check": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.AuthenticationResult.dmarc_check": {"qualname": 3, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.AuthenticationResult.arc_check": {"qualname": 3, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.DeliveryAction": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "emailsec.auth.DeliveryAction.ACCEPT": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.DeliveryAction.QUARANTINE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.DeliveryAction.REJECT": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.DeliveryAction.DEFER": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.SMTPContext": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "emailsec.auth.SMTPContext.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 3}, "emailsec.auth.SMTPContext.sender_ip_address": {"qualname": 4, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.SMTPContext.client_hostname": {"qualname": 3, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.auth.SMTPContext.mail_from": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.config": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.config.AuthenticationConfiguration": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "emailsec.config.AuthenticationConfiguration.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 3}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"qualname": 4, "fullname": 6, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 18}, "emailsec.dkim": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.check_dkim": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 61, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMCheck": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMCheck.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 117, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMCheck.result": {"qualname": 2, "fullname": 4, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMCheck.domain": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMCheck.selector": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMCheck.signature": {"qualname": 2, "fullname": 4, "annotation": 7, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMResult": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "emailsec.dkim.DKIMResult.SUCCESS": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMResult.PERMFAIL": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "emailsec.dkim.DKIMSignature.v": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.a": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.b": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.bh": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.c": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.d": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.h": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.i": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.l": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.q": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.s": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.t": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.x": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dkim.DKIMSignature.z": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.check_dmarc": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 153, "bases": 0, "doc": 50}, "emailsec.dmarc.get_dmarc_policy": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 131, "bases": 0, "doc": 13}, "emailsec.dmarc.DMARCCheck": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCCheck.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 122, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCCheck.result": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCCheck.policy": {"qualname": 2, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"qualname": 3, "fullname": 5, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"qualname": 3, "fullname": 5, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"qualname": 4, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCResult": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 9}, "emailsec.dmarc.DMARCResult.PASS": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCResult.FAIL": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCResult.NONE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCResult.PERMERROR": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCPolicy": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "emailsec.dmarc.DMARCPolicy.NONE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCPolicy.REJECT": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCRecord": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "emailsec.dmarc.DMARCRecord.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 89, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCRecord.policy": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCRecord.spf_mode": {"qualname": 3, "fullname": 5, "annotation": 9, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"qualname": 3, "fullname": 5, "annotation": 9, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.check_spf": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 3}, "emailsec.spf.SPFCheck": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFCheck.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 3}, "emailsec.spf.SPFCheck.result": {"qualname": 2, "fullname": 4, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFCheck.domain": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFCheck.sender_ip": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFCheck.exp": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "emailsec.spf.SPFResult.NONE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult.NEUTRAL": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult.PASS": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult.FAIL": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult.SOFTFAIL": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult.TEMPERROR": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult.PERMERROR": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "emailsec.spf.SPFResult.from_qualifier": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 3}}, "length": 105, "save": true}, "index": {"qualname": {"root": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 8, "c": {"docs": {"emailsec.dkim.DKIMSignature.c": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}}, "df": 8}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.SMTPContext.client_hostname": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {"emailsec.dkim.DKIMSignature.a": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.arc.ARCCheck": {"tf": 1}, "emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.arc.ARCCheck.signer": {"tf": 1}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCChainStatus": {"tf": 1}, "emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1}}, "df": 4}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.aar_header": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.AuthenticationResult": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}}, "df": 7}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.config.AuthenticationConfiguration": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {"emailsec.dkim.DKIMSignature.i": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 8}}}, "p": {"docs": {"emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}}, "df": 4}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {"emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"emailsec.dkim.DKIMSignature.s": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.signer": {"tf": 1}}, "df": 1, "s": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dkim.DKIMCheck.signature": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {"emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.spf.SPFCheck": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}}, "df": 6}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.spf.SPFResult": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 9}}}}}}}}, "m": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.SMTPContext": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1}, "emailsec.auth.SMTPContext.mail_from": {"tf": 1}}, "df": 5}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dkim.DKIMCheck.selector": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {"emailsec.dkim.DKIMSignature.h": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.aar_header": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.SMTPContext.client_hostname": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.SMTPContext.mail_from": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCChainStatus.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}}, "df": 3}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.auth.SMTPContext.mail_from": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {"emailsec.dkim.DKIMSignature.d": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.DeliveryAction.DEFER": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.dkim.DKIMCheck": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}}, "df": 6}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dkim.DKIMResult": {"tf": 1}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dkim.DKIMSignature": {"tf": 1}, "emailsec.dkim.DKIMSignature.v": {"tf": 1}, "emailsec.dkim.DKIMSignature.a": {"tf": 1}, "emailsec.dkim.DKIMSignature.b": {"tf": 1}, "emailsec.dkim.DKIMSignature.bh": {"tf": 1}, "emailsec.dkim.DKIMSignature.c": {"tf": 1}, "emailsec.dkim.DKIMSignature.d": {"tf": 1}, "emailsec.dkim.DKIMSignature.h": {"tf": 1}, "emailsec.dkim.DKIMSignature.i": {"tf": 1}, "emailsec.dkim.DKIMSignature.l": {"tf": 1}, "emailsec.dkim.DKIMSignature.q": {"tf": 1}, "emailsec.dkim.DKIMSignature.s": {"tf": 1}, "emailsec.dkim.DKIMSignature.t": {"tf": 1}, "emailsec.dkim.DKIMSignature.x": {"tf": 1}, "emailsec.dkim.DKIMSignature.z": {"tf": 1}}, "df": 15}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 3, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.dmarc.DMARCCheck": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 7}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.DMARCResult": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}}, "df": 6}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCRecord": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 5}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.DMARCPolicy": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}}, "df": 4}}}}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}}, "df": 2}}}}}}, "q": {"docs": {"emailsec.dkim.DKIMSignature.q": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"emailsec.dkim.DKIMSignature.t": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}}, "df": 2}}}}}}}}}, "v": {"docs": {"emailsec.dkim.DKIMSignature.v": {"tf": 1}}, "df": 1}, "b": {"docs": {"emailsec.dkim.DKIMSignature.b": {"tf": 1}}, "df": 1, "h": {"docs": {"emailsec.dkim.DKIMSignature.bh": {"tf": 1}}, "df": 1}}, "l": {"docs": {"emailsec.dkim.DKIMSignature.l": {"tf": 1}}, "df": 1}, "x": {"docs": {"emailsec.dkim.DKIMSignature.x": {"tf": 1}}, "df": 1}, "z": {"docs": {"emailsec.dkim.DKIMSignature.z": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 1}}}}}}}}}}, "fullname": {"root": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 1}, "emailsec.arc": {"tf": 1}, "emailsec.arc.check_arc": {"tf": 1}, "emailsec.arc.ARCCheck": {"tf": 1}, "emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.arc.ARCCheck.signer": {"tf": 1}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1}, "emailsec.arc.ARCChainStatus": {"tf": 1}, "emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1}, "emailsec.auth": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.auth.AuthenticationResult": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1}, "emailsec.auth.SMTPContext": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1}, "emailsec.auth.SMTPContext.mail_from": {"tf": 1}, "emailsec.config": {"tf": 1}, "emailsec.config.AuthenticationConfiguration": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dkim": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dkim.DKIMCheck": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}, "emailsec.dkim.DKIMResult": {"tf": 1}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}, "emailsec.dkim.DKIMSignature": {"tf": 1}, "emailsec.dkim.DKIMSignature.v": {"tf": 1}, "emailsec.dkim.DKIMSignature.a": {"tf": 1}, "emailsec.dkim.DKIMSignature.b": {"tf": 1}, "emailsec.dkim.DKIMSignature.bh": {"tf": 1}, "emailsec.dkim.DKIMSignature.c": {"tf": 1}, "emailsec.dkim.DKIMSignature.d": {"tf": 1}, "emailsec.dkim.DKIMSignature.h": {"tf": 1}, "emailsec.dkim.DKIMSignature.i": {"tf": 1}, "emailsec.dkim.DKIMSignature.l": {"tf": 1}, "emailsec.dkim.DKIMSignature.q": {"tf": 1}, "emailsec.dkim.DKIMSignature.s": {"tf": 1}, "emailsec.dkim.DKIMSignature.t": {"tf": 1}, "emailsec.dkim.DKIMSignature.x": {"tf": 1}, "emailsec.dkim.DKIMSignature.z": {"tf": 1}, "emailsec.dmarc": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}, "emailsec.dmarc.DMARCPolicy": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}, "emailsec.dmarc.DMARCRecord": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}, "emailsec.spf": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}, "emailsec.spf.SPFCheck": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}, "emailsec.spf.SPFResult": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 105}}}}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {"emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}}, "df": 2}}}, "a": {"docs": {"emailsec.dkim.DKIMSignature.a": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.arc": {"tf": 1}, "emailsec.arc.check_arc": {"tf": 1.4142135623730951}, "emailsec.arc.ARCCheck": {"tf": 1}, "emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.arc.ARCCheck.signer": {"tf": 1}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1}, "emailsec.arc.ARCChainStatus": {"tf": 1}, "emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 15, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.arc.ARCCheck": {"tf": 1}, "emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.arc.ARCCheck.signer": {"tf": 1}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCChainStatus": {"tf": 1}, "emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1}}, "df": 4}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.aar_header": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"emailsec.auth": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.auth.AuthenticationResult": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1}, "emailsec.auth.SMTPContext": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1}, "emailsec.auth.SMTPContext.mail_from": {"tf": 1}}, "df": 19, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.AuthenticationResult": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}}, "df": 7}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.config.AuthenticationConfiguration": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {"emailsec.dkim.DKIMSignature.c": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}}, "df": 8}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.SMTPContext.client_hostname": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.config": {"tf": 1}, "emailsec.config.AuthenticationConfiguration": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {"emailsec.dkim.DKIMSignature.i": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 8}}}, "p": {"docs": {"emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}}, "df": 4}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {"emailsec.dkim.DKIMSignature.s": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.signer": {"tf": 1}}, "df": 1, "s": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dkim.DKIMCheck.signature": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {"emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.spf": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1.4142135623730951}, "emailsec.spf.SPFCheck": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}, "emailsec.spf.SPFResult": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 20, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.spf.SPFCheck": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}}, "df": 6}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.spf.SPFResult": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 9}}}}}}}}, "m": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.SMTPContext": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1}, "emailsec.auth.SMTPContext.mail_from": {"tf": 1}}, "df": 5}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dkim.DKIMCheck.selector": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {"emailsec.dkim.DKIMSignature.h": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.aar_header": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.SMTPContext.client_hostname": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.SMTPContext.mail_from": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCChainStatus.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}}, "df": 3}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.auth.SMTPContext.mail_from": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {"emailsec.dkim.DKIMSignature.d": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.DeliveryAction.DEFER": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.dkim": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMCheck": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}, "emailsec.dkim.DKIMResult": {"tf": 1}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}, "emailsec.dkim.DKIMSignature": {"tf": 1}, "emailsec.dkim.DKIMSignature.v": {"tf": 1}, "emailsec.dkim.DKIMSignature.a": {"tf": 1}, "emailsec.dkim.DKIMSignature.b": {"tf": 1}, "emailsec.dkim.DKIMSignature.bh": {"tf": 1}, "emailsec.dkim.DKIMSignature.c": {"tf": 1}, "emailsec.dkim.DKIMSignature.d": {"tf": 1}, "emailsec.dkim.DKIMSignature.h": {"tf": 1}, "emailsec.dkim.DKIMSignature.i": {"tf": 1}, "emailsec.dkim.DKIMSignature.l": {"tf": 1}, "emailsec.dkim.DKIMSignature.q": {"tf": 1}, "emailsec.dkim.DKIMSignature.s": {"tf": 1}, "emailsec.dkim.DKIMSignature.t": {"tf": 1}, "emailsec.dkim.DKIMSignature.x": {"tf": 1}, "emailsec.dkim.DKIMSignature.z": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 30, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.dkim.DKIMCheck": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}}, "df": 6}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dkim.DKIMResult": {"tf": 1}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dkim.DKIMSignature": {"tf": 1}, "emailsec.dkim.DKIMSignature.v": {"tf": 1}, "emailsec.dkim.DKIMSignature.a": {"tf": 1}, "emailsec.dkim.DKIMSignature.b": {"tf": 1}, "emailsec.dkim.DKIMSignature.bh": {"tf": 1}, "emailsec.dkim.DKIMSignature.c": {"tf": 1}, "emailsec.dkim.DKIMSignature.d": {"tf": 1}, "emailsec.dkim.DKIMSignature.h": {"tf": 1}, "emailsec.dkim.DKIMSignature.i": {"tf": 1}, "emailsec.dkim.DKIMSignature.l": {"tf": 1}, "emailsec.dkim.DKIMSignature.q": {"tf": 1}, "emailsec.dkim.DKIMSignature.s": {"tf": 1}, "emailsec.dkim.DKIMSignature.t": {"tf": 1}, "emailsec.dkim.DKIMSignature.x": {"tf": 1}, "emailsec.dkim.DKIMSignature.z": {"tf": 1}}, "df": 15}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.dmarc": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}, "emailsec.dmarc.DMARCPolicy": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}, "emailsec.dmarc.DMARCRecord": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 26, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.dmarc.DMARCCheck": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 7}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.DMARCResult": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}}, "df": 6}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCRecord": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 5}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.DMARCPolicy": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}}, "df": 4}}}}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}}, "df": 2}}}}}}, "q": {"docs": {"emailsec.dkim.DKIMSignature.q": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"emailsec.dkim.DKIMSignature.t": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}}, "df": 2}}}}}}}}}, "v": {"docs": {"emailsec.dkim.DKIMSignature.v": {"tf": 1}}, "df": 1}, "b": {"docs": {"emailsec.dkim.DKIMSignature.b": {"tf": 1}}, "df": 1, "h": {"docs": {"emailsec.dkim.DKIMSignature.bh": {"tf": 1}}, "df": 1}}, "l": {"docs": {"emailsec.dkim.DKIMSignature.l": {"tf": 1}}, "df": 1}, "x": {"docs": {"emailsec.dkim.DKIMSignature.x": {"tf": 1}}, "df": 1}, "z": {"docs": {"emailsec.dkim.DKIMSignature.z": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 1}}}}}}}}}}, "annotation": {"root": {"docs": {"emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.arc.ARCCheck.signer": {"tf": 1.4142135623730951}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1.4142135623730951}, "emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1.4142135623730951}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1.4142135623730951}, "emailsec.auth.SMTPContext.mail_from": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMSignature.v": {"tf": 1}, "emailsec.dkim.DKIMSignature.a": {"tf": 1}, "emailsec.dkim.DKIMSignature.b": {"tf": 1}, "emailsec.dkim.DKIMSignature.bh": {"tf": 1}, "emailsec.dkim.DKIMSignature.c": {"tf": 1}, "emailsec.dkim.DKIMSignature.d": {"tf": 1}, "emailsec.dkim.DKIMSignature.h": {"tf": 1}, "emailsec.dkim.DKIMSignature.i": {"tf": 1}, "emailsec.dkim.DKIMSignature.l": {"tf": 1}, "emailsec.dkim.DKIMSignature.q": {"tf": 1}, "emailsec.dkim.DKIMSignature.s": {"tf": 1}, "emailsec.dkim.DKIMSignature.t": {"tf": 1}, "emailsec.dkim.DKIMSignature.x": {"tf": 1}, "emailsec.dkim.DKIMSignature.z": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1.4142135623730951}, "emailsec.spf.SPFCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}}, "df": 43, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}}, "df": 12}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.arc.ARCCheck.result": {"tf": 1}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCCheck.result": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.arc_check": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.exp": {"tf": 1}, "emailsec.arc.ARCCheck.signer": {"tf": 1}, "emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1}, "emailsec.auth.SMTPContext.mail_from": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1}, "emailsec.dkim.DKIMSignature.v": {"tf": 1}, "emailsec.dkim.DKIMSignature.a": {"tf": 1}, "emailsec.dkim.DKIMSignature.b": {"tf": 1}, "emailsec.dkim.DKIMSignature.bh": {"tf": 1}, "emailsec.dkim.DKIMSignature.d": {"tf": 1}, "emailsec.dkim.DKIMSignature.h": {"tf": 1}, "emailsec.dkim.DKIMSignature.s": {"tf": 1}, "emailsec.spf.SPFCheck.domain": {"tf": 1}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1}, "emailsec.spf.SPFCheck.exp": {"tf": 1}}, "df": 17, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {"emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.spf.SPFCheck.result": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.arc.ARCCheck.signer": {"tf": 1}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}}, "df": 11}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dkim.DKIMSignature.c": {"tf": 1}, "emailsec.dkim.DKIMSignature.i": {"tf": 1}, "emailsec.dkim.DKIMSignature.q": {"tf": 1}, "emailsec.dkim.DKIMSignature.z": {"tf": 1}}, "df": 4}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dkim.DKIMSignature.l": {"tf": 1}, "emailsec.dkim.DKIMSignature.t": {"tf": 1}, "emailsec.dkim.DKIMSignature.x": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCCheck.aar_header": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 3}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}}, "df": 3, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dkim.DKIMCheck.result": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dkim.DKIMCheck.signature": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.DMARCCheck.result": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.DMARCCheck.policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1}}, "df": 2}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.AuthenticationResult.spf_check": {"tf": 1}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1}, "emailsec.dkim.DKIMCheck.result": {"tf": 1}, "emailsec.spf.SPFCheck.result": {"tf": 1}}, "df": 4}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dkim.DKIMCheck.signature": {"tf": 1}}, "df": 1}}}}}}, "x": {"2": {"7": {"docs": {"emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 2}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 2}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1}}, "df": 2}}}}}}}}}, "default_value": {"root": {"docs": {"emailsec.arc.ARCChainStatus.NONE": {"tf": 1.4142135623730951}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1.4142135623730951}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.NONE": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.PASS": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.FAIL": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1.4142135623730951}}, "df": 25, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.arc.ARCCheck.signer": {"tf": 1}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1}, "emailsec.arc.ARCChainStatus.NONE": {"tf": 1.4142135623730951}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.NONE": {"tf": 1.4142135623730951}}, "df": 12}}}, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.spf.SPFResult.NEUTRAL": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}}, "df": 25}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1}}, "df": 3}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "x": {"2": {"7": {"docs": {"emailsec.arc.ARCChainStatus.NONE": {"tf": 1.4142135623730951}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1.4142135623730951}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.NONE": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.PASS": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.FAIL": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1.4142135623730951}}, "df": 25}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "g": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.arc.ARCChainStatus.NONE": {"tf": 1}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}, "emailsec.spf.SPFResult.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}}, "df": 25}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.arc.ARCChainStatus.FAIL": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.FAIL": {"tf": 1.4142135623730951}}, "df": 3}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCChainStatus.PASS": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.PASS": {"tf": 1.4142135623730951}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.DeliveryAction.DEFER": {"tf": 1.4142135623730951}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1}}, "df": 3}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.DMARCResult.PASS": {"tf": 1}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1}}, "df": 5}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1}}, "df": 3}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.DeliveryAction.REJECT": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.spf.SPFResult.NONE": {"tf": 1}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1}, "emailsec.spf.SPFResult.PASS": {"tf": 1}, "emailsec.spf.SPFResult.FAIL": {"tf": 1}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1}}, "df": 7}}}}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1.4142135623730951}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}}, "signature": {"root": {"3": {"9": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 2}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 2.8284271247461903}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"emailsec.arc.check_arc": {"tf": 6.708203932499369}, "emailsec.arc.ARCCheck.__init__": {"tf": 8.366600265340756}, "emailsec.auth.authenticate_message": {"tf": 8.366600265340756}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 10.099504938362077}, "emailsec.auth.SMTPContext.__init__": {"tf": 5.744562646538029}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 5.291502622129181}, "emailsec.dkim.check_dkim": {"tf": 7}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 9.848857801796104}, "emailsec.dmarc.check_dmarc": {"tf": 11}, "emailsec.dmarc.get_dmarc_policy": {"tf": 10.14889156509222}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 9.899494936611665}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 8.18535277187245}, "emailsec.spf.check_spf": {"tf": 6}, "emailsec.spf.SPFCheck.__init__": {"tf": 7.211102550927978}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 6.6332495807108}}, "df": 15, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.auth.SMTPContext.__init__": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCRecord.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dmarc.DMARCCheck.__init__": {"tf": 1.7320508075688772}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1.4142135623730951}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}}, "df": 6, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.auth.SMTPContext.__init__": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCCheck.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2, "s": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.SMTPContext.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.arc.check_arc": {"tf": 1.4142135623730951}, "emailsec.arc.ARCCheck.__init__": {"tf": 2}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1.4142135623730951}, "emailsec.dkim.check_dkim": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 2.449489742783178}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 2.23606797749979}}, "df": 11, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.arc.check_arc": {"tf": 1}, "emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1.7320508075688772}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 2.23606797749979}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 2.23606797749979}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1.4142135623730951}}, "df": 13}}}}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCRecord.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "w": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1.4142135623730951}, "emailsec.auth.SMTPContext.__init__": {"tf": 1.7320508075688772}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1.4142135623730951}, "emailsec.spf.SPFCheck.__init__": {"tf": 1.7320508075688772}}, "df": 8, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.DMARCRecord.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.arc.ARCCheck.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dkim.DKIMCheck.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1.4142135623730951}}, "df": 7, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1.4142135623730951}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dkim.DKIMCheck.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 2}, "emailsec.dmarc.check_dmarc": {"tf": 1.7320508075688772}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1.4142135623730951}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.spf.check_spf": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 7}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.SMTPContext.__init__": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1.4142135623730951}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}}, "df": 6, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.dkim.check_dkim": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dkim.DKIMCheck.__init__": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dkim.DKIMCheck.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}}, "df": 5, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.auth.AuthenticationResult.__init__": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.spf.check_spf": {"tf": 1}, "emailsec.spf.SPFCheck.__init__": {"tf": 1}}, "df": 3}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.SMTPContext.__init__": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "t": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1.4142135623730951}}, "df": 1}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dkim.DKIMCheck.__init__": {"tf": 1}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.dmarc.DMARCCheck.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "q": {"docs": {"emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.spf.SPFResult.from_qualifier": {"tf": 1}}, "df": 1}}}}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.arc.ARCChainStatus": {"tf": 1}, "emailsec.auth.DeliveryAction": {"tf": 1.4142135623730951}, "emailsec.dkim.DKIMResult": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}, "emailsec.dmarc.DMARCPolicy": {"tf": 1}, "emailsec.spf.SPFResult": {"tf": 1}}, "df": 6}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.arc.ARCChainStatus": {"tf": 1}, "emailsec.dkim.DKIMResult": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}, "emailsec.dmarc.DMARCPolicy": {"tf": 1}, "emailsec.spf.SPFResult": {"tf": 1}}, "df": 5}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.dkim.DKIMSignature": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dkim.DKIMSignature": {"tf": 1}}, "df": 1}}}}}}}}}}}, "doc": {"root": {"0": {"0": {"0": {"0": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"emailsec": {"tf": 2}}, "df": 1}, "1": {"0": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, ":": {"3": {"0": {"docs": {}, "df": 0, ":": {"4": {"5": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "1": {"3": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {"emailsec.dmarc.DMARCResult": {"tf": 1}}, "df": 1}, "9": {"2": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 3}, "2": {"0": {"2": {"5": {"0": {"1": {"2": {"7": {"1": {"0": {"3": {"0": {"4": {"5": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "3": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "7": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}}, "df": 3}, "3": {"0": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "9": {"docs": {"emailsec": {"tf": 8.12403840463596}}, "df": 1}, "docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}, "4": {"2": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0, "a": {"8": {"docs": {}, "df": 0, "b": {"2": {"docs": {}, "df": 0, "@": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}, "6": {"3": {"7": {"6": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}, "7": {"2": {"0": {"8": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "4": {"8": {"9": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}}, "df": 5}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "8": {"6": {"1": {"7": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {"emailsec": {"tf": 32.526911934581186}, "emailsec.arc": {"tf": 1.7320508075688772}, "emailsec.arc.check_arc": {"tf": 1.7320508075688772}, "emailsec.arc.ARCCheck": {"tf": 1.7320508075688772}, "emailsec.arc.ARCCheck.__init__": {"tf": 1.7320508075688772}, "emailsec.arc.ARCCheck.result": {"tf": 1.7320508075688772}, "emailsec.arc.ARCCheck.exp": {"tf": 1.7320508075688772}, "emailsec.arc.ARCCheck.signer": {"tf": 1.7320508075688772}, "emailsec.arc.ARCCheck.aar_header": {"tf": 1.7320508075688772}, "emailsec.arc.ARCChainStatus": {"tf": 1.7320508075688772}, "emailsec.arc.ARCChainStatus.NONE": {"tf": 1.7320508075688772}, "emailsec.arc.ARCChainStatus.FAIL": {"tf": 1.7320508075688772}, "emailsec.arc.ARCChainStatus.PASS": {"tf": 1.7320508075688772}, "emailsec.auth": {"tf": 1.7320508075688772}, "emailsec.auth.authenticate_message": {"tf": 6.324555320336759}, "emailsec.auth.AuthenticationResult": {"tf": 1.7320508075688772}, "emailsec.auth.AuthenticationResult.__init__": {"tf": 1.7320508075688772}, "emailsec.auth.AuthenticationResult.delivery_action": {"tf": 1.7320508075688772}, "emailsec.auth.AuthenticationResult.spf_check": {"tf": 1.7320508075688772}, "emailsec.auth.AuthenticationResult.dkim_check": {"tf": 1.7320508075688772}, "emailsec.auth.AuthenticationResult.dmarc_check": {"tf": 1.7320508075688772}, "emailsec.auth.AuthenticationResult.arc_check": {"tf": 1.7320508075688772}, "emailsec.auth.DeliveryAction": {"tf": 1.7320508075688772}, "emailsec.auth.DeliveryAction.ACCEPT": {"tf": 1.7320508075688772}, "emailsec.auth.DeliveryAction.QUARANTINE": {"tf": 1.7320508075688772}, "emailsec.auth.DeliveryAction.REJECT": {"tf": 1.7320508075688772}, "emailsec.auth.DeliveryAction.DEFER": {"tf": 1.7320508075688772}, "emailsec.auth.SMTPContext": {"tf": 1.7320508075688772}, "emailsec.auth.SMTPContext.__init__": {"tf": 1.7320508075688772}, "emailsec.auth.SMTPContext.sender_ip_address": {"tf": 1.7320508075688772}, "emailsec.auth.SMTPContext.client_hostname": {"tf": 1.7320508075688772}, "emailsec.auth.SMTPContext.mail_from": {"tf": 1.7320508075688772}, "emailsec.config": {"tf": 1.7320508075688772}, "emailsec.config.AuthenticationConfiguration": {"tf": 1.7320508075688772}, "emailsec.config.AuthenticationConfiguration.__init__": {"tf": 1.7320508075688772}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1.7320508075688772}, "emailsec.dkim": {"tf": 1.7320508075688772}, "emailsec.dkim.check_dkim": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMCheck": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMCheck.__init__": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMCheck.result": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMCheck.domain": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMCheck.selector": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMCheck.signature": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMResult": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMResult.SUCCESS": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMResult.PERMFAIL": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMResult.TEMPFAIL": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.v": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.a": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.b": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.bh": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.c": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.d": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.h": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.i": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.l": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.q": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.s": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.t": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.x": {"tf": 1.7320508075688772}, "emailsec.dkim.DKIMSignature.z": {"tf": 1.7320508075688772}, "emailsec.dmarc": {"tf": 1.7320508075688772}, "emailsec.dmarc.check_dmarc": {"tf": 2.449489742783178}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCCheck": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCCheck.__init__": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCCheck.result": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCCheck.policy": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCCheck.spf_aligned": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCCheck.dkim_aligned": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCCheck.arc_override_applied": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCResult": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCResult.PASS": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCResult.FAIL": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCResult.NONE": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCResult.PERMERROR": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCResult.TEMPERROR": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCPolicy": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCPolicy.NONE": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCPolicy.QUARANTINE": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCPolicy.REJECT": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCRecord": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCRecord.__init__": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCRecord.policy": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCRecord.spf_mode": {"tf": 1.7320508075688772}, "emailsec.dmarc.DMARCRecord.dkim_mode": {"tf": 1.7320508075688772}, "emailsec.spf": {"tf": 1.7320508075688772}, "emailsec.spf.check_spf": {"tf": 1.7320508075688772}, "emailsec.spf.SPFCheck": {"tf": 1.7320508075688772}, "emailsec.spf.SPFCheck.__init__": {"tf": 1.7320508075688772}, "emailsec.spf.SPFCheck.result": {"tf": 1.7320508075688772}, "emailsec.spf.SPFCheck.domain": {"tf": 1.7320508075688772}, "emailsec.spf.SPFCheck.sender_ip": {"tf": 1.7320508075688772}, "emailsec.spf.SPFCheck.exp": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.NONE": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.NEUTRAL": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.PASS": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.FAIL": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.SOFTFAIL": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.TEMPERROR": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.PERMERROR": {"tf": 1.7320508075688772}, "emailsec.spf.SPFResult.from_qualifier": {"tf": 1.7320508075688772}}, "df": 105, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec": {"tf": 2.23606797749979}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.auth.SMTPContext": {"tf": 1}}, "df": 3, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 2}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 2.8284271247461903}}, "df": 1}}}}}, "p": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1}}, "k": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "b": {"2": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "d": {"7": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"5": {"docs": {}, "df": 0, "z": {"4": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"0": {"9": {"docs": {}, "df": 0, "i": {"2": {"docs": {}, "df": 0, "c": {"1": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}}}}}}}}, "docs": {}, "df": 0}}}}}, "docs": {}, "df": 0}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {"emailsec": {"tf": 2.449489742783178}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCRecord": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "d": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 2}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.config.AuthenticationConfiguration": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 6, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}}}}}}}, "n": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 3, "d": {"docs": {"emailsec": {"tf": 2.23606797749979}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 3}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 2.23606797749979}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1.4142135623730951}}, "df": 3, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"emailsec": {"tf": 2}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "@": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "l": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {"emailsec": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}}, "df": 3, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.auth.SMTPContext": {"tf": 1}}, "df": 3}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {"emailsec": {"tf": 1.7320508075688772}, "emailsec.auth.authenticate_message": {"tf": 1.7320508075688772}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"emailsec": {"tf": 2.23606797749979}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}, "d": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "r": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 2.23606797749979}}, "df": 1}}}}}, "f": {"docs": {"emailsec.auth.authenticate_message": {"tf": 2.23606797749979}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.config.AuthenticationConfiguration": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "p": {"docs": {}, "df": 0, "f": {"1": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {"emailsec": {"tf": 3}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 2, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 2.6457513110645907}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"1": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1}, "docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.auth.SMTPContext": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 1}}, "df": 1, "s": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.auth.SMTPContext": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"2": {"5": {"6": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}}}}}}}}, "d": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {"emailsec": {"tf": 2.449489742783178}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 2, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 1.7320508075688772}, "emailsec.auth.authenticate_message": {"tf": 2.23606797749979}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCRecord": {"tf": 1}}, "df": 6, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.dmarc.DMARCResult": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 2.8284271247461903}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 2, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dmarc.DMARCRecord": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "e": {"docs": {"emailsec": {"tf": 1.7320508075688772}, "emailsec.auth.authenticate_message": {"tf": 2.23606797749979}, "emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.auth.SMTPContext": {"tf": 1.4142135623730951}, "emailsec.config.AuthenticationConfiguration": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}}, "df": 7, "n": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}}, "df": 2}}}, "o": {"docs": {"emailsec": {"tf": 1.7320508075688772}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.config.AuthenticationConfiguration": {"tf": 1}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 4}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {"emailsec.config.AuthenticationConfiguration": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.auth.SMTPContext": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"emailsec": {"tf": 2}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 3}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "r": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1}, "d": {"docs": {"emailsec.dmarc.DMARCRecord": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"emailsec": {"tf": 2.449489742783178}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.auth.SMTPContext": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 4, ":": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1.7320508075688772}}, "df": 2, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"emailsec.auth.DeliveryAction": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"emailsec.dmarc.get_dmarc_policy": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 2.23606797749979}, "emailsec.auth.authenticate_message": {"tf": 2.23606797749979}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}, "emailsec.dmarc.get_dmarc_policy": {"tf": 1}, "emailsec.dmarc.DMARCResult": {"tf": 1}}, "df": 5}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 2.23606797749979}, "emailsec.dmarc.check_dmarc": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1.4142135623730951}}, "df": 4}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.dmarc.DMARCRecord": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "w": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {}, "df": 0, "a": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}, "v": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"emailsec": {"tf": 1.7320508075688772}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 2}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 2.23606797749979}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "x": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "/": {"3": {"0": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, ":": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "f": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "c": {"7": {"0": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "f": {"8": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"1": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "p": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "docs": {}, "df": 0}}}}}}}}}}}}}}}}}}}}}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}, "docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec.config.AuthenticationConfiguration": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.auth.SMTPContext": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {"emailsec": {"tf": 3.3166247903554}}, "df": 1, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "d": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"emailsec": {"tf": 2.449489742783178}, "emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {"emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "x": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1}}}}, "b": {"docs": {"emailsec": {"tf": 1.7320508075688772}}, "df": 1, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "@": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}}, "h": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}, "u": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"emailsec.config.AuthenticationConfiguration": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 7.0710678118654755}}, "df": 1}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 5.477225575051661}}, "df": 1}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 2.8284271247461903}}, "df": 1}}}}}}}}}, "h": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.dmarc.DMARCRecord": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {"emailsec": {"tf": 1}}, "df": 1, "@": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}}, "x": {"docs": {}, "df": 0, "a": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "i": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {"emailsec": {"tf": 3.7416573867739413}}, "df": 1}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"emailsec.config.AuthenticationConfiguration.trusted_arc_signers": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}}, "df": 1, "g": {"docs": {"emailsec": {"tf": 1}}, "df": 1, "/": {"3": {"0": {"docs": {"emailsec": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1.4142135623730951}, "emailsec.auth.DeliveryAction": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 3, "e": {"docs": {"emailsec.auth.authenticate_message": {"tf": 1}, "emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 2}}, "f": {"docs": {"emailsec.dmarc.check_dmarc": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "o": {"docs": {"emailsec": {"tf": 1}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "e": {"docs": {"emailsec": {"tf": 2.6457513110645907}, "emailsec.auth.authenticate_message": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "a": {"docs": {"emailsec": {"tf": 1}}, "df": 1}}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();