import { ManagedInstanceRole } from '@renovosolutions/cdk-library-managed-instance-role';
import { aws_ec2 as ec2, aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface InstanceServiceProps {
    /**
     * The name of the service this instance service will host.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The VPC to launch this service in.
     *
     * @stability stable
     */
    readonly vpc: ec2.Vpc;
    /**
     * The subnet type to launch this service in.
     *
     * @default ec2.SubnetType.PRIVATE
     * @stability stable
     */
    readonly subnetType?: ec2.SubnetType;
    /**
     * The Amazon Machine Image (AMI) to launch the target instance with.
     *
     * @stability stable
     */
    readonly ami: ec2.IMachineImage;
    /**
     * Whether or not to enable logging to Cloudwatch Logs.
     *
     * @default true
     * @stability stable
     */
    readonly enableCloudwatchLogs?: boolean;
    /**
     * Allow all outbound traffic for the instances security group.
     *
     * @default true
     * @stability stable
     */
    readonly allowAllOutbound?: boolean;
    /**
     * Whether to disable inline ingress and egress rule optimization for the instances security group.
     *
     * If this is set to true, ingress and egress rules will not be declared under the SecurityGroup in cloudformation, but will be separate elements.
     *
     * Inlining rules is an optimization for producing smaller stack templates.
     * Sometimes this is not desirable, for example when security group access is managed via tags.
     *
     * The default value can be overriden globally by setting the context variable '@aws-cdk/aws-ec2.securityGroupDisableInlineRules'.
     *
     * @default false
     * @stability stable
     */
    readonly disableInlineRules?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access to remote management ports: SSH, RDP, WinRM, WinRM over HTTPs.
     *
     * If these ports are opened when this is enabled an error will be added to CDK metadata and deployment and synth will fail.
     *
     * @default true
     * @stability stable
     */
    readonly enableNoRemoteManagementPortsAspect?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access to relational DB ports: MySQL, PostgreSQL, MariaDB, Oracle, SQL Server.
     *
     * If these ports are opened when this is enabled an error will be added to CDK metadata and deployment and synth will fail.
     *
     * @default true
     * @stability stable
     */
    readonly enableNoDBPortsAspect?: boolean;
    /**
     * Whether or not to prevent security group from containing rules that allow access from the public internet: Any rule with a source from 0.0.0.0/0 or ::/0.
     *
     * If these sources are used when this is enabled and error will be added to CDK metadata and deployment and synth will fail.
     *
     * @stability stable
     */
    readonly enabledNoPublicIngressAspect?: boolean;
}
/**
 * @stability stable
 */
export interface ManagedLoggingPolicyProps {
    /**
     * The OS of the instance this policy is for.
     *
     * @stability stable
     */
    readonly os: string;
}
/**
 * @stability stable
 */
export interface AmiLookup {
    /**
     * The name string to use for AMI lookup.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The owners to use for AMI lookup.
     *
     * @stability stable
     */
    readonly owners?: string[];
    /**
     * Is this AMI expected to be windows?
     *
     * @stability stable
     */
    readonly windows?: boolean;
}
export declare function ec2ImageToOsString(stack: Construct, image: ec2.IMachineImage): string;
/**
 * @stability stable
 */
export declare class ManagedLoggingPolicy extends Construct {
    /**
     * @stability stable
     */
    readonly policy: iam.ManagedPolicy;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ManagedLoggingPolicyProps);
}
/**
 * @stability stable
 */
export declare class InstanceService extends Construct {
    /**
     * @stability stable
     */
    readonly instanceProfile: ManagedInstanceRole;
    /**
     * @stability stable
     */
    readonly securityGroup: ec2.SecurityGroup;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: InstanceServiceProps);
}
