"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceService = exports.ManagedLoggingPolicy = exports.ec2ImageToOsString = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_aspects_library_security_group_1 = require("@renovosolutions/cdk-aspects-library-security-group");
const cdk_library_managed_instance_role_1 = require("@renovosolutions/cdk-library-managed-instance-role");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function ec2ImageToOsString(stack, image) {
    return aws_cdk_lib_1.aws_ec2.OperatingSystemType[image.getImage(stack).osType].toLowerCase();
}
exports.ec2ImageToOsString = ec2ImageToOsString;
/**
 * @stability stable
 */
class ManagedLoggingPolicy extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (!(props.os.toLowerCase() == 'windows') && !(props.os.toLowerCase() == 'linux')) {
            throw new Error(`The os property for ManagedLoggingPolicy must be windows or linux and you gave: ${props.os.toLowerCase()}`);
        }
        let logResources = [];
        const logGroups = [
            `/${props.os}/logs`,
            `/${props.os}/logs/*`,
        ];
        logGroups.forEach((g) => {
            logResources.push(`arn:aws:logs:${aws_cdk_lib_1.Stack.of(this).region}:${aws_cdk_lib_1.Stack.of(this).account}:log-group:${g}`);
        });
        this.policy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'loggingPolicy', {
            description: 'Allow instance to log system logs to Cloudwatch',
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'logs:PutLogEvents',
                        'logs:CreateLogGroup',
                        'logs:CreateLogStream',
                    ],
                    resources: logResources,
                }),
            ],
        });
    }
}
exports.ManagedLoggingPolicy = ManagedLoggingPolicy;
_a = JSII_RTTI_SYMBOL_1;
ManagedLoggingPolicy[_a] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.ManagedLoggingPolicy", version: "2.1.8" };
/**
 * @stability stable
 */
class InstanceService extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        let enableNoRemoteManagementPortsAspect = (_c = props.enableNoRemoteManagementPortsAspect) !== null && _c !== void 0 ? _c : true;
        let enableNoDBPortsAspect = (_d = props.enableNoDBPortsAspect) !== null && _d !== void 0 ? _d : true;
        let enabledNoPublicIngressAspect = (_e = props.enabledNoPublicIngressAspect) !== null && _e !== void 0 ? _e : true;
        if (enableNoRemoteManagementPortsAspect)
            aws_cdk_lib_1.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonManagementPortsAspect());
        if (enableNoDBPortsAspect)
            aws_cdk_lib_1.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoIngressCommonRelationalDBPortsAspect());
        if (enabledNoPublicIngressAspect)
            aws_cdk_lib_1.Aspects.of(this).add(new cdk_aspects_library_security_group_1.NoPublicIngressAspect());
        let managedPolicies = [];
        // Logging configuration
        let enableCloudwatchLogs = (props.enableCloudwatchLogs === undefined) ? true : props.enableCloudwatchLogs;
        if (enableCloudwatchLogs) {
            managedPolicies.push(new ManagedLoggingPolicy(this, 'loggingPolicy', {
                os: ec2ImageToOsString(this, props.ami),
            }).policy);
        }
        this.instanceProfile = new cdk_library_managed_instance_role_1.ManagedInstanceRole(this, 'instanceRole', {
            domainJoinEnabled: false,
            ssmManagementEnabled: true,
            managedPolicies,
        });
        let allowAllOutbound = (props.allowAllOutbound === undefined) ? true : props.allowAllOutbound;
        let disableInlineRules = (props.disableInlineRules === undefined) ? false : props.disableInlineRules;
        this.securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'securityGroup', {
            allowAllOutbound: allowAllOutbound,
            vpc: props.vpc,
            description: `The security group applied to the instance service for ${props.name}`,
            disableInlineRules: disableInlineRules,
        });
    }
}
exports.InstanceService = InstanceService;
_b = JSII_RTTI_SYMBOL_1;
InstanceService[_b] = { fqn: "@renovosolutions/cdk-library-renovo-instance-service.InstanceService", version: "2.1.8" };
//# sourceMappingURL=data:application/json;base64,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