import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.websocket_trigger_error_handler_args import WebsocketTriggerErrorHandlerArgs
    from ..models.websocket_trigger_extra_perms import WebsocketTriggerExtraPerms
    from ..models.websocket_trigger_filters_item import WebsocketTriggerFiltersItem
    from ..models.websocket_trigger_initial_messages_item_type_0 import WebsocketTriggerInitialMessagesItemType0
    from ..models.websocket_trigger_initial_messages_item_type_1 import WebsocketTriggerInitialMessagesItemType1
    from ..models.websocket_trigger_retry import WebsocketTriggerRetry
    from ..models.websocket_trigger_url_runnable_args import WebsocketTriggerUrlRunnableArgs


T = TypeVar("T", bound="WebsocketTrigger")


@_attrs_define
class WebsocketTrigger:
    """
    Attributes:
        url (str):
        enabled (bool):
        filters (List['WebsocketTriggerFiltersItem']):
        can_return_message (bool):
        path (str):
        script_path (str):
        email (str):
        extra_perms (WebsocketTriggerExtraPerms):
        workspace_id (str):
        edited_by (str):
        edited_at (datetime.datetime):
        is_flow (bool):
        server_id (Union[Unset, str]):
        last_server_ping (Union[Unset, datetime.datetime]):
        error (Union[Unset, str]):
        initial_messages (Union[Unset, List[Union['WebsocketTriggerInitialMessagesItemType0',
            'WebsocketTriggerInitialMessagesItemType1']]]):
        url_runnable_args (Union[Unset, WebsocketTriggerUrlRunnableArgs]): The arguments to pass to the script or flow
        error_handler_path (Union[Unset, str]):
        error_handler_args (Union[Unset, WebsocketTriggerErrorHandlerArgs]): The arguments to pass to the script or flow
        retry (Union[Unset, WebsocketTriggerRetry]):
    """

    url: str
    enabled: bool
    filters: List["WebsocketTriggerFiltersItem"]
    can_return_message: bool
    path: str
    script_path: str
    email: str
    extra_perms: "WebsocketTriggerExtraPerms"
    workspace_id: str
    edited_by: str
    edited_at: datetime.datetime
    is_flow: bool
    server_id: Union[Unset, str] = UNSET
    last_server_ping: Union[Unset, datetime.datetime] = UNSET
    error: Union[Unset, str] = UNSET
    initial_messages: Union[
        Unset, List[Union["WebsocketTriggerInitialMessagesItemType0", "WebsocketTriggerInitialMessagesItemType1"]]
    ] = UNSET
    url_runnable_args: Union[Unset, "WebsocketTriggerUrlRunnableArgs"] = UNSET
    error_handler_path: Union[Unset, str] = UNSET
    error_handler_args: Union[Unset, "WebsocketTriggerErrorHandlerArgs"] = UNSET
    retry: Union[Unset, "WebsocketTriggerRetry"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        from ..models.websocket_trigger_initial_messages_item_type_0 import WebsocketTriggerInitialMessagesItemType0

        url = self.url
        enabled = self.enabled
        filters = []
        for filters_item_data in self.filters:
            filters_item = filters_item_data.to_dict()

            filters.append(filters_item)

        can_return_message = self.can_return_message
        path = self.path
        script_path = self.script_path
        email = self.email
        extra_perms = self.extra_perms.to_dict()

        workspace_id = self.workspace_id
        edited_by = self.edited_by
        edited_at = self.edited_at.isoformat()

        is_flow = self.is_flow
        server_id = self.server_id
        last_server_ping: Union[Unset, str] = UNSET
        if not isinstance(self.last_server_ping, Unset):
            last_server_ping = self.last_server_ping.isoformat()

        error = self.error
        initial_messages: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.initial_messages, Unset):
            initial_messages = []
            for initial_messages_item_data in self.initial_messages:
                initial_messages_item: Dict[str, Any]

                if isinstance(initial_messages_item_data, WebsocketTriggerInitialMessagesItemType0):
                    initial_messages_item = initial_messages_item_data.to_dict()

                else:
                    initial_messages_item = initial_messages_item_data.to_dict()

                initial_messages.append(initial_messages_item)

        url_runnable_args: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.url_runnable_args, Unset):
            url_runnable_args = self.url_runnable_args.to_dict()

        error_handler_path = self.error_handler_path
        error_handler_args: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.error_handler_args, Unset):
            error_handler_args = self.error_handler_args.to_dict()

        retry: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.retry, Unset):
            retry = self.retry.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "url": url,
                "enabled": enabled,
                "filters": filters,
                "can_return_message": can_return_message,
                "path": path,
                "script_path": script_path,
                "email": email,
                "extra_perms": extra_perms,
                "workspace_id": workspace_id,
                "edited_by": edited_by,
                "edited_at": edited_at,
                "is_flow": is_flow,
            }
        )
        if server_id is not UNSET:
            field_dict["server_id"] = server_id
        if last_server_ping is not UNSET:
            field_dict["last_server_ping"] = last_server_ping
        if error is not UNSET:
            field_dict["error"] = error
        if initial_messages is not UNSET:
            field_dict["initial_messages"] = initial_messages
        if url_runnable_args is not UNSET:
            field_dict["url_runnable_args"] = url_runnable_args
        if error_handler_path is not UNSET:
            field_dict["error_handler_path"] = error_handler_path
        if error_handler_args is not UNSET:
            field_dict["error_handler_args"] = error_handler_args
        if retry is not UNSET:
            field_dict["retry"] = retry

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.websocket_trigger_error_handler_args import WebsocketTriggerErrorHandlerArgs
        from ..models.websocket_trigger_extra_perms import WebsocketTriggerExtraPerms
        from ..models.websocket_trigger_filters_item import WebsocketTriggerFiltersItem
        from ..models.websocket_trigger_initial_messages_item_type_0 import WebsocketTriggerInitialMessagesItemType0
        from ..models.websocket_trigger_initial_messages_item_type_1 import WebsocketTriggerInitialMessagesItemType1
        from ..models.websocket_trigger_retry import WebsocketTriggerRetry
        from ..models.websocket_trigger_url_runnable_args import WebsocketTriggerUrlRunnableArgs

        d = src_dict.copy()
        url = d.pop("url")

        enabled = d.pop("enabled")

        filters = []
        _filters = d.pop("filters")
        for filters_item_data in _filters:
            filters_item = WebsocketTriggerFiltersItem.from_dict(filters_item_data)

            filters.append(filters_item)

        can_return_message = d.pop("can_return_message")

        path = d.pop("path")

        script_path = d.pop("script_path")

        email = d.pop("email")

        extra_perms = WebsocketTriggerExtraPerms.from_dict(d.pop("extra_perms"))

        workspace_id = d.pop("workspace_id")

        edited_by = d.pop("edited_by")

        edited_at = isoparse(d.pop("edited_at"))

        is_flow = d.pop("is_flow")

        server_id = d.pop("server_id", UNSET)

        _last_server_ping = d.pop("last_server_ping", UNSET)
        last_server_ping: Union[Unset, datetime.datetime]
        if isinstance(_last_server_ping, Unset):
            last_server_ping = UNSET
        else:
            last_server_ping = isoparse(_last_server_ping)

        error = d.pop("error", UNSET)

        initial_messages = []
        _initial_messages = d.pop("initial_messages", UNSET)
        for initial_messages_item_data in _initial_messages or []:

            def _parse_initial_messages_item(
                data: object,
            ) -> Union["WebsocketTriggerInitialMessagesItemType0", "WebsocketTriggerInitialMessagesItemType1"]:
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    initial_messages_item_type_0 = WebsocketTriggerInitialMessagesItemType0.from_dict(data)

                    return initial_messages_item_type_0
                except:  # noqa: E722
                    pass
                if not isinstance(data, dict):
                    raise TypeError()
                initial_messages_item_type_1 = WebsocketTriggerInitialMessagesItemType1.from_dict(data)

                return initial_messages_item_type_1

            initial_messages_item = _parse_initial_messages_item(initial_messages_item_data)

            initial_messages.append(initial_messages_item)

        _url_runnable_args = d.pop("url_runnable_args", UNSET)
        url_runnable_args: Union[Unset, WebsocketTriggerUrlRunnableArgs]
        if isinstance(_url_runnable_args, Unset):
            url_runnable_args = UNSET
        else:
            url_runnable_args = WebsocketTriggerUrlRunnableArgs.from_dict(_url_runnable_args)

        error_handler_path = d.pop("error_handler_path", UNSET)

        _error_handler_args = d.pop("error_handler_args", UNSET)
        error_handler_args: Union[Unset, WebsocketTriggerErrorHandlerArgs]
        if isinstance(_error_handler_args, Unset):
            error_handler_args = UNSET
        else:
            error_handler_args = WebsocketTriggerErrorHandlerArgs.from_dict(_error_handler_args)

        _retry = d.pop("retry", UNSET)
        retry: Union[Unset, WebsocketTriggerRetry]
        if isinstance(_retry, Unset):
            retry = UNSET
        else:
            retry = WebsocketTriggerRetry.from_dict(_retry)

        websocket_trigger = cls(
            url=url,
            enabled=enabled,
            filters=filters,
            can_return_message=can_return_message,
            path=path,
            script_path=script_path,
            email=email,
            extra_perms=extra_perms,
            workspace_id=workspace_id,
            edited_by=edited_by,
            edited_at=edited_at,
            is_flow=is_flow,
            server_id=server_id,
            last_server_ping=last_server_ping,
            error=error,
            initial_messages=initial_messages,
            url_runnable_args=url_runnable_args,
            error_handler_path=error_handler_path,
            error_handler_args=error_handler_args,
            retry=retry,
        )

        websocket_trigger.additional_properties = d
        return websocket_trigger

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
