# Getting Started [​](#getting-started){.header-anchor aria-label="Permalink to \"Getting Started\""} {#getting-started tabindex="-1"}

To get started with Blits, follow these simple steps to set up your
development environment and create your first Lightning 3 App.

## Installation [​](#installation){.header-anchor aria-label="Permalink to \"Installation\""} {#installation tabindex="-1"}

1.  Open your terminal or command prompt.

2.  Run the following command to start a new Blits Lightning 3 App
    project:

::: {.language-bash .vp-adaptive-theme}
[bash]{.lang}

``` {.shiki .shiki-themes .github-light .github-dark .vp-code tabindex="0"}
npm create @lightningjs/app
```
:::

You will be guided through a short series of questions to generate a new
project with all the boilerplate code you need to start building your
own Lightning 3 App.

3.  Navigate to the newly created project directory and install the
    project dependencies:

::: {.language-bash .vp-adaptive-theme}
[bash]{.lang}

``` {.shiki .shiki-themes .github-light .github-dark .vp-code tabindex="0"}
cd my_blits_app
npm install
```
:::

## Running Your App [​](#running-your-app){.header-anchor aria-label="Permalink to \"Running Your App\""} {#running-your-app tabindex="-1"}

4.  After installing the dependencies, you can start your development
    server by running:

::: {.language-bash .vp-adaptive-theme}
[bash]{.lang}

``` {.shiki .shiki-themes .github-light .github-dark .vp-code tabindex="0"}
npm run dev
```
:::

This command will create an application bundle and launch a development
server using Vite.

Once the server is up and running, open your web browser and navigate to
the URL displayed in the console. Congratulations! You now have your
brand new Blits Lightning 3 App up and running.

## Coding environment [​](#coding-environment){.header-anchor aria-label="Permalink to \"Coding environment\""} {#coding-environment tabindex="-1"}

You can use any code editor of your preference to further develop your
Blits App.

We recommend using VS code, since we have a dedicated [VS code extension
for
Blits](https://marketplace.visualstudio.com/items?itemName=LightningJS.lightning-blits){target="_blank"
rel="noreferrer"} that provides better syntax highlighting, code
completion, error checking, and other features to make working with
Blits easier.

## Next steps [​](#next-steps){.header-anchor aria-label="Permalink to \"Next steps\""} {#next-steps tabindex="-1"}

You are now ready to dive into the world of App development using Blits.
In the following sections, we will explore the core concepts and guide
you through building your TV applications step by step.
