class Stone:
    floor = "/Game/PrimalEarth/Structures/Stone/Stone_Floor/Floor_Stone.Floor_Stone_C"
    ceiling = "/Game/PrimalEarth/Structures/Stone/Stone_Ceiling/Ceiling_Stone.Ceiling_Stone_C"
    doorframe = "/Game/PrimalEarth/Structures/Tileset/DoorwayShort/Doorframe_Short_Stone.Doorframe_Short_Stone_C"
    wall = "/Game/PrimalEarth/Structures/Stone/Stone_Wall/Wall_Stone.Wall_Stone_C"
    beam = "/Game/PrimalEarth/Structures/Stone/Beam_Stone.Beam_Stone_C"
    triangle_foundation = "/Game/PrimalEarth/StructuresPlus/Structures/Foundations/Triangle/Stone/BP_TriFoundation_Stone.BP_TriFoundation_Stone_C"
    roof = "/Game/PrimalEarth/CoreBlueprints/Items/Structures/Roofs/Stone/StoneRoof_SM.StoneRoof_SM_C"
    door = "/Game/PrimalEarth/Structures/Tileset/DoorShort/Door_Short_Stone.Door_Short_Stone_C"
    gateframe = "/Game/PrimalEarth/Structures/Stone/Stone_GateFrame/GateFrame_Stone.GateFrame_Stone_C"
    pillar = "/Game/PrimalEarth/Structures/Stone/Stone_Pillar/Pillar_Stone.Pillar_Stone_C"
    tri_roof = "/Game/PrimalEarth/StructuresPlus/Structures/Roofs_Tri/Stone/BP_TriRoof_Stone.BP_TriRoof_Stone_C"

    all_bps = [floor, ceiling, doorframe, wall, beam, triangle_foundation, roof, door, gateframe, pillar, tri_roof]
class Metal:
    floor = "/Game/PrimalEarth/Structures/Metal/Floor_Metal.Floor_Metal_C"
    wall = "/Game/PrimalEarth/Structures/Metal/Wall_Metal.Wall_Metal_C"
    triangle_foundation = "/Game/PrimalEarth/StructuresPlus/Structures/Foundations/Triangle/Metal/BP_TriFoundation_Metal.BP_TriFoundation_Metal_C"
    cliff_platform = "/Game/Aberration/Structures/CliffPlatforms/Metal_CliffPlatform/Metal_Platform_BP_Small.Metal_Platform_BP_Small_C"
    double_doorframe = "/Game/PrimalEarth/StructuresPlus/Structures/Doorframes_Double/Metal/BP_DoubleDoorframe_Metal.BP_DoubleDoorframe_Metal_C"
    tri_roof = "/Game/PrimalEarth/StructuresPlus/Structures/Roofs_Tri/Metal/BP_TriRoof_Metal.BP_TriRoof_Metal_C"
    large_wall = "/Game/PrimalEarth/StructuresPlus/Structures/Walls_L/Metal/BP_LargeWall_Metal.BP_LargeWall_Metal_C"
    greenhouse_ceiling = "/Game/PrimalEarth/Structures/Greenhouse_Modular/Greenhouse_Ceiling.Greenhouse_Ceiling_C"
    greenhouse_wall = "/Game/PrimalEarth/Structures/Greenhouse_Modular/Greenhouse_Wall.Greenhouse_Wall_C"
    beam = "/Game/PrimalEarth/Structures/Metal/Beam_Metal.Beam_Metal_C"
    ceiling = "/Game/PrimalEarth/Structures/Metal/Ceiling_Metal.Ceiling_Metal_C"
    doorframe = "/Game/PrimalEarth/Structures/Metal/Doorframe_Metal.Doorframe_Metal_C"
    fence_foundation = "/Game/PrimalEarth/Structures/Metal/FenceFoundation_Metal.FenceFoundation_Metal_C"
    gateframe_large = "/Game/PrimalEarth/Structures/Metal/GateFrame_Large_Metal.GateFrame_Large_Metal_C"
    gateframe = "/Game/PrimalEarth/Structures/Metal/GateFrame_Metal.GateFrame_Metal_C"
    gate_large = "/Game/PrimalEarth/Structures/Metal/Gate_Large_Metal.Gate_Large_Metal_C"
    ladder = "/Game/PrimalEarth/Structures/Metal/Ladder_Metal.Ladder_Metal_C"
    pillar = "/Game/PrimalEarth/Structures/Metal/Pillar_Metal.Pillar_Metal_C"
    window_wall = "/Game/PrimalEarth/Structures/Metal/WindowWall_Metal.WindowWall_Metal_C"
    waterpipe_intake = "/Game/PrimalEarth/Structures/Pipes/WaterPipe_Metal_Intake.WaterPipe_Metal_Intake_C"
    behemoth_gate = "/Game/PrimalEarth/Structures/SM_MetalCeilingDoorGiant_BP.SM_MetalCeilingDoorGiant_BP_C"
    sign_large = "/Game/PrimalEarth/Structures/Sign_Large_Metal.Sign_Large_Metal_C"
    door_short = "/Game/PrimalEarth/Structures/Tileset/DoorShort/Door_Short_Metal.Door_Short_Metal_C"
    doorframe_short = "/Game/PrimalEarth/Structures/Tileset/DoorwayShort/Doorframe_Short_Metal.Doorframe_Short_Metal_C"
    wall_half = "/Game/PrimalEarth/Structures/Tileset/HalfWalls/StructureBP_Wall_Half_Metal.StructureBP_Wall_Half_Metal_C"
    hatchframe_xl = "/Game/PrimalEarth/Structures/Tileset/HatchframesXL/Doors/BP_Ceiling_Door_XL_Metal.BP_Ceiling_Door_XL_Metal_C"
    railing_sloped_right = "/Game/PrimalEarth/Structures/Tileset/Railings/Metal/StructureBP_Railing_Sloped_Right_Metal.StructureBP_Railing_Sloped_Right_Metal_C"
    door_secret = "/Game/PrimalEarth/Structures/Tileset/SecretDoorways/StructureBP_Door_Secret_Metal.StructureBP_Door_Secret_Metal_C"
    metalwall_sloped_right_sm = "/Game/PrimalEarth/CoreBlueprints/Items/Structures/Roofs/Metal/MetalWall_Sloped_Right_SM.MetalWall_Sloped_Right_SM_C"
    ceiling_doorway = "/Game/PrimalEarth/Structures/Metal/Ceiling_Doorway_Metal.Ceiling_Doorway_Metal_C"
    gate = "/Game/PrimalEarth/Structures/Metal/Gate_Metal.Gate_Metal_C"
    railing = "/Game/PrimalEarth/Structures/Metal/Railing_Metal.Railing_Metal_C"
    window = "/Game/PrimalEarth/Structures/Metal/Window_Metal_BP.Window_Metal_BP_C"
    ramp = "/Game/PrimalEarth/StructuresPlus/Structures/Ramps/Metal/BP_Ramp_Metal.BP_Ramp_Metal_C"
    generator = "/Game/PrimalEarth/Structures/Electric/ElectricGenerator.ElectricGenerator_C"
    sign = "/Game/PrimalEarth/Structures/Sign_Small_Metal.Sign_Small_Metal_C"
    wall_sign = "/Game/PrimalEarth/Structures/Sign_Wall_Metal.Sign_Wall_Metal_C"    

    all_bps = [floor, wall, triangle_foundation, cliff_platform, double_doorframe, tri_roof, large_wall, 
               greenhouse_ceiling, greenhouse_wall, beam, ceiling, doorframe, fence_foundation, 
               gateframe_large, gateframe, gate_large, ladder, pillar, window_wall, 
               waterpipe_intake, behemoth_gate, sign_large, door_short, doorframe_short, 
               wall_half, hatchframe_xl, railing_sloped_right, door_secret, metalwall_sloped_right_sm,
               generator, ceiling_doorway, gate, railing, window, ramp, sign, wall_sign]

class Thatch:
    floor = "/Game/PrimalEarth/Structures/Thatch/Thatch_Floor.Thatch_Floor_C"
    ceiling = "/Game/PrimalEarth/Structures/Thatch/Thatch_Ceiling.Thatch_Ceiling_C"
    all_bps = [floor, ceiling]

class Tek:
    floor = "/Game/PrimalEarth/Structures/TekTier/Floor_Tek.Floor_Tek_C"
    quarter_floor = "/Game/PrimalEarth/Structures/Tileset/Foundations/Quarter/Floor_Quarter_Tek.Floor_Quarter_Tek_C"
    tri_floor = "/Game/PrimalEarth/StructuresPlus/Structures/Foundations/Triangle/Tek/BP_TriFoundation_Tek.BP_TriFoundation_Tek_C"
    generator = "/Game/PrimalEarth/Structures/StorageBox_TekGenerator.StorageBox_TekGenerator_C"
    replicator = "/Game/PrimalEarth/Structures/StorageBox_TekReplicator.StorageBox_TekReplicator_C"
    teleporter_small = "/Game/PrimalEarth/Structures/TekTier/TekTeleporterMini.TekTeleporterMini_C"
    teleporter_medium = "/Game/PrimalEarth/CoreBlueprints/Items/Structures/Misc/PrimalItemStructure_TekTeleporterSmall.PrimalItemStructure_TekTeleporterSmall_C"
    teleporter_large = "/Game/PrimalEarth/CoreBlueprints/Items/Structures/Misc/PrimalItemStructure_TekTeleporter.PrimalItemStructure_TekTeleporter_C"
    
    all_bps = [floor, generator, teleporter_small, replicator, teleporter_medium, teleporter_large, quarter_floor, tri_floor]
    
class Wood:
    spike_wall = "/Game/PrimalEarth/Structures/Wooden/SpikeWall.SpikeWall_C"
    crop_plot_large = "/Game/PrimalEarth/Structures/Wooden/CropPlotLarge_SM.CropPlotLarge_SM_C"
    floor = "/Game/PrimalEarth/Structures/Wooden/Floor_Wood_SM_New.Floor_Wood_SM_New_C"
    sign = "/Game/PrimalEarth/Structures/Sign_Small_Wood.Sign_Small_Wood_C"
    wall_sign = "/Game/PrimalEarth/Structures/Sign_Wall_Wood.Sign_Wall_Wood_C"

    all_bps = [spike_wall, crop_plot_large, floor, sign, wall_sign]

class Crafting:
    forge = "/Game/PrimalEarth/Structures/Forge.Forge_C"
    mortar_and_pestle = "/Game/PrimalEarth/Structures/MortarAndPestle.MortarAndPestle_C"
    compost_bin = "/Game/PrimalEarth/Structures/CompostBin.CompostBin_C"
    campfire = "/Game/PrimalEarth/Structures/Campfire.Campfire_C"
    cooking_pot = "/Game/PrimalEarth/Structures/CookingPot.CookingPot_C"
    grill = "/Game/PrimalEarth/Structures/Grill.Grill_C"
    chembench = "/Game/PrimalEarth/Structures/StorageBox_ChemBench.StorageBox_ChemBench_C"

    all_bps = [forge, mortar_and_pestle, compost_bin, campfire, cooking_pot, grill, chembench]

class Utility:
    simple_bed = "/Game/PrimalEarth/Structures/SimpleBed.SimpleBed_C"
    bunk_bed = "/Game/PrimalEarth/Structures/ModernBed.ModernBed_C"
    sleeping_pod = "/Game/PrimalEarth/Structures/TekBed.TekBed_C"
    vault = "/Game/PrimalEarth/Structures/StorageBox_Huge.StorageBox_Huge_C"
    sleeping_bag = "/Game/PrimalEarth/Structures/SleepingBag.SleepingBag_C"
    anvil_bench = "/Game/PrimalEarth/Structures/StorageBox_AnvilBench.StorageBox_AnvilBench_C"
    small_storage_box = "/Game/PrimalEarth/Structures/StorageBox_Small.StorageBox_Small_C"
    large_bear_trap = "/Game/PrimalEarth/Structures/BearTrapLarge.BearTrapLarge_C"
    large_storage_box = "/Game/PrimalEarth/Structures/StorageBox_Large.StorageBox_Large_C"
    toilet = "/Game/PrimalEarth/Structures/Furniture/StructureBP_Toilet.StructureBP_Toilet_C"
    cryofridge = "/Game/Extinction/Structures/Cryofridge/CryoFridge.CryoFridge_C"
    deathitemcache = "/Game/PrimalEarth/Structures/DeathItemCache.DeathItemCache_C"

    all_bps = [simple_bed, sleeping_bag, anvil_bench, small_storage_box, large_bear_trap, large_storage_box,
               bunk_bed, vault, sleeping_pod, toilet, cryofridge, deathitemcache]
    
class TributeTerminals:
    tribute_terminal_purple = "/Game/PrimalEarth/Structures/TributeTerminal_Purple.TributeTerminal_Purple_C"
    tribute_terminal_red = "/Game/PrimalEarth/Structures/TributeTerminal_Red.TributeTerminal_Red_C"
    tribute_terminal_blue = "/Game/PrimalEarth/Structures/TributeTerminal_Blue.TributeTerminal_Blue_C"
    tribute_terminal_green = "/Game/PrimalEarth/Structures/TributeTerminal_Green.TributeTerminal_Green_C"

    all_bps = [tribute_terminal_purple, tribute_terminal_red, tribute_terminal_blue, tribute_terminal_green]

class Water:
    water_pipe_intake = "/Game/PrimalEarth/Structures/Pipes/WaterPipe_Stone_Intake.WaterPipe_Stone_Intake_C"
    water_tank = "/Game/PrimalEarth/Structures/BuildingBases/WaterTank_Metal.WaterTank_Metal_C"

    all_bps = [water_pipe_intake, water_tank]

class Turrets:
    auto = "/Game/PrimalEarth/Structures/BuildingBases/StructureTurretBaseBP.StructureTurretBaseBP_C"
    heavy = "/Game/PrimalEarth/Structures/BuildingBases/StructureTurretBaseBP_Heavy.StructureTurretBaseBP_Heavy_C"
    tek = "/Game/PrimalEarth/Structures/BuildingBases/StructureTurretTek.StructureTurretTek_C"

    all_bps = [auto, heavy, tek]

class Aberration:
    gas_collector = "/Game/Aberration/Structures/GasCollector/GasVein_Base_BP.GasVein_Base_BP_C"
    power_node = "/Game/Aberration/Structures/PowerNode/PrimalStructurePowerNode.PrimalStructurePowerNode_C"
    damaged_power_node = "/Game/Aberration/Structures/PowerNode/PrimalStructurePowerNode_Damaged.PrimalStructurePowerNode_Damaged_C"
    zipline_anchor = "/Game/Aberration/Structures/Zipline/Zipline_Anchor.Zipline_Anchor_C"
    gas_collector_asa = "/Game/Aberration/Structures/GasCollector/GasCollecter_ASA.GasCollecter_ASA_C"

    all_bps = [gas_collector, power_node, damaged_power_node, zipline_anchor, gas_collector_asa]


# class Frontier:
#     frontier_skin = "/Game/Packs/Frontier/Structures/Frontier/Skins/PrimalItemStructureSkin_Tileset_Frontier.PrimalItemStructureSkin_Tileset_Frontier_C"
#     train_car_platform = "/Game/Packs/Frontier/Structures/TrainCarts/PrimalItem_TrainCar_Platform.PrimalItem_TrainCar_Platform_C"

# class BobsTallTales:
#     steampunk_skin = "/Game/Packs/Steampunk/Structures/Tileset/PrimalItemStructureSkin_Tileset_Steampunk.PrimalItemStructureSkin_Tileset_Steampunk_C"

class PlacedStructures:
    stone: Stone = Stone()
    metal: Metal = Metal()
    thatch: Thatch = Thatch()
    tek: Tek = Tek()
    wood: Wood = Wood()
    crafting: Crafting = Crafting()
    utility: Utility = Utility()
    tribute_terminals: TributeTerminals = TributeTerminals()
    water: Water = Water()
    turrets: Turrets = Turrets()
    aberration: Aberration = Aberration()

    all_bps = stone.all_bps + metal.all_bps + thatch.all_bps + tek.all_bps + wood.all_bps + crafting.all_bps + utility.all_bps + tribute_terminals.all_bps + water.all_bps + turrets.all_bps + aberration.all_bps

