from http import HTTPStatus
from typing import Any, Optional, Union

import httpx

from galileo.utils.headers_data import get_package_version
from galileo_core.constants.request_method import RequestMethod
from galileo_core.helpers.api_client import ApiClient

from ... import errors
from ...models.http_validation_error import HTTPValidationError
from ...models.list_scorer_versions_response import ListScorerVersionsResponse
from ...types import UNSET, Response, Unset


def _get_kwargs(
    scorer_id: str,
    *,
    run_id: Union[None, Unset, str] = UNSET,
    starting_token: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}

    params: dict[str, Any] = {}

    json_run_id: Union[None, Unset, str]
    json_run_id = UNSET if isinstance(run_id, Unset) else run_id
    params["run_id"] = json_run_id

    params["starting_token"] = starting_token

    params["limit"] = limit

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": RequestMethod.GET,
        "return_raw_response": True,
        "path": f"/scorers/{scorer_id}/versions",
        "params": params,
    }

    headers["X-Galileo-SDK"] = f"galileo-python/{get_package_version()}"

    _kwargs["content_headers"] = headers
    return _kwargs


def _parse_response(
    *, client: ApiClient, response: httpx.Response
) -> Optional[Union[HTTPValidationError, ListScorerVersionsResponse]]:
    if response.status_code == 200:
        return ListScorerVersionsResponse.from_dict(response.json())

    if response.status_code == 422:
        return HTTPValidationError.from_dict(response.json())

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    return None


def _build_response(
    *, client: ApiClient, response: httpx.Response
) -> Response[Union[HTTPValidationError, ListScorerVersionsResponse]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    scorer_id: str,
    *,
    client: ApiClient,
    run_id: Union[None, Unset, str] = UNSET,
    starting_token: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
) -> Response[Union[HTTPValidationError, ListScorerVersionsResponse]]:
    """List All Versions For Scorer.

    Args:
        scorer_id (str):
        run_id (Union[None, Unset, str]):
        starting_token (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.

    Raises
    ------
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns
    -------
        Response[Union[HTTPValidationError, ListScorerVersionsResponse]]
    """
    kwargs = _get_kwargs(scorer_id=scorer_id, run_id=run_id, starting_token=starting_token, limit=limit)

    response = client.request(**kwargs)

    return _build_response(client=client, response=response)


def sync(
    scorer_id: str,
    *,
    client: ApiClient,
    run_id: Union[None, Unset, str] = UNSET,
    starting_token: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
) -> Optional[Union[HTTPValidationError, ListScorerVersionsResponse]]:
    """List All Versions For Scorer.

    Args:
        scorer_id (str):
        run_id (Union[None, Unset, str]):
        starting_token (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.

    Raises
    ------
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns
    -------
        Union[HTTPValidationError, ListScorerVersionsResponse]
    """
    return sync_detailed(
        scorer_id=scorer_id, client=client, run_id=run_id, starting_token=starting_token, limit=limit
    ).parsed


async def asyncio_detailed(
    scorer_id: str,
    *,
    client: ApiClient,
    run_id: Union[None, Unset, str] = UNSET,
    starting_token: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
) -> Response[Union[HTTPValidationError, ListScorerVersionsResponse]]:
    """List All Versions For Scorer.

    Args:
        scorer_id (str):
        run_id (Union[None, Unset, str]):
        starting_token (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.

    Raises
    ------
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns
    -------
        Response[Union[HTTPValidationError, ListScorerVersionsResponse]]
    """
    kwargs = _get_kwargs(scorer_id=scorer_id, run_id=run_id, starting_token=starting_token, limit=limit)

    response = await client.arequest(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    scorer_id: str,
    *,
    client: ApiClient,
    run_id: Union[None, Unset, str] = UNSET,
    starting_token: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
) -> Optional[Union[HTTPValidationError, ListScorerVersionsResponse]]:
    """List All Versions For Scorer.

    Args:
        scorer_id (str):
        run_id (Union[None, Unset, str]):
        starting_token (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.

    Raises
    ------
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns
    -------
        Union[HTTPValidationError, ListScorerVersionsResponse]
    """
    return (
        await asyncio_detailed(
            scorer_id=scorer_id, client=client, run_id=run_id, starting_token=starting_token, limit=limit
        )
    ).parsed
