from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="DatasetData")


@_attrs_define
class DatasetData:
    """
    Attributes
    ----------
        dataset_id (str):
        dataset_version_index (Union[None, Unset, int]):
    """

    dataset_id: str
    dataset_version_index: Union[None, Unset, int] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        dataset_id = self.dataset_id

        dataset_version_index: Union[None, Unset, int]
        dataset_version_index = UNSET if isinstance(self.dataset_version_index, Unset) else self.dataset_version_index

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({"dataset_id": dataset_id})
        if dataset_version_index is not UNSET:
            field_dict["dataset_version_index"] = dataset_version_index

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        dataset_id = d.pop("dataset_id")

        def _parse_dataset_version_index(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        dataset_version_index = _parse_dataset_version_index(d.pop("dataset_version_index", UNSET))

        dataset_data = cls(dataset_id=dataset_id, dataset_version_index=dataset_version_index)

        dataset_data.additional_properties = d
        return dataset_data

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
