# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.archive import Archive
from .raw_client import AsyncRawArchivesClient, RawArchivesClient
from .types.list_archives_request_order import ListArchivesRequestOrder

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ArchivesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawArchivesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawArchivesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawArchivesClient
        """
        return self._raw_client

    def list_archives(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[ListArchivesRequestOrder] = None,
        name: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Archive]:
        """
        Get a list of all archives for the current organization with optional filters and pagination.

        Parameters
        ----------
        before : typing.Optional[str]
            Archive ID cursor for pagination. Returns archives that come before this archive ID in the specified sort order

        after : typing.Optional[str]
            Archive ID cursor for pagination. Returns archives that come after this archive ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of archives to return

        order : typing.Optional[ListArchivesRequestOrder]
            Sort order for archives by creation time. 'asc' for oldest first, 'desc' for newest first

        name : typing.Optional[str]
            Filter by archive name (exact match)

        agent_id : typing.Optional[str]
            Only archives attached to this agent ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Archive]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.archives.list_archives()
        """
        _response = self._raw_client.list_archives(
            before=before,
            after=after,
            limit=limit,
            order=order,
            name=name,
            agent_id=agent_id,
            request_options=request_options,
        )
        return _response.data

    def create_archive(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Archive:
        """
        Create a new archive.

        Parameters
        ----------
        name : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Archive
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.archives.create_archive(
            name="name",
        )
        """
        _response = self._raw_client.create_archive(name=name, description=description, request_options=request_options)
        return _response.data

    def modify_archive(
        self,
        archive_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Archive:
        """
        Update an existing archive's name and/or description.

        Parameters
        ----------
        archive_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Archive
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.archives.modify_archive(
            archive_id="archive_id",
        )
        """
        _response = self._raw_client.modify_archive(
            archive_id, name=name, description=description, request_options=request_options
        )
        return _response.data


class AsyncArchivesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawArchivesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawArchivesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawArchivesClient
        """
        return self._raw_client

    async def list_archives(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[ListArchivesRequestOrder] = None,
        name: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Archive]:
        """
        Get a list of all archives for the current organization with optional filters and pagination.

        Parameters
        ----------
        before : typing.Optional[str]
            Archive ID cursor for pagination. Returns archives that come before this archive ID in the specified sort order

        after : typing.Optional[str]
            Archive ID cursor for pagination. Returns archives that come after this archive ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of archives to return

        order : typing.Optional[ListArchivesRequestOrder]
            Sort order for archives by creation time. 'asc' for oldest first, 'desc' for newest first

        name : typing.Optional[str]
            Filter by archive name (exact match)

        agent_id : typing.Optional[str]
            Only archives attached to this agent ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Archive]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.archives.list_archives()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_archives(
            before=before,
            after=after,
            limit=limit,
            order=order,
            name=name,
            agent_id=agent_id,
            request_options=request_options,
        )
        return _response.data

    async def create_archive(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Archive:
        """
        Create a new archive.

        Parameters
        ----------
        name : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Archive
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.archives.create_archive(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_archive(
            name=name, description=description, request_options=request_options
        )
        return _response.data

    async def modify_archive(
        self,
        archive_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Archive:
        """
        Update an existing archive's name and/or description.

        Parameters
        ----------
        archive_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Archive
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.archives.modify_archive(
                archive_id="archive_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.modify_archive(
            archive_id, name=name, description=description, request_options=request_options
        )
        return _response.data
