# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .agents.client import AgentsClient, AsyncAgentsClient
from .archives.client import ArchivesClient, AsyncArchivesClient
from .batches.client import AsyncBatchesClient, BatchesClient
from .blocks.client import AsyncBlocksClient, BlocksClient
from .client_side_access_tokens.client import AsyncClientSideAccessTokensClient, ClientSideAccessTokensClient
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import LettaEnvironment
from .folders.client import AsyncFoldersClient, FoldersClient
from .groups.client import AsyncGroupsClient, GroupsClient
from .health.client import AsyncHealthClient, HealthClient
from .identities.client import AsyncIdentitiesClient, IdentitiesClient
from .jobs.client import AsyncJobsClient, JobsClient
from .models.client import AsyncModelsClient, ModelsClient
from .projects.client import AsyncProjectsClient, ProjectsClient
from .providers.client import AsyncProvidersClient, ProvidersClient
from .runs.client import AsyncRunsClient, RunsClient
from .sources.client import AsyncSourcesClient, SourcesClient
from .steps.client import AsyncStepsClient, StepsClient
from .tags.client import AsyncTagsClient, TagsClient
from .telemetry.client import AsyncTelemetryClient, TelemetryClient
from .templates.client import AsyncTemplatesClient, TemplatesClient
from .tools.client import AsyncToolsClient, ToolsClient
from .voice.client import AsyncVoiceClient, VoiceClient


class LettaBase:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : LettaEnvironment
        The environment to use for requests from the client. from .environment import LettaEnvironment



        Defaults to LettaEnvironment.LETTA_CLOUD



    project : typing.Optional[str]
    token : typing.Optional[str]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from letta_client import Letta

    client = Letta(
        project="YOUR_PROJECT",
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: LettaEnvironment = LettaEnvironment.LETTA_CLOUD,
        project: typing.Optional[str] = None,
        token: typing.Optional[str] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            project=project,
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.archives = ArchivesClient(client_wrapper=self._client_wrapper)
        self.tools = ToolsClient(client_wrapper=self._client_wrapper)
        self.sources = SourcesClient(client_wrapper=self._client_wrapper)
        self.folders = FoldersClient(client_wrapper=self._client_wrapper)
        self.agents = AgentsClient(client_wrapper=self._client_wrapper)
        self.groups = GroupsClient(client_wrapper=self._client_wrapper)
        self.identities = IdentitiesClient(client_wrapper=self._client_wrapper)
        self.models = ModelsClient(client_wrapper=self._client_wrapper)
        self.blocks = BlocksClient(client_wrapper=self._client_wrapper)
        self.jobs = JobsClient(client_wrapper=self._client_wrapper)
        self.health = HealthClient(client_wrapper=self._client_wrapper)
        self.providers = ProvidersClient(client_wrapper=self._client_wrapper)
        self.runs = RunsClient(client_wrapper=self._client_wrapper)
        self.steps = StepsClient(client_wrapper=self._client_wrapper)
        self.tags = TagsClient(client_wrapper=self._client_wrapper)
        self.telemetry = TelemetryClient(client_wrapper=self._client_wrapper)
        self.batches = BatchesClient(client_wrapper=self._client_wrapper)
        self.voice = VoiceClient(client_wrapper=self._client_wrapper)
        self.templates = TemplatesClient(client_wrapper=self._client_wrapper)
        self.client_side_access_tokens = ClientSideAccessTokensClient(client_wrapper=self._client_wrapper)
        self.projects = ProjectsClient(client_wrapper=self._client_wrapper)


class AsyncLettaBase:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : LettaEnvironment
        The environment to use for requests from the client. from .environment import LettaEnvironment



        Defaults to LettaEnvironment.LETTA_CLOUD



    project : typing.Optional[str]
    token : typing.Optional[str]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from letta_client import AsyncLetta

    client = AsyncLetta(
        project="YOUR_PROJECT",
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: LettaEnvironment = LettaEnvironment.LETTA_CLOUD,
        project: typing.Optional[str] = None,
        token: typing.Optional[str] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            project=project,
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.archives = AsyncArchivesClient(client_wrapper=self._client_wrapper)
        self.tools = AsyncToolsClient(client_wrapper=self._client_wrapper)
        self.sources = AsyncSourcesClient(client_wrapper=self._client_wrapper)
        self.folders = AsyncFoldersClient(client_wrapper=self._client_wrapper)
        self.agents = AsyncAgentsClient(client_wrapper=self._client_wrapper)
        self.groups = AsyncGroupsClient(client_wrapper=self._client_wrapper)
        self.identities = AsyncIdentitiesClient(client_wrapper=self._client_wrapper)
        self.models = AsyncModelsClient(client_wrapper=self._client_wrapper)
        self.blocks = AsyncBlocksClient(client_wrapper=self._client_wrapper)
        self.jobs = AsyncJobsClient(client_wrapper=self._client_wrapper)
        self.health = AsyncHealthClient(client_wrapper=self._client_wrapper)
        self.providers = AsyncProvidersClient(client_wrapper=self._client_wrapper)
        self.runs = AsyncRunsClient(client_wrapper=self._client_wrapper)
        self.steps = AsyncStepsClient(client_wrapper=self._client_wrapper)
        self.tags = AsyncTagsClient(client_wrapper=self._client_wrapper)
        self.telemetry = AsyncTelemetryClient(client_wrapper=self._client_wrapper)
        self.batches = AsyncBatchesClient(client_wrapper=self._client_wrapper)
        self.voice = AsyncVoiceClient(client_wrapper=self._client_wrapper)
        self.templates = AsyncTemplatesClient(client_wrapper=self._client_wrapper)
        self.client_side_access_tokens = AsyncClientSideAccessTokensClient(client_wrapper=self._client_wrapper)
        self.projects = AsyncProjectsClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: LettaEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
