# This file was auto-generated by Fern from our API Definition.

import typing

from ... import core
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.duplicate_file_handling import DuplicateFileHandling
from ...types.file_metadata import FileMetadata
from .raw_client import AsyncRawFilesClient, RawFilesClient
from .types.files_list_request_order import FilesListRequestOrder

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFilesClient
        """
        return self._raw_client

    def upload(
        self,
        folder_id: str,
        *,
        file: core.File,
        duplicate_handling: typing.Optional[DuplicateFileHandling] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileMetadata:
        """
        Upload a file to a data folder.

        Parameters
        ----------
        folder_id : str

        file : core.File
            See core.File for more documentation

        duplicate_handling : typing.Optional[DuplicateFileHandling]
            How to handle duplicate filenames

        name : typing.Optional[str]
            Optional custom name to override the uploaded file's name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileMetadata
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.folders.files.upload(
            folder_id="folder_id",
        )
        """
        _response = self._raw_client.upload(
            folder_id, file=file, duplicate_handling=duplicate_handling, name=name, request_options=request_options
        )
        return _response.data

    def list(
        self,
        folder_id: str,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[FilesListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        include_content: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[FileMetadata]:
        """
        List paginated files associated with a data folder.

        Parameters
        ----------
        folder_id : str

        before : typing.Optional[str]
            File ID cursor for pagination. Returns files that come before this file ID in the specified sort order

        after : typing.Optional[str]
            File ID cursor for pagination. Returns files that come after this file ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of files to return

        order : typing.Optional[FilesListRequestOrder]
            Sort order for files by creation time. 'asc' for oldest first, 'desc' for newest first

        order_by : typing.Optional[typing.Literal["created_at"]]
            Field to sort by

        include_content : typing.Optional[bool]
            Whether to include full file content

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[FileMetadata]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.folders.files.list(
            folder_id="folder_id",
        )
        """
        _response = self._raw_client.list(
            folder_id,
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            include_content=include_content,
            request_options=request_options,
        )
        return _response.data

    def delete(self, folder_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a file from a folder.

        Parameters
        ----------
        folder_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.folders.files.delete(
            folder_id="folder_id",
            file_id="file_id",
        )
        """
        _response = self._raw_client.delete(folder_id, file_id, request_options=request_options)
        return _response.data


class AsyncFilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFilesClient
        """
        return self._raw_client

    async def upload(
        self,
        folder_id: str,
        *,
        file: core.File,
        duplicate_handling: typing.Optional[DuplicateFileHandling] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileMetadata:
        """
        Upload a file to a data folder.

        Parameters
        ----------
        folder_id : str

        file : core.File
            See core.File for more documentation

        duplicate_handling : typing.Optional[DuplicateFileHandling]
            How to handle duplicate filenames

        name : typing.Optional[str]
            Optional custom name to override the uploaded file's name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileMetadata
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.folders.files.upload(
                folder_id="folder_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upload(
            folder_id, file=file, duplicate_handling=duplicate_handling, name=name, request_options=request_options
        )
        return _response.data

    async def list(
        self,
        folder_id: str,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[FilesListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        include_content: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[FileMetadata]:
        """
        List paginated files associated with a data folder.

        Parameters
        ----------
        folder_id : str

        before : typing.Optional[str]
            File ID cursor for pagination. Returns files that come before this file ID in the specified sort order

        after : typing.Optional[str]
            File ID cursor for pagination. Returns files that come after this file ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of files to return

        order : typing.Optional[FilesListRequestOrder]
            Sort order for files by creation time. 'asc' for oldest first, 'desc' for newest first

        order_by : typing.Optional[typing.Literal["created_at"]]
            Field to sort by

        include_content : typing.Optional[bool]
            Whether to include full file content

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[FileMetadata]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.folders.files.list(
                folder_id="folder_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            folder_id,
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            include_content=include_content,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, folder_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete a file from a folder.

        Parameters
        ----------
        folder_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.folders.files.delete(
                folder_id="folder_id",
                file_id="file_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(folder_id, file_id, request_options=request_options)
        return _response.data
