# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.passage import Passage
from .raw_client import AsyncRawPassagesClient, RawPassagesClient
from .types.passages_list_request_order import PassagesListRequestOrder


class PassagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPassagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPassagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPassagesClient
        """
        return self._raw_client

    def list(
        self,
        folder_id: str,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[PassagesListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Passage]:
        """
        List all passages associated with a data folder.

        Parameters
        ----------
        folder_id : str

        before : typing.Optional[str]
            Passage ID cursor for pagination. Returns passages that come before this passage ID in the specified sort order

        after : typing.Optional[str]
            Passage ID cursor for pagination. Returns passages that come after this passage ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of passages to return

        order : typing.Optional[PassagesListRequestOrder]
            Sort order for passages by creation time. 'asc' for oldest first, 'desc' for newest first

        order_by : typing.Optional[typing.Literal["created_at"]]
            Field to sort by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Passage]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.folders.passages.list(
            folder_id="folder_id",
        )
        """
        _response = self._raw_client.list(
            folder_id,
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            request_options=request_options,
        )
        return _response.data


class AsyncPassagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPassagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPassagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPassagesClient
        """
        return self._raw_client

    async def list(
        self,
        folder_id: str,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[PassagesListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Passage]:
        """
        List all passages associated with a data folder.

        Parameters
        ----------
        folder_id : str

        before : typing.Optional[str]
            Passage ID cursor for pagination. Returns passages that come before this passage ID in the specified sort order

        after : typing.Optional[str]
            Passage ID cursor for pagination. Returns passages that come after this passage ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of passages to return

        order : typing.Optional[PassagesListRequestOrder]
            Sort order for passages by creation time. 'asc' for oldest first, 'desc' for newest first

        order_by : typing.Optional[typing.Literal["created_at"]]
            Field to sort by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Passage]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.folders.passages.list(
                folder_id="folder_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            folder_id,
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            request_options=request_options,
        )
        return _response.data
