# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.provider import Provider
from ..types.provider_type import ProviderType
from .raw_client import AsyncRawProvidersClient, RawProvidersClient
from .types.providers_list_request_order import ProvidersListRequestOrder

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProvidersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProvidersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[ProvidersListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        name: typing.Optional[str] = None,
        provider_type: typing.Optional[ProviderType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Provider]:
        """
        Get a list of all custom providers.

        Parameters
        ----------
        before : typing.Optional[str]
            Provider ID cursor for pagination. Returns providers that come before this provider ID in the specified sort order

        after : typing.Optional[str]
            Provider ID cursor for pagination. Returns providers that come after this provider ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of providers to return

        order : typing.Optional[ProvidersListRequestOrder]
            Sort order for providers by creation time. 'asc' for oldest first, 'desc' for newest first

        order_by : typing.Optional[typing.Literal["created_at"]]
            Field to sort by

        name : typing.Optional[str]
            Filter providers by name

        provider_type : typing.Optional[ProviderType]
            Filter providers by type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Provider]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.providers.list()
        """
        _response = self._raw_client.list(
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            name=name,
            provider_type=provider_type,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        name: str,
        provider_type: ProviderType,
        api_key: str,
        access_key: typing.Optional[str] = OMIT,
        region: typing.Optional[str] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        api_version: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Provider:
        """
        Create a new custom provider.

        Parameters
        ----------
        name : str
            The name of the provider.

        provider_type : ProviderType
            The type of the provider.

        api_key : str
            API key or secret key used for requests to the provider.

        access_key : typing.Optional[str]
            Access key used for requests to the provider.

        region : typing.Optional[str]
            Region used for requests to the provider.

        base_url : typing.Optional[str]
            Base URL used for requests to the provider.

        api_version : typing.Optional[str]
            API version used for requests to the provider.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Provider
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.providers.create(
            name="name",
            provider_type="anthropic",
            api_key="api_key",
        )
        """
        _response = self._raw_client.create(
            name=name,
            provider_type=provider_type,
            api_key=api_key,
            access_key=access_key,
            region=region,
            base_url=base_url,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data

    def retrieve_provider(
        self, provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Provider:
        """
        Get a provider by ID.

        Parameters
        ----------
        provider_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Provider
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.providers.retrieve_provider(
            provider_id="provider_id",
        )
        """
        _response = self._raw_client.retrieve_provider(provider_id, request_options=request_options)
        return _response.data

    def delete(
        self, provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an existing custom provider.

        Parameters
        ----------
        provider_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.providers.delete(
            provider_id="provider_id",
        )
        """
        _response = self._raw_client.delete(provider_id, request_options=request_options)
        return _response.data

    def modify(
        self,
        provider_id: str,
        *,
        api_key: str,
        access_key: typing.Optional[str] = OMIT,
        region: typing.Optional[str] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        api_version: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Provider:
        """
        Update an existing custom provider.

        Parameters
        ----------
        provider_id : str

        api_key : str
            API key or secret key used for requests to the provider.

        access_key : typing.Optional[str]
            Access key used for requests to the provider.

        region : typing.Optional[str]
            Region used for requests to the provider.

        base_url : typing.Optional[str]
            Base URL used for requests to the provider.

        api_version : typing.Optional[str]
            API version used for requests to the provider.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Provider
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.providers.modify(
            provider_id="provider_id",
            api_key="api_key",
        )
        """
        _response = self._raw_client.modify(
            provider_id,
            api_key=api_key,
            access_key=access_key,
            region=region,
            base_url=base_url,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data

    def check(
        self,
        *,
        provider_type: ProviderType,
        api_key: str,
        access_key: typing.Optional[str] = OMIT,
        region: typing.Optional[str] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        api_version: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Verify the API key and additional parameters for a provider.

        Parameters
        ----------
        provider_type : ProviderType
            The type of the provider.

        api_key : str
            API key or secret key used for requests to the provider.

        access_key : typing.Optional[str]
            Access key used for requests to the provider.

        region : typing.Optional[str]
            Region used for requests to the provider.

        base_url : typing.Optional[str]
            Base URL used for requests to the provider.

        api_version : typing.Optional[str]
            API version used for requests to the provider.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.providers.check(
            provider_type="anthropic",
            api_key="api_key",
        )
        """
        _response = self._raw_client.check(
            provider_type=provider_type,
            api_key=api_key,
            access_key=access_key,
            region=region,
            base_url=base_url,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data


class AsyncProvidersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProvidersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[ProvidersListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["created_at"]] = None,
        name: typing.Optional[str] = None,
        provider_type: typing.Optional[ProviderType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Provider]:
        """
        Get a list of all custom providers.

        Parameters
        ----------
        before : typing.Optional[str]
            Provider ID cursor for pagination. Returns providers that come before this provider ID in the specified sort order

        after : typing.Optional[str]
            Provider ID cursor for pagination. Returns providers that come after this provider ID in the specified sort order

        limit : typing.Optional[int]
            Maximum number of providers to return

        order : typing.Optional[ProvidersListRequestOrder]
            Sort order for providers by creation time. 'asc' for oldest first, 'desc' for newest first

        order_by : typing.Optional[typing.Literal["created_at"]]
            Field to sort by

        name : typing.Optional[str]
            Filter providers by name

        provider_type : typing.Optional[ProviderType]
            Filter providers by type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Provider]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.providers.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            name=name,
            provider_type=provider_type,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        name: str,
        provider_type: ProviderType,
        api_key: str,
        access_key: typing.Optional[str] = OMIT,
        region: typing.Optional[str] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        api_version: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Provider:
        """
        Create a new custom provider.

        Parameters
        ----------
        name : str
            The name of the provider.

        provider_type : ProviderType
            The type of the provider.

        api_key : str
            API key or secret key used for requests to the provider.

        access_key : typing.Optional[str]
            Access key used for requests to the provider.

        region : typing.Optional[str]
            Region used for requests to the provider.

        base_url : typing.Optional[str]
            Base URL used for requests to the provider.

        api_version : typing.Optional[str]
            API version used for requests to the provider.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Provider
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.providers.create(
                name="name",
                provider_type="anthropic",
                api_key="api_key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            provider_type=provider_type,
            api_key=api_key,
            access_key=access_key,
            region=region,
            base_url=base_url,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data

    async def retrieve_provider(
        self, provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Provider:
        """
        Get a provider by ID.

        Parameters
        ----------
        provider_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Provider
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.providers.retrieve_provider(
                provider_id="provider_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_provider(provider_id, request_options=request_options)
        return _response.data

    async def delete(
        self, provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an existing custom provider.

        Parameters
        ----------
        provider_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.providers.delete(
                provider_id="provider_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(provider_id, request_options=request_options)
        return _response.data

    async def modify(
        self,
        provider_id: str,
        *,
        api_key: str,
        access_key: typing.Optional[str] = OMIT,
        region: typing.Optional[str] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        api_version: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Provider:
        """
        Update an existing custom provider.

        Parameters
        ----------
        provider_id : str

        api_key : str
            API key or secret key used for requests to the provider.

        access_key : typing.Optional[str]
            Access key used for requests to the provider.

        region : typing.Optional[str]
            Region used for requests to the provider.

        base_url : typing.Optional[str]
            Base URL used for requests to the provider.

        api_version : typing.Optional[str]
            API version used for requests to the provider.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Provider
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.providers.modify(
                provider_id="provider_id",
                api_key="api_key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.modify(
            provider_id,
            api_key=api_key,
            access_key=access_key,
            region=region,
            base_url=base_url,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data

    async def check(
        self,
        *,
        provider_type: ProviderType,
        api_key: str,
        access_key: typing.Optional[str] = OMIT,
        region: typing.Optional[str] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        api_version: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Verify the API key and additional parameters for a provider.

        Parameters
        ----------
        provider_type : ProviderType
            The type of the provider.

        api_key : str
            API key or secret key used for requests to the provider.

        access_key : typing.Optional[str]
            Access key used for requests to the provider.

        region : typing.Optional[str]
            Region used for requests to the provider.

        base_url : typing.Optional[str]
            Base URL used for requests to the provider.

        api_version : typing.Optional[str]
            API version used for requests to the provider.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.providers.check(
                provider_type="anthropic",
                api_key="api_key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.check(
            provider_type=provider_type,
            api_key=api_key,
            access_key=access_key,
            region=region,
            base_url=base_url,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data
