# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.feedback_type import FeedbackType
from ...types.step import Step
from .raw_client import AsyncRawFeedbackClient, RawFeedbackClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FeedbackClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFeedbackClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFeedbackClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFeedbackClient
        """
        return self._raw_client

    def create(
        self,
        step_id: str,
        *,
        feedback: typing.Optional[FeedbackType] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Step:
        """
        Modify feedback for a given step.

        Parameters
        ----------
        step_id : str

        feedback : typing.Optional[FeedbackType]
            Whether this feedback is positive or negative

        tags : typing.Optional[typing.Sequence[str]]
            Feedback tags to add to the step

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Step
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.steps.feedback.create(
            step_id="step_id",
        )
        """
        _response = self._raw_client.create(step_id, feedback=feedback, tags=tags, request_options=request_options)
        return _response.data


class AsyncFeedbackClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFeedbackClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFeedbackClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFeedbackClient
        """
        return self._raw_client

    async def create(
        self,
        step_id: str,
        *,
        feedback: typing.Optional[FeedbackType] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Step:
        """
        Modify feedback for a given step.

        Parameters
        ----------
        step_id : str

        feedback : typing.Optional[FeedbackType]
            Whether this feedback is positive or negative

        tags : typing.Optional[typing.Sequence[str]]
            Feedback tags to add to the step

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Step
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.steps.feedback.create(
                step_id="step_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            step_id, feedback=feedback, tags=tags, request_options=request_options
        )
        return _response.data
