# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.provider_trace import ProviderTrace
from .raw_client import AsyncRawTraceClient, RawTraceClient


class TraceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTraceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTraceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTraceClient
        """
        return self._raw_client

    def retrieve(
        self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[ProviderTrace]:
        """
        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ProviderTrace]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.steps.trace.retrieve(
            step_id="step_id",
        )
        """
        _response = self._raw_client.retrieve(step_id, request_options=request_options)
        return _response.data


class AsyncTraceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTraceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTraceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTraceClient
        """
        return self._raw_client

    async def retrieve(
        self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[ProviderTrace]:
        """
        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ProviderTrace]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.steps.trace.retrieve(
                step_id="step_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(step_id, request_options=request_options)
        return _response.data
