# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawTagsClient, RawTagsClient
from .types.tags_list_request_order import TagsListRequestOrder


class TagsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTagsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTagsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[TagsListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["name"]] = None,
        query_text: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[str]:
        """
        Get the list of all agent tags that have been created.

        Parameters
        ----------
        before : typing.Optional[str]
            Tag cursor for pagination. Returns tags that come before this tag in the specified sort order

        after : typing.Optional[str]
            Tag cursor for pagination. Returns tags that come after this tag in the specified sort order

        limit : typing.Optional[int]
            Maximum number of tags to return

        order : typing.Optional[TagsListRequestOrder]
            Sort order for tags. 'asc' for alphabetical order, 'desc' for reverse alphabetical order

        order_by : typing.Optional[typing.Literal["name"]]
            Field to sort by

        query_text : typing.Optional[str]
            Filter tags by text search. Deprecated, please use name field instead

        name : typing.Optional[str]
            Filter tags by name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[str]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.tags.list()
        """
        _response = self._raw_client.list(
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            query_text=query_text,
            name=name,
            request_options=request_options,
        )
        return _response.data


class AsyncTagsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTagsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTagsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[TagsListRequestOrder] = None,
        order_by: typing.Optional[typing.Literal["name"]] = None,
        query_text: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[str]:
        """
        Get the list of all agent tags that have been created.

        Parameters
        ----------
        before : typing.Optional[str]
            Tag cursor for pagination. Returns tags that come before this tag in the specified sort order

        after : typing.Optional[str]
            Tag cursor for pagination. Returns tags that come after this tag in the specified sort order

        limit : typing.Optional[int]
            Maximum number of tags to return

        order : typing.Optional[TagsListRequestOrder]
            Sort order for tags. 'asc' for alphabetical order, 'desc' for reverse alphabetical order

        order_by : typing.Optional[typing.Literal["name"]]
            Field to sort by

        query_text : typing.Optional[str]
            Filter tags by text search. Deprecated, please use name field instead

        name : typing.Optional[str]
            Filter tags by name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[str]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tags.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            before=before,
            after=after,
            limit=limit,
            order=order,
            order_by=order_by,
            query_text=query_text,
            name=name,
            request_options=request_options,
        )
        return _response.data
