# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .agents.client import AgentsClient, AsyncAgentsClient
from .raw_client import AsyncRawTemplatesClient, RawTemplatesClient
from .types.templates_create_agents_from_template_request_initial_message_sequence_item import (
    TemplatesCreateAgentsFromTemplateRequestInitialMessageSequenceItem,
)
from .types.templates_create_agents_from_template_response import TemplatesCreateAgentsFromTemplateResponse
from .types.templates_create_template_request import TemplatesCreateTemplateRequest
from .types.templates_create_template_response import TemplatesCreateTemplateResponse
from .types.templates_delete_template_response import TemplatesDeleteTemplateResponse
from .types.templates_fork_template_response import TemplatesForkTemplateResponse
from .types.templates_get_template_snapshot_response import TemplatesGetTemplateSnapshotResponse
from .types.templates_list_request_sort_by import TemplatesListRequestSortBy
from .types.templates_list_response import TemplatesListResponse
from .types.templates_list_template_versions_response import TemplatesListTemplateVersionsResponse
from .types.templates_migrate_deployment_response import TemplatesMigrateDeploymentResponse
from .types.templates_rename_template_response import TemplatesRenameTemplateResponse
from .types.templates_save_template_version_response import TemplatesSaveTemplateVersionResponse
from .types.templates_set_current_template_from_snapshot_response import TemplatesSetCurrentTemplateFromSnapshotResponse
from .types.templates_update_template_description_response import TemplatesUpdateTemplateDescriptionResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTemplatesClient(client_wrapper=client_wrapper)
        self.agents = AgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTemplatesClient
        """
        return self._raw_client

    def createagentsfromtemplate(
        self,
        project_id: str,
        template_version: str,
        *,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        agent_name: typing.Optional[str] = OMIT,
        initial_message_sequence: typing.Optional[
            typing.Sequence[TemplatesCreateAgentsFromTemplateRequestInitialMessageSequenceItem]
        ] = OMIT,
        memory_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        tool_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        identity_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesCreateAgentsFromTemplateResponse:
        """
        Creates an Agent or multiple Agents from a template

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        tags : typing.Optional[typing.Sequence[str]]
            The tags to assign to the agent

        agent_name : typing.Optional[str]
            The name of the agent, optional otherwise a random one will be assigned

        initial_message_sequence : typing.Optional[typing.Sequence[TemplatesCreateAgentsFromTemplateRequestInitialMessageSequenceItem]]
            Set an initial sequence of messages, if not provided, the agent will start with the default message sequence, if an empty array is provided, the agent will start with no messages

        memory_variables : typing.Optional[typing.Dict[str, str]]
            The memory variables to assign to the agent

        tool_variables : typing.Optional[typing.Dict[str, str]]
            The tool variables to assign to the agent

        identity_ids : typing.Optional[typing.Sequence[str]]
            The identity ids to assign to the agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesCreateAgentsFromTemplateResponse
            201

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.createagentsfromtemplate(
            project_id="project_id",
            template_version="template_version",
        )
        """
        _response = self._raw_client.createagentsfromtemplate(
            project_id,
            template_version,
            tags=tags,
            agent_name=agent_name,
            initial_message_sequence=initial_message_sequence,
            memory_variables=memory_variables,
            tool_variables=tool_variables,
            identity_ids=identity_ids,
            request_options=request_options,
        )
        return _response.data

    def list(
        self,
        *,
        offset: typing.Optional[str] = None,
        exact: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        version: typing.Optional[str] = None,
        template_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        project_slug: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        sort_by: typing.Optional[TemplatesListRequestSortBy] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListResponse:
        """
        List all templates

        Parameters
        ----------
        offset : typing.Optional[str]

        exact : typing.Optional[str]
            Whether to search for an exact name match

        limit : typing.Optional[str]

        version : typing.Optional[str]
            Specify the version you want to return, otherwise will return the latest version

        template_id : typing.Optional[str]

        name : typing.Optional[str]

        search : typing.Optional[str]

        project_slug : typing.Optional[str]

        project_id : typing.Optional[str]

        sort_by : typing.Optional[TemplatesListRequestSortBy]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.list()
        """
        _response = self._raw_client.list(
            offset=offset,
            exact=exact,
            limit=limit,
            version=version,
            template_id=template_id,
            name=name,
            search=search,
            project_slug=project_slug,
            project_id=project_id,
            sort_by=sort_by,
            request_options=request_options,
        )
        return _response.data

    def savetemplateversion(
        self,
        project_id: str,
        template_name: str,
        *,
        preserve_environment_variables_on_migration: typing.Optional[bool] = OMIT,
        preserve_core_memories_on_migration: typing.Optional[bool] = OMIT,
        migrate_agents: typing.Optional[bool] = OMIT,
        message: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesSaveTemplateVersionResponse:
        """
        Saves the current version of the template as a new version

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template version, formatted as {template-name}, any version appended will be ignored

        preserve_environment_variables_on_migration : typing.Optional[bool]
            If true, the environment variables will be preserved in the template version when migrating agents

        preserve_core_memories_on_migration : typing.Optional[bool]
            If true, the core memories will be preserved in the template version when migrating agents

        migrate_agents : typing.Optional[bool]
            If true, existing agents attached to this template will be migrated to the new template version

        message : typing.Optional[str]
            A message to describe the changes made in this template version

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesSaveTemplateVersionResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.savetemplateversion(
            project_id="project_id",
            template_name="template_name",
        )
        """
        _response = self._raw_client.savetemplateversion(
            project_id,
            template_name,
            preserve_environment_variables_on_migration=preserve_environment_variables_on_migration,
            preserve_core_memories_on_migration=preserve_core_memories_on_migration,
            migrate_agents=migrate_agents,
            message=message,
            request_options=request_options,
        )
        return _response.data

    def deletetemplate(
        self, project_id: str, template_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplatesDeleteTemplateResponse:
        """
        Deletes all versions of a template with the specified name

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template name (without version)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesDeleteTemplateResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.deletetemplate(
            project_id="project_id",
            template_name="template_name",
        )
        """
        _response = self._raw_client.deletetemplate(project_id, template_name, request_options=request_options)
        return _response.data

    def gettemplatesnapshot(
        self, project_id: str, template_version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplatesGetTemplateSnapshotResponse:
        """
        Get a snapshot of the template version, this will return the template state at a specific version

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesGetTemplateSnapshotResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.gettemplatesnapshot(
            project_id="project_id",
            template_version="template_version",
        )
        """
        _response = self._raw_client.gettemplatesnapshot(project_id, template_version, request_options=request_options)
        return _response.data

    def setcurrenttemplatefromsnapshot(
        self,
        project_id: str,
        template_version: str,
        *,
        request: typing.Optional[typing.Any] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesSetCurrentTemplateFromSnapshotResponse:
        """
        Updates the current working version of a template from a snapshot

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template name with :current version (e.g., my-template:current)

        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesSetCurrentTemplateFromSnapshotResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.setcurrenttemplatefromsnapshot(
            project_id="project_id",
            template_version="template_version",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.setcurrenttemplatefromsnapshot(
            project_id, template_version, request=request, request_options=request_options
        )
        return _response.data

    def forktemplate(
        self,
        project_id: str,
        template_version: str,
        *,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesForkTemplateResponse:
        """
        Forks a template version into a new template

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        name : typing.Optional[str]
            Optional custom name for the forked template. If not provided, a random name will be generated.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesForkTemplateResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.forktemplate(
            project_id="project_id",
            template_version="template_version",
        )
        """
        _response = self._raw_client.forktemplate(
            project_id, template_version, name=name, request_options=request_options
        )
        return _response.data

    def createtemplate(
        self,
        project_id: str,
        *,
        request: TemplatesCreateTemplateRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesCreateTemplateResponse:
        """
        Creates a new template from an existing agent or agent file

        Parameters
        ----------
        project_id : str
            The project id

        request : TemplatesCreateTemplateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesCreateTemplateResponse
            201

        Examples
        --------
        from letta_client import Letta
        from letta_client.templates import TemplatesCreateTemplateRequestAgentId

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.createtemplate(
            project_id="project_id",
            request=TemplatesCreateTemplateRequestAgentId(
                agent_id="agent_id",
            ),
        )
        """
        _response = self._raw_client.createtemplate(project_id, request=request, request_options=request_options)
        return _response.data

    def renametemplate(
        self,
        project_id: str,
        template_name: str,
        *,
        new_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesRenameTemplateResponse:
        """
        Renames all versions of a template with the specified name. Versions are automatically stripped from the current template name if accidentally included.

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The current template name (version will be automatically stripped if included)

        new_name : str
            The new name for the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesRenameTemplateResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.renametemplate(
            project_id="project_id",
            template_name="template_name",
            new_name="new_name",
        )
        """
        _response = self._raw_client.renametemplate(
            project_id, template_name, new_name=new_name, request_options=request_options
        )
        return _response.data

    def updatetemplatedescription(
        self,
        project_id: str,
        template_name: str,
        *,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesUpdateTemplateDescriptionResponse:
        """
        Updates the description for all versions of a template with the specified name. Versions are automatically stripped from the current template name if accidentally included.

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template name (version will be automatically stripped if included)

        description : typing.Optional[str]
            The new description for the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesUpdateTemplateDescriptionResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.updatetemplatedescription(
            project_id="project_id",
            template_name="template_name",
        )
        """
        _response = self._raw_client.updatetemplatedescription(
            project_id, template_name, description=description, request_options=request_options
        )
        return _response.data

    def listtemplateversions(
        self,
        project_id: str,
        name: str,
        *,
        offset: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListTemplateVersionsResponse:
        """
        List all versions of a specific template

        Parameters
        ----------
        project_id : str
            The project id

        name : str
            The template name (without version)

        offset : typing.Optional[str]

        limit : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListTemplateVersionsResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.listtemplateversions(
            project_id="project_id",
            name="name",
        )
        """
        _response = self._raw_client.listtemplateversions(
            project_id, name, offset=offset, limit=limit, request_options=request_options
        )
        return _response.data

    def migratedeployment(
        self,
        project_id: str,
        template_name: str,
        deployment_id: str,
        *,
        version: str,
        preserve_tool_variables: typing.Optional[bool] = OMIT,
        preserve_core_memories: typing.Optional[bool] = OMIT,
        memory_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesMigrateDeploymentResponse:
        """
        Migrates a deployment to a specific template version

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template name (without version)

        deployment_id : str
            The deployment ID to migrate

        version : str
            The target template version to migrate to

        preserve_tool_variables : typing.Optional[bool]
            Whether to preserve existing tool variables during migration

        preserve_core_memories : typing.Optional[bool]
            Whether to preserve existing core memories during migration

        memory_variables : typing.Optional[typing.Dict[str, str]]
            Additional memory variables to apply during migration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesMigrateDeploymentResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.migratedeployment(
            project_id="project_id",
            template_name="template_name",
            deployment_id="deployment_id",
            version="version",
        )
        """
        _response = self._raw_client.migratedeployment(
            project_id,
            template_name,
            deployment_id,
            version=version,
            preserve_tool_variables=preserve_tool_variables,
            preserve_core_memories=preserve_core_memories,
            memory_variables=memory_variables,
            request_options=request_options,
        )
        return _response.data


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTemplatesClient(client_wrapper=client_wrapper)
        self.agents = AsyncAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTemplatesClient
        """
        return self._raw_client

    async def createagentsfromtemplate(
        self,
        project_id: str,
        template_version: str,
        *,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        agent_name: typing.Optional[str] = OMIT,
        initial_message_sequence: typing.Optional[
            typing.Sequence[TemplatesCreateAgentsFromTemplateRequestInitialMessageSequenceItem]
        ] = OMIT,
        memory_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        tool_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        identity_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesCreateAgentsFromTemplateResponse:
        """
        Creates an Agent or multiple Agents from a template

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        tags : typing.Optional[typing.Sequence[str]]
            The tags to assign to the agent

        agent_name : typing.Optional[str]
            The name of the agent, optional otherwise a random one will be assigned

        initial_message_sequence : typing.Optional[typing.Sequence[TemplatesCreateAgentsFromTemplateRequestInitialMessageSequenceItem]]
            Set an initial sequence of messages, if not provided, the agent will start with the default message sequence, if an empty array is provided, the agent will start with no messages

        memory_variables : typing.Optional[typing.Dict[str, str]]
            The memory variables to assign to the agent

        tool_variables : typing.Optional[typing.Dict[str, str]]
            The tool variables to assign to the agent

        identity_ids : typing.Optional[typing.Sequence[str]]
            The identity ids to assign to the agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesCreateAgentsFromTemplateResponse
            201

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.createagentsfromtemplate(
                project_id="project_id",
                template_version="template_version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.createagentsfromtemplate(
            project_id,
            template_version,
            tags=tags,
            agent_name=agent_name,
            initial_message_sequence=initial_message_sequence,
            memory_variables=memory_variables,
            tool_variables=tool_variables,
            identity_ids=identity_ids,
            request_options=request_options,
        )
        return _response.data

    async def list(
        self,
        *,
        offset: typing.Optional[str] = None,
        exact: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        version: typing.Optional[str] = None,
        template_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        project_slug: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        sort_by: typing.Optional[TemplatesListRequestSortBy] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListResponse:
        """
        List all templates

        Parameters
        ----------
        offset : typing.Optional[str]

        exact : typing.Optional[str]
            Whether to search for an exact name match

        limit : typing.Optional[str]

        version : typing.Optional[str]
            Specify the version you want to return, otherwise will return the latest version

        template_id : typing.Optional[str]

        name : typing.Optional[str]

        search : typing.Optional[str]

        project_slug : typing.Optional[str]

        project_id : typing.Optional[str]

        sort_by : typing.Optional[TemplatesListRequestSortBy]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            offset=offset,
            exact=exact,
            limit=limit,
            version=version,
            template_id=template_id,
            name=name,
            search=search,
            project_slug=project_slug,
            project_id=project_id,
            sort_by=sort_by,
            request_options=request_options,
        )
        return _response.data

    async def savetemplateversion(
        self,
        project_id: str,
        template_name: str,
        *,
        preserve_environment_variables_on_migration: typing.Optional[bool] = OMIT,
        preserve_core_memories_on_migration: typing.Optional[bool] = OMIT,
        migrate_agents: typing.Optional[bool] = OMIT,
        message: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesSaveTemplateVersionResponse:
        """
        Saves the current version of the template as a new version

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template version, formatted as {template-name}, any version appended will be ignored

        preserve_environment_variables_on_migration : typing.Optional[bool]
            If true, the environment variables will be preserved in the template version when migrating agents

        preserve_core_memories_on_migration : typing.Optional[bool]
            If true, the core memories will be preserved in the template version when migrating agents

        migrate_agents : typing.Optional[bool]
            If true, existing agents attached to this template will be migrated to the new template version

        message : typing.Optional[str]
            A message to describe the changes made in this template version

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesSaveTemplateVersionResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.savetemplateversion(
                project_id="project_id",
                template_name="template_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.savetemplateversion(
            project_id,
            template_name,
            preserve_environment_variables_on_migration=preserve_environment_variables_on_migration,
            preserve_core_memories_on_migration=preserve_core_memories_on_migration,
            migrate_agents=migrate_agents,
            message=message,
            request_options=request_options,
        )
        return _response.data

    async def deletetemplate(
        self, project_id: str, template_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplatesDeleteTemplateResponse:
        """
        Deletes all versions of a template with the specified name

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template name (without version)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesDeleteTemplateResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.deletetemplate(
                project_id="project_id",
                template_name="template_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deletetemplate(project_id, template_name, request_options=request_options)
        return _response.data

    async def gettemplatesnapshot(
        self, project_id: str, template_version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplatesGetTemplateSnapshotResponse:
        """
        Get a snapshot of the template version, this will return the template state at a specific version

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesGetTemplateSnapshotResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.gettemplatesnapshot(
                project_id="project_id",
                template_version="template_version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.gettemplatesnapshot(
            project_id, template_version, request_options=request_options
        )
        return _response.data

    async def setcurrenttemplatefromsnapshot(
        self,
        project_id: str,
        template_version: str,
        *,
        request: typing.Optional[typing.Any] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesSetCurrentTemplateFromSnapshotResponse:
        """
        Updates the current working version of a template from a snapshot

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template name with :current version (e.g., my-template:current)

        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesSetCurrentTemplateFromSnapshotResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.setcurrenttemplatefromsnapshot(
                project_id="project_id",
                template_version="template_version",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.setcurrenttemplatefromsnapshot(
            project_id, template_version, request=request, request_options=request_options
        )
        return _response.data

    async def forktemplate(
        self,
        project_id: str,
        template_version: str,
        *,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesForkTemplateResponse:
        """
        Forks a template version into a new template

        Parameters
        ----------
        project_id : str
            The project id

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        name : typing.Optional[str]
            Optional custom name for the forked template. If not provided, a random name will be generated.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesForkTemplateResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.forktemplate(
                project_id="project_id",
                template_version="template_version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.forktemplate(
            project_id, template_version, name=name, request_options=request_options
        )
        return _response.data

    async def createtemplate(
        self,
        project_id: str,
        *,
        request: TemplatesCreateTemplateRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesCreateTemplateResponse:
        """
        Creates a new template from an existing agent or agent file

        Parameters
        ----------
        project_id : str
            The project id

        request : TemplatesCreateTemplateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesCreateTemplateResponse
            201

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta
        from letta_client.templates import TemplatesCreateTemplateRequestAgentId

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.createtemplate(
                project_id="project_id",
                request=TemplatesCreateTemplateRequestAgentId(
                    agent_id="agent_id",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.createtemplate(project_id, request=request, request_options=request_options)
        return _response.data

    async def renametemplate(
        self,
        project_id: str,
        template_name: str,
        *,
        new_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesRenameTemplateResponse:
        """
        Renames all versions of a template with the specified name. Versions are automatically stripped from the current template name if accidentally included.

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The current template name (version will be automatically stripped if included)

        new_name : str
            The new name for the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesRenameTemplateResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.renametemplate(
                project_id="project_id",
                template_name="template_name",
                new_name="new_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.renametemplate(
            project_id, template_name, new_name=new_name, request_options=request_options
        )
        return _response.data

    async def updatetemplatedescription(
        self,
        project_id: str,
        template_name: str,
        *,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesUpdateTemplateDescriptionResponse:
        """
        Updates the description for all versions of a template with the specified name. Versions are automatically stripped from the current template name if accidentally included.

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template name (version will be automatically stripped if included)

        description : typing.Optional[str]
            The new description for the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesUpdateTemplateDescriptionResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.updatetemplatedescription(
                project_id="project_id",
                template_name="template_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.updatetemplatedescription(
            project_id, template_name, description=description, request_options=request_options
        )
        return _response.data

    async def listtemplateversions(
        self,
        project_id: str,
        name: str,
        *,
        offset: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListTemplateVersionsResponse:
        """
        List all versions of a specific template

        Parameters
        ----------
        project_id : str
            The project id

        name : str
            The template name (without version)

        offset : typing.Optional[str]

        limit : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListTemplateVersionsResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.listtemplateversions(
                project_id="project_id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.listtemplateversions(
            project_id, name, offset=offset, limit=limit, request_options=request_options
        )
        return _response.data

    async def migratedeployment(
        self,
        project_id: str,
        template_name: str,
        deployment_id: str,
        *,
        version: str,
        preserve_tool_variables: typing.Optional[bool] = OMIT,
        preserve_core_memories: typing.Optional[bool] = OMIT,
        memory_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesMigrateDeploymentResponse:
        """
        Migrates a deployment to a specific template version

        Parameters
        ----------
        project_id : str
            The project id

        template_name : str
            The template name (without version)

        deployment_id : str
            The deployment ID to migrate

        version : str
            The target template version to migrate to

        preserve_tool_variables : typing.Optional[bool]
            Whether to preserve existing tool variables during migration

        preserve_core_memories : typing.Optional[bool]
            Whether to preserve existing core memories during migration

        memory_variables : typing.Optional[typing.Dict[str, str]]
            Additional memory variables to apply during migration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesMigrateDeploymentResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.migratedeployment(
                project_id="project_id",
                template_name="template_name",
                deployment_id="deployment_id",
                version="version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.migratedeployment(
            project_id,
            template_name,
            deployment_id,
            version=version,
            preserve_tool_variables=preserve_tool_variables,
            preserve_core_memories=preserve_core_memories,
            memory_variables=memory_variables,
            request_options=request_options,
        )
        return _response.data
