# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .block_schema import BlockSchema
from .file_schema import FileSchema
from .group_schema import GroupSchema
from .letta_schemas_agent_file_agent_schema import LettaSchemasAgentFileAgentSchema
from .letta_schemas_agent_file_tool_schema import LettaSchemasAgentFileToolSchema
from .mcp_server_schema import McpServerSchema
from .source_schema import SourceSchema


class AgentFileSchema(UncheckedBaseModel):
    """
    Schema for serialized agent file that can be exported to JSON and imported into agent server.
    """

    agents: typing.List[LettaSchemasAgentFileAgentSchema] = pydantic.Field()
    """
    List of agents in this agent file
    """

    groups: typing.List[GroupSchema] = pydantic.Field()
    """
    List of groups in this agent file
    """

    blocks: typing.List[BlockSchema] = pydantic.Field()
    """
    List of memory blocks in this agent file
    """

    files: typing.List[FileSchema] = pydantic.Field()
    """
    List of files in this agent file
    """

    sources: typing.List[SourceSchema] = pydantic.Field()
    """
    List of sources in this agent file
    """

    tools: typing.List[LettaSchemasAgentFileToolSchema] = pydantic.Field()
    """
    List of tools in this agent file
    """

    mcp_servers: typing.List[McpServerSchema] = pydantic.Field()
    """
    List of MCP servers in this agent file
    """

    metadata: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Metadata for this agent file, including revision_id and other export information.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
