# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ApprovalResponseMessage(UncheckedBaseModel):
    """
    A message representing a response form the user indicating whether a tool has been approved to run.

    Args:
        id (str): The ID of the message
        date (datetime): The date the message was created in ISO format
        name (Optional[str]): The name of the sender of the message
        approve: (bool) Whether the tool has been approved
        approval_request_id: The ID of the approval request
        reason: (Optional[str]) An optional explanation for the provided approval status
    """

    id: str
    date: dt.datetime
    name: typing.Optional[str] = None
    message_type: typing.Literal["approval_response_message"] = "approval_response_message"
    otid: typing.Optional[str] = None
    sender_id: typing.Optional[str] = None
    step_id: typing.Optional[str] = None
    is_err: typing.Optional[bool] = None
    seq_id: typing.Optional[int] = None
    run_id: typing.Optional[str] = None
    approve: bool = pydantic.Field()
    """
    Whether the tool has been approved
    """

    approval_request_id: str = pydantic.Field()
    """
    The message ID of the approval request
    """

    reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional explanation for the provided approval status
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
