# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .vector_db_provider import VectorDbProvider


class Archive(UncheckedBaseModel):
    """
    Representation of an archive - a collection of archival passages that can be shared between agents.

    Parameters:
        id (str): The unique identifier of the archive.
        name (str): The name of the archive.
        description (str): A description of the archive.
        organization_id (str): The organization this archive belongs to.
        created_at (datetime): The creation date of the archive.
        metadata (dict): Additional metadata for the archive.
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The creation date of the archive
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was last updated.
    """

    name: str = pydantic.Field()
    """
    The name of the archive
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description of the archive
    """

    vector_db_provider: typing.Optional[VectorDbProvider] = pydantic.Field(default=None)
    """
    The vector database provider used for this archive's passages
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional metadata
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Archive
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
