# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .embedding_config_embedding_endpoint_type import EmbeddingConfigEmbeddingEndpointType


class EmbeddingConfig(UncheckedBaseModel):
    """
    Configuration for embedding model connection and processing parameters.
    """

    embedding_endpoint_type: EmbeddingConfigEmbeddingEndpointType = pydantic.Field()
    """
    The endpoint type for the model.
    """

    embedding_endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    The endpoint for the model (`None` if local).
    """

    embedding_model: str = pydantic.Field()
    """
    The model for the embedding.
    """

    embedding_dim: int = pydantic.Field()
    """
    The dimension of the embedding.
    """

    embedding_chunk_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The chunk size of the embedding.
    """

    handle: typing.Optional[str] = pydantic.Field(default=None)
    """
    The handle for this config, in the format provider/model-name.
    """

    batch_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum batch size for processing embeddings.
    """

    azure_endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Azure endpoint for the model.
    """

    azure_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Azure version for the model.
    """

    azure_deployment: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Azure deployment for the model.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
