# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class McpServerSchema(UncheckedBaseModel):
    """
    MCP server schema for agent files with remapped ID.
    """

    id: str = pydantic.Field()
    """
    Human-readable MCP server ID
    """

    server_type: str
    server_name: str
    server_url: typing.Optional[str] = None
    stdio_config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    metadata: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="metadata_")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
